/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.serializer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.annotation.JSONType;
import com.alibaba.fastjson.asm.ClassWriter;
import com.alibaba.fastjson.asm.FieldWriter;
import com.alibaba.fastjson.asm.Label;
import com.alibaba.fastjson.asm.MethodVisitor;
import com.alibaba.fastjson.asm.MethodWriter;
import com.alibaba.fastjson.asm.Opcodes;
import com.alibaba.fastjson.serializer.ASMJavaBeanSerializer;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.JavaBeanSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerialContext;
import com.alibaba.fastjson.serializer.SerializeWriter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.util.ASMClassLoader;
import com.alibaba.fastjson.util.ASMUtils;
import com.alibaba.fastjson.util.FieldInfo;
import com.alibaba.fastjson.util.TypeUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public class ASMSerializerFactory
implements Opcodes {
    protected final ASMClassLoader classLoader = new ASMClassLoader();
    private final AtomicLong seed = new AtomicLong();
    static final String JSONSerializer = ASMUtils.type(JSONSerializer.class);
    static final String SerializeWriter = ASMUtils.type(SerializeWriter.class);
    static final String JavaBeanSerializer = ASMUtils.type(JavaBeanSerializer.class);
    static final String JavaBeanSerializer_desc = "L" + ASMUtils.type(JavaBeanSerializer.class) + ";";
    static final String SerialContext_desc = ASMUtils.desc(SerialContext.class);

    /*
     * WARNING - void declaration
     */
    public ObjectSerializer createJavaBeanSerializer(Class<?> clazz, Map<String, String> aliasMap) throws Exception {
        void var15_21;
        List<FieldInfo> getters;
        if (clazz.isPrimitive()) {
            throw new JSONException("unsupportd class " + clazz.getName());
        }
        JSONType jsonType = clazz.getAnnotation(JSONType.class);
        List<FieldInfo> unsortedGetters = TypeUtils.computeGetters(clazz, jsonType, aliasMap, false);
        for (FieldInfo fieldInfo : unsortedGetters) {
            if (fieldInfo.field != null || fieldInfo.method == null || !fieldInfo.method.getDeclaringClass().isInterface()) continue;
            return new JavaBeanSerializer(clazz);
        }
        String[] orders = null;
        if (jsonType != null) {
            orders = jsonType.orders();
        }
        if (orders != null && orders.length != 0) {
            getters = TypeUtils.computeGetters(clazz, jsonType, aliasMap, true);
        } else {
            getters = new ArrayList<FieldInfo>(unsortedGetters);
            Collections.sort(getters);
        }
        boolean nativeSorted = true;
        int size = unsortedGetters.size();
        for (int i = 0; i < size; ++i) {
            if (unsortedGetters.get(i).equals(getters.get(i))) continue;
            nativeSorted = false;
            break;
        }
        if (getters.size() > 256) {
            return null;
        }
        for (FieldInfo getter : getters) {
            if (ASMUtils.checkName(getter.getMember().getName())) continue;
            return null;
        }
        String className = "ASMSerializer_" + this.seed.incrementAndGet() + "_" + clazz.getSimpleName();
        String packageName = ASMSerializerFactory.class.getPackage().getName();
        String classNameType = packageName.replace('.', '/') + "/" + className;
        String classNameFull = packageName + "." + className;
        int beanSerializeFeatures = TypeUtils.getSerializeFeatures(clazz);
        ClassWriter cw = new ClassWriter();
        cw.visit(49, 33, classNameType, ASMUtils.type(ASMJavaBeanSerializer.class), new String[]{ASMUtils.type(ObjectSerializer.class)});
        for (FieldInfo fieldInfo : getters) {
            if (fieldInfo.fieldClass.isPrimitive() || fieldInfo.fieldClass.isEnum() || fieldInfo.fieldClass == String.class) continue;
            FieldWriter fw = new FieldWriter(cw, 1, fieldInfo.name + "_asm_fieldType", "Ljava/lang/reflect/Type;");
            fw.visitEnd();
        }
        MethodWriter mw = new MethodWriter(cw, 1, "<init>", "()V", null, null);
        mw.visitVarInsn(25, 0);
        mw.visitLdcInsn(com.alibaba.fastjson.asm.Type.getType(ASMUtils.desc(clazz)));
        mw.visitMethodInsn(183, ASMUtils.type(ASMJavaBeanSerializer.class), "<init>", "(Ljava/lang/Class;)V");
        for (FieldInfo fieldInfo : getters) {
            if (fieldInfo.fieldClass.isPrimitive() || fieldInfo.fieldClass.isEnum() || fieldInfo.fieldClass == String.class) continue;
            mw.visitVarInsn(25, 0);
            mw.visitLdcInsn(com.alibaba.fastjson.asm.Type.getType(ASMUtils.desc(fieldInfo.declaringClass)));
            if (fieldInfo.method != null) {
                mw.visitLdcInsn(fieldInfo.method.getName());
                mw.visitMethodInsn(184, ASMUtils.type(ASMUtils.class), "getMethodType", "(Ljava/lang/Class;Ljava/lang/String;)Ljava/lang/reflect/Type;");
            } else {
                mw.visitLdcInsn(fieldInfo.field.getName());
                mw.visitMethodInsn(184, ASMUtils.type(ASMUtils.class), "getFieldType", "(Ljava/lang/Class;Ljava/lang/String;)Ljava/lang/reflect/Type;");
            }
            mw.visitFieldInsn(181, classNameType, fieldInfo.name + "_asm_fieldType", "Ljava/lang/reflect/Type;");
        }
        mw.visitInsn(177);
        mw.visitMaxs(4, 4);
        mw.visitEnd();
        boolean bl = false;
        while (var15_21 < 2) {
            Label _else;
            String methodName;
            boolean writeDirect = false;
            if (var15_21 == false) {
                methodName = "write";
                writeDirect = true;
            } else {
                methodName = "write1";
            }
            Context context = new Context(classNameType, beanSerializeFeatures, writeDirect);
            mw = new MethodWriter(cw, 1, methodName, "(L" + JSONSerializer + ";Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/reflect/Type;I)V", null, new String[]{"java/io/IOException"});
            mw.visitVarInsn(25, 1);
            mw.visitMethodInsn(182, JSONSerializer, "getWriter", "()L" + SerializeWriter + ";");
            mw.visitVarInsn(58, context.var("out"));
            if (!nativeSorted && (jsonType == null || jsonType.alphabetic())) {
                _else = new Label();
                mw.visitVarInsn(25, context.var("out"));
                mw.visitMethodInsn(182, SerializeWriter, "isSortField", "()Z");
                mw.visitJumpInsn(154, _else);
                mw.visitVarInsn(25, 0);
                mw.visitVarInsn(25, 1);
                mw.visitVarInsn(25, 2);
                mw.visitVarInsn(25, 3);
                mw.visitVarInsn(25, 4);
                mw.visitVarInsn(21, 5);
                mw.visitMethodInsn(182, classNameType, "writeUnsorted", "(L" + JSONSerializer + ";Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/reflect/Type;I)V");
                mw.visitInsn(177);
                mw.visitLabel(_else);
            }
            if (context.writeDirect) {
                _else = new Label();
                mw.visitVarInsn(25, 1);
                mw.visitMethodInsn(182, JSONSerializer, "writeDirect", "()Z");
                mw.visitJumpInsn(154, _else);
                mw.visitVarInsn(25, 0);
                mw.visitVarInsn(25, 1);
                mw.visitVarInsn(25, 2);
                mw.visitVarInsn(25, 3);
                mw.visitVarInsn(25, 4);
                mw.visitVarInsn(21, 5);
                mw.visitMethodInsn(182, classNameType, "write1", "(L" + JSONSerializer + ";Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/reflect/Type;I)V");
                mw.visitInsn(177);
                mw.visitLabel(_else);
            }
            mw.visitVarInsn(25, 2);
            mw.visitTypeInsn(192, ASMUtils.type(clazz));
            mw.visitVarInsn(58, context.var("entity"));
            this.generateWriteMethod(clazz, mw, getters, context);
            mw.visitInsn(177);
            mw.visitMaxs(7, context.variantIndex + 2);
            mw.visitEnd();
            ++var15_21;
        }
        if (!nativeSorted) {
            Context context = new Context(classNameType, beanSerializeFeatures, false);
            mw = new MethodWriter(cw, 1, "writeUnsorted", "(L" + JSONSerializer + ";Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/reflect/Type;I)V", null, new String[]{"java/io/IOException"});
            mw.visitVarInsn(25, 1);
            mw.visitMethodInsn(182, JSONSerializer, "getWriter", "()L" + SerializeWriter + ";");
            mw.visitVarInsn(58, context.var("out"));
            mw.visitVarInsn(25, 2);
            mw.visitTypeInsn(192, ASMUtils.type(clazz));
            mw.visitVarInsn(58, context.var("entity"));
            this.generateWriteMethod(clazz, mw, unsortedGetters, context);
            mw.visitInsn(177);
            mw.visitMaxs(7, context.variantIndex + 2);
            mw.visitEnd();
        }
        Context context = new Context(classNameType, beanSerializeFeatures, false);
        mw = new MethodWriter(cw, 1, "writeAsArray", "(L" + JSONSerializer + ";Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/reflect/Type;)V", null, new String[]{"java/io/IOException"});
        mw.visitVarInsn(25, 1);
        mw.visitMethodInsn(182, JSONSerializer, "getWriter", "()L" + SerializeWriter + ";");
        mw.visitVarInsn(58, context.var("out"));
        mw.visitVarInsn(25, 2);
        mw.visitTypeInsn(192, ASMUtils.type(clazz));
        mw.visitVarInsn(58, context.var("entity"));
        this.generateWriteAsArray(clazz, mw, getters, context);
        mw.visitInsn(177);
        mw.visitMaxs(7, context.variantIndex + 2);
        mw.visitEnd();
        byte[] byArray = cw.toByteArray();
        Class<?> exampleClass = this.classLoader.defineClassPublic(classNameFull, byArray, 0, byArray.length);
        Object instance = exampleClass.newInstance();
        return (ObjectSerializer)instance;
    }

    private void generateWriteAsArray(Class<?> clazz, MethodVisitor mw, List<FieldInfo> getters, Context context) throws Exception {
        mw.visitVarInsn(25, context.var("out"));
        mw.visitVarInsn(16, 91);
        mw.visitMethodInsn(182, SerializeWriter, "write", "(I)V");
        int size = getters.size();
        if (size == 0) {
            mw.visitVarInsn(25, context.var("out"));
            mw.visitVarInsn(16, 93);
            mw.visitMethodInsn(182, SerializeWriter, "write", "(I)V");
            return;
        }
        for (int i = 0; i < size; ++i) {
            int seperator = i == size - 1 ? 93 : 44;
            FieldInfo property = getters.get(i);
            Class<?> propertyClass = property.fieldClass;
            mw.visitLdcInsn(property.name);
            mw.visitVarInsn(58, Context.fieldName);
            if (propertyClass == Byte.TYPE || propertyClass == Short.TYPE || propertyClass == Integer.TYPE) {
                mw.visitVarInsn(25, context.var("out"));
                this._get(mw, context, property);
                mw.visitVarInsn(16, seperator);
                mw.visitMethodInsn(182, SerializeWriter, "writeIntAndChar", "(IC)V");
                continue;
            }
            if (propertyClass == Long.TYPE) {
                mw.visitVarInsn(25, context.var("out"));
                this._get(mw, context, property);
                mw.visitVarInsn(16, seperator);
                mw.visitMethodInsn(182, SerializeWriter, "writeLongAndChar", "(JC)V");
                continue;
            }
            if (propertyClass == Float.TYPE) {
                mw.visitVarInsn(25, context.var("out"));
                this._get(mw, context, property);
                mw.visitVarInsn(16, seperator);
                mw.visitMethodInsn(182, SerializeWriter, "writeFloatAndChar", "(FC)V");
                continue;
            }
            if (propertyClass == Double.TYPE) {
                mw.visitVarInsn(25, context.var("out"));
                this._get(mw, context, property);
                mw.visitVarInsn(16, seperator);
                mw.visitMethodInsn(182, SerializeWriter, "writeDoubleAndChar", "(DC)V");
                continue;
            }
            if (propertyClass == Boolean.TYPE) {
                mw.visitVarInsn(25, context.var("out"));
                this._get(mw, context, property);
                mw.visitVarInsn(16, seperator);
                mw.visitMethodInsn(182, SerializeWriter, "writeBooleanAndChar", "(ZC)V");
                continue;
            }
            if (propertyClass == Character.TYPE) {
                mw.visitVarInsn(25, context.var("out"));
                this._get(mw, context, property);
                mw.visitVarInsn(16, seperator);
                mw.visitMethodInsn(182, SerializeWriter, "writeCharacterAndChar", "(CC)V");
                continue;
            }
            if (propertyClass == String.class) {
                mw.visitVarInsn(25, context.var("out"));
                this._get(mw, context, property);
                mw.visitVarInsn(16, seperator);
                mw.visitMethodInsn(182, SerializeWriter, "writeString", "(Ljava/lang/String;C)V");
                continue;
            }
            if (propertyClass.isEnum()) {
                mw.visitVarInsn(25, context.var("out"));
                this._get(mw, context, property);
                mw.visitVarInsn(16, seperator);
                mw.visitMethodInsn(182, SerializeWriter, "writeEnum", "(Ljava/lang/Enum;C)V");
                continue;
            }
            String format = property.getFormat();
            mw.visitVarInsn(25, 1);
            this._get(mw, context, property);
            if (format != null) {
                mw.visitLdcInsn(format);
                mw.visitMethodInsn(182, JSONSerializer, "writeWithFormat", "(Ljava/lang/Object;Ljava/lang/String;)V");
            } else {
                mw.visitVarInsn(25, Context.fieldName);
                if (property.fieldType instanceof Class && ((Class)property.fieldType).isPrimitive()) {
                    mw.visitMethodInsn(182, JSONSerializer, "writeWithFieldName", "(Ljava/lang/Object;Ljava/lang/Object;)V");
                } else {
                    mw.visitVarInsn(25, 0);
                    mw.visitFieldInsn(180, context.className, property.name + "_asm_fieldType", "Ljava/lang/reflect/Type;");
                    mw.visitLdcInsn(property.serialzeFeatures);
                    mw.visitMethodInsn(182, JSONSerializer, "writeWithFieldName", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/reflect/Type;I)V");
                }
            }
            mw.visitVarInsn(25, context.var("out"));
            mw.visitVarInsn(16, seperator);
            mw.visitMethodInsn(182, SerializeWriter, "write", "(I)V");
        }
    }

    private void generateWriteMethod(Class<?> clazz, MethodVisitor mw, List<FieldInfo> getters, Context context) throws Exception {
        Label end = new Label();
        int size = getters.size();
        Label endFormat_ = new Label();
        Label notNull_ = new Label();
        mw.visitVarInsn(25, context.var("out"));
        mw.visitMethodInsn(182, SerializeWriter, "isPrettyFormat", "()Z");
        mw.visitJumpInsn(153, endFormat_);
        mw.visitVarInsn(25, 0);
        mw.visitFieldInsn(180, context.className, "nature", JavaBeanSerializer_desc);
        mw.visitJumpInsn(199, notNull_);
        mw.visitLabel(notNull_);
        mw.visitVarInsn(25, 0);
        mw.visitFieldInsn(180, context.className, "nature", JavaBeanSerializer_desc);
        mw.visitVarInsn(25, 1);
        mw.visitVarInsn(25, 2);
        mw.visitVarInsn(25, 3);
        mw.visitVarInsn(25, 4);
        mw.visitVarInsn(21, 5);
        mw.visitMethodInsn(182, JavaBeanSerializer, "write", "(L" + JSONSerializer + ";Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/reflect/Type;I)V");
        mw.visitInsn(177);
        mw.visitLabel(endFormat_);
        Label endRef_ = new Label();
        notNull_ = new Label();
        mw.visitVarInsn(25, 0);
        mw.visitFieldInsn(180, context.className, "nature", JavaBeanSerializer_desc);
        mw.visitJumpInsn(199, notNull_);
        mw.visitLabel(notNull_);
        mw.visitVarInsn(25, 0);
        mw.visitFieldInsn(180, context.className, "nature", JavaBeanSerializer_desc);
        mw.visitVarInsn(25, 1);
        mw.visitVarInsn(25, 2);
        mw.visitVarInsn(21, 5);
        mw.visitMethodInsn(182, JavaBeanSerializer, "writeReference", "(L" + JSONSerializer + ";Ljava/lang/Object;I)Z");
        mw.visitJumpInsn(153, endRef_);
        mw.visitInsn(177);
        mw.visitLabel(endRef_);
        Label endWriteAsArray_ = new Label();
        mw.visitVarInsn(25, 0);
        mw.visitFieldInsn(180, context.className, "nature", JavaBeanSerializer_desc);
        mw.visitVarInsn(25, 1);
        mw.visitMethodInsn(182, JavaBeanSerializer, "isWriteAsArray", "(L" + JSONSerializer + ";)Z");
        mw.visitJumpInsn(153, endWriteAsArray_);
        mw.visitVarInsn(25, 0);
        mw.visitVarInsn(25, 1);
        mw.visitVarInsn(25, 2);
        mw.visitVarInsn(25, 3);
        mw.visitVarInsn(25, 4);
        mw.visitMethodInsn(182, context.className, "writeAsArray", "(L" + JSONSerializer + ";Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/reflect/Type;)V");
        mw.visitInsn(177);
        mw.visitLabel(endWriteAsArray_);
        mw.visitVarInsn(25, 1);
        mw.visitMethodInsn(182, JSONSerializer, "getContext", "()" + SerialContext_desc);
        mw.visitVarInsn(58, context.var("parent"));
        mw.visitVarInsn(25, 1);
        mw.visitVarInsn(25, context.var("parent"));
        mw.visitVarInsn(25, 2);
        mw.visitVarInsn(25, 3);
        mw.visitLdcInsn(context.beanSerializeFeatures);
        mw.visitMethodInsn(182, JSONSerializer, "setContext", "(" + SerialContext_desc + "Ljava/lang/Object;Ljava/lang/Object;I)V");
        Label end_ = new Label();
        Label else_ = new Label();
        Label writeClass_ = new Label();
        mw.visitVarInsn(25, 1);
        mw.visitVarInsn(25, 4);
        mw.visitVarInsn(25, 2);
        mw.visitMethodInsn(182, JSONSerializer, "isWriteClassName", "(Ljava/lang/reflect/Type;Ljava/lang/Object;)Z");
        mw.visitJumpInsn(153, else_);
        mw.visitVarInsn(25, 4);
        mw.visitVarInsn(25, 2);
        mw.visitMethodInsn(182, "java/lang/Object", "getClass", "()Ljava/lang/Class;");
        mw.visitJumpInsn(165, else_);
        mw.visitLabel(writeClass_);
        mw.visitVarInsn(25, context.var("out"));
        mw.visitLdcInsn("{\"" + JSON.DEFAULT_TYPE_KEY + "\":\"" + clazz.getName() + "\"");
        mw.visitMethodInsn(182, SerializeWriter, "write", "(Ljava/lang/String;)V");
        mw.visitVarInsn(16, 44);
        mw.visitJumpInsn(167, end_);
        mw.visitLabel(else_);
        mw.visitVarInsn(16, 123);
        mw.visitLabel(end_);
        mw.visitVarInsn(54, context.var("seperator"));
        if (!context.writeDirect) {
            this._before(mw, context);
        }
        mw.visitVarInsn(25, context.var("out"));
        mw.visitMethodInsn(182, SerializeWriter, "isNotWriteDefaultValue", "()Z");
        mw.visitVarInsn(54, context.var("notWriteDefaultValue"));
        if (!context.writeDirect) {
            mw.visitVarInsn(25, 1);
            mw.visitMethodInsn(182, JSONSerializer, "checkValue", "()Z");
            mw.visitVarInsn(54, context.var("checkValue"));
            mw.visitVarInsn(25, 1);
            mw.visitMethodInsn(182, JSONSerializer, "hasNameFilters", "()Z");
            mw.visitVarInsn(54, context.var("hasNameFilters"));
        }
        for (int i = 0; i < size; ++i) {
            FieldInfo property = getters.get(i);
            Class<?> propertyClass = property.fieldClass;
            mw.visitLdcInsn(property.name);
            mw.visitVarInsn(58, Context.fieldName);
            if (propertyClass == Byte.TYPE) {
                this._byte(clazz, mw, property, context);
                continue;
            }
            if (propertyClass == Short.TYPE) {
                this._short(clazz, mw, property, context);
                continue;
            }
            if (propertyClass == Integer.TYPE) {
                this._int(clazz, mw, property, context);
                continue;
            }
            if (propertyClass == Long.TYPE) {
                this._long(clazz, mw, property, context);
                continue;
            }
            if (propertyClass == Float.TYPE) {
                this._float(clazz, mw, property, context);
                continue;
            }
            if (propertyClass == Double.TYPE) {
                this._double(clazz, mw, property, context);
                continue;
            }
            if (propertyClass == Boolean.TYPE) {
                this._boolean(clazz, mw, property, context);
                continue;
            }
            if (propertyClass == Character.TYPE) {
                this._char(clazz, mw, property, context);
                continue;
            }
            if (propertyClass == String.class) {
                this._string(clazz, mw, property, context);
                continue;
            }
            if (propertyClass == BigDecimal.class) {
                this._decimal(clazz, mw, property, context);
                continue;
            }
            if (List.class.isAssignableFrom(propertyClass)) {
                this._list(clazz, mw, property, context);
                continue;
            }
            if (propertyClass.isEnum()) {
                this._enum(clazz, mw, property, context);
                continue;
            }
            this._object(clazz, mw, property, context);
        }
        if (!context.writeDirect) {
            this._after(mw, context);
        }
        Label _else = new Label();
        Label _end_if = new Label();
        mw.visitVarInsn(21, context.var("seperator"));
        mw.visitIntInsn(16, 123);
        mw.visitJumpInsn(160, _else);
        mw.visitVarInsn(25, context.var("out"));
        mw.visitVarInsn(16, 123);
        mw.visitMethodInsn(182, SerializeWriter, "write", "(I)V");
        mw.visitLabel(_else);
        mw.visitVarInsn(25, context.var("out"));
        mw.visitVarInsn(16, 125);
        mw.visitMethodInsn(182, SerializeWriter, "write", "(I)V");
        mw.visitLabel(_end_if);
        mw.visitLabel(end);
        mw.visitVarInsn(25, 1);
        mw.visitVarInsn(25, context.var("parent"));
        mw.visitMethodInsn(182, JSONSerializer, "setContext", "(" + SerialContext_desc + ")V");
    }

    private void _object(Class<?> clazz, MethodVisitor mw, FieldInfo property, Context context) {
        Label _end = new Label();
        this._nameApply(mw, property, context, _end);
        this._get(mw, context, property);
        mw.visitVarInsn(58, context.var("object"));
        this._filters(mw, property, context, _end);
        this._writeObject(mw, property, context, _end);
        mw.visitLabel(_end);
    }

    private void _enum(Class<?> clazz, MethodVisitor mw, FieldInfo property, Context context) {
        boolean writeEnumUsingToString = false;
        JSONField annotation = property.getAnnotation();
        if (annotation != null) {
            for (SerializerFeature feature : annotation.serialzeFeatures()) {
                if (feature != SerializerFeature.WriteEnumUsingToString) continue;
                writeEnumUsingToString = true;
            }
        }
        Label _not_null = new Label();
        Label _end_if = new Label();
        Label _end = new Label();
        this._nameApply(mw, property, context, _end);
        this._get(mw, context, property);
        mw.visitTypeInsn(192, "java/lang/Enum");
        mw.visitVarInsn(58, context.var("enum"));
        this._filters(mw, property, context, _end);
        mw.visitVarInsn(25, context.var("enum"));
        mw.visitJumpInsn(199, _not_null);
        this._if_write_null(mw, property, context);
        mw.visitJumpInsn(167, _end_if);
        mw.visitLabel(_not_null);
        mw.visitVarInsn(25, context.var("out"));
        mw.visitVarInsn(21, context.var("seperator"));
        mw.visitVarInsn(25, Context.fieldName);
        mw.visitVarInsn(25, context.var("enum"));
        if (writeEnumUsingToString) {
            mw.visitMethodInsn(182, "java/lang/Object", "toString", "()Ljava/lang/String;");
            mw.visitMethodInsn(182, SerializeWriter, "writeFieldValue", "(CLjava/lang/String;Ljava/lang/String;)V");
        } else if (context.writeDirect) {
            mw.visitMethodInsn(182, "java/lang/Enum", "name", "()Ljava/lang/String;");
            mw.visitMethodInsn(182, SerializeWriter, "writeFieldValueStringWithDoubleQuote", "(CLjava/lang/String;Ljava/lang/String;)V");
        } else {
            mw.visitMethodInsn(182, SerializeWriter, "writeFieldValue", "(CLjava/lang/String;Ljava/lang/Enum;)V");
        }
        this._seperator(mw, context);
        mw.visitLabel(_end_if);
        mw.visitLabel(_end);
    }

    private void _long(Class<?> clazz, MethodVisitor mw, FieldInfo property, Context context) {
        Label _end = new Label();
        this._nameApply(mw, property, context, _end);
        this._get(mw, context, property);
        mw.visitVarInsn(55, context.var("long", 2));
        this._filters(mw, property, context, _end);
        mw.visitVarInsn(25, context.var("out"));
        mw.visitVarInsn(21, context.var("seperator"));
        mw.visitVarInsn(25, Context.fieldName);
        mw.visitVarInsn(22, context.var("long", 2));
        mw.visitMethodInsn(182, SerializeWriter, "writeFieldValue", "(CLjava/lang/String;J)V");
        this._seperator(mw, context);
        mw.visitLabel(_end);
    }

    private void _float(Class<?> clazz, MethodVisitor mw, FieldInfo property, Context context) {
        Label _end = new Label();
        this._nameApply(mw, property, context, _end);
        this._get(mw, context, property);
        mw.visitVarInsn(56, context.var("float"));
        this._filters(mw, property, context, _end);
        mw.visitVarInsn(25, context.var("out"));
        mw.visitVarInsn(21, context.var("seperator"));
        mw.visitVarInsn(25, Context.fieldName);
        mw.visitVarInsn(23, context.var("float"));
        mw.visitMethodInsn(182, SerializeWriter, "writeFieldValue", "(CLjava/lang/String;F)V");
        this._seperator(mw, context);
        mw.visitLabel(_end);
    }

    private void _double(Class<?> clazz, MethodVisitor mw, FieldInfo property, Context context) {
        Label _end = new Label();
        this._nameApply(mw, property, context, _end);
        this._get(mw, context, property);
        mw.visitVarInsn(57, context.var("double", 2));
        this._filters(mw, property, context, _end);
        mw.visitVarInsn(25, context.var("out"));
        mw.visitVarInsn(21, context.var("seperator"));
        mw.visitVarInsn(25, Context.fieldName);
        mw.visitVarInsn(24, context.var("double", 2));
        mw.visitMethodInsn(182, SerializeWriter, "writeFieldValue", "(CLjava/lang/String;D)V");
        this._seperator(mw, context);
        mw.visitLabel(_end);
    }

    private void _char(Class<?> clazz, MethodVisitor mw, FieldInfo property, Context context) {
        Label _end = new Label();
        this._nameApply(mw, property, context, _end);
        this._get(mw, context, property);
        mw.visitVarInsn(54, context.var("char"));
        this._filters(mw, property, context, _end);
        mw.visitVarInsn(25, context.var("out"));
        mw.visitVarInsn(21, context.var("seperator"));
        mw.visitVarInsn(25, Context.fieldName);
        mw.visitVarInsn(21, context.var("char"));
        mw.visitMethodInsn(182, SerializeWriter, "writeFieldValue", "(CLjava/lang/String;C)V");
        this._seperator(mw, context);
        mw.visitLabel(_end);
    }

    private void _boolean(Class<?> clazz, MethodVisitor mw, FieldInfo property, Context context) {
        Label _end = new Label();
        this._nameApply(mw, property, context, _end);
        this._get(mw, context, property);
        mw.visitVarInsn(54, context.var("boolean"));
        this._filters(mw, property, context, _end);
        mw.visitVarInsn(25, context.var("out"));
        mw.visitVarInsn(21, context.var("seperator"));
        mw.visitVarInsn(25, Context.fieldName);
        mw.visitVarInsn(21, context.var("boolean"));
        mw.visitMethodInsn(182, SerializeWriter, "writeFieldValue", "(CLjava/lang/String;Z)V");
        this._seperator(mw, context);
        mw.visitLabel(_end);
    }

    private void _get(MethodVisitor mw, Context context, FieldInfo property) {
        Method method = property.method;
        if (method != null) {
            mw.visitVarInsn(25, context.var("entity"));
            mw.visitMethodInsn(182, ASMUtils.type(method.getDeclaringClass()), method.getName(), ASMUtils.desc(method));
        } else {
            mw.visitVarInsn(25, context.var("entity"));
            mw.visitFieldInsn(180, ASMUtils.type(property.declaringClass), property.field.getName(), ASMUtils.desc(property.fieldClass));
        }
    }

    private void _byte(Class<?> clazz, MethodVisitor mw, FieldInfo property, Context context) {
        Label _end = new Label();
        this._nameApply(mw, property, context, _end);
        this._get(mw, context, property);
        mw.visitVarInsn(54, context.var("byte"));
        this._filters(mw, property, context, _end);
        mw.visitVarInsn(25, context.var("out"));
        mw.visitVarInsn(21, context.var("seperator"));
        mw.visitVarInsn(25, Context.fieldName);
        mw.visitVarInsn(21, context.var("byte"));
        mw.visitMethodInsn(182, SerializeWriter, "writeFieldValue", "(CLjava/lang/String;I)V");
        this._seperator(mw, context);
        mw.visitLabel(_end);
    }

    private void _short(Class<?> clazz, MethodVisitor mw, FieldInfo property, Context context) {
        Label _end = new Label();
        this._nameApply(mw, property, context, _end);
        this._get(mw, context, property);
        mw.visitVarInsn(54, context.var("short"));
        this._filters(mw, property, context, _end);
        mw.visitVarInsn(25, context.var("out"));
        mw.visitVarInsn(21, context.var("seperator"));
        mw.visitVarInsn(25, Context.fieldName);
        mw.visitVarInsn(21, context.var("short"));
        mw.visitMethodInsn(182, SerializeWriter, "writeFieldValue", "(CLjava/lang/String;I)V");
        this._seperator(mw, context);
        mw.visitLabel(_end);
    }

    private void _int(Class<?> clazz, MethodVisitor mw, FieldInfo property, Context context) {
        Label _end = new Label();
        this._nameApply(mw, property, context, _end);
        this._get(mw, context, property);
        mw.visitVarInsn(54, context.var("int"));
        this._filters(mw, property, context, _end);
        mw.visitVarInsn(25, context.var("out"));
        mw.visitVarInsn(21, context.var("seperator"));
        mw.visitVarInsn(25, Context.fieldName);
        mw.visitVarInsn(21, context.var("int"));
        mw.visitMethodInsn(182, SerializeWriter, "writeFieldValue", "(CLjava/lang/String;I)V");
        this._seperator(mw, context);
        mw.visitLabel(_end);
    }

    private void _decimal(Class<?> clazz, MethodVisitor mw, FieldInfo property, Context context) {
        Label _end = new Label();
        this._nameApply(mw, property, context, _end);
        this._get(mw, context, property);
        mw.visitVarInsn(58, context.var("decimal"));
        this._filters(mw, property, context, _end);
        Label _if = new Label();
        Label _else = new Label();
        Label _end_if = new Label();
        mw.visitLabel(_if);
        mw.visitVarInsn(25, context.var("decimal"));
        mw.visitJumpInsn(199, _else);
        this._if_write_null(mw, property, context);
        mw.visitJumpInsn(167, _end_if);
        mw.visitLabel(_else);
        mw.visitVarInsn(25, context.var("out"));
        mw.visitVarInsn(21, context.var("seperator"));
        mw.visitVarInsn(25, Context.fieldName);
        mw.visitVarInsn(25, context.var("decimal"));
        mw.visitMethodInsn(182, SerializeWriter, "writeFieldValue", "(CLjava/lang/String;Ljava/math/BigDecimal;)V");
        this._seperator(mw, context);
        mw.visitJumpInsn(167, _end_if);
        mw.visitLabel(_end_if);
        mw.visitLabel(_end);
    }

    private void _string(Class<?> clazz, MethodVisitor mw, FieldInfo property, Context context) {
        Label _end = new Label();
        this._nameApply(mw, property, context, _end);
        this._get(mw, context, property);
        mw.visitVarInsn(58, context.var("string"));
        this._filters(mw, property, context, _end);
        Label _else = new Label();
        Label _end_if = new Label();
        mw.visitVarInsn(25, context.var("string"));
        mw.visitJumpInsn(199, _else);
        this._if_write_null(mw, property, context);
        mw.visitJumpInsn(167, _end_if);
        mw.visitLabel(_else);
        if (context.writeDirect) {
            mw.visitVarInsn(25, context.var("out"));
            mw.visitVarInsn(21, context.var("seperator"));
            mw.visitVarInsn(25, Context.fieldName);
            mw.visitVarInsn(25, context.var("string"));
            mw.visitMethodInsn(182, SerializeWriter, "writeFieldValueStringWithDoubleQuoteCheck", "(CLjava/lang/String;Ljava/lang/String;)V");
        } else {
            mw.visitVarInsn(25, context.var("out"));
            mw.visitVarInsn(21, context.var("seperator"));
            mw.visitVarInsn(25, Context.fieldName);
            mw.visitVarInsn(25, context.var("string"));
            mw.visitMethodInsn(182, SerializeWriter, "writeFieldValue", "(CLjava/lang/String;Ljava/lang/String;)V");
        }
        this._seperator(mw, context);
        mw.visitLabel(_end_if);
        mw.visitLabel(_end);
    }

    private void _list(Class<?> clazz, MethodVisitor mw, FieldInfo property, Context context) {
        Type propertyType = property.fieldType;
        Object elementType = propertyType instanceof Class ? Object.class : ((ParameterizedType)propertyType).getActualTypeArguments()[0];
        Class elementClass = null;
        if (elementType instanceof Class) {
            elementClass = (Class)elementType;
        }
        Label _end = new Label();
        Label _if = new Label();
        Label _else = new Label();
        Label _end_if = new Label();
        mw.visitLabel(_if);
        this._nameApply(mw, property, context, _end);
        this._get(mw, context, property);
        mw.visitTypeInsn(192, "java/util/List");
        mw.visitVarInsn(58, context.var("list"));
        this._filters(mw, property, context, _end);
        mw.visitVarInsn(25, context.var("list"));
        mw.visitJumpInsn(199, _else);
        this._if_write_null(mw, property, context);
        mw.visitJumpInsn(167, _end_if);
        mw.visitLabel(_else);
        mw.visitVarInsn(25, context.var("out"));
        mw.visitVarInsn(21, context.var("seperator"));
        mw.visitMethodInsn(182, SerializeWriter, "write", "(I)V");
        mw.visitVarInsn(25, context.var("out"));
        mw.visitVarInsn(25, Context.fieldName);
        mw.visitInsn(3);
        mw.visitMethodInsn(182, SerializeWriter, "writeFieldName", "(Ljava/lang/String;Z)V");
        mw.visitVarInsn(25, context.var("list"));
        mw.visitMethodInsn(185, "java/util/List", "size", "()I");
        mw.visitVarInsn(54, context.var("int"));
        Label _if_3 = new Label();
        Label _else_3 = new Label();
        Label _end_if_3 = new Label();
        mw.visitLabel(_if_3);
        mw.visitVarInsn(21, context.var("int"));
        mw.visitInsn(3);
        mw.visitJumpInsn(160, _else_3);
        mw.visitVarInsn(25, context.var("out"));
        mw.visitLdcInsn("[]");
        mw.visitMethodInsn(182, SerializeWriter, "write", "(Ljava/lang/String;)V");
        mw.visitJumpInsn(167, _end_if_3);
        mw.visitLabel(_else_3);
        mw.visitVarInsn(25, 1);
        mw.visitVarInsn(25, context.var("list"));
        mw.visitVarInsn(25, Context.fieldName);
        mw.visitMethodInsn(182, JSONSerializer, "setContext", "(Ljava/lang/Object;Ljava/lang/Object;)V");
        mw.visitVarInsn(25, context.var("out"));
        mw.visitVarInsn(16, 91);
        mw.visitMethodInsn(182, SerializeWriter, "write", "(I)V");
        mw.visitInsn(1);
        mw.visitTypeInsn(192, ASMUtils.type(ObjectSerializer.class));
        mw.visitVarInsn(58, context.var("list_ser"));
        Label _for = new Label();
        Label _end_for = new Label();
        mw.visitInsn(3);
        mw.visitVarInsn(54, context.var("i"));
        mw.visitLabel(_for);
        mw.visitVarInsn(21, context.var("i"));
        mw.visitVarInsn(21, context.var("int"));
        mw.visitInsn(4);
        mw.visitInsn(100);
        mw.visitJumpInsn(162, _end_for);
        if (elementType == String.class) {
            mw.visitVarInsn(25, context.var("out"));
            mw.visitVarInsn(25, context.var("list"));
            mw.visitVarInsn(21, context.var("i"));
            mw.visitMethodInsn(185, "java/util/List", "get", "(I)Ljava/lang/Object;");
            mw.visitTypeInsn(192, "java/lang/String");
            mw.visitVarInsn(16, 44);
            if (context.writeDirect) {
                mw.visitMethodInsn(182, SerializeWriter, "writeStringWithDoubleQuoteDirect", "(Ljava/lang/String;C)V");
            } else {
                mw.visitMethodInsn(182, SerializeWriter, "writeString", "(Ljava/lang/String;C)V");
            }
        } else {
            mw.visitVarInsn(25, 1);
            mw.visitVarInsn(25, context.var("list"));
            mw.visitVarInsn(21, context.var("i"));
            mw.visitMethodInsn(185, "java/util/List", "get", "(I)Ljava/lang/Object;");
            mw.visitVarInsn(21, context.var("i"));
            mw.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
            if (elementClass != null && Modifier.isPublic(elementClass.getModifiers())) {
                mw.visitLdcInsn(com.alibaba.fastjson.asm.Type.getType(ASMUtils.desc((Class)elementType)));
                mw.visitLdcInsn(property.serialzeFeatures);
                mw.visitMethodInsn(182, JSONSerializer, "writeWithFieldName", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/reflect/Type;I)V");
            } else {
                mw.visitMethodInsn(182, JSONSerializer, "writeWithFieldName", "(Ljava/lang/Object;Ljava/lang/Object;)V");
            }
            mw.visitVarInsn(25, context.var("out"));
            mw.visitVarInsn(16, 44);
            mw.visitMethodInsn(182, SerializeWriter, "write", "(I)V");
        }
        mw.visitIincInsn(context.var("i"), 1);
        mw.visitJumpInsn(167, _for);
        mw.visitLabel(_end_for);
        if (elementType == String.class) {
            mw.visitVarInsn(25, context.var("out"));
            mw.visitVarInsn(25, context.var("list"));
            mw.visitVarInsn(21, context.var("int"));
            mw.visitInsn(4);
            mw.visitInsn(100);
            mw.visitMethodInsn(185, "java/util/List", "get", "(I)Ljava/lang/Object;");
            mw.visitTypeInsn(192, "java/lang/String");
            mw.visitVarInsn(16, 93);
            if (context.writeDirect) {
                mw.visitMethodInsn(182, SerializeWriter, "writeStringWithDoubleQuoteDirect", "(Ljava/lang/String;C)V");
            } else {
                mw.visitMethodInsn(182, SerializeWriter, "writeString", "(Ljava/lang/String;C)V");
            }
        } else {
            mw.visitVarInsn(25, 1);
            mw.visitVarInsn(25, context.var("list"));
            mw.visitVarInsn(21, context.var("i"));
            mw.visitMethodInsn(185, "java/util/List", "get", "(I)Ljava/lang/Object;");
            mw.visitVarInsn(21, context.var("i"));
            mw.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
            if (elementClass != null && Modifier.isPublic(elementClass.getModifiers())) {
                mw.visitLdcInsn(com.alibaba.fastjson.asm.Type.getType(ASMUtils.desc((Class)elementType)));
                mw.visitLdcInsn(property.serialzeFeatures);
                mw.visitMethodInsn(182, JSONSerializer, "writeWithFieldName", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/reflect/Type;I)V");
            } else {
                mw.visitMethodInsn(182, JSONSerializer, "writeWithFieldName", "(Ljava/lang/Object;Ljava/lang/Object;)V");
            }
            mw.visitVarInsn(25, context.var("out"));
            mw.visitVarInsn(16, 93);
            mw.visitMethodInsn(182, SerializeWriter, "write", "(I)V");
        }
        mw.visitVarInsn(25, 1);
        mw.visitMethodInsn(182, JSONSerializer, "popContext", "()V");
        mw.visitLabel(_end_if_3);
        this._seperator(mw, context);
        mw.visitLabel(_end_if);
        mw.visitLabel(_end);
    }

    private void _filters(MethodVisitor mw, FieldInfo property, Context context, Label _end) {
        if (property.field != null && Modifier.isTransient(property.field.getModifiers())) {
            mw.visitVarInsn(25, context.var("out"));
            mw.visitMethodInsn(182, SerializeWriter, "isSkipTransientField", "()Z");
            mw.visitJumpInsn(154, _end);
        }
        this._notWriteDefault(mw, property, context, _end);
        if (context.writeDirect) {
            return;
        }
        this._apply(mw, property, context);
        mw.visitJumpInsn(153, _end);
        this._processKey(mw, property, context);
        Label _else_processKey = new Label();
        mw.visitVarInsn(21, context.var("checkValue"));
        mw.visitJumpInsn(154, _end);
        this._processValue(mw, property, context);
        mw.visitVarInsn(25, Context.original);
        mw.visitVarInsn(25, Context.processValue);
        mw.visitJumpInsn(165, _else_processKey);
        this._writeObject(mw, property, context, _end);
        mw.visitJumpInsn(167, _end);
        mw.visitLabel(_else_processKey);
    }

    private void _nameApply(MethodVisitor mw, FieldInfo property, Context context, Label _end) {
        if (!context.writeDirect) {
            mw.visitVarInsn(25, 1);
            mw.visitVarInsn(25, 2);
            mw.visitVarInsn(25, Context.fieldName);
            mw.visitMethodInsn(182, JSONSerializer, "applyName", "(Ljava/lang/Object;Ljava/lang/String;)Z");
            mw.visitJumpInsn(153, _end);
            this._labelApply(mw, property, context, _end);
        }
        if (property.field == null) {
            mw.visitVarInsn(25, context.var("out"));
            mw.visitMethodInsn(182, SerializeWriter, "isIgnoreNonFieldGetter", "()Z");
            mw.visitJumpInsn(154, _end);
        }
    }

    private void _labelApply(MethodVisitor mw, FieldInfo property, Context context, Label _end) {
        mw.visitVarInsn(25, 1);
        mw.visitLdcInsn(property.label);
        mw.visitMethodInsn(182, JSONSerializer, "applyLabel", "(Ljava/lang/String;)Z");
        mw.visitJumpInsn(153, _end);
    }

    private void _writeObject(MethodVisitor mw, FieldInfo fieldInfo, Context context, Label _end) {
        String format = fieldInfo.getFormat();
        Label _not_null = new Label();
        if (context.writeDirect) {
            mw.visitVarInsn(25, context.var("object"));
        } else {
            mw.visitVarInsn(25, Context.processValue);
        }
        mw.visitJumpInsn(199, _not_null);
        this._if_write_null(mw, fieldInfo, context);
        mw.visitJumpInsn(167, _end);
        mw.visitLabel(_not_null);
        mw.visitVarInsn(25, context.var("out"));
        mw.visitVarInsn(21, context.var("seperator"));
        mw.visitMethodInsn(182, SerializeWriter, "write", "(I)V");
        mw.visitVarInsn(25, context.var("out"));
        mw.visitVarInsn(25, Context.fieldName);
        mw.visitInsn(3);
        mw.visitMethodInsn(182, SerializeWriter, "writeFieldName", "(Ljava/lang/String;Z)V");
        mw.visitVarInsn(25, 1);
        if (context.writeDirect) {
            mw.visitVarInsn(25, context.var("object"));
        } else {
            mw.visitVarInsn(25, Context.processValue);
        }
        if (format != null) {
            mw.visitLdcInsn(format);
            mw.visitMethodInsn(182, JSONSerializer, "writeWithFormat", "(Ljava/lang/Object;Ljava/lang/String;)V");
        } else {
            mw.visitVarInsn(25, Context.fieldName);
            if (fieldInfo.fieldType instanceof Class && ((Class)fieldInfo.fieldType).isPrimitive()) {
                mw.visitMethodInsn(182, JSONSerializer, "writeWithFieldName", "(Ljava/lang/Object;Ljava/lang/Object;)V");
            } else {
                if (fieldInfo.fieldClass == String.class) {
                    mw.visitLdcInsn(com.alibaba.fastjson.asm.Type.getType(ASMUtils.desc(String.class)));
                } else {
                    mw.visitVarInsn(25, 0);
                    mw.visitFieldInsn(180, context.className, fieldInfo.name + "_asm_fieldType", "Ljava/lang/reflect/Type;");
                }
                mw.visitLdcInsn(fieldInfo.serialzeFeatures);
                mw.visitMethodInsn(182, JSONSerializer, "writeWithFieldName", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/reflect/Type;I)V");
            }
        }
        this._seperator(mw, context);
    }

    private void _before(MethodVisitor mw, Context context) {
        mw.visitVarInsn(25, 1);
        mw.visitVarInsn(25, 2);
        mw.visitVarInsn(21, context.var("seperator"));
        mw.visitMethodInsn(182, JSONSerializer, "writeBefore", "(Ljava/lang/Object;C)C");
        mw.visitVarInsn(54, context.var("seperator"));
    }

    private void _after(MethodVisitor mw, Context context) {
        mw.visitVarInsn(25, 1);
        mw.visitVarInsn(25, 2);
        mw.visitVarInsn(21, context.var("seperator"));
        mw.visitMethodInsn(182, JSONSerializer, "writeAfter", "(Ljava/lang/Object;C)C");
        mw.visitVarInsn(54, context.var("seperator"));
    }

    private void _notWriteDefault(MethodVisitor mw, FieldInfo property, Context context, Label _end) {
        Label elseLabel = new Label();
        mw.visitVarInsn(21, context.var("notWriteDefaultValue"));
        mw.visitJumpInsn(153, elseLabel);
        Class<?> propertyClass = property.fieldClass;
        if (propertyClass == Boolean.TYPE) {
            mw.visitVarInsn(21, context.var("boolean"));
            mw.visitJumpInsn(153, _end);
        } else if (propertyClass == Byte.TYPE) {
            mw.visitVarInsn(21, context.var("byte"));
            mw.visitJumpInsn(153, _end);
        } else if (propertyClass == Short.TYPE) {
            mw.visitVarInsn(21, context.var("short"));
            mw.visitJumpInsn(153, _end);
        } else if (propertyClass == Integer.TYPE) {
            mw.visitVarInsn(21, context.var("int"));
            mw.visitJumpInsn(153, _end);
        } else if (propertyClass == Long.TYPE) {
            mw.visitVarInsn(22, context.var("long"));
            mw.visitInsn(9);
            mw.visitInsn(148);
            mw.visitJumpInsn(153, _end);
        } else if (propertyClass == Float.TYPE) {
            mw.visitVarInsn(23, context.var("float"));
            mw.visitInsn(11);
            mw.visitInsn(149);
            mw.visitJumpInsn(153, _end);
        } else if (propertyClass == Double.TYPE) {
            mw.visitVarInsn(24, context.var("double"));
            mw.visitInsn(14);
            mw.visitInsn(151);
            mw.visitJumpInsn(153, _end);
        }
        mw.visitLabel(elseLabel);
    }

    private void _apply(MethodVisitor mw, FieldInfo property, Context context) {
        Class<?> propertyClass = property.fieldClass;
        mw.visitVarInsn(25, 1);
        mw.visitVarInsn(25, 2);
        mw.visitVarInsn(25, Context.fieldName);
        if (propertyClass == Byte.TYPE) {
            mw.visitVarInsn(21, context.var("byte"));
            mw.visitMethodInsn(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;");
        } else if (propertyClass == Short.TYPE) {
            mw.visitVarInsn(21, context.var("short"));
            mw.visitMethodInsn(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;");
        } else if (propertyClass == Integer.TYPE) {
            mw.visitVarInsn(21, context.var("int"));
            mw.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
        } else if (propertyClass == Character.TYPE) {
            mw.visitVarInsn(21, context.var("char"));
            mw.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;");
        } else if (propertyClass == Long.TYPE) {
            mw.visitVarInsn(22, context.var("long", 2));
            mw.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;");
        } else if (propertyClass == Float.TYPE) {
            mw.visitVarInsn(23, context.var("float"));
            mw.visitMethodInsn(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;");
        } else if (propertyClass == Double.TYPE) {
            mw.visitVarInsn(24, context.var("double", 2));
            mw.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;");
        } else if (propertyClass == Boolean.TYPE) {
            mw.visitVarInsn(21, context.var("boolean"));
            mw.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;");
        } else if (propertyClass == BigDecimal.class) {
            mw.visitVarInsn(25, context.var("decimal"));
        } else if (propertyClass == String.class) {
            mw.visitVarInsn(25, context.var("string"));
        } else if (propertyClass.isEnum()) {
            mw.visitVarInsn(25, context.var("enum"));
        } else if (List.class.isAssignableFrom(propertyClass)) {
            mw.visitVarInsn(25, context.var("list"));
        } else {
            mw.visitVarInsn(25, context.var("object"));
        }
        mw.visitMethodInsn(182, JSONSerializer, "apply", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;)Z");
    }

    private void _processValue(MethodVisitor mw, FieldInfo property, Context context) {
        Class<?> propertyClass = property.fieldClass;
        mw.visitVarInsn(25, 1);
        mw.visitVarInsn(25, 0);
        mw.visitFieldInsn(180, context.className, "nature", JavaBeanSerializer_desc);
        mw.visitVarInsn(25, 2);
        mw.visitVarInsn(25, Context.fieldName);
        String valueDesc = "Ljava/lang/Object;";
        if (propertyClass == Byte.TYPE) {
            mw.visitVarInsn(21, context.var("byte"));
            mw.visitMethodInsn(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;");
            mw.visitInsn(89);
            mw.visitVarInsn(58, Context.original);
        } else if (propertyClass == Short.TYPE) {
            mw.visitVarInsn(21, context.var("short"));
            mw.visitMethodInsn(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;");
            mw.visitInsn(89);
            mw.visitVarInsn(58, Context.original);
        } else if (propertyClass == Integer.TYPE) {
            mw.visitVarInsn(21, context.var("int"));
            mw.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
            mw.visitInsn(89);
            mw.visitVarInsn(58, Context.original);
        } else if (propertyClass == Character.TYPE) {
            mw.visitVarInsn(21, context.var("char"));
            mw.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;");
            mw.visitInsn(89);
            mw.visitVarInsn(58, Context.original);
        } else if (propertyClass == Long.TYPE) {
            mw.visitVarInsn(22, context.var("long", 2));
            mw.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;");
            mw.visitInsn(89);
            mw.visitVarInsn(58, Context.original);
        } else if (propertyClass == Float.TYPE) {
            mw.visitVarInsn(23, context.var("float"));
            mw.visitMethodInsn(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;");
            mw.visitInsn(89);
            mw.visitVarInsn(58, Context.original);
        } else if (propertyClass == Double.TYPE) {
            mw.visitVarInsn(24, context.var("double", 2));
            mw.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;");
            mw.visitInsn(89);
            mw.visitVarInsn(58, Context.original);
        } else if (propertyClass == Boolean.TYPE) {
            mw.visitVarInsn(21, context.var("boolean"));
            mw.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;");
            mw.visitInsn(89);
            mw.visitVarInsn(58, Context.original);
        } else if (propertyClass == BigDecimal.class) {
            mw.visitVarInsn(25, context.var("decimal"));
            mw.visitVarInsn(58, Context.original);
            mw.visitVarInsn(25, Context.original);
        } else if (propertyClass == String.class) {
            mw.visitVarInsn(25, context.var("string"));
            mw.visitVarInsn(58, Context.original);
            mw.visitVarInsn(25, Context.original);
        } else if (propertyClass.isEnum()) {
            mw.visitVarInsn(25, context.var("enum"));
            mw.visitVarInsn(58, Context.original);
            mw.visitVarInsn(25, Context.original);
        } else if (List.class.isAssignableFrom(propertyClass)) {
            mw.visitVarInsn(25, context.var("list"));
            mw.visitVarInsn(58, Context.original);
            mw.visitVarInsn(25, Context.original);
        } else {
            mw.visitVarInsn(25, context.var("object"));
            mw.visitVarInsn(58, Context.original);
            mw.visitVarInsn(25, Context.original);
        }
        mw.visitMethodInsn(182, JSONSerializer, "processValue", "(" + JavaBeanSerializer_desc + "Ljava/lang/Object;Ljava/lang/String;" + valueDesc + ")Ljava/lang/Object;");
        mw.visitVarInsn(58, Context.processValue);
    }

    private void _processKey(MethodVisitor mw, FieldInfo property, Context context) {
        Label _else_processKey = new Label();
        mw.visitVarInsn(21, context.var("hasNameFilters"));
        mw.visitJumpInsn(154, _else_processKey);
        Class<?> propertyClass = property.fieldClass;
        mw.visitVarInsn(25, 1);
        mw.visitVarInsn(25, 2);
        mw.visitVarInsn(25, Context.fieldName);
        if (propertyClass == Byte.TYPE) {
            mw.visitVarInsn(21, context.var("byte"));
            mw.visitMethodInsn(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;");
        } else if (propertyClass == Short.TYPE) {
            mw.visitVarInsn(21, context.var("short"));
            mw.visitMethodInsn(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;");
        } else if (propertyClass == Integer.TYPE) {
            mw.visitVarInsn(21, context.var("int"));
            mw.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
        } else if (propertyClass == Character.TYPE) {
            mw.visitVarInsn(21, context.var("char"));
            mw.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;");
        } else if (propertyClass == Long.TYPE) {
            mw.visitVarInsn(22, context.var("long", 2));
            mw.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;");
        } else if (propertyClass == Float.TYPE) {
            mw.visitVarInsn(23, context.var("float"));
            mw.visitMethodInsn(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;");
        } else if (propertyClass == Double.TYPE) {
            mw.visitVarInsn(24, context.var("double", 2));
            mw.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;");
        } else if (propertyClass == Boolean.TYPE) {
            mw.visitVarInsn(21, context.var("boolean"));
            mw.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;");
        } else if (propertyClass == BigDecimal.class) {
            mw.visitVarInsn(25, context.var("decimal"));
        } else if (propertyClass == String.class) {
            mw.visitVarInsn(25, context.var("string"));
        } else if (propertyClass.isEnum()) {
            mw.visitVarInsn(25, context.var("enum"));
        } else if (List.class.isAssignableFrom(propertyClass)) {
            mw.visitVarInsn(25, context.var("list"));
        } else {
            mw.visitVarInsn(25, context.var("object"));
        }
        mw.visitMethodInsn(182, JSONSerializer, "processKey", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/String;");
        mw.visitVarInsn(58, Context.fieldName);
        mw.visitLabel(_else_processKey);
    }

    private void _if_write_null(MethodVisitor mw, FieldInfo fieldInfo, Context context) {
        Class<?> propertyClass = fieldInfo.fieldClass;
        Label _if = new Label();
        Label _else = new Label();
        Label _write_null = new Label();
        Label _end_if = new Label();
        mw.visitLabel(_if);
        boolean writeNull = false;
        boolean writeNullNumberAsZero = false;
        boolean writeNullStringAsEmpty = false;
        boolean writeNullBooleanAsFalse = false;
        boolean writeNullListAsEmpty = false;
        JSONField annotation = fieldInfo.getAnnotation();
        if (annotation != null) {
            for (SerializerFeature feature : annotation.serialzeFeatures()) {
                if (feature == SerializerFeature.WriteMapNullValue) {
                    writeNull = true;
                    continue;
                }
                if (feature == SerializerFeature.WriteNullNumberAsZero) {
                    writeNullNumberAsZero = true;
                    continue;
                }
                if (feature == SerializerFeature.WriteNullStringAsEmpty) {
                    writeNullStringAsEmpty = true;
                    continue;
                }
                if (feature == SerializerFeature.WriteNullBooleanAsFalse) {
                    writeNullBooleanAsFalse = true;
                    continue;
                }
                if (feature != SerializerFeature.WriteNullListAsEmpty) continue;
                writeNullListAsEmpty = true;
            }
        }
        if (!writeNull) {
            mw.visitVarInsn(25, context.var("out"));
            mw.visitMethodInsn(182, SerializeWriter, "isWriteMapNullValue", "()Z");
            mw.visitJumpInsn(153, _else);
        }
        mw.visitLabel(_write_null);
        mw.visitVarInsn(25, context.var("out"));
        mw.visitVarInsn(21, context.var("seperator"));
        mw.visitVarInsn(25, Context.fieldName);
        if (propertyClass == String.class || propertyClass == Character.class) {
            if (writeNullStringAsEmpty) {
                mw.visitLdcInsn("");
                mw.visitMethodInsn(182, SerializeWriter, "writeFieldValue", "(CLjava/lang/String;Ljava/lang/String;)V");
            } else {
                mw.visitMethodInsn(182, SerializeWriter, "writeFieldNullString", "(CLjava/lang/String;)V");
            }
        } else if (Number.class.isAssignableFrom(propertyClass)) {
            if (writeNullNumberAsZero) {
                mw.visitInsn(3);
                mw.visitMethodInsn(182, SerializeWriter, "writeFieldValue", "(CLjava/lang/String;I)V");
            } else {
                mw.visitMethodInsn(182, SerializeWriter, "writeFieldNullNumber", "(CLjava/lang/String;)V");
            }
        } else if (propertyClass == Boolean.class) {
            if (writeNullBooleanAsFalse) {
                mw.visitInsn(3);
                mw.visitMethodInsn(182, SerializeWriter, "writeFieldValue", "(CLjava/lang/String;Z)V");
            } else {
                mw.visitMethodInsn(182, SerializeWriter, "writeFieldNullBoolean", "(CLjava/lang/String;)V");
            }
        } else if (Collection.class.isAssignableFrom(propertyClass) || propertyClass.isArray()) {
            if (writeNullListAsEmpty) {
                mw.visitMethodInsn(182, SerializeWriter, "writeFieldEmptyList", "(CLjava/lang/String;)V");
            } else {
                mw.visitMethodInsn(182, SerializeWriter, "writeFieldNullList", "(CLjava/lang/String;)V");
            }
        } else {
            mw.visitMethodInsn(182, SerializeWriter, "writeFieldNull", "(CLjava/lang/String;)V");
        }
        this._seperator(mw, context);
        mw.visitJumpInsn(167, _end_if);
        mw.visitLabel(_else);
        mw.visitLabel(_end_if);
    }

    private void _seperator(MethodVisitor mw, Context context) {
        mw.visitVarInsn(16, 44);
        mw.visitVarInsn(54, context.var("seperator"));
    }

    static class Context {
        static final int serializer = 1;
        static final int obj = 2;
        static final int paramFieldName = 3;
        static final int paramFieldType = 4;
        static final int features = 5;
        static int fieldName = 6;
        static int original = 7;
        static int processValue = 8;
        private final String className;
        private final int beanSerializeFeatures;
        private final boolean writeDirect;
        private Map<String, Integer> variants = new HashMap<String, Integer>();
        private int variantIndex = 9;

        public Context(String className, int beanSerializeFeatures, boolean writeDirect) {
            this.className = className;
            this.beanSerializeFeatures = beanSerializeFeatures;
            this.writeDirect = writeDirect;
            if (this.writeDirect) {
                processValue = 8;
            }
        }

        public int var(String name) {
            Integer i = this.variants.get(name);
            if (i == null) {
                this.variants.put(name, this.variantIndex++);
            }
            i = this.variants.get(name);
            return i;
        }

        public int var(String name, int increment) {
            Integer i = this.variants.get(name);
            if (i == null) {
                this.variants.put(name, this.variantIndex);
                this.variantIndex += increment;
            }
            i = this.variants.get(name);
            return i;
        }
    }
}

