/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.codegen;

import java.io.IOException;
import java.lang.reflect.Type;

public abstract class ClassGen {
    protected Class<?> clazz;
    protected Type type;
    protected Appendable out;
    private String indent = "\t";
    private int indentCount = 0;

    public ClassGen(Class<?> clazz, Appendable out) {
        this(clazz, null, out);
    }

    public ClassGen(Class<?> clazz, Type type, Appendable out) {
        this.clazz = clazz;
        this.type = type;
        this.out = out;
    }

    public abstract void gen() throws IOException;

    protected void println() throws IOException {
        this.out.append("\n");
        this.printIndent();
    }

    protected void println(String text) throws IOException {
        this.out.append(text);
        this.out.append("\n");
        this.printIndent();
    }

    protected void print(String text) throws IOException {
        this.out.append(text);
    }

    protected void printPackage() throws IOException {
        this.print("package ");
        this.print(this.clazz.getPackage().getName());
        this.println(";");
    }

    protected void beginClass(String className) throws IOException {
        this.print("public class ");
        this.print(className);
        this.print(" implements ObjectDeserializer {");
        this.incrementIndent();
        this.println();
    }

    protected void endClass() throws IOException {
        this.decrementIndent();
        this.println();
        this.print("}");
        this.println();
    }

    protected void genField(String name, Class<?> feildClass) throws IOException {
        if (feildClass == char[].class) {
            this.print("char[]");
        }
        this.print(" ");
        this.print(name);
        this.println(";");
    }

    protected void beginInit(String className) throws IOException {
        this.print("public ");
        this.print(className);
        this.println(" () {");
        this.incrementIndent();
    }

    protected void endInit() throws IOException {
        this.decrementIndent();
        this.print("}");
        this.println();
    }

    public void decrementIndent() {
        --this.indentCount;
    }

    public void incrementIndent() {
        ++this.indentCount;
    }

    public void printIndent() throws IOException {
        for (int i = 0; i < this.indentCount; ++i) {
            this.print(this.indent);
        }
    }

    protected void printClassName(Class<?> clazz) throws IOException {
        String name = clazz.getName();
        name = name.replace('$', '.');
        this.print(name);
    }
}

