/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.remoting.transport.netty4;

import com.alibaba.dubbo.common.Constants;
import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.common.Version;
import com.alibaba.dubbo.common.logger.Logger;
import com.alibaba.dubbo.common.logger.LoggerFactory;
import com.alibaba.dubbo.common.utils.NetUtils;
import com.alibaba.dubbo.remoting.Channel;
import com.alibaba.dubbo.remoting.ChannelHandler;
import com.alibaba.dubbo.remoting.RemotingException;
import com.alibaba.dubbo.remoting.transport.AbstractClient;
import com.alibaba.dubbo.remoting.transport.netty4.NettyChannel;
import com.alibaba.dubbo.remoting.transport.netty4.NettyClientHandler;
import com.alibaba.dubbo.remoting.transport.netty4.NettyCodecAdapter;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.net.SocketAddress;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class NettyClient
extends AbstractClient {
    private static final Logger logger = LoggerFactory.getLogger(NettyClient.class);
    private static final NioEventLoopGroup nioEventLoopGroup = new NioEventLoopGroup(Constants.DEFAULT_IO_THREADS, (ThreadFactory)new DefaultThreadFactory("NettyClientWorker", true));
    private Bootstrap bootstrap;
    private volatile io.netty.channel.Channel channel;

    public NettyClient(URL url, ChannelHandler handler) throws RemotingException {
        super(url, NettyClient.wrapChannelHandler(url, handler));
    }

    @Override
    protected void doOpen() throws Throwable {
        final NettyClientHandler nettyClientHandler = new NettyClientHandler(this.getUrl(), this);
        this.bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)this.bootstrap.group((EventLoopGroup)nioEventLoopGroup)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT)).channel(NioSocketChannel.class);
        if (this.getTimeout() < 3000) {
            this.bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)3000);
        } else {
            this.bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.getTimeout());
        }
        this.bootstrap.handler((io.netty.channel.ChannelHandler)new ChannelInitializer(){

            protected void initChannel(io.netty.channel.Channel ch) throws Exception {
                NettyCodecAdapter adapter = new NettyCodecAdapter(NettyClient.this.getCodec(), NettyClient.this.getUrl(), NettyClient.this);
                ch.pipeline().addLast("decoder", adapter.getDecoder()).addLast("encoder", adapter.getEncoder()).addLast("handler", (io.netty.channel.ChannelHandler)nettyClientHandler);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doConnect() throws Throwable {
        block21: {
            long start = System.currentTimeMillis();
            ChannelFuture future = this.bootstrap.connect((SocketAddress)this.getConnectAddress());
            try {
                boolean ret = future.awaitUninterruptibly(3000L, TimeUnit.MILLISECONDS);
                if (ret && future.isSuccess()) {
                    io.netty.channel.Channel newChannel = future.channel();
                    try {
                        io.netty.channel.Channel oldChannel = this.channel;
                        if (oldChannel == null) break block21;
                        try {
                            if (logger.isInfoEnabled()) {
                                logger.info("Close old netty channel " + oldChannel + " on create new netty channel " + newChannel);
                            }
                            oldChannel.close();
                            break block21;
                        }
                        finally {
                            NettyChannel.removeChannelIfDisconnected(oldChannel);
                        }
                    }
                    finally {
                        if (this.isClosed()) {
                            try {
                                if (logger.isInfoEnabled()) {
                                    logger.info("Close new netty channel " + newChannel + ", because the client closed.");
                                }
                                newChannel.close();
                            }
                            finally {
                                this.channel = null;
                                NettyChannel.removeChannelIfDisconnected(newChannel);
                            }
                        } else {
                            this.channel = newChannel;
                        }
                    }
                }
                if (future.cause() != null) {
                    throw new RemotingException(this, "client(url: " + this.getUrl() + ") failed to connect to server " + this.getRemoteAddress() + ", error message is:" + future.cause().getMessage(), future.cause());
                }
                throw new RemotingException((Channel)this, "client(url: " + this.getUrl() + ") failed to connect to server " + this.getRemoteAddress() + " client-side timeout " + this.getConnectTimeout() + "ms (elapsed: " + (System.currentTimeMillis() - start) + "ms) from netty client " + NetUtils.getLocalHost() + " using dubbo version " + Version.getVersion());
            }
            finally {
                if (!this.isConnected()) {
                    // empty if block
                }
            }
        }
    }

    @Override
    protected void doDisConnect() throws Throwable {
        try {
            NettyChannel.removeChannelIfDisconnected(this.channel);
        }
        catch (Throwable t) {
            logger.warn(t.getMessage());
        }
    }

    @Override
    protected void doClose() throws Throwable {
    }

    @Override
    protected Channel getChannel() {
        io.netty.channel.Channel c = this.channel;
        if (c == null || !c.isActive()) {
            return null;
        }
        return NettyChannel.getOrAddChannel(c, this.getUrl(), this);
    }
}

