/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.qos.server;

import com.alibaba.dubbo.common.logger.Logger;
import com.alibaba.dubbo.common.logger.LoggerFactory;
import com.alibaba.dubbo.common.utils.ConfigUtils;
import com.alibaba.dubbo.qos.server.DubboLogo;
import com.alibaba.dubbo.qos.server.handler.QosProcessHandler;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;

public class Server {
    private static final Logger logger = LoggerFactory.getLogger(Server.class);
    private static final Server INSTANCE = new Server();
    private int port = Integer.parseInt(ConfigUtils.getProperty("dubbo.qos.port", "22222"));
    private EventLoopGroup boss;
    private EventLoopGroup worker;
    private String welcome;
    private AtomicBoolean hasStarted = new AtomicBoolean();

    public static final Server getInstance() {
        return INSTANCE;
    }

    public int getPort() {
        return this.port;
    }

    private Server() {
        this.welcome = DubboLogo.dubbo;
    }

    public void setWelcome(String welcome) {
        this.welcome = welcome;
    }

    public void start() throws Throwable {
        if (!this.hasStarted.compareAndSet(false, true)) {
            return;
        }
        this.boss = new NioEventLoopGroup(0, (ThreadFactory)new DefaultThreadFactory("qos-boss", true));
        this.worker = new NioEventLoopGroup(0, (ThreadFactory)new DefaultThreadFactory("qos-worker", true));
        ServerBootstrap serverBootstrap = new ServerBootstrap();
        serverBootstrap.group(this.boss, this.worker);
        serverBootstrap.channel(NioServerSocketChannel.class);
        serverBootstrap.childOption(ChannelOption.TCP_NODELAY, (Object)true);
        serverBootstrap.childOption(ChannelOption.SO_REUSEADDR, (Object)true);
        serverBootstrap.childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{new QosProcessHandler(Server.this.welcome)});
            }
        });
        try {
            serverBootstrap.bind(this.port).sync();
            logger.info("qos-server bind localhost:" + this.port);
        }
        catch (Throwable throwable) {
            logger.error("qos-server can not bind localhost:" + this.port, throwable);
            throw throwable;
        }
    }

    public void stop() {
        logger.info("qos-server stopped.");
        if (this.boss != null) {
            this.boss.shutdownGracefully();
        }
        if (this.worker != null) {
            this.worker.shutdownGracefully();
        }
    }
}

