/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.gateway.common.param;

import com.alibaba.csp.sentinel.adapter.gateway.common.param.GatewayRegexCache;
import com.alibaba.csp.sentinel.adapter.gateway.common.param.RequestItemParser;
import com.alibaba.csp.sentinel.adapter.gateway.common.rule.GatewayFlowRule;
import com.alibaba.csp.sentinel.adapter.gateway.common.rule.GatewayParamFlowItem;
import com.alibaba.csp.sentinel.adapter.gateway.common.rule.GatewayRuleManager;
import com.alibaba.csp.sentinel.util.AssertUtil;
import com.alibaba.csp.sentinel.util.StringUtil;
import com.alibaba.csp.sentinel.util.function.Predicate;
import java.util.HashSet;
import java.util.regex.Pattern;

public class GatewayParamParser<T> {
    private final RequestItemParser<T> requestItemParser;

    public GatewayParamParser(RequestItemParser<T> requestItemParser) {
        AssertUtil.notNull(requestItemParser, (String)"requestItemParser cannot be null");
        this.requestItemParser = requestItemParser;
    }

    public Object[] parseParameterFor(String resource, T request, Predicate<GatewayFlowRule> rulePredicate) {
        if (StringUtil.isEmpty((String)resource) || request == null || rulePredicate == null) {
            return new Object[0];
        }
        HashSet<GatewayFlowRule> gatewayRules = new HashSet<GatewayFlowRule>();
        HashSet<Boolean> predSet = new HashSet<Boolean>();
        boolean hasNonParamRule = false;
        for (GatewayFlowRule rule : GatewayRuleManager.getRulesForResource(resource)) {
            if (rule.getParamItem() != null) {
                gatewayRules.add(rule);
                predSet.add(rulePredicate.test((Object)rule));
                continue;
            }
            hasNonParamRule = true;
        }
        if (!hasNonParamRule && gatewayRules.isEmpty()) {
            return new Object[0];
        }
        if (predSet.size() > 1 || predSet.contains(false)) {
            return new Object[0];
        }
        int size = hasNonParamRule ? gatewayRules.size() + 1 : gatewayRules.size();
        Object[] arr = new Object[size];
        for (GatewayFlowRule rule : gatewayRules) {
            GatewayParamFlowItem paramItem = rule.getParamItem();
            int idx = paramItem.getIndex();
            String param = this.parseInternal(paramItem, request);
            arr[idx] = param;
        }
        if (hasNonParamRule) {
            arr[size - 1] = "$D";
        }
        return arr;
    }

    private String parseInternal(GatewayParamFlowItem item, T request) {
        switch (item.getParseStrategy()) {
            case 0: {
                return this.parseClientIp(item, request);
            }
            case 1: {
                return this.parseHost(item, request);
            }
            case 2: {
                return this.parseHeader(item, request);
            }
            case 3: {
                return this.parseUrlParameter(item, request);
            }
            case 4: {
                return this.parseCookie(item, request);
            }
        }
        return null;
    }

    private String parseClientIp(GatewayParamFlowItem item, T request) {
        String clientIp = this.requestItemParser.getRemoteAddress(request);
        String pattern = item.getPattern();
        if (pattern == null) {
            return clientIp;
        }
        return this.parseWithMatchStrategyInternal(item.getMatchStrategy(), clientIp, pattern);
    }

    private String parseHeader(GatewayParamFlowItem item, T request) {
        String headerKey = item.getFieldName();
        String pattern = item.getPattern();
        String headerValue = this.requestItemParser.getHeader(request, headerKey);
        if (pattern == null) {
            return headerValue;
        }
        return this.parseWithMatchStrategyInternal(item.getMatchStrategy(), headerValue, pattern);
    }

    private String parseHost(GatewayParamFlowItem item, T request) {
        String pattern = item.getPattern();
        String host = this.requestItemParser.getHeader(request, "Host");
        if (pattern == null) {
            return host;
        }
        return this.parseWithMatchStrategyInternal(item.getMatchStrategy(), host, pattern);
    }

    private String parseUrlParameter(GatewayParamFlowItem item, T request) {
        String paramName = item.getFieldName();
        String pattern = item.getPattern();
        String param = this.requestItemParser.getUrlParam(request, paramName);
        if (pattern == null) {
            return param;
        }
        return this.parseWithMatchStrategyInternal(item.getMatchStrategy(), param, pattern);
    }

    private String parseCookie(GatewayParamFlowItem item, T request) {
        String cookieName = item.getFieldName();
        String pattern = item.getPattern();
        String param = this.requestItemParser.getCookieValue(request, cookieName);
        if (pattern == null) {
            return param;
        }
        return this.parseWithMatchStrategyInternal(item.getMatchStrategy(), param, pattern);
    }

    private String parseWithMatchStrategyInternal(int matchStrategy, String value, String pattern) {
        if (value == null) {
            return null;
        }
        switch (matchStrategy) {
            case 0: {
                return value.equals(pattern) ? value : "$NM";
            }
            case 3: {
                return value.contains(pattern) ? value : "$NM";
            }
            case 2: {
                Pattern regex = GatewayRegexCache.getRegexPattern(pattern);
                if (regex == null) {
                    return value;
                }
                return regex.matcher(value).matches() ? value : "$NM";
            }
        }
        return value;
    }
}

