/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.gateway.common.command;

import com.alibaba.csp.sentinel.adapter.gateway.common.api.ApiDefinition;
import com.alibaba.csp.sentinel.adapter.gateway.common.api.GatewayApiDefinitionManager;
import com.alibaba.csp.sentinel.command.CommandHandler;
import com.alibaba.csp.sentinel.command.CommandRequest;
import com.alibaba.csp.sentinel.command.CommandResponse;
import com.alibaba.csp.sentinel.command.annotation.CommandMapping;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.util.StringUtil;
import com.alibaba.fastjson.JSONArray;
import java.net.URLDecoder;
import java.util.HashSet;
import java.util.List;

@CommandMapping(name="gateway/updateApiDefinitions", desc="")
public class UpdateGatewayApiDefinitionGroupCommandHandler
implements CommandHandler<String> {
    private static final String SUCCESS_MSG = "success";

    public CommandResponse<String> handle(CommandRequest request) {
        String data = request.getParam("data");
        if (StringUtil.isBlank((String)data)) {
            return CommandResponse.ofFailure((Throwable)new IllegalArgumentException("Bad data"));
        }
        try {
            data = URLDecoder.decode(data, "utf-8");
        }
        catch (Exception e) {
            RecordLog.info((String)"Decode gateway API definition data error", (Throwable)e);
            return CommandResponse.ofFailure((Throwable)e, (Object)"decode gateway API definition data error");
        }
        RecordLog.info((String)"[API Server] Receiving data change (type: gateway API definition): {0}", (Object[])new Object[]{data});
        String result = SUCCESS_MSG;
        List apiDefinitions = JSONArray.parseArray((String)data, ApiDefinition.class);
        GatewayApiDefinitionManager.loadApiDefinitions(new HashSet<ApiDefinition>(apiDefinitions));
        return CommandResponse.ofSuccess((Object)result);
    }
}

