/*
 * Decompiled with CFR 0.152.
 */
package cn.jiguang.common.connection;

import cn.jiguang.common.ClientConfig;
import cn.jiguang.common.connection.HttpProxy;
import cn.jiguang.common.connection.IHttpClient;
import cn.jiguang.common.resp.APIConnectionException;
import cn.jiguang.common.resp.APIRequestException;
import cn.jiguang.common.resp.ResponseWrapper;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.UnknownHostException;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApacheHttpClient
implements IHttpClient {
    private static Logger LOG = LoggerFactory.getLogger(ApacheHttpClient.class);
    private static CloseableHttpClient _httpClient = null;
    private static final Object syncLock = new Object();
    private final int _connectionTimeout;
    private final int _connectionRequestTimeout;
    private final int _socketTimeout;
    private final int _maxRetryTimes;
    private String _authCode;
    private HttpHost _proxy;

    public ApacheHttpClient(String authCode, HttpProxy proxy, ClientConfig config) {
        this._maxRetryTimes = config.getMaxRetryTimes();
        this._connectionTimeout = config.getConnectionTimeout();
        this._connectionRequestTimeout = config.getConnectionRequestTimeout();
        this._socketTimeout = config.getSocketTimeout();
        this._authCode = authCode;
        if (proxy != null) {
            this._proxy = new HttpHost(proxy.getHost(), proxy.getPort());
        }
    }

    private void configHttpRequest(HttpRequestBase httpRequestBase) {
        RequestConfig requestConfig = this._proxy != null ? RequestConfig.custom().setConnectionRequestTimeout(this._connectionRequestTimeout).setConnectTimeout(this._connectionTimeout).setSocketTimeout(this._socketTimeout).setProxy(this._proxy).build() : RequestConfig.custom().setConnectionRequestTimeout(this._connectionRequestTimeout).setConnectTimeout(this._connectionTimeout).setSocketTimeout(this._socketTimeout).build();
        httpRequestBase.setConfig(requestConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CloseableHttpClient getHttpClient(String url) {
        String hostname = url.split("/")[2];
        int port = 80;
        if (hostname.contains(":")) {
            String[] arr = hostname.split(":");
            hostname = arr[0];
            port = Integer.parseInt(arr[1]);
        }
        if (_httpClient == null) {
            Object object = syncLock;
            synchronized (object) {
                if (_httpClient == null) {
                    _httpClient = this.createHttpClient(200, 40, 100, hostname, port);
                }
            }
        }
        return _httpClient;
    }

    public CloseableHttpClient createHttpClient(int maxTotal, int maxPerRoute, int maxRoute, String hostname, int port) {
        PlainConnectionSocketFactory plainsf = PlainConnectionSocketFactory.getSocketFactory();
        SSLConnectionSocketFactory sslsf = SSLConnectionSocketFactory.getSocketFactory();
        Registry registry = RegistryBuilder.create().register("http", (Object)plainsf).register("https", (Object)sslsf).build();
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager(registry);
        cm.setMaxTotal(maxTotal);
        cm.setDefaultMaxPerRoute(maxPerRoute);
        HttpHost httpHost = new HttpHost(hostname, port);
        cm.setMaxPerRoute(new HttpRoute(httpHost), maxRoute);
        HttpRequestRetryHandler httpRequestRetryHandler = new HttpRequestRetryHandler(){

            public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
                if (executionCount >= ApacheHttpClient.this._maxRetryTimes) {
                    return false;
                }
                if (exception instanceof NoHttpResponseException) {
                    return true;
                }
                if (exception instanceof SSLHandshakeException) {
                    return false;
                }
                if (exception instanceof InterruptedIOException) {
                    return false;
                }
                if (exception instanceof UnknownHostException) {
                    return false;
                }
                if (exception instanceof ConnectTimeoutException) {
                    return false;
                }
                if (exception instanceof SSLException) {
                    return false;
                }
                HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
                HttpRequest request = clientContext.getRequest();
                return !(request instanceof HttpEntityEnclosingRequest);
            }
        };
        CloseableHttpClient httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).setRetryHandler(httpRequestRetryHandler).build();
        return httpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResponseWrapper sendGet(String url) throws APIConnectionException, APIRequestException {
        ResponseWrapper wrapper = new ResponseWrapper();
        CloseableHttpResponse response = null;
        try {
            HttpGet httpGet = new HttpGet(url);
            httpGet.setHeader("Authorization", this._authCode);
            this.configHttpRequest((HttpRequestBase)httpGet);
            response = this.getHttpClient(url).execute((HttpUriRequest)httpGet, (HttpContext)HttpClientContext.create());
            this.processResponse(response, wrapper);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return wrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseWrapper sendGet(String url, String content) throws APIConnectionException, APIRequestException {
        ResponseWrapper wrapper = new ResponseWrapper();
        CloseableHttpResponse response = null;
        try {
            HttpGet httpGet = new HttpGet(url);
            httpGet.setHeader("Authorization", this._authCode);
            this.configHttpRequest((HttpRequestBase)httpGet);
            response = this.getHttpClient(url).execute((HttpUriRequest)httpGet, (HttpContext)HttpClientContext.create());
            this.processResponse(response, wrapper);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return wrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResponseWrapper sendDelete(String url) throws APIConnectionException, APIRequestException {
        ResponseWrapper wrapper = new ResponseWrapper();
        CloseableHttpResponse response = null;
        try {
            HttpDelete httpDelete = new HttpDelete(url);
            httpDelete.setHeader("Authorization", this._authCode);
            this.configHttpRequest((HttpRequestBase)httpDelete);
            response = this.getHttpClient(url).execute((HttpUriRequest)httpDelete, (HttpContext)HttpClientContext.create());
            this.processResponse(response, wrapper);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return wrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseWrapper sendDelete(String url, String content) throws APIConnectionException, APIRequestException {
        ResponseWrapper wrapper = new ResponseWrapper();
        CloseableHttpResponse response = null;
        try {
            HttpDelete httpDelete = new HttpDelete(url);
            httpDelete.setHeader("Authorization", this._authCode);
            this.configHttpRequest((HttpRequestBase)httpDelete);
            response = this.getHttpClient(url).execute((HttpUriRequest)httpDelete, (HttpContext)HttpClientContext.create());
            this.processResponse(response, wrapper);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return wrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResponseWrapper sendPost(String url, String content) throws APIConnectionException, APIRequestException {
        ResponseWrapper wrapper = new ResponseWrapper();
        CloseableHttpResponse response = null;
        try {
            HttpPost httpPost = new HttpPost(url);
            httpPost.setHeader("Authorization", this._authCode);
            this.configHttpRequest((HttpRequestBase)httpPost);
            StringEntity params = new StringEntity(content, "UTF-8");
            httpPost.setEntity((HttpEntity)params);
            response = this.getHttpClient(url).execute((HttpUriRequest)httpPost, (HttpContext)HttpClientContext.create());
            this.processResponse(response, wrapper);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return wrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResponseWrapper sendPut(String url, String content) throws APIConnectionException, APIRequestException {
        ResponseWrapper wrapper = new ResponseWrapper();
        CloseableHttpResponse response = null;
        try {
            HttpPut httpPut = new HttpPut(url);
            httpPut.setHeader("Authorization", this._authCode);
            this.configHttpRequest((HttpRequestBase)httpPut);
            StringEntity params = new StringEntity(content, "UTF-8");
            httpPut.setEntity((HttpEntity)params);
            response = this.getHttpClient(url).execute((HttpUriRequest)httpPut, (HttpContext)HttpClientContext.create());
            this.processResponse(response, wrapper);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return wrapper;
    }

    public void processResponse(CloseableHttpResponse response, ResponseWrapper wrapper) throws APIConnectionException, APIRequestException, IOException {
        HttpEntity entity = response.getEntity();
        LOG.debug("Response", (Object)response.toString());
        int status = response.getStatusLine().getStatusCode();
        String responseContent = EntityUtils.toString((HttpEntity)entity, (String)"utf-8");
        wrapper.responseCode = status;
        wrapper.responseContent = responseContent;
        LOG.debug(wrapper.responseContent);
        EntityUtils.consume((HttpEntity)entity);
        if (status >= 200 && status < 300) {
            LOG.debug("Succeed to get response OK - responseCode:" + status);
            LOG.debug("Response Content - " + responseContent);
        } else if (status >= 300 && status < 400) {
            LOG.warn("Normal response but unexpected - responseCode:" + status + ", responseContent:" + responseContent);
        } else {
            LOG.warn("Got error response - responseCode:" + status + ", responseContent:" + responseContent);
            switch (status) {
                case 400: {
                    LOG.error("Your request params is invalid. Please check them according to error message.");
                    wrapper.setErrorObject();
                    break;
                }
                case 401: {
                    LOG.error("Authentication failed! Please check authentication params according to docs.");
                    wrapper.setErrorObject();
                    break;
                }
                case 403: {
                    LOG.error("Request is forbidden! Maybe your appkey is listed in blacklist or your params is invalid.");
                    wrapper.setErrorObject();
                    break;
                }
                case 404: {
                    LOG.error("Request page is not found! Maybe your params is invalid.");
                    wrapper.setErrorObject();
                    break;
                }
                case 410: {
                    LOG.error("Request resource is no longer in service. Please according to notice on official website.");
                    wrapper.setErrorObject();
                }
                case 429: {
                    LOG.error("Too many requests! Please review your appkey's request quota.");
                    wrapper.setErrorObject();
                    break;
                }
                case 500: 
                case 502: 
                case 503: 
                case 504: {
                    LOG.error("Seems encountered server error. Maybe JPush is in maintenance? Please retry later.");
                    break;
                }
                default: {
                    LOG.error("Unexpected response.");
                }
            }
            throw new APIRequestException(wrapper);
        }
    }
}

