/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.convert.impl;

import cn.hutool.core.convert.AbstractConverter;
import cn.hutool.core.date.DateUtil;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;

public class TemporalAccessorConverter
extends AbstractConverter<TemporalAccessor> {
    private static final long serialVersionUID = 1L;
    private Class<?> targetType;
    private String format;

    public TemporalAccessorConverter(Class<?> targetType) {
        this.targetType = targetType;
    }

    public TemporalAccessorConverter(Class<?> targetType, String format) {
        this.targetType = targetType;
        this.format = format;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    @Override
    protected TemporalAccessor convertInternal(Object value) {
        if (value instanceof Long) {
            return this.parseFromLong((Long)value);
        }
        if (value instanceof TemporalAccessor) {
            return this.parseFromTemporalAccessor((TemporalAccessor)value);
        }
        if (value instanceof Date) {
            return this.parseFromInstant(((Date)value).toInstant());
        }
        if (value instanceof Calendar) {
            return this.parseFromInstant(((Calendar)value).toInstant());
        }
        return this.parseFromCharSequence(this.convertToStr(value));
    }

    private TemporalAccessor parseFromCharSequence(CharSequence value) {
        Instant instant;
        if (null != this.format) {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(this.format);
            instant = formatter.parse(value, Instant::from);
        } else {
            instant = DateUtil.parse(value).toInstant();
        }
        return this.parseFromInstant(instant);
    }

    private TemporalAccessor parseFromLong(Long time) {
        return this.parseFromInstant(Instant.ofEpochMilli(time));
    }

    private TemporalAccessor parseFromTemporalAccessor(TemporalAccessor temporalAccessor) {
        TemporalAccessor result = null;
        if (temporalAccessor instanceof LocalDateTime) {
            result = this.parseFromLocalDateTime((LocalDateTime)temporalAccessor);
        } else if (temporalAccessor instanceof ZonedDateTime) {
            result = this.parseFromZonedDateTime((ZonedDateTime)temporalAccessor);
        }
        if (null == result) {
            result = this.parseFromInstant(DateUtil.toInstant(temporalAccessor));
        }
        return result;
    }

    private TemporalAccessor parseFromLocalDateTime(LocalDateTime localDateTime) {
        if (Instant.class.equals(this.targetType)) {
            return DateUtil.toInstant(localDateTime);
        }
        if (LocalDate.class.equals(this.targetType)) {
            return localDateTime.toLocalDate();
        }
        if (LocalTime.class.equals(this.targetType)) {
            return localDateTime.toLocalTime();
        }
        if (ZonedDateTime.class.equals(this.targetType)) {
            return localDateTime.atZone(ZoneId.systemDefault());
        }
        if (OffsetDateTime.class.equals(this.targetType)) {
            return localDateTime.atZone(ZoneId.systemDefault()).toOffsetDateTime();
        }
        if (OffsetTime.class.equals(this.targetType)) {
            return localDateTime.atZone(ZoneId.systemDefault()).toOffsetDateTime().toOffsetTime();
        }
        return null;
    }

    private TemporalAccessor parseFromZonedDateTime(ZonedDateTime zonedDateTime) {
        if (Instant.class.equals(this.targetType)) {
            return DateUtil.toInstant(zonedDateTime);
        }
        if (LocalDateTime.class.equals(this.targetType)) {
            return zonedDateTime.toLocalDateTime();
        }
        if (LocalDate.class.equals(this.targetType)) {
            return zonedDateTime.toLocalDate();
        }
        if (LocalTime.class.equals(this.targetType)) {
            return zonedDateTime.toLocalTime();
        }
        if (OffsetDateTime.class.equals(this.targetType)) {
            return zonedDateTime.toOffsetDateTime();
        }
        if (OffsetTime.class.equals(this.targetType)) {
            return zonedDateTime.toOffsetDateTime().toOffsetTime();
        }
        return null;
    }

    private TemporalAccessor parseFromInstant(Instant instant) {
        if (Instant.class.equals(this.targetType)) {
            return instant;
        }
        if (LocalDateTime.class.equals(this.targetType)) {
            return LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
        }
        if (LocalDate.class.equals(this.targetType)) {
            return instant.atZone(ZoneId.systemDefault()).toLocalDate();
        }
        if (LocalTime.class.equals(this.targetType)) {
            return instant.atZone(ZoneId.systemDefault()).toLocalTime();
        }
        if (ZonedDateTime.class.equals(this.targetType)) {
            return instant.atZone(ZoneId.systemDefault());
        }
        if (OffsetDateTime.class.equals(this.targetType)) {
            return OffsetDateTime.ofInstant(instant, ZoneId.systemDefault());
        }
        if (OffsetTime.class.equals(this.targetType)) {
            return OffsetTime.ofInstant(instant, ZoneId.systemDefault());
        }
        return null;
    }
}

