/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.json;

import cn.hutool.core.bean.BeanDesc;
import cn.hutool.core.bean.BeanPath;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.lang.TypeReference;
import cn.hutool.core.map.CaseInsensitiveLinkedMap;
import cn.hutool.core.map.CaseInsensitiveMap;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.json.InternalJSONUtil;
import cn.hutool.json.JSON;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONConfig;
import cn.hutool.json.JSONConverter;
import cn.hutool.json.JSONException;
import cn.hutool.json.JSONGetter;
import cn.hutool.json.JSONTokener;
import cn.hutool.json.JSONUtil;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class JSONObject
extends JSONGetter<String>
implements JSON,
Map<String, Object> {
    private static final long serialVersionUID = -330220388580734346L;
    private static final int DEFAULT_CAPACITY = 16;
    private final Map<String, Object> rawHashMap;
    private JSONConfig config;

    public JSONObject() {
        this(16, false);
    }

    public JSONObject(boolean isOrder) {
        this(16, isOrder);
    }

    public JSONObject(int capacity, boolean isOrder) {
        this(capacity, false, isOrder);
    }

    public JSONObject(int capacity, boolean isIgnoreCase, boolean isOrder) {
        this(capacity, JSONConfig.create().setIgnoreCase(isIgnoreCase).setOrder(isOrder));
    }

    public JSONObject(int capacity, JSONConfig config) {
        this.rawHashMap = config.isIgnoreCase() ? (config.isOrder() ? new CaseInsensitiveLinkedMap(capacity) : new CaseInsensitiveMap(capacity)) : (config.isOrder() ? new LinkedHashMap(capacity) : new HashMap(capacity));
        this.config = config;
    }

    public JSONObject(Object source) {
        this(source, InternalJSONUtil.defaultIgnoreNullValue(source));
    }

    public JSONObject(Object source, boolean ignoreNullValue) {
        this(source, ignoreNullValue, source instanceof LinkedHashMap);
    }

    public JSONObject(Object source, boolean ignoreNullValue, boolean isOrder) {
        this(source, JSONConfig.create().setOrder(isOrder).setIgnoreCase(source instanceof CaseInsensitiveMap || source instanceof CaseInsensitiveLinkedMap).setIgnoreNullValue(ignoreNullValue));
    }

    public JSONObject(Object source, JSONConfig config) {
        this(16, config);
        this.init(source);
    }

    public JSONObject(Object obj, String ... names) {
        this();
        if (ArrayUtil.isEmpty(names)) {
            this.init(obj);
            return;
        }
        if (obj instanceof Map) {
            for (String name : names) {
                Object value = ((Map)obj).get(name);
                this.putOnce(name, value);
            }
        } else {
            for (String name : names) {
                try {
                    this.putOpt(name, ReflectUtil.getFieldValue(obj, name));
                }
                catch (Exception ignore) {
                    // empty catch block
                }
            }
        }
    }

    public JSONObject(CharSequence source, boolean isOrder) throws JSONException {
        this((Object)source, JSONConfig.create().setOrder(isOrder));
    }

    public JSONConfig getConfig() {
        return this.config;
    }

    public JSONObject setDateFormat(String format) {
        this.config.setDateFormat(format);
        return this;
    }

    public JSONArray toJSONArray(Collection<String> names) throws JSONException {
        if (CollectionUtil.isEmpty(names)) {
            return null;
        }
        JSONArray ja = new JSONArray();
        for (String name : names) {
            Object value = this.get(name);
            if (null == value) continue;
            ja.put(value);
        }
        return ja;
    }

    public <T> T toBean(Class<T> clazz) {
        return this.toBean((Type)clazz);
    }

    public <T> T toBean(TypeReference<T> reference) {
        return this.toBean(reference.getType());
    }

    public <T> T toBean(Type type) {
        return JSONConverter.jsonConvert(type, this, false);
    }

    @Override
    public int size() {
        return this.rawHashMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.rawHashMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.rawHashMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.rawHashMap.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        return this.rawHashMap.get(key);
    }

    @Override
    public Object getObj(String key, Object defaultValue) {
        Object obj = this.rawHashMap.get(key);
        return null == obj ? defaultValue : obj;
    }

    @Override
    public Object getByPath(String expression) {
        return BeanPath.create(expression).get(this);
    }

    @Override
    public <T> T getByPath(String expression, Class<T> resultType) {
        return JSONConverter.jsonConvert(resultType, this.getByPath(expression), true);
    }

    @Override
    public void putByPath(String expression, Object value) {
        BeanPath.create(expression).set(this, value);
    }

    @Override
    public JSONObject put(String key, Object value) throws JSONException {
        if (null == key) {
            return this;
        }
        boolean ignoreNullValue = this.config.isIgnoreNullValue();
        if (ObjectUtil.isNull(value) && ignoreNullValue) {
            this.remove(key);
        } else {
            InternalJSONUtil.testValidity(value);
            this.rawHashMap.put(key, JSONUtil.wrap(value, ignoreNullValue));
        }
        return this;
    }

    public JSONObject putOnce(String key, Object value) throws JSONException {
        if (key != null && value != null) {
            if (this.rawHashMap.containsKey(key)) {
                throw new JSONException("Duplicate key \"{}\"", key);
            }
            this.put(key, value);
        }
        return this;
    }

    public JSONObject putOpt(String key, Object value) throws JSONException {
        if (key != null && value != null) {
            this.put(key, value);
        }
        return this;
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        for (Map.Entry<? extends String, ? extends Object> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public JSONObject accumulate(String key, Object value) throws JSONException {
        InternalJSONUtil.testValidity(value);
        Object object = this.getObj(key);
        if (object == null) {
            this.put(key, value instanceof JSONArray ? new JSONArray().put(value) : value);
        } else if (object instanceof JSONArray) {
            ((JSONArray)object).put(value);
        } else {
            this.put(key, (Object)new JSONArray().put(object).put(value));
        }
        return this;
    }

    public JSONObject append(String key, Object value) throws JSONException {
        InternalJSONUtil.testValidity(value);
        Object object = this.getObj(key);
        if (object == null) {
            this.put(key, (Object)new JSONArray().put(value));
        } else if (object instanceof JSONArray) {
            this.put(key, (Object)((JSONArray)object).put(value));
        } else {
            throw new JSONException("JSONObject [" + key + "] is not a JSONArray.");
        }
        return this;
    }

    public JSONObject increment(String key) throws JSONException {
        Object value = this.getObj(key);
        if (value == null) {
            this.put(key, (Object)1);
        } else if (value instanceof BigInteger) {
            this.put(key, (Object)((BigInteger)value).add(BigInteger.ONE));
        } else if (value instanceof BigDecimal) {
            this.put(key, (Object)((BigDecimal)value).add(BigDecimal.ONE));
        } else if (value instanceof Integer) {
            this.put(key, (Object)((Integer)value + 1));
        } else if (value instanceof Long) {
            this.put(key, (Object)((Long)value + 1L));
        } else if (value instanceof Double) {
            this.put(key, (Object)((Double)value + 1.0));
        } else if (value instanceof Float) {
            this.put(key, (Object)Float.valueOf(((Float)value).floatValue() + 1.0f));
        } else {
            throw new JSONException("Unable to increment [" + JSONUtil.quote(key) + "].");
        }
        return this;
    }

    @Override
    public Object remove(Object key) {
        return this.rawHashMap.remove(key);
    }

    @Override
    public void clear() {
        this.rawHashMap.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.rawHashMap.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.rawHashMap.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.rawHashMap.entrySet();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.rawHashMap == null ? 0 : this.rawHashMap.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JSONObject other = (JSONObject)obj;
        return !(this.rawHashMap == null ? other.rawHashMap != null : !this.rawHashMap.equals(other.rawHashMap));
    }

    public String toString() {
        try {
            return this.toJSONString(0);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public String toStringPretty() throws JSONException {
        return this.toJSONString(4);
    }

    @Override
    public String toJSONString(int indentFactor) throws JSONException {
        StringWriter w = new StringWriter();
        return this.write(w, indentFactor, 0).toString();
    }

    @Override
    public Writer write(Writer writer) throws JSONException {
        return this.write(writer, 0, 0);
    }

    @Override
    public Writer write(Writer writer, int indentFactor, int indent) throws JSONException {
        try {
            return this.doWrite(writer, indentFactor, indent);
        }
        catch (IOException exception) {
            throw new JSONException(exception);
        }
    }

    private Writer doWrite(Writer writer, int indentFactor, int indent) throws IOException {
        writer.write(123);
        boolean isFirst = true;
        boolean isIgnoreNullValue = this.config.isIgnoreNullValue();
        int newIndent = indent + indentFactor;
        for (Map.Entry<String, Object> entry : this.entrySet()) {
            if (ObjectUtil.isNull(entry.getKey()) || ObjectUtil.isNull(entry.getValue()) && isIgnoreNullValue) continue;
            if (isFirst) {
                isFirst = false;
            } else {
                writer.write(44);
            }
            if (indentFactor > 0) {
                writer.write(10);
            }
            InternalJSONUtil.indent(writer, newIndent);
            writer.write(JSONUtil.quote(entry.getKey().toString()));
            writer.write(58);
            if (indentFactor > 0) {
                writer.write(32);
            }
            InternalJSONUtil.writeValue(writer, entry.getValue(), indentFactor, newIndent, this.config);
        }
        if (indentFactor > 0) {
            writer.write(10);
        }
        InternalJSONUtil.indent(writer, indent);
        writer.write(125);
        return writer;
    }

    private void populateMap(Object bean) {
        Collection<BeanDesc.PropDesc> props = BeanUtil.getBeanDesc(bean.getClass()).getProps();
        for (BeanDesc.PropDesc prop : props) {
            Object value;
            Method getter = prop.getGetter();
            if (null == getter) continue;
            try {
                value = getter.invoke(bean, new Object[0]);
            }
            catch (Exception ignore) {
                continue;
            }
            if (ObjectUtil.isNull(value) && this.config.isIgnoreNullValue() || value == bean) continue;
            this.rawHashMap.put(prop.getFieldName(), JSONUtil.wrap(value, this.config.isIgnoreNullValue()));
        }
    }

    private void init(Object source) {
        if (null == source) {
            return;
        }
        if (source instanceof Map) {
            boolean ignoreNullValue = this.config.isIgnoreNullValue();
            for (Map.Entry e : ((Map)source).entrySet()) {
                Object value = e.getValue();
                if (ignoreNullValue && null == value) continue;
                this.rawHashMap.put(Convert.toStr(e.getKey()), JSONUtil.wrap(value, ignoreNullValue));
            }
        } else if (source instanceof CharSequence) {
            this.init((CharSequence)source);
        } else if (source instanceof JSONTokener) {
            this.init((JSONTokener)source);
        } else if (!(source instanceof Number)) {
            this.populateMap(source);
        }
    }

    private void init(CharSequence source) {
        this.init(new JSONTokener(source.toString()));
    }

    private void init(JSONTokener x) {
        if (x.nextClean() != '{') {
            throw x.syntaxError("A JSONObject text must begin with '{'");
        }
        block8: while (true) {
            char c = x.nextClean();
            switch (c) {
                case '\u0000': {
                    throw x.syntaxError("A JSONObject text must end with '}'");
                }
                case '}': {
                    return;
                }
            }
            x.back();
            String key = x.nextValue().toString();
            c = x.nextClean();
            if (c != ':') {
                throw x.syntaxError("Expected a ':' after a key");
            }
            this.putOnce(key, x.nextValue());
            switch (x.nextClean()) {
                case ',': 
                case ';': {
                    if (x.nextClean() == '}') {
                        return;
                    }
                    x.back();
                    continue block8;
                }
                case '}': {
                    return;
                }
            }
            break;
        }
        throw x.syntaxError("Expected a ',' or '}'");
    }
}

