/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.db.sql;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.StrSpliter;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.db.DbUtil;
import cn.hutool.db.sql.LogicalOperator;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class Condition
implements Cloneable {
    private static final String OPERATOR_LIKE = "LIKE";
    private static final String OPERATOR_IN = "IN";
    private static final String OPERATOR_IS = "IS";
    private static final String OPERATOR_BETWEEN = "BETWEEN";
    private static final List<String> OPERATORS = Arrays.asList("<>", "<=", "<", ">=", ">", "=", "!=", "IN");
    private static final String VALUE_NULL = "NULL";
    private String field;
    private String operator;
    private Object value;
    private boolean isPlaceHolder = true;
    private boolean isBetween = false;
    private Object secondValue;

    public static Condition parse(String field, Object expression) {
        return new Condition(field, expression);
    }

    public Condition() {
    }

    public Condition(boolean isPlaceHolder) {
        this.isPlaceHolder = isPlaceHolder;
    }

    public Condition(String field, Object value) {
        this(field, "=", value);
        this.parseValue();
    }

    public Condition(String field, String operator, Object value) {
        this.field = field;
        this.operator = operator;
        this.value = value;
    }

    public Condition(String field, String value, LikeType likeType) {
        this.field = field;
        this.operator = OPERATOR_LIKE;
        this.value = DbUtil.buildLikeValue(value, likeType);
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public String getOperator() {
        return this.operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.setValue(value, false);
    }

    public void setValue(Object value, boolean isParse) {
        this.value = value;
        if (isParse) {
            this.parseValue();
        }
    }

    public boolean isPlaceHolder() {
        return this.isPlaceHolder;
    }

    public void setPlaceHolder(boolean isPlaceHolder) {
        this.isPlaceHolder = isPlaceHolder;
    }

    public boolean isBetween() {
        return this.isBetween;
    }

    public void setBetween(boolean between) {
        this.isBetween = between;
    }

    public Object getSecondValue() {
        return this.secondValue;
    }

    public void setSecondValue(Object secondValue) {
        this.secondValue = secondValue;
    }

    public Condition clone() {
        try {
            return (Condition)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public String toString() {
        return StrUtil.format((CharSequence)"`{}` {} {}", this.field, this.operator, this.value);
    }

    private void parseValue() {
        if (null == this.value) {
            this.operator = OPERATOR_IS;
            this.value = VALUE_NULL;
            return;
        }
        if (this.value instanceof Collection) {
            this.operator = OPERATOR_IN;
            this.value = CollectionUtil.join((Collection)this.value, (CharSequence)",");
            return;
        }
        if (ArrayUtil.isArray(this.value)) {
            this.operator = OPERATOR_IN;
            this.value = ArrayUtil.join(this.value, (CharSequence)",");
            return;
        }
        if (!(this.value instanceof String)) {
            return;
        }
        String valueStr = (String)this.value;
        if (StrUtil.isBlank(valueStr)) {
            return;
        }
        List<String> strs = StrUtil.split(valueStr = valueStr.trim(), ' ', 2);
        if (strs.size() < 2) {
            return;
        }
        String firstPart = strs.get(0).trim().toUpperCase();
        if (OPERATORS.contains(firstPart)) {
            this.operator = firstPart;
            this.value = strs.get(1).trim();
            return;
        }
        if (OPERATOR_LIKE.equals(firstPart)) {
            this.operator = OPERATOR_LIKE;
            this.value = Condition.unwrapQuote(strs.get(1));
            return;
        }
        if (OPERATOR_BETWEEN.equals(firstPart)) {
            this.isBetween = true;
            List<String> betweenValueStrs = StrSpliter.splitTrimIgnoreCase(strs.get(1), LogicalOperator.AND.toString(), 2, true);
            if (betweenValueStrs.size() < 2) {
                return;
            }
            this.operator = OPERATOR_BETWEEN;
            this.value = Condition.unwrapQuote(betweenValueStrs.get(0));
            this.secondValue = Condition.unwrapQuote(betweenValueStrs.get(1));
            return;
        }
        if (StrUtil.equalsIgnoreCase("= null", valueStr)) {
            this.operator = OPERATOR_IS;
            this.value = VALUE_NULL;
            return;
        }
    }

    private static String unwrapQuote(String value) {
        char endChar;
        if (null == value) {
            return null;
        }
        value = value.trim();
        int from = 0;
        int to = value.length();
        char startChar = value.charAt(0);
        if (startChar == (endChar = value.charAt(to - 1)) && ('\'' == startChar || '\"' == startChar)) {
            from = 1;
            --to;
        }
        if (from == 0 && to == value.length()) {
            return value;
        }
        return value.substring(from, to);
    }

    public static enum LikeType {
        StartWith,
        EndWith,
        Contains;

    }
}

