/*
 * Decompiled with CFR 0.152.
 */
package oracle.jpub.runtime;

import java.sql.Connection;
import java.sql.SQLException;
import oracle.jdbc.OracleDataFactory;
import oracle.jdbc.OracleStruct;
import oracle.jpub.runtime.OracleDataUtil;

public class OracleDataMutableStruct {
    int length;
    OracleStruct pickled;
    Object[] jdbcObjects;
    Object[] attributes;
    OracleDataFactory[] oracleDataFactories;
    int[] sqlTypes;
    boolean pickledCorrect;
    boolean[] isNChar;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;

    public OracleDataMutableStruct(OracleStruct oracleStruct, int[] nArray, OracleDataFactory[] oracleDataFactoryArray) {
        this.length = oracleDataFactoryArray.length;
        this.pickled = oracleStruct;
        this.oracleDataFactories = oracleDataFactoryArray;
        this.sqlTypes = nArray;
        this.initNChar(nArray.length);
        this.pickledCorrect = true;
    }

    public OracleDataMutableStruct(Object[] objectArray, int[] nArray, OracleDataFactory[] oracleDataFactoryArray) {
        this.length = oracleDataFactoryArray.length;
        this.attributes = objectArray;
        this.oracleDataFactories = oracleDataFactoryArray;
        this.sqlTypes = nArray;
        this.initNChar(nArray.length);
        this.pickledCorrect = false;
    }

    public OracleDataMutableStruct(OracleDataMutableStruct oracleDataMutableStruct, int[] nArray, OracleDataFactory[] oracleDataFactoryArray) {
        this.length = oracleDataFactoryArray.length;
        this.oracleDataFactories = oracleDataFactoryArray;
        this.sqlTypes = nArray;
        this.initNChar(nArray.length);
        this.pickled = oracleDataMutableStruct.pickled;
        this.pickledCorrect = oracleDataMutableStruct.pickledCorrect;
        this.jdbcObjects = oracleDataMutableStruct.jdbcObjects;
        this.attributes = oracleDataMutableStruct.attributes;
    }

    public Object toJDBCObject(Connection connection, String string) throws SQLException {
        if (!this.pickledCorrect) {
            this.pickled = (OracleStruct)connection.createStruct(string, this.getJDBCObjectAttributes(connection));
            this.pickledCorrect = true;
        }
        return this.pickled;
    }

    public Object getAttribute(int n2) throws SQLException {
        Object object = this.getLazyAttributes()[n2];
        if (object == null) {
            Object object2 = this.getLazyJDBCObjects()[n2];
            if (this.oracleDataFactories != null) {
                this.attributes[n2] = object = OracleDataUtil.convertToObject(object2, this.sqlTypes[n2], this.oracleDataFactories[n2]);
                if (OracleDataUtil.isMutable(object2, this.oracleDataFactories[n2])) {
                    this.resetJDBCObject(n2);
                }
            }
        }
        return object;
    }

    public Object getOracleAttribute(int n2) throws SQLException {
        Object object;
        if (this.oracleDataFactories[n2] == null) {
            object = this.getJDBCObjectAttribute(n2, null);
            Object object2 = this.getLazyJDBCObjects()[n2];
            if (OracleDataUtil.isMutable(object2, this.oracleDataFactories[n2])) {
                this.pickledCorrect = false;
            }
        } else {
            object = this.getAttribute(n2);
        }
        return object;
    }

    public Object[] getAttributes() throws SQLException {
        for (int i2 = 0; i2 < this.length; ++i2) {
            this.getAttribute(i2);
        }
        return this.attributes;
    }

    public Object[] getOracleAttributes() throws SQLException {
        Object[] objectArray = new Object[this.length];
        for (int i2 = 0; i2 < this.length; ++i2) {
            objectArray[i2] = this.getOracleAttribute(i2);
        }
        return objectArray;
    }

    public void setAttribute(int n2, Object object) throws SQLException {
        if (object == null) {
            this.getLazyJDBCObjects();
        }
        this.resetJDBCObject(n2);
        this.getLazyAttributes()[n2] = object;
    }

    public void setDoubleAttribute(int n2, double d2) throws SQLException {
        this.setAttribute(n2, d2);
    }

    public void setFloatAttribute(int n2, float f2) throws SQLException {
        this.setAttribute(n2, Float.valueOf(f2));
    }

    public void setIntAttribute(int n2, int n3) throws SQLException {
        this.setAttribute(n2, n3);
    }

    public void setOracleAttribute(int n2, Object object) throws SQLException {
        if (this.oracleDataFactories != null) {
            if (this.oracleDataFactories[n2] == null) {
                this.setJDBCObjectAttribute(n2, object);
            } else {
                this.setAttribute(n2, object);
            }
        }
    }

    Object getJDBCObjectAttribute(int n2, Connection connection) throws SQLException {
        Object object = this.getLazyJDBCObjects()[n2];
        if (object == null) {
            Object object2 = this.getLazyAttributes()[n2];
            this.jdbcObjects[n2] = object = OracleDataUtil.convertToOracle(object2, connection, this.isNChar(n2));
        }
        return object;
    }

    void setJDBCObjectAttribute(int n2, Object object) throws SQLException {
        this.resetAttribute(n2);
        this.getLazyJDBCObjects()[n2] = object;
        this.pickledCorrect = false;
    }

    Object[] getJDBCObjectAttributes(Connection connection) throws SQLException {
        for (int i2 = 0; i2 < this.length; ++i2) {
            this.getJDBCObjectAttribute(i2, connection);
        }
        return (Object[])this.jdbcObjects.clone();
    }

    void resetAttribute(int n2) throws SQLException {
        if (this.attributes != null) {
            this.attributes[n2] = null;
        }
    }

    void resetJDBCObject(int n2) throws SQLException {
        if (this.jdbcObjects != null) {
            this.jdbcObjects[n2] = null;
        }
        this.pickledCorrect = false;
    }

    Object[] getLazyAttributes() {
        if (this.attributes == null) {
            this.attributes = new Object[this.length];
        }
        return this.attributes;
    }

    Object[] getLazyJDBCObjects() throws SQLException {
        if (this.jdbcObjects == null) {
            if (this.pickled != null) {
                this.jdbcObjects = this.pickled.getAttributes();
                this.pickledCorrect = true;
                if (this.attributes != null) {
                    for (int i2 = 0; i2 < this.length; ++i2) {
                        if (this.attributes[i2] == null) continue;
                        this.jdbcObjects[i2] = null;
                        this.pickledCorrect = false;
                    }
                }
            } else {
                this.jdbcObjects = new Object[this.length];
            }
        }
        return this.jdbcObjects;
    }

    private void initNChar(int n2) {
        this.isNChar = new boolean[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.isNChar[i2] = false;
        }
    }

    public void setNChar(int n2) throws SQLException {
        this.isNChar[n2] = true;
    }

    public boolean isNChar(int n2) throws SQLException {
        boolean bl = this.isNChar[n2];
        return bl;
    }
}

