/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLocale;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CKvaldfList;
import oracle.jdbc.driver.T4CTTIfun;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.util.RepConversion;
import oracle.net.ano.AuthenticationService;
import oracle.net.nt.TcpsNTAdapter;
import oracle.security.o3logon.O3LoginClientHelper;
import oracle.security.o5logon.O5Logon;
import oracle.sql.ZONEIDMAP;
import oracle.sql.converter.CharacterSetMetaData;

final class T4CTTIoauthenticate
extends T4CTTIfun {
    byte[] terminal;
    byte[] enableTempLobRefCnt;
    byte[] machine;
    byte[] sysUserName;
    byte[] processID;
    byte[] programName;
    byte[] encryptedSK;
    byte[] internalName;
    byte[] externalName;
    byte[] alterSession;
    byte[] aclValue;
    byte[] clientname;
    byte[] editionName = null;
    byte[] driverName;
    String ressourceManagerId;
    boolean bUseO5Logon;
    int verifierType;
    static final int ZTVT_ORCL_7 = 2361;
    static final int ZTVT_SSH1 = 6949;
    static final int ZTVT_NTV = 7809;
    static final int ZTVT_SMD5 = 59694;
    static final int ZTVT_MD5 = 40674;
    static final int ZTVT_SH1 = 45394;
    static final int ZTVT_SHA512 = 18453;
    byte[] salt;
    byte[] encryptedKB;
    boolean isSessionTZ = true;
    static final int SERVER_VERSION_81 = 8100;
    static final int KPZ_LOGON = 1;
    static final int KPZ_CPW = 2;
    static final int KPZ_SRVAUTH = 4;
    static final int KPZ_ENCRYPTED_PASSWD = 256;
    static final int KPZ_LOGON_MIGRATE = 16;
    static final int KPZ_LOGON_SYSDBA = 32;
    static final int KPZ_LOGON_SYSOPER = 64;
    static final int KPZ_LOGON_PRELIMAUTH = 128;
    static final int KPZ_PASSWD_ENCRYPTED = 256;
    static final int KPZ_LOGON_DBCONC = 512;
    static final int KPZ_PROXY_AUTH = 1024;
    static final int KPZ_SESSION_CACHE = 2048;
    static final int KPZ_PASSWD_IS_VFR = 4096;
    static final int KPZ_LOGON_SYSASM = 0x400000;
    static final int KPZ_SESSION_QCACHE = 0x800000;
    static final int KPZ_LOGON_SYSBKP = 0x1000000;
    static final int KPZ_LOGON_SYSDGD = 0x2000000;
    static final int KPZ_LOGON_SYSKMT = 0x4000000;
    static final String AUTH_TERMINAL = "AUTH_TERMINAL";
    static final String AUTH_PROGRAM_NM = "AUTH_PROGRAM_NM";
    static final String AUTH_MACHINE = "AUTH_MACHINE";
    static final String AUTH_PID = "AUTH_PID";
    static final String AUTH_SID = "AUTH_SID";
    static final String AUTH_SESSKEY = "AUTH_SESSKEY";
    static final String AUTH_VFR_DATA = "AUTH_VFR_DATA";
    static final String AUTH_PASSWORD = "AUTH_PASSWORD";
    static final String AUTH_INTERNALNAME = "AUTH_INTERNALNAME_";
    static final String AUTH_EXTERNALNAME = "AUTH_EXTERNALNAME_";
    static final String AUTH_ACL = "AUTH_ACL";
    static final String AUTH_ALTER_SESSION = "AUTH_ALTER_SESSION";
    static final String AUTH_INITIAL_CLIENT_ROLE = "INITIAL_CLIENT_ROLE";
    static final String AUTH_VERSION_SQL = "AUTH_VERSION_SQL";
    static final String AUTH_VERSION_NO = "AUTH_VERSION_NO";
    static final String AUTH_XACTION_TRAITS = "AUTH_XACTION_TRAITS";
    static final String AUTH_VERSION_STATUS = "AUTH_VERSION_STATUS";
    static final String AUTH_SERIAL_NUM = "AUTH_SERIAL_NUM";
    static final String AUTH_SESSION_ID = "AUTH_SESSION_ID";
    static final String AUTH_CLIENT_CERTIFICATE = "AUTH_CLIENT_CERTIFICATE";
    static final String AUTH_PROXY_CLIENT_NAME = "PROXY_CLIENT_NAME";
    static final String AUTH_CLIENT_DN = "AUTH_CLIENT_DISTINGUISHED_NAME";
    static final String AUTH_INSTANCENAME = "AUTH_INSTANCENAME";
    static final String AUTH_DBNAME = "AUTH_DBNAME";
    static final String AUTH_INSTANCE_NO = "AUTH_INSTANCE_NO";
    static final String AUTH_DB_ID = "AUTH_DB_ID";
    static final String AUTH_QCACHE_MAXSIZE = "AUTH_QCACHE_MAXSIZE";
    static final String AUTH_QCACHE_CACHELAG = "AUTH_QCACHE_CACHELAG";
    static final String AUTH_GLOBALLY_UNIQUE_DBID = "AUTH_GLOBALLY_UNIQUE_DBID";
    static final String AUTH_QCACHE_CACHEID = "AUTH_QCACHE_CACHEID";
    static final String AUTH_QCACHE_REGID = "AUTH_QCACHE_REGID";
    static final String AUTH_SC_SERVER_HOST = "AUTH_SC_SERVER_HOST";
    static final String AUTH_SC_INSTANCE_NAME = "AUTH_SC_INSTANCE_NAME";
    static final String AUTH_SC_INSTANCE_ID = "AUTH_SC_INSTANCE_ID";
    static final String AUTH_SC_INSTANCE_START_TIME = "AUTH_SC_INSTANCE_START_TIME";
    static final String AUTH_SC_DBUNIQUE_NAME = "AUTH_SC_DBUNIQUE_NAME";
    static final String AUTH_SC_SERVICE_NAME = "AUTH_SC_SERVICE_NAME";
    static final String AUTH_SC_SVC_FLAGS = "AUTH_SC_SVC_FLAGS";
    static final String AUTH_SC_DB_DOMAIN = "AUTH_SC_DB_DOMAIN";
    static final String AUTH_SESSION_CLIENT_CSET = "SESSION_CLIENT_CHARSET";
    static final String AUTH_SESSION_CLIENT_LTYPE = "SESSION_CLIENT_LIB_TYPE";
    static final String AUTH_SESSION_CLIENT_DRVNM = "SESSION_CLIENT_DRIVER_NAME";
    static final String AUTH_SESSION_CLIENT_VSN = "SESSION_CLIENT_VERSION";
    static final String AUTH_NLS_LXLAN = "AUTH_NLS_LXLAN";
    static final String AUTH_NLS_LXCTERRITORY = "AUTH_NLS_LXCTERRITORY";
    static final String AUTH_NLS_LXCCURRENCY = "AUTH_NLS_LXCCURRENCY";
    static final String AUTH_NLS_LXCISOCURR = "AUTH_NLS_LXCISOCURR";
    static final String AUTH_NLS_LXCNUMERICS = "AUTH_NLS_LXCNUMERICS";
    static final String AUTH_NLS_LXCDATEFM = "AUTH_NLS_LXCDATEFM";
    static final String AUTH_NLS_LXCDATELANG = "AUTH_NLS_LXCDATELANG";
    static final String AUTH_NLS_LXCSORT = "AUTH_NLS_LXCSORT";
    static final String AUTH_NLS_LXCCALENDAR = "AUTH_NLS_LXCCALENDAR";
    static final String AUTH_NLS_LXCUNIONCUR = "AUTH_NLS_LXCUNIONCUR";
    static final String AUTH_NLS_LXCTIMEFM = "AUTH_NLS_LXCTIMEFM";
    static final String AUTH_NLS_LXCSTMPFM = "AUTH_NLS_LXCSTMPFM";
    static final String AUTH_NLS_LXCTTZNFM = "AUTH_NLS_LXCTTZNFM";
    static final String AUTH_NLS_LXCSTZNFM = "AUTH_NLS_LXCSTZNFM";
    static final String SESSION_CLIENT_LOBATTR = "SESSION_CLIENT_LOBATTR";
    static final String AUTH_KPPL_CONN_CLASS = "AUTH_KPPL_CONN_CLASS";
    static final String AUTH_KPPL_PURITY = "AUTH_KPPL_PURITY";
    static final String AUTH_KPPL_TAG = "AUTH_KPPL_TAG";
    static final String AUTH_KPPL_WAIT = "AUTH_KPPL_WAIT";
    static final String AUTH_PBKDF2_SPEEDY_KEY = "AUTH_PBKDF2_SPEEDY_KEY";
    static final String KPPL_PURITY_DEFAULT = "0";
    static final String KPPL_PURITY_NEW = "1";
    static final String KPPL_PURITY_SELF = "2";
    static final String AUTH_CONNECT_STRING = "AUTH_CONNECT_STRING";
    static final String DRIVER_NAME_DEFAULT = "jdbcthin";
    static final int KPU_LIB_UNKN = 0;
    static final int KPU_LIB_DEF = 1;
    static final int KPU_LIB_EI = 2;
    static final int KPU_LIB_XE = 3;
    static final int KPU_LIB_ICUS = 4;
    static final int KPU_LIB_OCI = 5;
    static final int KPU_LIB_THIN = 10;
    static final String AUTH_ORA_EDITION = "AUTH_ORA_EDITION";
    static final String AUTH_COPYRIGHT = "AUTH_COPYRIGHT";
    static final String COPYRIGHT_STR = "\"Oracle\nEverybody follows\nSpeedy bits exchange\nStars await to glow\"\nThe preceding key is copyrighted by Oracle Corporation.\nDuplication of this key is not allowed without permission\nfrom Oracle Corporation. Copyright 2003 Oracle Corporation.";
    static final String SESSION_TIME_ZONE = "SESSION_TIME_ZONE";
    static final String SESSION_NLS_LXCCHARSET = "SESSION_NLS_LXCCHARSET";
    static final String SESSION_NLS_LXCNLSLENSEM = "SESSION_NLS_LXCNLSLENSEM";
    static final String SESSION_NLS_LXCNCHAREXCP = "SESSION_NLS_LXCNCHAREXCP";
    static final String SESSION_NLS_LXCNCHARIMP = "SESSION_NLS_LXCNCHARIMP";
    public static final int AUTH_FLAG_O5LOGON = 0;
    public static final int AUTH_FLAG_NONO5LOGON = 1;
    String sessionTimeZone = null;
    private T4CKvaldfList keyValList = null;
    private byte[] user = null;
    private long logonMode;
    private byte[][] outKeys = null;
    private byte[][] outValues = null;
    private int[] outFlags = new int[0];
    private int outNbPairs = 0;
    private byte[] PBKDF2Salt;
    private int PBKDF2VgenCount;
    private int PBKDF2SderCount;
    O5Logon o5logonHelper = null;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;

    T4CTTIoauthenticate(T4CConnection t4CConnection, String string) throws SQLException {
        super(t4CConnection, (byte)3);
        this.ressourceManagerId = string;
        this.setSessionFields(t4CConnection);
        this.isSessionTZ = true;
        this.bUseO5Logon = false;
    }

    @Override
    void marshal() throws IOException {
        if (this.user != null && this.user.length > 0) {
            this.meg.marshalPTR();
            this.meg.marshalSB4(this.user.length);
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalSB4(0);
        }
        this.meg.marshalUB4(this.logonMode);
        this.meg.marshalPTR();
        this.meg.marshalUB4(this.keyValList.size());
        this.meg.marshalPTR();
        this.meg.marshalPTR();
        if (this.user != null && this.user.length > 0) {
            this.meg.marshalCHR(this.user);
        }
        this.meg.marshalKEYVAL(this.keyValList.getKeys(), this.keyValList.getValues(), this.keyValList.getFlags(), this.keyValList.size());
    }

    private void doOAUTH(byte[] byArray, byte[] byArray2, long l2, String string, boolean bl, byte[] byArray3, byte[] byArray4, byte[][] byArray5, int n2, int n3, byte[] byArray6) throws IOException, SQLException {
        this.setFunCode((short)115);
        this.user = byArray;
        this.logonMode = l2 | 1L;
        if (this.connection.isResultSetCacheEnabled) {
            this.logonMode |= 0x800000L;
        }
        if (bl) {
            this.logonMode |= 0x400L;
        }
        if (byArray != null && byArray.length != 0 && byArray2 != null && string != "RADIUS") {
            this.logonMode |= 0x100L;
        }
        this.keyValList = new T4CKvaldfList(this.meg.conv);
        if (byArray2 != null) {
            this.keyValList.add(AUTH_PASSWORD, byArray2);
        }
        if (byArray6 != null) {
            this.keyValList.add(AUTH_PBKDF2_SPEEDY_KEY, byArray6);
        }
        if (byArray5 != null) {
            for (int i2 = 0; i2 < byArray5.length; ++i2) {
                this.keyValList.add(AUTH_INITIAL_CLIENT_ROLE, byArray5[i2]);
            }
        }
        if (byArray3 != null) {
            this.keyValList.add(AUTH_CLIENT_DN, byArray3);
        }
        if (byArray4 != null) {
            this.keyValList.add(AUTH_CLIENT_CERTIFICATE, byArray4);
        }
        this.keyValList.add(AUTH_TERMINAL, this.terminal);
        if (this.bUseO5Logon && this.encryptedKB != null) {
            this.keyValList.add(AUTH_SESSKEY, this.encryptedKB, (byte)1);
        }
        if (this.programName != null) {
            this.keyValList.add(AUTH_PROGRAM_NM, this.programName);
        }
        if (this.clientname != null) {
            this.keyValList.add(AUTH_PROXY_CLIENT_NAME, this.clientname);
        }
        this.keyValList.add(AUTH_MACHINE, this.machine);
        this.keyValList.add(AUTH_PID, this.processID);
        if (!this.ressourceManagerId.equals("0000")) {
            byte[] byArray7 = this.meg.conv.StringToCharBytes(AUTH_INTERNALNAME);
            byArray7[byArray7.length - 1] = 0;
            this.keyValList.add(byArray7, this.internalName);
            byArray7 = this.meg.conv.StringToCharBytes(AUTH_EXTERNALNAME);
            byArray7[byArray7.length - 1] = 0;
            this.keyValList.add(byArray7, this.externalName);
        }
        this.keyValList.add(AUTH_ACL, this.aclValue);
        this.keyValList.add(AUTH_ALTER_SESSION, this.alterSession, (byte)1);
        if (this.editionName != null) {
            this.keyValList.add(AUTH_ORA_EDITION, this.editionName);
        }
        this.keyValList.add(SESSION_CLIENT_LOBATTR, this.enableTempLobRefCnt);
        this.keyValList.add(AUTH_SESSION_CLIENT_DRVNM, this.driverName);
        this.keyValList.add(AUTH_SESSION_CLIENT_VSN, this.meg.conv.StringToCharBytes(Integer.toString(this.versionStringToInt(this.connection.getMetaData().getDriverVersion()), 10)));
        if (n2 != -1) {
            this.keyValList.add(AUTH_SESSION_ID, this.meg.conv.StringToCharBytes(Integer.toString(n2)));
        }
        if (n3 != -1) {
            this.keyValList.add(AUTH_SERIAL_NUM, this.meg.conv.StringToCharBytes(Integer.toString(n3)));
        }
        if (this.connection.drcpEnabled) {
            this.keyValList.add(AUTH_KPPL_CONN_CLASS, this.meg.conv.StringToCharBytes(this.connection.drcpConnectionClass));
            this.keyValList.add(AUTH_KPPL_PURITY, this.meg.conv.StringToCharBytes(KPPL_PURITY_SELF));
            if (this.connection.drcpTagName != null) {
                this.keyValList.add(AUTH_KPPL_TAG, this.meg.conv.StringToCharBytes(this.connection.drcpTagName));
            }
        }
        this.keyValList.add(AUTH_CONNECT_STRING, this.meg.conv.StringToCharBytes(this.connection.net.getConnectionString()));
        if (this.connection.isResultSetCacheActive()) {
            this.keyValList.add(AUTH_QCACHE_CACHEID, this.connection.getResultSetCacheIdAsNibbles());
            this.keyValList.add(AUTH_QCACHE_REGID, this.meg.conv.StringToCharBytes(Long.toString(this.connection.getResultSetCacheRegistrationId())));
        }
        this.keyValList.add(AUTH_COPYRIGHT, this.meg.conv.StringToCharBytes(COPYRIGHT_STR));
        this.outNbPairs = 0;
        this.outKeys = null;
        this.outValues = null;
        this.outFlags = new int[0];
        this.doRPC();
    }

    void doOSESSKEY(String string, long l2) throws IOException, SQLException {
        this.setFunCode((short)118);
        this.user = this.meg.conv.StringToCharBytes(string);
        this.logonMode = l2 | 1L;
        this.keyValList = new T4CKvaldfList(this.meg.conv);
        this.keyValList.add(AUTH_TERMINAL, this.terminal);
        if (this.programName != null) {
            this.keyValList.add(AUTH_PROGRAM_NM, this.programName);
        }
        this.keyValList.add(AUTH_MACHINE, this.machine);
        this.keyValList.add(AUTH_PID, this.processID);
        this.keyValList.add(AUTH_SID, this.sysUserName);
        this.outNbPairs = 0;
        this.outKeys = null;
        this.outValues = null;
        this.outFlags = new int[0];
        this.doRPC();
    }

    @Override
    void readRPA() throws IOException, SQLException {
        this.outNbPairs = this.meg.unmarshalUB2();
        this.outKeys = new byte[this.outNbPairs][];
        this.outValues = new byte[this.outNbPairs][];
        this.outFlags = this.meg.unmarshalKEYVAL(this.outKeys, this.outValues, this.outNbPairs);
    }

    @Override
    void processError() throws SQLException {
        if (this.getFunCode() == 118) {
            if (this.oer.getRetCode() != 28035 || this.connection.net.getAuthenticationAdaptorName() != "RADIUS") {
                this.oer.processError();
            }
        } else {
            super.processError();
        }
    }

    @Override
    protected void processRPA() throws SQLException {
        if (this.getFunCode() == 115) {
            Properties properties = new Properties();
            for (int i2 = 0; i2 < this.outNbPairs; ++i2) {
                String string = this.meg.conv.CharBytesToString(this.outKeys[i2], this.outKeys[i2].length).trim();
                String string2 = "";
                if (this.outValues[i2] != null) {
                    string2 = this.meg.conv.CharBytesToString(this.outValues[i2], this.outValues[i2].length).trim();
                }
                properties.setProperty(string, string2);
            }
            String string = properties.getProperty(AUTH_VERSION_NO);
            if (string != null) {
                try {
                    int n2 = new Integer(string);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            properties.setProperty("SERVER_HOST", properties.getProperty(AUTH_SC_SERVER_HOST, ""));
            properties.setProperty("INSTANCE_NAME", properties.getProperty(AUTH_SC_INSTANCE_NAME, ""));
            properties.setProperty("DATABASE_NAME", properties.getProperty(AUTH_SC_DBUNIQUE_NAME, ""));
            properties.setProperty("SERVICE_NAME", properties.getProperty(AUTH_SC_SERVICE_NAME, ""));
            properties.setProperty(SESSION_TIME_ZONE, this.sessionTimeZone);
            if (this.connection.sessionProperties != null) {
                this.connection.sessionProperties.putAll((Map<?, ?>)properties);
            } else {
                this.connection.sessionProperties = properties;
            }
        } else if (this.getFunCode() == 118) {
            int n3;
            Properties properties = new Properties();
            for (n3 = 0; n3 < this.outNbPairs; ++n3) {
                String string = this.meg.conv.CharBytesToString(this.outKeys[n3], this.outKeys[n3].length).trim();
                String string3 = "";
                if (this.outValues[n3] != null) {
                    string3 = this.meg.conv.CharBytesToString(this.outValues[n3], this.outValues[n3].length).trim();
                }
                if (string.compareTo(AUTH_GLOBALLY_UNIQUE_DBID) != 0 && string.compareTo(AUTH_QCACHE_MAXSIZE) != 0 && string.compareTo(AUTH_QCACHE_CACHELAG) != 0) continue;
                properties.setProperty(string, string3);
            }
            if (this.connection.sessionProperties != null) {
                this.connection.sessionProperties.putAll((Map<?, ?>)properties);
            } else {
                this.connection.sessionProperties = properties;
            }
            if (this.connection.net.getAuthenticationAdaptorName() != "RADIUS") {
                if (this.outKeys == null || this.outKeys.length < 1) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 438);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                n3 = -1;
                int n4 = -1;
                int n5 = -1;
                int n6 = -1;
                int n7 = -1;
                try {
                    for (int i3 = 0; i3 < this.outKeys.length; ++i3) {
                        String string = new String(this.outKeys[i3], "US-ASCII");
                        if (string.equals(AUTH_SESSKEY)) {
                            n3 = i3;
                        } else if (string.equals(AUTH_VFR_DATA)) {
                            n4 = i3;
                        } else if (string.equals("AUTH_PBKDF2_CSK_SALT")) {
                            n5 = i3;
                        } else if (string.equals("AUTH_PBKDF2_VGEN_COUNT")) {
                            n6 = i3;
                        } else if (string.equals("AUTH_PBKDF2_SDER_COUNT")) {
                            n7 = i3;
                        }
                        if (n4 == -1 || n3 == -1 || n5 == -1 || n6 == -1 || n7 == -1) {
                            continue;
                        }
                        break;
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                if (n3 == -1) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 438);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.encryptedSK = this.outValues[n3];
                if (n4 != -1) {
                    this.bUseO5Logon = true;
                    this.salt = this.outValues[n4];
                    this.verifierType = this.outFlags[n4];
                    if (this.connection.allowedLogonVersion.equals("12a") && this.verifierType != 18453) {
                        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 292);
                        sQLException.fillInStackTrace();
                        throw sQLException;
                    }
                    if (this.connection.allowedLogonVersion.equals("12") && this.verifierType != 18453 && (this.verifierType != 6949 && this.verifierType != 45394 || !this.connection.hasServerCompileTimeCapability(4, 2))) {
                        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 292);
                        sQLException.fillInStackTrace();
                        throw sQLException;
                    }
                }
                if (n5 != -1) {
                    this.PBKDF2Salt = this.outValues[n5];
                }
                if (n6 != -1) {
                    try {
                        this.PBKDF2VgenCount = Integer.parseInt(new String(this.outValues[n6], "US-ASCII"));
                        if (this.PBKDF2VgenCount < 4096) {
                            this.PBKDF2VgenCount = 4096;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (n7 != -1) {
                    try {
                        this.PBKDF2SderCount = Integer.parseInt(new String(this.outValues[n7], "US-ASCII"));
                        if (this.PBKDF2SderCount < 3) {
                            this.PBKDF2SderCount = 3;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (!(this.bUseO5Logon || this.encryptedSK != null && this.encryptedSK.length == 16)) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 438);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
            }
        }
    }

    void doOAUTH(String string, String string2, long l2) throws IOException, SQLException {
        Object object;
        Object object2;
        byte[] byArray = null;
        if (string != null && string.length() > 0) {
            byArray = this.meg.conv.StringToCharBytes(string);
        }
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        byte[] byArray5 = null;
        String string3 = this.connection.net.getAuthenticationAdaptorName();
        if (string != null && string.length() != 0) {
            byte by;
            if (string3 != "RADIUS" && this.encryptedSK.length > 16 && !this.bUseO5Logon) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 413);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.bUseO5Logon && (this.encryptedSK == null || this.encryptedSK.length != 64 && this.encryptedSK.length != 96)) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 413);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            object2 = string.trim();
            object = null;
            if (string2 != null) {
                object = string2.trim();
            }
            string2 = null;
            String string4 = object2;
            String string5 = object;
            if (((String)object2).startsWith("\"") || ((String)object2).endsWith("\"")) {
                string4 = this.removeQuotes((String)object2);
            }
            if (object != null && ((String)object).startsWith("\"") && ((String)object).endsWith("\"")) {
                string5 = this.removeQuotes((String)object);
            }
            if (string5 != null) {
                byArray2 = this.meg.conv.StringToCharBytes(string5);
            }
            if (string3 != "RADIUS") {
                if (byArray2 == null) {
                    byArray4 = null;
                } else if (this.bUseO5Logon) {
                    if (this.o5logonHelper == null) {
                        this.o5logonHelper = new O5Logon(this.connection, this.connection.isO7L_MRExposed);
                    }
                    if (this.verifierType != 2361 && this.verifierType != 40674 && this.verifierType != 59694 && this.verifierType != 45394 && this.verifierType != 6949 && this.verifierType != 18453) {
                        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 451);
                        sQLException.fillInStackTrace();
                        throw sQLException;
                    }
                    this.encryptedKB = new byte[this.encryptedSK.length];
                    for (int i2 = 0; i2 < this.encryptedKB.length; ++i2) {
                        this.encryptedKB[i2] = 1;
                    }
                    int[] nArray = new int[1];
                    byte[] byArray6 = new byte[256];
                    int[] nArray2 = new int[1];
                    byte[] byArray7 = new byte[256];
                    for (int i3 = 0; i3 < 256; ++i3) {
                        byArray6[i3] = 0;
                    }
                    try {
                        this.o5logonHelper.generateOAuthResponse(this.verifierType, this.salt, string4, string5, byArray2, this.encryptedSK, this.encryptedKB, byArray6, nArray, this.meg.conv.isServerCSMultiByte, this.connection.getServerCompileTimeCapability(4), this.PBKDF2Salt, this.PBKDF2VgenCount, this.PBKDF2SderCount, byArray7, nArray2);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    byArray4 = new byte[nArray[0]];
                    System.arraycopy(byArray6, 0, byArray4, 0, nArray[0]);
                    if (this.verifierType == 18453 && this.connection.hasServerCompileTimeCapability(4, 32)) {
                        byArray5 = new byte[nArray2[0]];
                        System.arraycopy(byArray7, 0, byArray5, 0, nArray2[0]);
                    }
                } else {
                    O3LoginClientHelper o3LoginClientHelper = new O3LoginClientHelper(this.meg.conv.isServerCSMultiByte);
                    byte[] byArray8 = o3LoginClientHelper.getSessionKey(string4, string5, this.encryptedSK);
                    by = byArray2.length % 8 > 0 ? (byte)((byte)(8 - byArray2.length % 8)) : (byte)0;
                    byArray3 = new byte[byArray2.length + by];
                    System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
                    byte[] byArray9 = o3LoginClientHelper.getEPasswd(byArray8, byArray3);
                    byArray4 = new byte[2 * byArray3.length + 1];
                    if (byArray4.length < 2 * byArray9.length) {
                        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 413);
                        sQLException.fillInStackTrace();
                        throw sQLException;
                    }
                    RepConversion.bArray2Nibbles(byArray9, byArray4);
                    byArray4[byArray4.length - 1] = RepConversion.nibbleToHex(by);
                }
            } else if (byArray2 != null) {
                if (this.connection.net.getSessionAttributes().getNTAdapter() instanceof TcpsNTAdapter) {
                    byArray4 = byArray2;
                } else {
                    by = (byArray2.length + 1) % 8 > 0 ? (byte)((byte)(8 - (byArray2.length + 1) % 8)) : (byte)0;
                    byArray3 = new byte[byArray2.length + 1 + by];
                    System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
                    byte[] byArray10 = AuthenticationService.obfuscatePasswordForRadius(byArray3);
                    byArray4 = new byte[byArray10.length * 2];
                    for (int i4 = 0; i4 < byArray10.length; ++i4) {
                        byte by2 = (byte)((byArray10[i4] & 0xF0) >> 4);
                        byte by3 = (byte)(byArray10[i4] & 0xF);
                        byArray4[i4 * 2] = (byte)(by2 < 10 ? by2 + 48 : by2 - 10 + 97);
                        byArray4[i4 * 2 + 1] = (byte)(by3 < 10 ? by3 + 48 : by3 - 10 + 97);
                    }
                }
            }
        }
        this.doOAUTH(byArray, byArray4, l2, string3, false, null, null, null, -1, -1, byArray5);
        if (string3 != "RADIUS" && this.bUseO5Logon) {
            String string6 = this.connection.sessionProperties.getProperty("AUTH_SVR_RESPONSE");
            try {
                if (this.o5logonHelper == null) {
                    this.o5logonHelper = new O5Logon(this.connection, this.connection.isO7L_MRExposed);
                }
                if (!this.o5logonHelper.validateServerIdentity(string6)) {
                    object2 = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 452);
                    ((Throwable)object2).fillInStackTrace();
                    throw object2;
                }
            }
            catch (Exception exception) {
                object = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 452);
                ((Throwable)object).fillInStackTrace();
                throw object;
            }
        }
    }

    void doOAUTH(int n2, Properties properties, int n3, int n4) throws IOException, SQLException {
        String string;
        CharSequence charSequence;
        byte[] byArray = null;
        byte[] byArray2 = null;
        String[] stringArray = null;
        Object object = null;
        byte[] byArray3 = null;
        if (n2 == 1) {
            charSequence = properties.getProperty("PROXY_USER_NAME");
            string = properties.getProperty("PROXY_USER_PASSWORD");
            if (string != null) {
                charSequence = (String)charSequence + "/" + string;
            }
            byArray3 = this.meg.conv.StringToCharBytes((String)charSequence);
        } else if (n2 == 2) {
            charSequence = properties.getProperty("PROXY_DISTINGUISHED_NAME");
            byArray = this.meg.conv.StringToCharBytes((String)charSequence);
        } else {
            try {
                byArray2 = (byte[])properties.get("PROXY_CERTIFICATE");
                charSequence = new StringBuffer();
                for (int i2 = 0; i2 < byArray2.length; ++i2) {
                    string = Integer.toHexString(0xFF & byArray2[i2]);
                    int n5 = string.length();
                    if (n5 == 0) {
                        ((StringBuffer)charSequence).append("00");
                        continue;
                    }
                    if (n5 == 1) {
                        ((StringBuffer)charSequence).append('0');
                        ((StringBuffer)charSequence).append(string);
                        continue;
                    }
                    ((StringBuffer)charSequence).append(string);
                }
                byArray2 = ((StringBuffer)charSequence).toString().getBytes();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            stringArray = (String[])properties.get("PROXY_ROLES");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (stringArray != null) {
            object = new byte[stringArray.length][];
            for (int i3 = 0; i3 < stringArray.length; ++i3) {
                object[i3] = this.meg.conv.StringToCharBytes(stringArray[i3]);
            }
        }
        this.doOAUTH(byArray3, null, 0L, null, true, byArray, byArray2, (byte[][])object, n3, n4, null);
    }

    private void setSessionFields(T4CConnection t4CConnection) throws SQLException {
        String string = this.connection.thinVsessionTerminal;
        String string2 = this.connection.thinVsessionMachine;
        String string3 = this.connection.thinVsessionOsuser;
        String string4 = this.connection.thinVsessionProgram;
        String string5 = this.connection.thinVsessionProcess;
        String string6 = this.connection.thinVsessionIname;
        String string7 = this.connection.thinVsessionEname;
        String string8 = this.connection.proxyClientName;
        String string9 = this.connection.driverNameAttribute;
        String string10 = this.connection.editionName;
        this.enableTempLobRefCnt = this.connection.enableTempLobRefCnt ? new String(KPPL_PURITY_NEW).getBytes() : new String(KPPL_PURITY_DEFAULT).getBytes();
        if (string2 == null) {
            try {
                string2 = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception exception) {
                string2 = "jdbcclient";
            }
        }
        if (string7 == null) {
            string7 = "jdbc_" + this.ressourceManagerId;
        }
        if (string9 == null) {
            string9 = DRIVER_NAME_DEFAULT;
        }
        this.terminal = this.meg.conv.StringToCharBytes(string);
        this.machine = this.meg.conv.StringToCharBytes(string2);
        this.sysUserName = this.meg.conv.StringToCharBytes(string3);
        this.programName = this.meg.conv.StringToCharBytes(string4);
        this.processID = this.meg.conv.StringToCharBytes(string5);
        this.internalName = this.meg.conv.StringToCharBytes(string6);
        this.externalName = this.meg.conv.StringToCharBytes(string7);
        if (string8 != null) {
            this.clientname = this.meg.conv.StringToCharBytes(string8);
        }
        if (string10 != null) {
            this.editionName = this.meg.conv.StringToCharBytes(string10);
        }
        this.driverName = this.meg.conv.StringToCharBytes(string9);
        TimeZone timeZone = TimeZone.getDefault();
        String string11 = timeZone.getID();
        if (!ZONEIDMAP.isValidRegion(string11) || !t4CConnection.timezoneAsRegion) {
            int n2 = timeZone.getOffset(System.currentTimeMillis());
            int n3 = n2 / 3600000;
            int n4 = Math.abs(n2 / 60000 % 60);
            string11 = (n3 < 0 ? "" + n3 : "+" + n3) + (n4 < 10 ? ":0" + n4 : ":" + n4);
        }
        this.sessionTimeZone = string11;
        t4CConnection.sessionTimeZone = string11;
        String string12 = CharacterSetMetaData.getNLSLanguage(OracleLocale.getDefault());
        String string13 = CharacterSetMetaData.getNLSTerritory(OracleLocale.getDefault());
        if (string12 == null || string13 == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 176);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.alterSession = this.meg.conv.StringToCharBytes("ALTER SESSION SET " + (this.isSessionTZ ? "TIME_ZONE='" + this.sessionTimeZone + "'" : "") + " NLS_LANGUAGE='" + string12 + "' NLS_TERRITORY='" + string13 + "' ");
        this.aclValue = this.meg.conv.StringToCharBytes("4400");
        this.alterSession[this.alterSession.length - 1] = 0;
    }

    String removeQuotes(String string) {
        int n2;
        int n3 = 0;
        int n4 = string.length() - 1;
        for (n2 = 0; n2 < string.length(); ++n2) {
            if (string.charAt(n2) == '\"') continue;
            n3 = n2;
            break;
        }
        for (n2 = string.length() - 1; n2 >= 0; --n2) {
            if (string.charAt(n2) == '\"') continue;
            n4 = n2;
            break;
        }
        String string2 = string.substring(n3, n4 + 1);
        return string2;
    }

    private int versionStringToInt(String string) throws SQLException {
        String[] stringArray = string.split("\\.");
        int n2 = Integer.parseInt(stringArray[0].replaceAll("\\D", ""));
        int n3 = Integer.parseInt(stringArray[1].replaceAll("\\D", ""));
        int n4 = Integer.parseInt(stringArray[2].replaceAll("\\D", ""));
        int n5 = Integer.parseInt(stringArray[3].replaceAll("\\D", ""));
        int n6 = Integer.parseInt(stringArray[4].replaceAll("\\D", ""));
        int n7 = n2 << 24 | n3 << 20 | n4 << 12 | n5 << 8 | n6;
        return n7;
    }

    private String versionIntToString(int n2) throws SQLException {
        int n3 = (n2 & 0xFF000000) >> 24 & 0xFF;
        int n4 = (n2 & 0xF00000) >> 20 & 0xFF;
        int n5 = (n2 & 0xFF000) >> 12 & 0xFF;
        int n6 = (n2 & 0xF00) >> 8 & 0xFF;
        int n7 = n2 & 0xFF;
        String string = "" + n3 + "." + n4 + "." + n5 + "." + n6 + "." + n7;
        return string;
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        return this.connection;
    }

    public byte[] getDerivedKeyJdbc(byte[] byArray, int n2) throws NoSuchAlgorithmException, InvalidKeySpecException, SQLException {
        n2 = this.verifierType == 2361 ? (n2 |= 1) : (n2 |= 0);
        if (this.o5logonHelper == null) {
            this.o5logonHelper = new O5Logon(this.connection, this.connection.isO7L_MRExposed);
        }
        return this.o5logonHelper.getDerivedKey(byArray, n2);
    }
}

