/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.util.io;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.util.io.StreamSource;

public class InputStreamSource
implements StreamSource {
    protected BufferedInputStream inputStream;
    protected byte[] bytes;

    public InputStreamSource(InputStream inputStream) {
        this.inputStream = new BufferedInputStream(inputStream);
    }

    @Override
    public InputStream getInputStream() {
        if (this.bytes == null) {
            try {
                this.bytes = this.getBytesFromInputStream(this.inputStream);
            }
            catch (IOException e) {
                throw new ActivitiException("Could not read from inputstream", e);
            }
        }
        return new BufferedInputStream(new ByteArrayInputStream(this.bytes));
    }

    public String toString() {
        return "InputStream";
    }

    public byte[] getBytesFromInputStream(InputStream inStream) throws IOException {
        int offset;
        long length = inStream.available();
        byte[] bytes = new byte[(int)length];
        int numRead = 0;
        for (offset = 0; offset < bytes.length && (numRead = inStream.read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
        }
        if (offset < bytes.length) {
            throw new ActivitiException("Could not completely read inputstream ");
        }
        inStream.close();
        return bytes;
    }
}

