/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.runtime;

import java.util.HashMap;
import java.util.Map;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.impl.RuntimeServiceImpl;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.runtime.ProcessInstanceBuilder;

public class ProcessInstanceBuilderImpl
implements ProcessInstanceBuilder {
    protected RuntimeServiceImpl runtimeService;
    protected String processDefinitionId;
    protected String processDefinitionKey;
    protected String processInstanceName;
    protected String businessKey;
    protected String tenantId;
    protected Map<String, Object> variables = new HashMap<String, Object>();
    protected String processTitle;
    protected String dataDetail;

    public ProcessInstanceBuilderImpl(RuntimeServiceImpl runtimeService) {
        this.runtimeService = runtimeService;
    }

    @Override
    public ProcessInstanceBuilder processDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Override
    public ProcessInstanceBuilder processDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    @Override
    public ProcessInstanceBuilder processInstanceName(String processInstanceName) {
        this.processInstanceName = processInstanceName;
        return this;
    }

    @Override
    public ProcessInstanceBuilder businessKey(String businessKey) {
        this.businessKey = businessKey;
        return this;
    }

    @Override
    public ProcessInstanceBuilder tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    @Override
    public ProcessInstanceBuilder addVariable(String variableName, Object value) {
        this.variables.put(variableName, value);
        return this;
    }

    public ProcessInstanceBuilder processTitle(String processTitle) {
        this.processTitle = processTitle;
        return this;
    }

    public ProcessInstanceBuilder dataDetail(String dataDetail) {
        this.dataDetail = dataDetail;
        return this;
    }

    @Override
    public ProcessInstance start() {
        if (this.processDefinitionId == null && this.processDefinitionKey == null) {
            throw new ActivitiIllegalArgumentException("processDefinitionKey and processDefinitionId are null");
        }
        return this.runtimeService.startProcessInstance(this);
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public String getProcessInstanceName() {
        return this.processInstanceName;
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public String getProcessTitle() {
        return this.processTitle;
    }

    public String getDataDetail() {
        return this.dataDetail;
    }
}

