/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.el;

import java.beans.FeatureDescriptor;
import java.util.Iterator;
import java.util.Map;
import org.activiti.engine.delegate.VariableScope;
import org.activiti.engine.impl.identity.Authentication;
import org.activiti.engine.impl.javax.el.ELContext;
import org.activiti.engine.impl.javax.el.ELResolver;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;

public class VariableScopeElResolver
extends ELResolver {
    public static final String EXECUTION_KEY = "execution";
    public static final String TASK_KEY = "task";
    public static final String LOGGED_IN_USER_KEY = "authenticatedUserId";
    public static final String PROCESS_VARIABLES = "processVariables";
    protected VariableScope variableScope;

    public VariableScopeElResolver(VariableScope variableScope) {
        this.variableScope = variableScope;
    }

    @Override
    public Object getValue(ELContext context, Object base, Object property) {
        if (base == null) {
            Map variableMap;
            String variable = (String)property;
            if (EXECUTION_KEY.equals(property) && this.variableScope instanceof ExecutionEntity || TASK_KEY.equals(property) && this.variableScope instanceof TaskEntity) {
                context.setPropertyResolved(true);
                return this.variableScope;
            }
            if (EXECUTION_KEY.equals(property) && this.variableScope instanceof TaskEntity) {
                context.setPropertyResolved(true);
                return ((TaskEntity)this.variableScope).getExecution();
            }
            if (LOGGED_IN_USER_KEY.equals(property)) {
                context.setPropertyResolved(true);
                return Authentication.getAuthenticatedUserId();
            }
            if (this.variableScope instanceof ActivityExecution && (variableMap = (Map)((ExecutionEntity)this.variableScope).getTempVariable(PROCESS_VARIABLES)) != null && variableMap.containsKey(variable)) {
                context.setPropertyResolved(true);
                return variableMap.get(variable);
            }
            if (this.variableScope.hasVariable(variable)) {
                context.setPropertyResolved(true);
                return this.variableScope.getVariable(variable);
            }
        }
        return null;
    }

    @Override
    public boolean isReadOnly(ELContext context, Object base, Object property) {
        if (base == null) {
            String variable = (String)property;
            return !this.variableScope.hasVariable(variable);
        }
        return true;
    }

    @Override
    public void setValue(ELContext context, Object base, Object property, Object value) {
        String variable;
        if (base == null && this.variableScope.hasVariable(variable = (String)property)) {
            this.variableScope.setVariable(variable, value);
        }
    }

    @Override
    public Class<?> getCommonPropertyType(ELContext arg0, Object arg1) {
        return Object.class;
    }

    @Override
    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext arg0, Object arg1) {
        return null;
    }

    @Override
    public Class<?> getType(ELContext arg0, Object arg1, Object arg2) {
        return Object.class;
    }
}

