/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.helper;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jxdinfo.hussar.workflow.util.BpmActivityExceptionUtil;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.MapExceptionEntry;
import org.activiti.bpmn.model.Process;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.BusinessRuleException;
import org.activiti.engine.delegate.BpmnError;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.DelegateTask;
import org.activiti.engine.delegate.ExecutionListener;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.delegate.JavaDelegate;
import org.activiti.engine.delegate.TaskListener;
import org.activiti.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.activiti.engine.impl.bpmn.behavior.ServiceTaskJavaDelegateActivityBehavior;
import org.activiti.engine.impl.bpmn.helper.ErrorPropagation;
import org.activiti.engine.impl.bpmn.helper.SkipExpressionUtil;
import org.activiti.engine.impl.bpmn.parser.FieldDeclaration;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.delegate.ExecutionListenerInvocation;
import org.activiti.engine.impl.delegate.TaskListenerInvocation;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.persistence.entity.VariableInstance;
import org.activiti.engine.impl.pvm.delegate.ActivityBehavior;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.impl.pvm.delegate.SignallableActivityBehavior;
import org.activiti.engine.impl.pvm.delegate.SubProcessActivityBehavior;
import org.activiti.engine.impl.util.ReflectUtil;
import org.apache.commons.lang3.StringUtils;

public class ClassDelegate
extends AbstractBpmnActivityBehavior
implements TaskListener,
ExecutionListener,
SubProcessActivityBehavior {
    protected String className;
    protected List<FieldDeclaration> fieldDeclarations;
    protected ExecutionListener executionListenerInstance;
    protected TaskListener taskListenerInstance;
    protected ActivityBehavior activityBehaviorInstance;
    protected Expression skipExpression;
    protected List<MapExceptionEntry> mapExceptions;
    protected String serviceTaskId;

    public ClassDelegate(String className, List<FieldDeclaration> fieldDeclarations, Expression skipExpression) {
        this.className = className;
        this.fieldDeclarations = fieldDeclarations;
        this.skipExpression = skipExpression;
    }

    public ClassDelegate(String id, String className, List<FieldDeclaration> fieldDeclarations, Expression skipExpression, List<MapExceptionEntry> mapExceptions) {
        this(className, fieldDeclarations, skipExpression);
        this.serviceTaskId = id;
        this.mapExceptions = mapExceptions;
    }

    public ClassDelegate(String className, List<FieldDeclaration> fieldDeclarations) {
        this(className, fieldDeclarations, null);
    }

    public ClassDelegate(Class<?> clazz, List<FieldDeclaration> fieldDeclarations) {
        this(clazz.getName(), fieldDeclarations, null);
    }

    public ClassDelegate(Class<?> clazz, List<FieldDeclaration> fieldDeclarations, Expression skipExpression) {
        this(clazz.getName(), fieldDeclarations, skipExpression);
    }

    @Override
    public void notify(DelegateExecution execution) throws Exception {
        VariableInstance loopCounter = execution.getVariableInstance("loopCounter");
        if (loopCounter == null) {
            this.postHttp(execution);
            if (this.executionListenerInstance == null) {
                this.executionListenerInstance = this.getExecutionListenerInstance();
            }
            Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(new ExecutionListenerInvocation(this.executionListenerInstance, execution));
        } else {
            String subProcessKey = ((ExecutionEntity)execution).getSubProcessKey();
            if (subProcessKey != null) {
                ExecutionEntity executionEntity = (ExecutionEntity)execution;
                while (executionEntity.getSubProcessKey() != null) {
                    executionEntity = executionEntity.getParent();
                }
                this.postHttp(execution);
                if (this.executionListenerInstance == null) {
                    this.executionListenerInstance = this.getExecutionListenerInstance();
                }
                Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(new ExecutionListenerInvocation(this.executionListenerInstance, execution));
            }
        }
    }

    protected ExecutionListener getExecutionListenerInstance() {
        Object delegateInstance = this.instantiateDelegate(this.className, this.fieldDeclarations);
        if (delegateInstance instanceof ExecutionListener) {
            return (ExecutionListener)delegateInstance;
        }
        if (delegateInstance instanceof JavaDelegate) {
            return new ServiceTaskJavaDelegateActivityBehavior((JavaDelegate)delegateInstance);
        }
        throw new ActivitiIllegalArgumentException(delegateInstance.getClass().getName() + " doesn't implement " + ExecutionListener.class + " nor " + JavaDelegate.class);
    }

    @Override
    public void notify(DelegateTask delegateTask) {
        block4: {
            if (this.taskListenerInstance == null) {
                this.taskListenerInstance = this.getTaskListenerInstance();
            }
            try {
                Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(new TaskListenerInvocation(this.taskListenerInstance, delegateTask));
            }
            catch (BusinessRuleException e) {
                throw e;
            }
            catch (Exception e) {
                TaskEntity taskEntity = (TaskEntity)delegateTask;
                boolean isAsyn = taskEntity.isAsyn(taskEntity.getEventName());
                if (isAsyn) break block4;
                BpmActivityExceptionUtil.throwBpmException(new ActivitiException("Exception while invoking TaskListener: " + e.getMessage(), e));
            }
        }
    }

    protected TaskListener getTaskListenerInstance() {
        Object delegateInstance = this.instantiateDelegate(this.className, this.fieldDeclarations);
        if (delegateInstance instanceof TaskListener) {
            return (TaskListener)delegateInstance;
        }
        throw new ActivitiIllegalArgumentException(delegateInstance.getClass().getName() + " doesn't implement " + TaskListener.class);
    }

    @Override
    public void execute(ActivityExecution execution) throws Exception {
        block6: {
            boolean isSkipExpressionEnabled = SkipExpressionUtil.isSkipExpressionEnabled(execution, this.skipExpression);
            if (!isSkipExpressionEnabled || isSkipExpressionEnabled && !SkipExpressionUtil.shouldSkipFlowElement(execution, this.skipExpression)) {
                String overrideClassName;
                ObjectNode taskElementProperties;
                if (Context.getProcessEngineConfiguration().isEnableProcessDefinitionInfoCache() && (taskElementProperties = Context.getBpmnOverrideElementProperties(this.serviceTaskId, execution.getProcessDefinitionId())) != null && taskElementProperties.has("serviceTaskClassName") && StringUtils.isNotEmpty((CharSequence)(overrideClassName = taskElementProperties.get("serviceTaskClassName").asText())) && !overrideClassName.equals(this.className)) {
                    this.className = overrideClassName;
                    this.activityBehaviorInstance = null;
                }
                if (this.activityBehaviorInstance == null) {
                    this.activityBehaviorInstance = this.getActivityBehaviorInstance(execution);
                }
                try {
                    this.activityBehaviorInstance.execute(execution);
                }
                catch (BpmnError error) {
                    ErrorPropagation.propagateError(error, execution);
                }
                catch (Exception e) {
                    if (ErrorPropagation.mapException(e, execution, this.mapExceptions)) break block6;
                    throw e;
                }
            }
        }
    }

    @Override
    public void signal(ActivityExecution execution, String signalName, Object signalData) throws Exception {
        if (this.activityBehaviorInstance == null) {
            this.activityBehaviorInstance = this.getActivityBehaviorInstance(execution);
        }
        if (!(this.activityBehaviorInstance instanceof SignallableActivityBehavior)) {
            throw new ActivitiException("signal() can only be called on a " + SignallableActivityBehavior.class.getName() + " instance");
        }
        ((SignallableActivityBehavior)this.activityBehaviorInstance).signal(execution, signalName, signalData);
    }

    @Override
    public void completing(DelegateExecution execution, DelegateExecution subProcessInstance) throws Exception {
        if (this.activityBehaviorInstance == null) {
            this.activityBehaviorInstance = this.getActivityBehaviorInstance((ActivityExecution)execution);
        }
        if (!(this.activityBehaviorInstance instanceof SubProcessActivityBehavior)) {
            throw new ActivitiException("completing() can only be called on a " + SubProcessActivityBehavior.class.getName() + " instance");
        }
        ((SubProcessActivityBehavior)this.activityBehaviorInstance).completing(execution, subProcessInstance);
    }

    @Override
    public void completed(ActivityExecution execution) throws Exception {
        if (this.activityBehaviorInstance == null) {
            this.activityBehaviorInstance = this.getActivityBehaviorInstance(execution);
        }
        if (!(this.activityBehaviorInstance instanceof SubProcessActivityBehavior)) {
            throw new ActivitiException("completed() can only be called on a " + SubProcessActivityBehavior.class.getName() + " instance");
        }
        ((SubProcessActivityBehavior)this.activityBehaviorInstance).completed(execution);
    }

    protected ActivityBehavior getActivityBehaviorInstance(ActivityExecution execution) {
        Object delegateInstance = this.instantiateDelegate(this.className, this.fieldDeclarations);
        if (delegateInstance instanceof ActivityBehavior) {
            return this.determineBehaviour((ActivityBehavior)delegateInstance, execution);
        }
        if (delegateInstance instanceof JavaDelegate) {
            return this.determineBehaviour(new ServiceTaskJavaDelegateActivityBehavior((JavaDelegate)delegateInstance), execution);
        }
        throw new ActivitiIllegalArgumentException(delegateInstance.getClass().getName() + " doesn't implement " + JavaDelegate.class.getName() + " nor " + ActivityBehavior.class.getName());
    }

    protected ActivityBehavior determineBehaviour(ActivityBehavior delegateInstance, ActivityExecution execution) {
        if (this.hasMultiInstanceCharacteristics()) {
            this.multiInstanceActivityBehavior.setInnerActivityBehavior((AbstractBpmnActivityBehavior)delegateInstance);
            return this.multiInstanceActivityBehavior;
        }
        return delegateInstance;
    }

    protected Object instantiateDelegate(String className, List<FieldDeclaration> fieldDeclarations) {
        return ClassDelegate.defaultInstantiateDelegate(className, fieldDeclarations);
    }

    public static Object defaultInstantiateDelegate(Class<?> clazz, List<FieldDeclaration> fieldDeclarations) {
        return ClassDelegate.defaultInstantiateDelegate(clazz.getName(), fieldDeclarations);
    }

    public static Object defaultInstantiateDelegate(String className, List<FieldDeclaration> fieldDeclarations) {
        Object object = ReflectUtil.instantiate(className);
        ClassDelegate.applyFieldDeclaration(fieldDeclarations, object);
        return object;
    }

    public static void applyFieldDeclaration(List<FieldDeclaration> fieldDeclarations, Object target) {
        ClassDelegate.applyFieldDeclaration(fieldDeclarations, target, true);
    }

    public static void applyFieldDeclaration(List<FieldDeclaration> fieldDeclarations, Object target, boolean throwExceptionOnMissingField) {
        if (fieldDeclarations != null) {
            for (FieldDeclaration declaration : fieldDeclarations) {
                ClassDelegate.applyFieldDeclaration(declaration, target, throwExceptionOnMissingField);
            }
        }
    }

    public static void applyFieldDeclaration(FieldDeclaration declaration, Object target) {
        ClassDelegate.applyFieldDeclaration(declaration, target, true);
    }

    public static void applyFieldDeclaration(FieldDeclaration declaration, Object target, boolean throwExceptionOnMissingField) {
        Method setterMethod = ReflectUtil.getSetter(declaration.getName(), target.getClass(), declaration.getValue().getClass());
        if (setterMethod != null) {
            try {
                setterMethod.invoke(target, declaration.getValue());
            }
            catch (IllegalArgumentException e) {
                throw new ActivitiException("Error while invoking '" + declaration.getName() + "' on class " + target.getClass().getName(), e);
            }
            catch (IllegalAccessException e) {
                throw new ActivitiException("Illegal acces when calling '" + declaration.getName() + "' on class " + target.getClass().getName(), e);
            }
            catch (InvocationTargetException e) {
                throw new ActivitiException("Exception while invoking '" + declaration.getName() + "' on class " + target.getClass().getName(), e);
            }
        } else {
            String fieldName = declaration.getName();
            if (!("isAsyn".equals(fieldName) || "listenerModel".equals(fieldName) || "requestMethod".equals(fieldName))) {
                Field field = ReflectUtil.getField(declaration.getName(), target);
                if (field == null) {
                    if (throwExceptionOnMissingField) {
                        throw new ActivitiIllegalArgumentException("Field definition uses unexisting field '" + declaration.getName() + "' on class " + target.getClass().getName());
                    }
                    return;
                }
                if (!ClassDelegate.fieldTypeCompatible(declaration, field)) {
                    throw new ActivitiIllegalArgumentException("Incompatible type set on field declaration '" + declaration.getName() + "' for class " + target.getClass().getName() + ". Declared value has type " + declaration.getValue().getClass().getName() + ", while expecting " + field.getType().getName());
                }
                ReflectUtil.setField(field, target, declaration.getValue());
            }
        }
    }

    public static boolean fieldTypeCompatible(FieldDeclaration declaration, Field field) {
        if (declaration.getValue() != null) {
            return field.getType().isAssignableFrom(declaration.getValue().getClass());
        }
        return true;
    }

    public String getClassName() {
        return this.className;
    }

    public List<FieldDeclaration> getFieldDeclarations() {
        return this.fieldDeclarations;
    }

    private void postHttp(DelegateExecution execution) {
        ExecutionEntity executionEntity = (ExecutionEntity)execution;
        String processDefinitionId = execution.getProcessDefinitionId();
        BpmnModel bpmnModel = Context.getProcessEngineConfiguration().getRepositoryService().getBpmnModel(processDefinitionId);
        if (bpmnModel != null) {
            Process process = bpmnModel.getMainProcess();
            String eventName = execution.getEventName();
            Map listeners = process.getExtensionElements();
            executionEntity.postHttp(listeners, eventName);
            String activityId = executionEntity.getActivityId();
            FlowElement flowElement = process.getFlowElement(activityId);
            if (flowElement != null) {
                Map activityListeners = flowElement.getExtensionElements();
                executionEntity.postHttp(activityListeners, eventName);
            }
        }
    }
}

