/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.behavior;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jxdinfo.hussar.workflow.util.BpmActivitiSpringContextHolder;
import java.util.List;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.delegate.BpmnError;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.delegate.JavaDelegate;
import org.activiti.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.activiti.engine.impl.bpmn.behavior.TaskActivityBehavior;
import org.activiti.engine.impl.bpmn.helper.DelegateExpressionUtil;
import org.activiti.engine.impl.bpmn.helper.ErrorPropagation;
import org.activiti.engine.impl.bpmn.helper.SkipExpressionUtil;
import org.activiti.engine.impl.bpmn.parser.FieldDeclaration;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.delegate.ActivityBehaviorInvocation;
import org.activiti.engine.impl.delegate.JavaDelegateInvocation;
import org.activiti.engine.impl.el.FixedValue;
import org.activiti.engine.impl.pvm.delegate.ActivityBehavior;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.impl.pvm.delegate.SignallableActivityBehavior;
import org.apache.commons.lang3.StringUtils;

public class ServiceTaskDelegateExpressionActivityBehavior
extends TaskActivityBehavior {
    protected String serviceTaskId;
    protected Expression expression;
    protected Expression skipExpression;
    private final List<FieldDeclaration> fieldDeclarations;

    public ServiceTaskDelegateExpressionActivityBehavior(String serviceTaskId, Expression expression, Expression skipExpression, List<FieldDeclaration> fieldDeclarations) {
        this.serviceTaskId = serviceTaskId;
        this.expression = expression;
        this.skipExpression = skipExpression;
        this.fieldDeclarations = fieldDeclarations;
    }

    @Override
    public void signal(ActivityExecution execution, String signalName, Object signalData) throws Exception {
        Object delegate = DelegateExpressionUtil.resolveDelegateExpression(this.expression, execution, this.fieldDeclarations);
        if (delegate instanceof SignallableActivityBehavior) {
            ((SignallableActivityBehavior)delegate).signal(execution, signalName, signalData);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute(ActivityExecution execution) throws Exception {
        try {
            boolean isSkipExpressionEnabled = SkipExpressionUtil.isSkipExpressionEnabled(execution, this.skipExpression);
            if (!isSkipExpressionEnabled || isSkipExpressionEnabled && !SkipExpressionUtil.shouldSkipFlowElement(execution, this.skipExpression)) {
                Object object;
                Object overrideExpression;
                ObjectNode objectNode;
                if (Context.getProcessEngineConfiguration().isEnableProcessDefinitionInfoCache() && (objectNode = Context.getBpmnOverrideElementProperties(this.serviceTaskId, execution.getProcessDefinitionId())) != null && objectNode.has("serviceTaskDelegateExpression") && StringUtils.isNotEmpty((CharSequence)(overrideExpression = objectNode.get("serviceTaskDelegateExpression").asText())) && !((String)overrideExpression).equals(this.expression.getExpressionText())) {
                    this.expression = Context.getProcessEngineConfiguration().getExpressionManager().createExpression((String)overrideExpression);
                }
                if ((object = DelegateExpressionUtil.resolveDelegateExpression(this.expression, execution, this.fieldDeclarations)) instanceof ActivityBehavior) {
                    if (object instanceof AbstractBpmnActivityBehavior) {
                        ((AbstractBpmnActivityBehavior)object).setMultiInstanceActivityBehavior(this.getMultiInstanceActivityBehavior());
                    }
                    Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(new ActivityBehaviorInvocation((ActivityBehavior)object, execution));
                    return;
                } else if (object instanceof JavaDelegate) {
                    Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(new JavaDelegateInvocation((JavaDelegate)object, execution));
                    this.leave(execution);
                    return;
                } else {
                    if (!(object instanceof String)) throw new ActivitiIllegalArgumentException("Delegate expression " + this.expression + " did neither resolve to an implementation of " + ActivityBehavior.class + " nor " + JavaDelegate.class);
                    execution.addLocalTempVariable("requestMethod", "POST");
                    for (FieldDeclaration fieldDeclaration : this.fieldDeclarations) {
                        if (!"listenerModel".equals(fieldDeclaration.getName()) && !"requestMethod".equals(fieldDeclaration.getName())) continue;
                        execution.addLocalTempVariable(fieldDeclaration.getName(), ((FixedValue)fieldDeclaration.getValue()).getExpressionText());
                    }
                    execution.addLocalTempVariable("beanId", object);
                    Object object2 = BpmActivitiSpringContextHolder.getBean("DefaultCloudServiceTaskListener");
                    if (object2 instanceof ActivityBehavior) {
                        if (object2 instanceof AbstractBpmnActivityBehavior) {
                            ((AbstractBpmnActivityBehavior)object2).setMultiInstanceActivityBehavior(this.getMultiInstanceActivityBehavior());
                        }
                        Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(new ActivityBehaviorInvocation((ActivityBehavior)object2, execution));
                        return;
                    } else {
                        if (!(object2 instanceof JavaDelegate)) throw new ActivitiIllegalArgumentException("Delegate expression " + this.expression + " did neither resolve to an implementation of " + ActivityBehavior.class + " nor " + JavaDelegate.class);
                        Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(new JavaDelegateInvocation((JavaDelegate)object2, execution));
                        this.leave(execution);
                    }
                }
                return;
            } else {
                this.leave(execution);
            }
            return;
        }
        catch (Exception exc) {
            void var3_7;
            Exception exception = exc;
            BpmnError error = null;
            while (var3_7 != null) {
                if (var3_7 instanceof BpmnError) {
                    error = (BpmnError)var3_7;
                    break;
                }
                Throwable throwable = var3_7.getCause();
            }
            if (error == null) throw exc;
            ErrorPropagation.propagateError(error, execution);
            return;
        }
    }
}

