/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.spc.formula.api.util.quantity;

import com.jxdinfo.spc.formula.api.util.aviator.Calc;
import com.jxdinfo.spc.formula.api.util.common.CommonUtil;
import com.jxdinfo.spc.formula.api.util.quantity.entity.HistogramBar;
import com.jxdinfo.spc.formula.api.util.quantity.entity.NormalCurvePoint;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class CapabilityUtil {
    private static final BigDecimal MILLION = new BigDecimal("1000000");
    private static final BigDecimal HUNDRED = new BigDecimal("100");
    private static final MathContext MC = MathContext.DECIMAL128;

    public static BigDecimal cp(BigDecimal usl, BigDecimal lsl, BigDecimal groupSigma) {
        if (groupSigma.compareTo(BigDecimal.ZERO) == 0) {
            throw new ArithmeticException("groupSigma cannot be zero.");
        }
        BigDecimal numerator = usl.subtract(lsl);
        BigDecimal denominator = new BigDecimal("6").multiply(groupSigma);
        return numerator.divide(denominator, MC);
    }

    public static BigDecimal cpu(BigDecimal usl, BigDecimal totalAvg, BigDecimal groupSigma) {
        if (groupSigma.compareTo(BigDecimal.ZERO) == 0) {
            throw new ArithmeticException("groupSigma cannot be zero.");
        }
        BigDecimal numerator = usl.subtract(totalAvg);
        BigDecimal denominator = new BigDecimal("3").multiply(groupSigma);
        return numerator.divide(denominator, MC);
    }

    public static BigDecimal cpl(BigDecimal lsl, BigDecimal totalAvg, BigDecimal groupSigma) {
        if (groupSigma.compareTo(BigDecimal.ZERO) == 0) {
            throw new ArithmeticException("groupSigma cannot be zero.");
        }
        BigDecimal numerator = totalAvg.subtract(lsl);
        BigDecimal denominator = new BigDecimal("3").multiply(groupSigma);
        return numerator.divide(denominator, MC);
    }

    public static BigDecimal cpk(BigDecimal usl, BigDecimal lsl, BigDecimal cpu, BigDecimal cpl) {
        if (usl == null) {
            return cpl;
        }
        if (lsl == null) {
            return cpu;
        }
        cpu = cpu == null ? BigDecimal.ZERO : cpu;
        cpl = cpl == null ? BigDecimal.ZERO : cpl;
        return cpu.min(cpl);
    }

    public static BigDecimal pp(BigDecimal usl, BigDecimal lsl, BigDecimal totalSigma) {
        if (totalSigma.compareTo(BigDecimal.ZERO) == 0) {
            throw new ArithmeticException("totalSigma cannot be zero.");
        }
        BigDecimal numerator = usl.subtract(lsl);
        BigDecimal denominator = new BigDecimal("6").multiply(totalSigma);
        return numerator.divide(denominator, MC);
    }

    public static BigDecimal ppu(BigDecimal usl, BigDecimal totalAvg, BigDecimal totalSigma) {
        if (totalSigma.compareTo(BigDecimal.ZERO) == 0) {
            throw new ArithmeticException("totalSigma cannot be zero.");
        }
        BigDecimal numerator = usl.subtract(totalAvg);
        BigDecimal denominator = new BigDecimal("3").multiply(totalSigma);
        return numerator.divide(denominator, MC);
    }

    public static BigDecimal ppl(BigDecimal lsl, BigDecimal totalAvg, BigDecimal totalSigma) {
        if (totalSigma.compareTo(BigDecimal.ZERO) == 0) {
            throw new ArithmeticException("totalSigma cannot be zero.");
        }
        BigDecimal numerator = totalAvg.subtract(lsl);
        BigDecimal denominator = new BigDecimal("3").multiply(totalSigma);
        return numerator.divide(denominator, MC);
    }

    public static BigDecimal ppk(BigDecimal usl, BigDecimal lsl, BigDecimal ppu, BigDecimal ppl) {
        if (usl == null) {
            return ppl;
        }
        if (lsl == null) {
            return ppu;
        }
        ppu = ppu == null ? BigDecimal.ZERO : ppu;
        ppl = ppl == null ? BigDecimal.ZERO : ppl;
        return ppu.min(ppl);
    }

    public static BigDecimal cov(BigDecimal totalSigma, BigDecimal totalAvg) {
        if (totalAvg.compareTo(BigDecimal.ZERO) == 0) {
            throw new ArithmeticException("totalAvg cannot be zero.");
        }
        return totalSigma.divide(totalAvg, MC);
    }

    public static BigDecimal cpm(BigDecimal usl, BigDecimal lsl, BigDecimal targetT, List<List<BigDecimal>> subgroups, BigDecimal toler) {
        BigDecimal numerator;
        int totalCount = 0;
        BigDecimal sumSquaredDev = BigDecimal.ZERO;
        for (List<BigDecimal> subgroup : subgroups) {
            if (subgroup == null || subgroup.isEmpty()) continue;
            totalCount += subgroup.size();
            for (BigDecimal x : subgroup) {
                if (x == null) continue;
                BigDecimal deviation = x.subtract(targetT);
                sumSquaredDev = sumSquaredDev.add(deviation.multiply(deviation));
            }
        }
        if (totalCount == 0) {
            throw new RuntimeException("\u6240\u6709\u5b50\u7ec4\u4e2d\u5747\u65e0\u6709\u6548\u89c2\u6d4b\u6570\u636e");
        }
        BigDecimal variance = sumSquaredDev.divide(new BigDecimal(totalCount), MC);
        BigDecimal stdDeviation = CommonUtil.getSqrt(variance);
        if (stdDeviation.compareTo(BigDecimal.ZERO) == 0) {
            return new BigDecimal("1000000");
        }
        BigDecimal denominatorBase = toler.multiply(stdDeviation);
        if (usl != null && lsl != null) {
            BigDecimal mean = usl.add(lsl).divide(new BigDecimal("2.0"), MC);
            if (targetT.compareTo(mean) == 0) {
                BigDecimal numerator2 = usl.subtract(lsl);
                return numerator2.divide(denominatorBase, MC);
            }
            BigDecimal distToLsl = targetT.subtract(lsl);
            BigDecimal distToUsl = usl.subtract(targetT);
            BigDecimal minDist = distToLsl.min(distToUsl);
            return minDist.divide(denominatorBase.divide(new BigDecimal("2.0"), MC), MC);
        }
        if (usl != null) {
            numerator = usl.subtract(targetT);
            return numerator.divide(denominatorBase.divide(new BigDecimal("2.0"), MC), MC);
        }
        if (lsl != null) {
            numerator = targetT.subtract(lsl);
            return numerator.divide(denominatorBase.divide(new BigDecimal("2.0"), MC), MC);
        }
        return BigDecimal.ZERO;
    }

    public static BigDecimal ca(BigDecimal usl, BigDecimal lsl, BigDecimal totalAvg) {
        if (usl == null || lsl == null) {
            return null;
        }
        BigDecimal specRange = usl.subtract(lsl);
        if (specRange.compareTo(BigDecimal.ZERO) == 0) {
            throw new ArithmeticException("usl cannot be equal to lsl.");
        }
        BigDecimal numerator = totalAvg.subtract(usl.add(lsl).divide(new BigDecimal("2"), MC)).abs();
        BigDecimal denominator = specRange.divide(new BigDecimal("2"), MC);
        return numerator.divide(denominator, MC).multiply(HUNDRED);
    }

    public static BigDecimal meanDeviation(BigDecimal usl, BigDecimal lsl, BigDecimal totalAvg) {
        if (usl == null || lsl == null) {
            return null;
        }
        BigDecimal caValue = CapabilityUtil.ca(usl, lsl, totalAvg);
        return caValue.abs();
    }

    public static BigDecimal belowSpecificationObservationPercentage(BigDecimal belowLslCount, BigDecimal dataCount) {
        if (dataCount.compareTo(BigDecimal.ZERO) == 0) {
            throw new ArithmeticException("dataCount cannot be zero.");
        }
        return belowLslCount.divide(dataCount, MC).multiply(MILLION);
    }

    public static BigDecimal aboveSpecificationObservationPercentage(BigDecimal aboveUsLCount, BigDecimal dataCount) {
        if (dataCount.compareTo(BigDecimal.ZERO) == 0) {
            throw new ArithmeticException("dataCount cannot be zero.");
        }
        return aboveUsLCount.divide(dataCount, MC).multiply(MILLION);
    }

    public static BigDecimal exceedingSpecificationObservationPercentage(BigDecimal belowLslCount, BigDecimal aboveUsLCount, BigDecimal dataCount) {
        if (dataCount.compareTo(BigDecimal.ZERO) == 0) {
            throw new ArithmeticException("dataCount cannot be zero.");
        }
        BigDecimal totalExceeding = belowLslCount.add(aboveUsLCount);
        return totalExceeding.divide(dataCount, MC).multiply(MILLION);
    }

    public static BigDecimal belowSpecificationGroupPercentage(BigDecimal lsl, BigDecimal totalAvg, BigDecimal sigma) {
        if (lsl == null) {
            return BigDecimal.ZERO;
        }
        return Calc.getBigDecimal(CommonUtil.getNormdist(lsl, totalAvg, sigma, true)).multiply(MILLION);
    }

    public static BigDecimal aboveSpecificationGroupPercentage(BigDecimal usl, BigDecimal totalAvg, BigDecimal sigma) {
        if (usl == null) {
            return BigDecimal.ZERO;
        }
        BigDecimal cdf = Calc.getBigDecimal(CommonUtil.getNormdist(usl, totalAvg, sigma, true));
        return BigDecimal.ONE.subtract(cdf).multiply(MILLION);
    }

    public static BigDecimal exceedingSpecificationGroupPercentage(BigDecimal belowSpecificationPercentage, BigDecimal aboveSpecificationPercentage) {
        belowSpecificationPercentage = belowSpecificationPercentage == null ? BigDecimal.ZERO : belowSpecificationPercentage;
        aboveSpecificationPercentage = aboveSpecificationPercentage == null ? BigDecimal.ZERO : aboveSpecificationPercentage;
        return belowSpecificationPercentage.add(aboveSpecificationPercentage);
    }

    public static List<HistogramBar> generateProcessHistogram(List<BigDecimal> totalValueList, BigDecimal usl, BigDecimal lsl) {
        if (totalValueList == null || totalValueList.isEmpty()) {
            return new ArrayList<HistogramBar>();
        }
        List<BigDecimal> sortedValues = new ArrayList<BigDecimal>(totalValueList).stream().filter(Objects::nonNull).sorted(Comparator.naturalOrder()).collect(Collectors.toList());
        if (sortedValues.isEmpty()) {
            return new ArrayList<HistogramBar>();
        }
        BigDecimal dataMin = (BigDecimal)sortedValues.get(0);
        BigDecimal dataMax = (BigDecimal)sortedValues.get(sortedValues.size() - 1);
        if (lsl != null && lsl.compareTo(dataMin) < 0) {
            dataMin = lsl;
        }
        if (usl != null && usl.compareTo(dataMax) > 0) {
            dataMax = usl;
        }
        BigDecimal range = dataMax.subtract(dataMin);
        BigDecimal intervalWidth = CapabilityUtil.calculateOptimalIntervalWidth(range);
        BigDecimal startInterval = dataMin.divide(intervalWidth, 0, RoundingMode.FLOOR).multiply(intervalWidth).subtract(intervalWidth.divide(BigDecimal.valueOf(2L)));
        BigDecimal endInterval = dataMax.divide(intervalWidth, 0, RoundingMode.CEILING).multiply(intervalWidth).subtract(intervalWidth.divide(BigDecimal.valueOf(2L)));
        if (endInterval.compareTo(dataMax) < 0) {
            endInterval = dataMax;
        }
        if (startInterval.compareTo(dataMin) > 0) {
            startInterval = dataMin;
        }
        ArrayList<HistogramBar> histogramBars = new ArrayList<HistogramBar>();
        BigDecimal currentStart = startInterval;
        while (currentStart.compareTo(endInterval) < 0) {
            BigDecimal currentEnd = currentStart.add(intervalWidth);
            long frequency = CapabilityUtil.countDataInInterval(sortedValues, currentStart, currentEnd);
            if (frequency != 0L) {
                histogramBars.add(new HistogramBar(currentStart.setScale(2, RoundingMode.HALF_UP), currentEnd.setScale(2, RoundingMode.HALF_UP), frequency));
            }
            currentStart = currentEnd;
        }
        return histogramBars;
    }

    private static BigDecimal calculateOptimalIntervalWidth(BigDecimal range) {
        if (range == null || range.compareTo(BigDecimal.ZERO) <= 0) {
            return new BigDecimal("1.0");
        }
        List<BigDecimal> candidateIntervals = Arrays.asList(new BigDecimal("0.05"), new BigDecimal("0.1"), new BigDecimal("0.5"), new BigDecimal("1.0"), new BigDecimal("2.5"), new BigDecimal("5.0"), new BigDecimal("10.0"), new BigDecimal("25.0"), new BigDecimal("50.0"), new BigDecimal("100.0"));
        BigDecimal bestInterval = candidateIntervals.get(0);
        int bestIntervalCount = Integer.MAX_VALUE;
        for (BigDecimal interval : candidateIntervals) {
            int intervalCount = range.divide(interval, 0, RoundingMode.CEILING).intValue();
            if (intervalCount < 5 || intervalCount > 40) continue;
            return interval;
        }
        return candidateIntervals.get(0);
    }

    private static long countDataInInterval(List<BigDecimal> sortedData, BigDecimal start, BigDecimal end) {
        int leftIndex = Collections.binarySearch(sortedData, start);
        leftIndex = leftIndex < 0 ? -(leftIndex + 1) : leftIndex;
        int rightIndex = Collections.binarySearch(sortedData, end);
        rightIndex = rightIndex < 0 ? -(rightIndex + 1) : rightIndex;
        return rightIndex - leftIndex;
    }

    public static NormalCurvePoint generateNormalCurves(List<BigDecimal> totalValueList, BigDecimal overallMean, BigDecimal overallStdDev, BigDecimal withinStdDev, int decimalNum, List<HistogramBar> histogramBarList, BigDecimal usl, BigDecimal lsl) {
        if (histogramBarList == null || histogramBarList.isEmpty()) {
            throw new IllegalArgumentException("\u76f4\u65b9\u56fe\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (overallMean == null || overallStdDev == null || withinStdDev == null) {
            throw new IllegalArgumentException("\u5747\u503c\u548c\u6807\u51c6\u5dee\u4e0d\u80fd\u4e3anull");
        }
        int sampleSize = totalValueList == null || totalValueList.isEmpty() ? 1 : totalValueList.size();
        BigDecimal intervalWidth = histogramBarList.get(0).getIntervalEnd().subtract(histogramBarList.get(0).getIntervalStart());
        if (intervalWidth.compareTo(BigDecimal.ZERO) <= 0) {
            intervalWidth = new BigDecimal("1.0");
        }
        long maxFrequency = histogramBarList.stream().mapToLong(HistogramBar::getFrequency).max().orElse(1L);
        BigDecimal curveMin = histogramBarList.get(0).getIntervalStart();
        BigDecimal curveMax = histogramBarList.get(histogramBarList.size() - 1).getIntervalEnd();
        if (lsl != null && lsl.compareTo(curveMin) < 0) {
            curveMin = lsl;
        }
        if (usl != null && usl.compareTo(curveMax) > 0) {
            curveMax = usl;
        }
        int pointsCount = 100;
        BigDecimal step = curveMax.subtract(curveMin).divide(new BigDecimal(pointsCount), 10, RoundingMode.HALF_UP);
        ArrayList<BigDecimal> baseXList = new ArrayList<BigDecimal>(pointsCount + 1);
        BigDecimal currentX = curveMin;
        for (int i = 0; i <= pointsCount; ++i) {
            baseXList.add(Calc.tidyDecimal(currentX, decimalNum, true));
            if (i >= pointsCount) continue;
            currentX = currentX.add(step);
        }
        ArrayList<BigDecimal> overallRawDensities = new ArrayList<BigDecimal>(pointsCount + 1);
        ArrayList<BigDecimal> withinRawDensities = new ArrayList<BigDecimal>(pointsCount + 1);
        for (BigDecimal x2 : baseXList) {
            BigDecimal overallRaw = CapabilityUtil.calculateNormalDensity(x2, overallMean, overallStdDev);
            overallRawDensities.add(CapabilityUtil.scaleDensity(overallRaw, sampleSize, intervalWidth));
            BigDecimal withinRaw = CapabilityUtil.calculateNormalDensity(x2, overallMean, withinStdDev);
            withinRawDensities.add(CapabilityUtil.scaleDensity(withinRaw, sampleSize, intervalWidth));
        }
        List<BigDecimal> filteredOverallX = CapabilityUtil.filterCurvePoints(baseXList, overallRawDensities, decimalNum);
        List<BigDecimal> filteredOverallDensities = CapabilityUtil.mapXToDensity(filteredOverallX, baseXList, overallRawDensities);
        List<BigDecimal> filteredWithinX = CapabilityUtil.filterCurvePoints(baseXList, withinRawDensities, decimalNum);
        List<BigDecimal> filteredWithinDensities = CapabilityUtil.mapXToDensity(filteredWithinX, baseXList, withinRawDensities);
        TreeSet<BigDecimal> mergedXSet = new TreeSet<BigDecimal>(Comparator.comparing(BigDecimal::doubleValue));
        mergedXSet.addAll(filteredOverallX);
        mergedXSet.addAll(filteredWithinX);
        ArrayList<BigDecimal> finalXList = new ArrayList<BigDecimal>(mergedXSet);
        List<BigDecimal> finalOverallDensities = CapabilityUtil.alignDensities(finalXList, filteredOverallX, filteredOverallDensities);
        List<BigDecimal> finalWithinDensities = CapabilityUtil.alignDensities(finalXList, filteredWithinX, filteredWithinDensities);
        List<BigDecimal> formattedX = finalXList.stream().map(x -> Calc.tidyDecimal(x, decimalNum, true)).collect(Collectors.toList());
        List<BigDecimal> formattedOverall = finalOverallDensities.stream().map(d -> Calc.tidyDecimal(d, decimalNum, true)).collect(Collectors.toList());
        List<BigDecimal> formattedWithin = finalWithinDensities.stream().map(d -> Calc.tidyDecimal(d, decimalNum, true)).collect(Collectors.toList());
        return new NormalCurvePoint(formattedX, formattedOverall, formattedWithin);
    }

    private static List<BigDecimal> filterCurvePoints(List<BigDecimal> xList, List<BigDecimal> densityList, int decimalNum) {
        if (xList.size() != densityList.size()) {
            throw new IllegalArgumentException("X\u8f74\u5217\u8868\u548c\u5bc6\u5ea6\u5217\u8868\u957f\u5ea6\u4e0d\u4e00\u81f4\uff01");
        }
        ArrayList<Integer> nonZeroIndices = new ArrayList<Integer>();
        for (int i = 0; i < densityList.size(); ++i) {
            BigDecimal density = Calc.tidyDecimal(densityList.get(i), decimalNum, true);
            if (density.compareTo(new BigDecimal("1e-6")) <= 0) continue;
            nonZeroIndices.add(i);
        }
        if (nonZeroIndices.isEmpty()) {
            return new ArrayList<BigDecimal>();
        }
        int firstNonZeroIdx = (Integer)nonZeroIndices.get(0);
        int lastNonZeroIdx = (Integer)nonZeroIndices.get(nonZeroIndices.size() - 1);
        int startIdx = Math.max(0, firstNonZeroIdx - 1);
        int endIdx = Math.min(xList.size() - 1, lastNonZeroIdx + 1);
        return xList.subList(startIdx, endIdx + 1);
    }

    private static List<BigDecimal> mapXToDensity(List<BigDecimal> filteredX, List<BigDecimal> baseX, List<BigDecimal> baseDensity) {
        HashMap<BigDecimal, BigDecimal> xToDensityMap = new HashMap<BigDecimal, BigDecimal>();
        for (int i = 0; i < baseX.size(); ++i) {
            xToDensityMap.putIfAbsent(baseX.get(i), baseDensity.get(i));
        }
        ArrayList<BigDecimal> filteredDensity = new ArrayList<BigDecimal>();
        for (BigDecimal x : filteredX) {
            filteredDensity.add(xToDensityMap.getOrDefault(x, BigDecimal.ZERO));
        }
        return filteredDensity;
    }

    private static List<BigDecimal> alignDensities(List<BigDecimal> mergedX, List<BigDecimal> filteredX, List<BigDecimal> filteredDensity) {
        HashMap<BigDecimal, BigDecimal> xToDensityMap = new HashMap<BigDecimal, BigDecimal>();
        for (int i = 0; i < filteredX.size(); ++i) {
            xToDensityMap.put(filteredX.get(i), filteredDensity.get(i));
        }
        ArrayList<BigDecimal> alignedDensity = new ArrayList<BigDecimal>();
        for (BigDecimal x : mergedX) {
            alignedDensity.add(xToDensityMap.getOrDefault(x, BigDecimal.ZERO));
        }
        return alignedDensity;
    }

    private static BigDecimal scaleDensity(BigDecimal rawDensity, int sampleSize, BigDecimal intervalWidth) {
        return rawDensity.multiply(new BigDecimal(sampleSize)).multiply(intervalWidth);
    }

    private static BigDecimal calculateNormalDensity(BigDecimal x, BigDecimal mean, BigDecimal stdDev) {
        double xVal = x.doubleValue();
        double meanVal = mean.doubleValue();
        double stdDevVal = stdDev.doubleValue();
        if (stdDevVal == 0.0) {
            return xVal == meanVal ? new BigDecimal("1000000") : BigDecimal.ZERO;
        }
        double coefficient = 1.0 / (stdDevVal * Math.sqrt(Math.PI * 2));
        double exponent = -Math.pow(xVal - meanVal, 2.0) / (2.0 * Math.pow(stdDevVal, 2.0));
        double density = coefficient * Math.exp(exponent);
        return new BigDecimal(density);
    }
}

