/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.spc.formula.api.util.quantity;

import com.jxdinfo.spc.formula.api.util.aviator.Calc;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.List;
import java.util.stream.Collectors;

public class XSControlChartUtil {
    public static BigDecimal calculateXBarChartCL(List<List<BigDecimal>> subgroupDataList) {
        if (subgroupDataList == null || subgroupDataList.isEmpty()) {
            return BigDecimal.ZERO;
        }
        List subgroupMeans = subgroupDataList.stream().filter(subgroup -> subgroup != null && !subgroup.isEmpty()).map(subgroup -> {
            BigDecimal sum = subgroup.stream().reduce(BigDecimal.ZERO, BigDecimal::add);
            return sum.divide(new BigDecimal(subgroup.size()), MathContext.DECIMAL128);
        }).collect(Collectors.toList());
        if (subgroupMeans.isEmpty()) {
            return BigDecimal.ZERO;
        }
        BigDecimal totalMeanSum = subgroupMeans.stream().reduce(BigDecimal.ZERO, BigDecimal::add);
        return totalMeanSum.divide(new BigDecimal(subgroupMeans.size()), MathContext.DECIMAL128);
    }

    public static BigDecimal calculateSChartCL(List<List<BigDecimal>> subgroupDataList) {
        if (subgroupDataList == null || subgroupDataList.isEmpty()) {
            return BigDecimal.ZERO;
        }
        List subgroupStdevs = subgroupDataList.stream().filter(subgroup -> subgroup != null && subgroup.size() >= 2).map(subgroup -> {
            int n = subgroup.size();
            BigDecimal subgroupMean = subgroup.stream().reduce(BigDecimal.ZERO, BigDecimal::add).divide(new BigDecimal(n), MathContext.DECIMAL128);
            BigDecimal sumOfSquares = subgroup.stream().map(x -> x.subtract(subgroupMean)).map(diff -> diff.multiply((BigDecimal)diff)).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal variance = sumOfSquares.divide(new BigDecimal(n - 1), MathContext.DECIMAL128);
            return Calc.getBigDecimal(Math.sqrt(variance.doubleValue()));
        }).collect(Collectors.toList());
        if (subgroupStdevs.isEmpty()) {
            return BigDecimal.ZERO;
        }
        BigDecimal totalStdevSum = subgroupStdevs.stream().reduce(BigDecimal.ZERO, BigDecimal::add);
        return totalStdevSum.divide(new BigDecimal(subgroupStdevs.size()), MathContext.DECIMAL128);
    }

    public static BigDecimal calculateXBarChartUCL(BigDecimal cl, BigDecimal a3, BigDecimal sBar) {
        return cl.add(a3.multiply(sBar));
    }

    public static BigDecimal calculateXBarChartLCL(BigDecimal cl, BigDecimal a3, BigDecimal sBar) {
        BigDecimal lcl = cl.subtract(a3.multiply(sBar));
        return lcl.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : lcl;
    }

    public static BigDecimal calculateSChartUCL(BigDecimal b4, BigDecimal sBar) {
        return b4.multiply(sBar);
    }

    public static BigDecimal calculateSChartLCL(BigDecimal b3, BigDecimal sBar) {
        BigDecimal lcl = b3.multiply(sBar);
        return lcl.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : lcl;
    }

    public static BigDecimal estimateProcessStdevBySBar(BigDecimal sBar, BigDecimal c4) {
        if (c4.compareTo(BigDecimal.ZERO) == 0) {
            throw new ArithmeticException("Division by zero: c4 cannot be zero.");
        }
        return sBar.divide(c4, MathContext.DECIMAL128);
    }
}

