/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.spc.formula.api.util.quantity;

import com.jxdinfo.spc.formula.api.util.aviator.Calc;
import com.jxdinfo.spc.formula.api.util.common.CommonUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class BoxplotUtil {
    public static BigDecimal calculateMedian(List<BigDecimal> list) {
        int n = (list = list.stream().sorted().collect(Collectors.toList())).size();
        if (n % 2 == 1) {
            return list.get(n / 2);
        }
        BigDecimal mid1 = list.get(n / 2 - 1);
        BigDecimal mid2 = list.get(n / 2);
        return mid1.add(mid2).divide(BigDecimal.valueOf(2L), 4);
    }

    public static BigDecimal calculatePercentile(List<BigDecimal> list, double percentile) {
        int n = (list = list.stream().sorted().collect(Collectors.toList())).size();
        if (n == 0) {
            return BigDecimal.ZERO;
        }
        double position = percentile * (double)(n + 1);
        int k = (int)Math.floor(position);
        double f = position - (double)k;
        if (k <= 0) {
            return list.get(0);
        }
        if (k >= n) {
            return list.get(n - 1);
        }
        BigDecimal xk = list.get(k - 1);
        BigDecimal xk1 = list.get(k);
        return xk.add(xk1.subtract(xk).multiply(BigDecimal.valueOf(f)));
    }

    public static BigDecimal iqr(BigDecimal q1, BigDecimal q3) {
        return Calc.tidyDecimal(q3.subtract(q1), 4, false);
    }

    public static BigDecimal upperBound(BigDecimal q3, BigDecimal iqr) {
        return q3.add(BigDecimal.valueOf(1.5).multiply(iqr));
    }

    public static BigDecimal lowerBound(BigDecimal q1, BigDecimal iqr) {
        return q1.subtract(BigDecimal.valueOf(1.5).multiply(iqr));
    }

    public static List<BigDecimal> outliers(List<BigDecimal> list, BigDecimal upperBound, BigDecimal lowerBound, int decimalNum) {
        BigDecimal maxValue = Calc.getBigDecimal(CommonUtil.getMax(list));
        BigDecimal minValue = Calc.getBigDecimal(CommonUtil.getMin(list));
        BigDecimal upperWhisker = Calc.tidyDecimal(maxValue.compareTo(upperBound) > 0 ? upperBound : maxValue, decimalNum, false);
        BigDecimal lowerWhisker = Calc.tidyDecimal(minValue.compareTo(lowerBound) < 0 ? lowerBound : minValue, decimalNum, false);
        ArrayList<BigDecimal> outliers = new ArrayList<BigDecimal>();
        for (BigDecimal value : list) {
            if (value.compareTo(upperWhisker) <= 0 && value.compareTo(lowerWhisker) >= 0) continue;
            outliers.add(value);
        }
        return outliers;
    }
}

