/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.unify.authentication.client.validation;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.unify.authentication.client.utils.UnifySessionCacheUtil;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.Cas30ServiceTicketValidator;
import org.jasig.cas.client.validation.TicketValidationException;

public class CasClientUrlBasedTicketValidator
extends Cas30ServiceTicketValidator {
    public CasClientUrlBasedTicketValidator(String casServerUrlPrefix) {
        super(casServerUrlPrefix);
    }

    protected void customParseResponse(String response, Assertion assertion) throws TicketValidationException {
        Map attributes = assertion.getPrincipal().getAttributes();
        String serviceTicketId = (String)attributes.get("serviceTicketId");
        String grantingTicketId = (String)attributes.get("grantingTicketId");
        String tgtExpiresTime = (String)attributes.get("tgtExpiresTime");
        if (HussarUtils.isNotEmpty((Object)serviceTicketId) && HussarUtils.isNotEmpty((Object)grantingTicketId) && HussarUtils.isNotEmpty((Object)tgtExpiresTime)) {
            Map tgtMap = (Map)UnifySessionCacheUtil.getTgtExpiresTime(grantingTicketId);
            if (tgtMap != null) {
                String oldSt = (String)tgtMap.get("serviceTicketId");
                UnifySessionCacheUtil.removeStTgtMapping(oldSt);
                String sessionId = UnifySessionCacheUtil.getSessionIdByStKey(oldSt);
                UnifySessionCacheUtil.removeStKeyWithSessionId(sessionId);
                UnifySessionCacheUtil.removeSessionWithStKey(oldSt);
                UnifySessionCacheUtil.removeTgtExpiresTime(grantingTicketId);
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            DateTimeFormatter formatter = DateTimeFormatter.ISO_ZONED_DATE_TIME;
            ZonedDateTime result = ZonedDateTime.parse(tgtExpiresTime, formatter);
            map.put("tgtExpiresTime", result);
            map.put("serviceTicketId", serviceTicketId);
            UnifySessionCacheUtil.putTgtExpiresTime(grantingTicketId, map);
            UnifySessionCacheUtil.putStTgtMapping(serviceTicketId, grantingTicketId);
        }
    }
}

