/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.unify.authentication.client.session;

import com.jxdinfo.hussar.unify.authentication.client.service.SpringSessionService;
import com.jxdinfo.hussar.unify.authentication.client.utils.UnifySessionCacheUtil;
import javax.servlet.http.HttpSession;
import org.jasig.cas.client.session.SessionMappingStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RedisBackedSessionMappingStorage
implements SessionMappingStorage {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private SpringSessionService springSessionService;

    public RedisBackedSessionMappingStorage() {
    }

    public RedisBackedSessionMappingStorage(SpringSessionService springSessionService) {
        this.springSessionService = springSessionService;
    }

    public synchronized void addSessionById(String mappingId, HttpSession session) {
        try {
            UnifySessionCacheUtil.putSessionMapping(mappingId, session.getId());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized void removeBySessionById(String sessionId) {
        this.logger.debug("Attempting to remove Session=[{}]", (Object)sessionId);
        try {
            String mappingId = UnifySessionCacheUtil.getStKeyBySessionId(sessionId);
            if (this.logger.isDebugEnabled()) {
                if (mappingId != null) {
                    this.logger.debug("Found mapping for session.  Session Removed.");
                } else {
                    this.logger.debug("No mapping for session found.  Ignoring.");
                }
            }
            if (mappingId != null) {
                UnifySessionCacheUtil.removeSessionMapping(mappingId, sessionId);
                String grantingTicketId = UnifySessionCacheUtil.getStTgtMapping(mappingId);
                UnifySessionCacheUtil.removeTgtExpiresTime(grantingTicketId);
                UnifySessionCacheUtil.removeStTgtMapping(mappingId);
                this.springSessionService.deleteSessionBySessionId(sessionId);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized HttpSession removeSessionByMappingId(String mappingId) {
        try {
            String sessionId = UnifySessionCacheUtil.getSessionIdByStKey(mappingId);
            if (sessionId != null) {
                this.removeBySessionById(sessionId);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }
}

