/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.manage.engine.service.impl;

import com.jxdinfo.hussar.applicationmix.service.IHussarBaseSharePluginBoService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.expansion.core.service.dto.SharePluginInfoDto;
import com.jxdinfo.hussar.support.hotloaded.framework.integration.user.PluginUser;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import com.jxdinfo.hussar.workflow.manage.engine.service.BpmPluginUserApiService;
import com.jxdinfo.hussar.workflow.manage.properties.BpmPluginProperties;
import com.jxdinfo.hussar.workflow.manage.util.BpmPluginUtil;
import com.jxdinfo.hussar.workflow.manage.util.BpmSpringContextHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class RemoteBpmPluginUserApiService
implements BpmPluginUserApiService {
    private static final Logger logger = LoggerFactory.getLogger(RemoteBpmPluginUserApiService.class);
    @Autowired
    private BpmPluginProperties bpmPluginProperties;
    @Autowired(required=false)
    @Lazy
    private PluginUser pluginUser;
    @Autowired
    @Lazy
    private IHussarBaseSharePluginBoService hussarBaseSharePluginBoService;

    public <T> T getPluginBean(Long appId, String beanId, String appCode) {
        if (!this.bpmPluginProperties.isEnable()) {
            return null;
        }
        if (this.pluginUser == null) {
            this.pluginUser = (PluginUser)BpmSpringContextHolder.getBean(PluginUser.class);
        }
        String tcode = HussarContextHolder.getHussarTenant().getTenantCode();
        if (HussarUtils.isNotEmpty((Object)appCode)) {
            Object t;
            appCode = BpmPluginUtil.asIdentifier((String)appCode);
            String standardAppCode = "";
            String pluginId = "";
            String extensionPluginId = "";
            boolean endWithExtension = StringUtil.endWith((CharSequence)appCode, (CharSequence)"_extension");
            standardAppCode = endWithExtension ? appCode.substring(0, appCode.length() - "_extension".length()) : appCode;
            SharePluginInfoDto sharePluginInfoDto = this.hussarBaseSharePluginBoService.queryPluginInfo(tcode, standardAppCode);
            tcode = BpmPluginUtil.asIdentifier((String)tcode);
            if (HussarUtils.isNotEmpty((Object)sharePluginInfoDto)) {
                if (!endWithExtension) {
                    pluginId = sharePluginInfoDto.getSharePluginId();
                    if (HussarUtils.isNotEmpty((Object)sharePluginInfoDto.getAppVersion())) {
                        pluginId = pluginId + "-" + sharePluginInfoDto.getAppVersion();
                        extensionPluginId = tcode + sharePluginInfoDto.getSharePluginId() + "-" + sharePluginInfoDto.getAppVersion() + "_extension";
                    }
                } else {
                    pluginId = tcode + sharePluginInfoDto.getSharePluginId() + "-" + sharePluginInfoDto.getAppVersion() + "_extension";
                }
            }
            if (HussarUtils.isEmpty((Object)(t = this.pluginUser.getPluginBeans(pluginId, beanId))) && !endWithExtension && HussarUtils.isNotEmpty((Object)extensionPluginId)) {
                logger.info(beanId + "\u6d41\u7a0b\u56de\u8c03\u4f7f\u7528\u6807\u51c6\u5e94\u7528\u7684appCode" + appCode + "\u5931\u8d25\uff0c\u6dfb\u52a0\u6269\u5c55\u540e\u7f00\u540e\u91cd\u65b0\u83b7\u53d6");
                pluginId = extensionPluginId;
            }
            if ((t = this.pluginUser.getPluginBeans(pluginId, beanId)) != null) {
                return (T)t;
            }
        }
        return (T)this.pluginUser.getBean(beanId);
    }
}

