/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.manage.engine.service.impl;

import com.jxdinfo.hussar.workflow.common.InstallResult;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.DefinitionSearchDto;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.manage.engine.feign.RemoteDefinitionEngineService;
import com.jxdinfo.hussar.workflow.manage.engine.service.DefinitionEngineApiService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RemoteDefinitionEngineApiServiceImpl
implements DefinitionEngineApiService {
    @Autowired
    private RemoteDefinitionEngineService remoteDefinitionEngineService;

    public BpmResponseResult queryProcessName(String processKey) {
        return this.remoteDefinitionEngineService.queryProcessName(processKey);
    }

    public BpmResponseResult queryProcessDefListOfMainVersion(String processName) {
        return this.remoteDefinitionEngineService.queryProcessDefListOfMainVersion(processName);
    }

    public BpmResponseResult getProcessMainOrNew(String processKey, String organId) {
        return this.remoteDefinitionEngineService.getProcessMainOrNew(processKey, organId);
    }

    public BpmResponseResult queryProcessDefList(String processName) {
        return this.remoteDefinitionEngineService.queryProcessDefList(processName);
    }

    public BpmResponseResult getProcessDefList(String processKey, String organId) {
        return this.remoteDefinitionEngineService.getProcessDefList(processKey, organId);
    }

    public BpmResponseResult activateProcessDefinitionById(String processDefinitionId) {
        return this.remoteDefinitionEngineService.activateProcessDefinitionById(processDefinitionId);
    }

    public BpmResponseResult activateProcessByKeyAndVersion(String processKey, String version) {
        DefinitionSearchDto definitionSearchDto = new DefinitionSearchDto();
        definitionSearchDto.setProcessKey(processKey);
        definitionSearchDto.setVersion(version);
        return this.remoteDefinitionEngineService.activateProcessByKeyAndVersion(definitionSearchDto);
    }

    public BpmResponseResult suspendProcessDefinitionById(String processDefinitionId) {
        return this.remoteDefinitionEngineService.suspendProcessDefinitionById(processDefinitionId);
    }

    public BpmResponseResult suspendProcessByKeyAndVersion(String processKey, String version) {
        DefinitionSearchDto definitionSearchDto = new DefinitionSearchDto();
        definitionSearchDto.setProcessKey(processKey);
        definitionSearchDto.setVersion(version);
        return this.remoteDefinitionEngineService.suspendProcessByKeyAndVersion(definitionSearchDto);
    }

    public BpmResponseResult deleteProcessDefinition(String processDefinitionId) {
        return this.remoteDefinitionEngineService.deleteProcessDefinition(processDefinitionId);
    }

    public BpmResponseResult deleteProcessDefinitionByKeyAndVersion(String processKey, String version, String organId) {
        DefinitionSearchDto definitionSearchDto = new DefinitionSearchDto();
        definitionSearchDto.setProcessKey(processKey);
        definitionSearchDto.setVersion(version);
        definitionSearchDto.setOrganId(organId);
        return this.remoteDefinitionEngineService.deleteProcessDefinitionByKeyAndVersion(definitionSearchDto);
    }

    public BpmResponseResult queryProcess() {
        return this.remoteDefinitionEngineService.queryProcess();
    }

    public BpmResponseResult queryProcessLink(String processKey) {
        return this.remoteDefinitionEngineService.queryProcessLink(processKey);
    }

    public BpmResponseResult queryStartFormUrl(String processKey) {
        return this.remoteDefinitionEngineService.queryStartFormUrl(processKey);
    }

    public BpmResponseResult queryAllNodeFormKey(String processKey, String version) {
        DefinitionSearchDto definitionSearchDto = new DefinitionSearchDto();
        definitionSearchDto.setProcessKey(processKey);
        definitionSearchDto.setVersion(version);
        return this.remoteDefinitionEngineService.queryAllNodeFormKey(definitionSearchDto);
    }

    public BpmResponseResult queryIsPublish(String processKey) {
        boolean isPublish = this.remoteDefinitionEngineService.queryIsPublish(processKey);
        return InstallResult.success((Object)isPublish);
    }

    public BpmResponseResult queryNodeInfoByProcessKeyAndVersion(String processKey, String version) {
        DefinitionSearchDto definitionSearchDto = new DefinitionSearchDto();
        definitionSearchDto.setProcessKey(processKey);
        definitionSearchDto.setVersion(version);
        return this.remoteDefinitionEngineService.queryNodeInfoByProcessKeyAndVersion(definitionSearchDto);
    }

    public BpmResponseResult queryAllProcess(String processKey) {
        return this.remoteDefinitionEngineService.queryAllProcess(processKey);
    }
}

