/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.word.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.jxdinfo.document.word.dao.WordEditHistoryMapper;
import com.jxdinfo.document.word.dao.WordEditorDetailsMapper;
import com.jxdinfo.document.word.dao.WordModelInfoMapper;
import com.jxdinfo.document.word.dto.WordEditHistoryDto;
import com.jxdinfo.document.word.model.WordEditHistory;
import com.jxdinfo.document.word.model.WordEditorDetails;
import com.jxdinfo.document.word.model.WordModelInfo;
import com.jxdinfo.document.word.service.IWordEditHistoryService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.HussarBaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.document.word.service.impl.WordEditHistoryImpl")
public class WordEditHistoryImpl
implements IWordEditHistoryService {
    @Resource
    private WordEditHistoryMapper wordEditHistoryMapper;
    @Resource
    private WordEditorDetailsMapper wordEditorDetailsMapper;
    @Resource
    private WordModelInfoMapper wordModelInfoMapper;

    public void saveWordEditHistory(WordEditHistoryDto wordEditHistoryDto) {
        WordEditHistory wordEditHistory = new WordEditHistory();
        this.wordEditHistoryMapper.insert(wordEditHistory);
    }

    public List<WordEditHistory> queryWordEditHistory(Long docId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(WordEditHistory::getDocId, (Object)docId);
        queryWrapper.orderByDesc(HussarBaseEntity::getCreateTime);
        List wordEditHistoryList = this.wordEditHistoryMapper.selectList((Wrapper)queryWrapper);
        return wordEditHistoryList;
    }

    public ApiResponse<String> rollbackWordEditHistoryLastVersion(Long id) {
        WordEditHistory wordEditHistory = (WordEditHistory)this.wordEditHistoryMapper.selectById(id);
        if (HussarUtils.isNotEmpty((Object)wordEditHistory)) {
            String detailContent = wordEditHistory.getDetailContent();
            String detailOptions = wordEditHistory.getDetailOptions();
            Long docId = wordEditHistory.getDocId();
            String detailsId = ((WordModelInfo)this.wordModelInfoMapper.selectById(docId)).getDetailsId();
            if (HussarUtils.isNotEmpty((Object)detailsId)) {
                WordEditorDetails wordEditorDetails = (WordEditorDetails)this.wordEditorDetailsMapper.selectById((Serializable)((Object)detailsId));
                wordEditorDetails.setDetailContent(detailContent);
                wordEditorDetails.setDetailOptions(detailOptions);
                LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                updateWrapper.eq(WordEditorDetails::getId, (Object)detailsId);
                this.wordEditorDetailsMapper.update(wordEditorDetails, (Wrapper)updateWrapper);
                return ApiResponse.success((String)"\u8fd8\u539f\u6210\u529f");
            }
            return ApiResponse.fail((String)"\u672a\u67e5\u8be2\u5230\u8bb0\u5f55\u8be6\u60c5\uff0c\u8fd8\u539f\u5931\u8d25");
        }
        return ApiResponse.fail((String)"\u672a\u67e5\u8be2\u5230\u5386\u53f2\u8bb0\u5f55\uff0c\u8fd8\u539f\u5931\u8d25");
    }

    public void deleteWordEditHistory() {
    }
}

