/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.word.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.document.common.dto.AttachmentInfoDto;
import com.jxdinfo.document.common.service.IFileService;
import com.jxdinfo.document.editor.core.word.util.PdfUtil;
import com.jxdinfo.document.word.dao.WordModelInfoMapper;
import com.jxdinfo.document.word.model.WordAndPdfRelationship;
import com.jxdinfo.document.word.model.WordEditorDetails;
import com.jxdinfo.document.word.model.WordModelInfo;
import com.jxdinfo.document.word.model.WordTempAttachmentModel;
import com.jxdinfo.document.word.service.IWordDocExportService;
import com.jxdinfo.document.word.service.WordEditorDetailsService;
import com.jxdinfo.document.word.service.WordParticularService;
import com.jxdinfo.document.word.service.WordPdfRelationshipService;
import com.jxdinfo.document.word.service.impl.WordModelInfoServiceImpl;
import com.jxdinfo.hussar.license.ModuleVerify;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.IdUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

@Service(value="com.jxdinfo.document.word.service.impl.wordDocExportServiceImpl")
public class WordDocExportServiceImpl
implements IWordDocExportService {
    private static Logger logger = LoggerFactory.getLogger(WordDocExportServiceImpl.class);
    @Autowired
    private WordEditorDetailsService wordEditorDetailsService;
    @Resource
    private WordParticularService wordParticularService;
    @Resource
    private IFileService fileService;
    @Autowired
    private WordPdfRelationshipService wordPdfRelationshipService;
    @Resource
    private WordModelInfoServiceImpl wordModelInfoService;

    @HussarTransactional
    public void exportDoc(HttpServletResponse response, Long detailsId) {
        long downloadStartTime = Calendar.getInstance().getTimeInMillis();
        logger.info("<<<<<<<<<<<<<<<<<<<<<<<<\u6587\u4ef6\u5bfc\u51fa\u5f00\u59cb>>>>>>>>>>>>>>>>>>>>>>>");
        WordEditorDetails wordEditorDetails = (WordEditorDetails)this.wordEditorDetailsService.getOne((Wrapper)new LambdaQueryWrapper().eq(WordEditorDetails::getId, (Object)detailsId));
        String name = "\u65e0\u6807\u9898\u6587\u6863";
        Map<String, Object> resultMap = this.customExportProcessing(detailsId.toString());
        if (HussarUtils.isNotEmpty(resultMap) && HussarUtils.isNotEmpty((Object)resultMap.get("docName"))) {
            name = resultMap.get("docName").toString();
        }
        String detailContent = wordEditorDetails.getDetailContent();
        String detailOptions = wordEditorDetails.getDetailOptions();
        HashMap<String, String> configDetails = new HashMap<String, String>();
        configDetails.put("detailContent", detailContent);
        configDetails.put("detailOptions", detailOptions);
        List<WordTempAttachmentModel> fileIds = this.getAttachments(detailContent);
        try (ServletOutputStream out = response.getOutputStream();){
            String safeName;
            if (HussarUtils.isEmpty(fileIds)) {
                response.setContentType("multipart/form-data");
                safeName = name.trim() + ".docx";
                String downLoadFileName = URLEncoder.encode(safeName, "UTF-8").replaceAll("\\+", "%20").replaceAll("%28", "(").replaceAll("%29", ")").replaceAll("%2B", "+");
                response.addHeader("Content-Disposition", "attachment;filename=" + downLoadFileName);
                this.wordParticularService.exportFile(configDetails, (OutputStream)out);
            } else {
                response.setContentType("application/zip");
                safeName = name.trim() + ".zip";
                String downLoadFileName = URLEncoder.encode(safeName, "UTF-8").replaceAll("\\+", "%20").replaceAll("%28", "(").replaceAll("%29", ")").replaceAll("%2B", "+");
                response.addHeader("Content-Disposition", "attachment;filename=" + downLoadFileName);
                ZipOutputStream zipOut = new ZipOutputStream((OutputStream)out);
                ByteArrayOutputStream wordBaos = new ByteArrayOutputStream();
                this.wordParticularService.exportFile(configDetails, (OutputStream)wordBaos);
                byte[] wordData = wordBaos.toByteArray();
                ZipEntry wordEntry = new ZipEntry(name + ".docx");
                zipOut.putNextEntry(wordEntry);
                zipOut.write(wordData);
                zipOut.closeEntry();
                for (WordTempAttachmentModel tempModel : fileIds) {
                    AttachmentInfoDto infoDto = this.fileService.getModelById(Long.valueOf(Long.parseLong(tempModel.getFileId())));
                    ApiResponse apiResponse = this.fileService.backgroundDownload(infoDto.getFileId());
                    if (!HussarUtils.isNotEmpty((Object)infoDto) || !HussarUtils.isNotEmpty((Object)infoDto.getAttachmentName())) continue;
                    ZipEntry attachmentEntry = new ZipEntry("attachement/" + tempModel.getFileName());
                    zipOut.putNextEntry(attachmentEntry);
                    zipOut.write((byte[])apiResponse.getData());
                    zipOut.closeEntry();
                }
                zipOut.finish();
            }
            String useTime = String.format("%.3f", (double)(Calendar.getInstance().getTimeInMillis() - downloadStartTime) / 1000.0);
            logger.info("\u672c\u6b21({})\u5bfc\u51fa\u8017\u65f6\u4e3a\uff1a{}s", (Object)name, (Object)useTime);
            logger.info("<<<<<<<<<<<<<<<<<<<<<<<<\u6587\u4ef6\u5bfc\u51fa\u7ed3\u675f>>>>>>>>>>>>>>>>>>>>>>>");
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private List<WordTempAttachmentModel> getAttachments(String detailContent) {
        ArrayList<WordTempAttachmentModel> rawList = new ArrayList<WordTempAttachmentModel>();
        JSONObject jsonObject = JSON.parseObject((String)detailContent);
        WordDocExportServiceImpl.traverseNodes(jsonObject, rawList);
        HashMap<String, Integer> fileNameCountMap = new HashMap<String, Integer>();
        ArrayList<WordTempAttachmentModel> resultList = new ArrayList<WordTempAttachmentModel>();
        for (WordTempAttachmentModel item : rawList) {
            String newFileName;
            if (item.getFileId() == null || item.getFileId().trim().isEmpty()) continue;
            String originalFileName = item.getFileName();
            int count = fileNameCountMap.getOrDefault(originalFileName, 0);
            if (count == 0) {
                newFileName = originalFileName;
            } else {
                String baseName = originalFileName;
                String extension = "";
                int dotIndex = originalFileName.lastIndexOf(46);
                if (dotIndex > 0) {
                    baseName = originalFileName.substring(0, dotIndex);
                    extension = originalFileName.substring(dotIndex);
                }
                newFileName = baseName + "(" + count + ")" + extension;
            }
            fileNameCountMap.put(originalFileName, count + 1);
            WordTempAttachmentModel outputItem = new WordTempAttachmentModel(newFileName, item.getFileId());
            resultList.add(outputItem);
        }
        return resultList;
    }

    private static void traverseNodes(JSONObject node, List<WordTempAttachmentModel> results) {
        JSONArray content;
        JSONObject attrs;
        String type = node.getString("type");
        if ("image".equals(type) && HussarUtils.isNotEmpty((Object)(attrs = node.getJSONObject("attrs"))) && "file".equals(attrs.getString("type"))) {
            WordTempAttachmentModel item;
            String fileId;
            String src = attrs.getString("src");
            String fileName = attrs.getString("fileName");
            if (HussarUtils.isNotEmpty((Object)src) && src.contains("?fileId")) {
                fileId = src.substring(src.lastIndexOf("=") + 1);
                item = new WordTempAttachmentModel(fileName, fileId);
                results.add(item);
            } else if (HussarUtils.isNotEmpty((Object)src) && src.contains("showPicture?id")) {
                fileId = src.substring(src.lastIndexOf("=") + 1);
                item = new WordTempAttachmentModel(fileName, fileId);
                results.add(item);
            }
        }
        if ((content = node.getJSONArray("content")) != null) {
            for (int i = 0; i < content.size(); ++i) {
                JSONObject childNode = content.getJSONObject(i);
                WordDocExportServiceImpl.traverseNodes(childNode, results);
            }
        }
    }

    @HussarTransactional
    public void exportDocument(HttpServletResponse response, Long docId) {
        ModuleVerify mv = new ModuleVerify();
        if (!mv.verify("a775d647e0f64fdd8ad6db742f091ae4")) {
            return;
        }
        long downloadStartTime = Calendar.getInstance().getTimeInMillis();
        logger.info("<<<<<<<<<<<<<<<<<<<<<<<<\u6587\u4ef6\u5bfc\u51fa\u5f00\u59cb>>>>>>>>>>>>>>>>>>>>>>>");
        HashMap<String, String> resultMap = new HashMap<String, String>();
        WordModelInfo wordModelInfo = (WordModelInfo)((WordModelInfoMapper)this.wordModelInfoService.getBaseMapper()).selectById(docId);
        String detailsId = wordModelInfo.getDetailsId();
        if (HussarUtils.isNotEmpty((Object)detailsId) && HussarUtils.isNotEmpty((Object)wordModelInfo) && HussarUtils.isNotEmpty((Object)wordModelInfo.getModelName())) {
            resultMap.put("docName", wordModelInfo.getModelName());
        }
        WordEditorDetails wordEditorDetails = (WordEditorDetails)this.wordEditorDetailsService.getOne((Wrapper)new LambdaQueryWrapper().eq(WordEditorDetails::getId, (Object)detailsId));
        String name = "\u65e0\u6807\u9898\u6587\u6863";
        if (HussarUtils.isNotEmpty(resultMap) && HussarUtils.isNotEmpty(resultMap.get("docName"))) {
            name = resultMap.get("docName").toString();
        }
        String detailContent = wordEditorDetails.getDetailContent();
        String detailOptions = wordEditorDetails.getDetailOptions();
        HashMap<String, String> configDetails = new HashMap<String, String>();
        configDetails.put("detailContent", detailContent);
        configDetails.put("detailOptions", detailOptions);
        List<WordTempAttachmentModel> fileIds = this.getAttachments(detailContent);
        try (ServletOutputStream out = response.getOutputStream();){
            String safeName;
            if (HussarUtils.isEmpty(fileIds)) {
                response.setContentType("multipart/form-data");
                safeName = name.trim() + ".docx";
                String downLoadFileName = URLEncoder.encode(safeName, "UTF-8").replaceAll("\\+", "%20").replaceAll("%28", "(").replaceAll("%29", ")").replaceAll("%2B", "+");
                response.addHeader("Content-Disposition", "attachment;filename=" + downLoadFileName);
                this.wordParticularService.exportFile(configDetails, (OutputStream)out);
            } else {
                response.setContentType("application/zip");
                safeName = name.trim() + ".zip";
                String downLoadFileName = URLEncoder.encode(safeName, "UTF-8").replaceAll("\\+", "%20").replaceAll("%28", "(").replaceAll("%29", ")").replaceAll("%2B", "+");
                response.addHeader("Content-Disposition", "attachment;filename=" + downLoadFileName);
                ZipOutputStream zipOut = new ZipOutputStream((OutputStream)out);
                ByteArrayOutputStream wordBaos = new ByteArrayOutputStream();
                this.wordParticularService.exportFile(configDetails, (OutputStream)wordBaos);
                byte[] wordData = wordBaos.toByteArray();
                ZipEntry wordEntry = new ZipEntry(name + ".docx");
                zipOut.putNextEntry(wordEntry);
                zipOut.write(wordData);
                zipOut.closeEntry();
                for (WordTempAttachmentModel tempModel : fileIds) {
                    AttachmentInfoDto infoDto = this.fileService.getModelById(Long.valueOf(Long.parseLong(tempModel.getFileId())));
                    ApiResponse apiResponse = this.fileService.backgroundDownload(infoDto.getFileId());
                    ZipEntry attachmentEntry = new ZipEntry("attachement/" + tempModel.getFileName());
                    zipOut.putNextEntry(attachmentEntry);
                    zipOut.write((byte[])apiResponse.getData());
                    zipOut.closeEntry();
                }
                zipOut.finish();
            }
            String useTime = String.format("%.3f", (double)(Calendar.getInstance().getTimeInMillis() - downloadStartTime) / 1000.0);
            logger.info("\u672c\u6b21({})\u5bfc\u51fa\u8017\u65f6\u4e3a\uff1a{}s", (Object)name, (Object)useTime);
            logger.info("<<<<<<<<<<<<<<<<<<<<<<<<\u6587\u4ef6\u5bfc\u51fa\u7ed3\u675f>>>>>>>>>>>>>>>>>>>>>>>");
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public ApiResponse<Long> uploadReportPdfFile(MultipartFile fileInput, String docIdS, String fileName) {
        if (fileInput == null || docIdS == null) {
            logger.info("\u4f20\u5165\u6587\u4ef6\u6216id\u4e3a\u7a7a");
            return ApiResponse.fail((String)"\u4f20\u5165\u6587\u4ef6\u6216id\u4e3a\u7a7a");
        }
        Long docId = Long.parseLong(docIdS);
        String fileOriginName = fileName + ".pdf";
        try {
            InputStream fis = fileInput.getInputStream();
            byte[] fileByte = PdfUtil.imagesZipToPdf((InputStream)fis, null, null);
            MultipartFile file = WordDocExportServiceImpl.convertByteToMultipartFile(fileByte, fileOriginName);
            ApiResponse upload = this.fileService.upload(file);
            String filePath = ((AttachmentInfoDto)upload.getData()).getPath();
            Long fileId = ((AttachmentInfoDto)upload.getData()).getFileId();
            WordAndPdfRelationship wordAndPdfRelationship = new WordAndPdfRelationship();
            wordAndPdfRelationship.setId(Long.valueOf(IdUtil.getSnowflakeNextId()));
            wordAndPdfRelationship.setDocId(docId);
            wordAndPdfRelationship.setPdfId(fileId);
            wordAndPdfRelationship.setPdfPath(filePath);
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(WordAndPdfRelationship::getDocId, (Object)docId);
            this.wordPdfRelationshipService.remove((Wrapper)wrapper);
            this.wordPdfRelationshipService.save((Object)wordAndPdfRelationship);
            return ApiResponse.success((Object)fileId, (String)"\u6587\u4ef6\u4e0a\u4f20\u6210\u529f");
        }
        catch (IOException e) {
            logger.error(e.getMessage() + "\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25");
            throw new RuntimeException(e);
        }
    }

    public ApiResponse<Long> uploadPDF(MultipartFile inputFile, String docId, String fileName) {
        ModuleVerify mv = new ModuleVerify();
        if (!mv.verify("a775d647e0f64fdd8ad6db742f091ae4")) {
            return ApiResponse.fail((String)"\u6388\u6743\u9a8c\u8bc1\u5931\u8d25\uff0c\u8bf7\u7533\u8bf7\u667a\u80fd\u62a5\u544a\u6a21\u5757\u6388\u6743\uff01");
        }
        if (inputFile == null || docId == null) {
            logger.info("\u4f20\u5165\u6587\u4ef6\u6216id\u4e3a\u7a7a");
            return ApiResponse.fail((String)"\u4f20\u5165\u6587\u4ef6\u6216id\u4e3a\u7a7a");
        }
        Long aLong = Long.parseLong(docId);
        ApiResponse upload = this.fileService.upload(inputFile);
        String filePath = ((AttachmentInfoDto)upload.getData()).getPath();
        Long fileId = ((AttachmentInfoDto)upload.getData()).getFileId();
        WordAndPdfRelationship wordAndPdfRelationship = new WordAndPdfRelationship();
        wordAndPdfRelationship.setId(Long.valueOf(IdUtil.getSnowflakeNextId()));
        wordAndPdfRelationship.setDocId(aLong);
        wordAndPdfRelationship.setPdfId(fileId);
        wordAndPdfRelationship.setPdfPath(filePath);
        Long fileIdByDocId = this.wordPdfRelationshipService.getFileIdByDocId(aLong);
        if (HussarUtils.isNotEmpty((Object)fileIdByDocId)) {
            this.fileService.deleteFile(fileIdByDocId);
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(WordAndPdfRelationship::getDocId, (Object)docId);
        this.wordPdfRelationshipService.remove((Wrapper)wrapper);
        this.wordPdfRelationshipService.save((Object)wordAndPdfRelationship);
        return ApiResponse.success((Object)fileId, (String)"\u6587\u4ef6\u4e0a\u4f20\u6210\u529f");
    }

    public void exportPdf(HttpServletResponse response, Long docId, Long fileId) {
        WordEditorDetails wordEditorDetails;
        String detailContent;
        List<WordTempAttachmentModel> fileIds;
        WordModelInfo wordModelInfo = (WordModelInfo)((WordModelInfoMapper)this.wordModelInfoService.getBaseMapper()).selectById(docId);
        String detailsId = wordModelInfo.getDetailsId();
        String name = wordModelInfo.getModelName();
        if (HussarUtils.isEmpty((Object)name)) {
            name = "\u65e0\u6807\u9898\u6587\u6863";
        }
        if (HussarUtils.isEmpty(fileIds = this.getAttachments(detailContent = (wordEditorDetails = (WordEditorDetails)this.wordEditorDetailsService.getOne((Wrapper)new LambdaQueryWrapper().eq(WordEditorDetails::getId, (Object)detailsId))).getDetailContent()))) {
            this.fileService.download(response, fileId);
        } else {
            try (ServletOutputStream out = response.getOutputStream();){
                response.setContentType("application/zip");
                String safeName = name.trim() + ".zip";
                String downLoadFileName = URLEncoder.encode(safeName, "UTF-8").replaceAll("\\+", "%20").replaceAll("%28", "(").replaceAll("%29", ")").replaceAll("%2B", "+");
                response.addHeader("Content-Disposition", "attachment;filename=" + downLoadFileName);
                ZipOutputStream zipOut = new ZipOutputStream((OutputStream)out);
                ApiResponse download = this.fileService.backgroundDownload(fileId);
                ZipEntry wordEntry = new ZipEntry(name + ".pdf");
                zipOut.putNextEntry(wordEntry);
                zipOut.write((byte[])download.getData());
                zipOut.closeEntry();
                for (WordTempAttachmentModel tempModel : fileIds) {
                    AttachmentInfoDto infoDto = this.fileService.getModelById(Long.valueOf(Long.parseLong(tempModel.getFileId())));
                    ApiResponse apiResponse = this.fileService.backgroundDownload(infoDto.getFileId());
                    ZipEntry attachmentEntry = new ZipEntry("attachement/" + tempModel.getFileName());
                    zipOut.putNextEntry(attachmentEntry);
                    zipOut.write((byte[])apiResponse.getData());
                    zipOut.closeEntry();
                }
                zipOut.finish();
            }
            catch (IOException e) {
                throw new HussarException((Throwable)e);
            }
        }
    }

    public static MultipartFile convertByteToMultipartFile(byte[] data, String fileName) {
        String contentType = "application/octet-stream";
        DiskFileItemFactory factory = new DiskFileItemFactory();
        FileItem fileItem = factory.createItem(fileName, contentType, true, fileName);
        try (OutputStream os = fileItem.getOutputStream();){
            os.write(data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new CommonsMultipartFile(fileItem);
    }

    public Map<String, Object> customExportProcessing(String detailsId) {
        WordModelInfo wordModelInfo;
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (HussarUtils.isNotEmpty((Object)detailsId) && HussarUtils.isNotEmpty((Object)(wordModelInfo = this.wordModelInfoService.getByWordDetailId(detailsId))) && HussarUtils.isNotEmpty((Object)wordModelInfo.getModelName())) {
            resultMap.put("docName", wordModelInfo.getModelName());
        }
        return resultMap;
    }
}

