/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.word.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.document.word.bean.PageRequestBody;
import com.jxdinfo.document.word.dto.WordDocInfoDto;
import com.jxdinfo.document.word.model.WordDocInfo;
import com.jxdinfo.document.word.service.WordDocInfoService;
import com.jxdinfo.document.word.service.impl.WordCommonDocumentImpl;
import com.jxdinfo.document.word.vo.WordDocInfoSearchVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="com.jxdinfo.document.word.controller.wordDocInfoController")
@RequestMapping(value={"/hussarDocument/word/docInfo"})
@AuditLog(moduleName="\u6587\u6863\u57fa\u672c\u4fe1\u606f")
@Api(tags={"\u6587\u6863\u57fa\u672c\u4fe1\u606f\u64cd\u4f5c\u63a7\u5236\u5668"})
public class WordDocInfoController {
    @Autowired
    private WordDocInfoService wordDocInfoService;
    @Autowired
    private WordCommonDocumentImpl wordCommonDocument;

    @ApiOperation(value="\u67e5\u8be2\u6587\u6863\u57fa\u672c\u4fe1\u606f\u8868\u5206\u9875\u4fe1\u606f")
    @AuditLog(moduleName="\u6587\u6863\u57fa\u672c\u4fe1\u606f\u8868", eventDesc="\u8868\u683c\u67e5\u8be2", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @RequestMapping(value={"/hussarQueryPage"})
    public ApiResponse<Page<WordDocInfo>> hussarQueryPage(@RequestBody PageRequestBody<WordDocInfo> page) {
        return this.wordDocInfoService.hussarQueryPage(page);
    }

    @ApiOperation(value="\u67e5\u8be2\u6587\u6863\u57fa\u672c\u4fe1\u606f\u8868\u4fe1\u606f")
    @AuditLog(moduleName="\u6587\u6863\u57fa\u672c\u4fe1\u606f\u8868", eventDesc="\u8be6\u60c5\u67e5\u8be2", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @GetMapping(value={"/getWordDocInfoById"})
    public ApiResponse<WordDocInfoSearchVo> getWordDocInfoById(@RequestParam Long id) {
        return this.wordDocInfoService.getWordDocInfoById(id);
    }

    @ApiOperation(value="\u66f4\u65b0\u6587\u6863\u57fa\u672c\u4fe1\u606f\u8868\u4fe1\u606f")
    @AuditLog(moduleName="\u6587\u6863\u57fa\u672c\u4fe1\u606f\u8868", eventDesc="\u4fee\u6539", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    @PostMapping(value={"/updateInfo"})
    public ApiResponse<Long> updateInfo(@RequestBody WordDocInfoDto wordDocInfoDto) {
        return this.wordDocInfoService.update(wordDocInfoDto);
    }

    @ApiOperation(value="\u65b0\u589e\u6587\u6863\u57fa\u672c\u4fe1\u606f\u8868\u4fe1\u606f")
    @AuditLog(moduleName="\u6587\u6863\u57fa\u672c\u4fe1\u606f\u8868", eventDesc="\u65b0\u589e", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.INSERT)
    @PostMapping(value={"/addInfo"})
    public ApiResponse<Long> addInfo(@RequestBody WordDocInfoDto wordDocInfoDto) {
        return this.wordDocInfoService.add(wordDocInfoDto);
    }

    @ApiOperation(value="\u5220\u9664\u6587\u6863\u57fa\u672c\u4fe1\u606f\u8868\u4fe1\u606f")
    @AuditLog(moduleName="\u6587\u6863\u57fa\u672c\u4fe1\u606f\u8868", eventDesc="\u5220\u9664", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.DELETE)
    @PostMapping(value={"/deleteInfo"})
    public ApiResponse<Boolean> deleteInfo(@RequestParam Long id) {
        return this.wordDocInfoService.delete(id);
    }

    @ApiOperation(value="\u6587\u6863\u590d\u5236")
    @PostMapping(value={"/copyDocument"})
    public ApiResponse<Long> copyDocument(@RequestParam(value="docId") String docId) {
        return ApiResponse.success((Object)this.wordCommonDocument.copyDocument(Long.parseLong(docId)));
    }
}

