/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.word.controller;

import com.jxdinfo.document.common.service.IDocumentInfoService;
import com.jxdinfo.document.word.service.IWordDocExportService;
import com.jxdinfo.hussar.platform.core.annotation.Inner;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController(value="com.jxdinfo.document.word.controller.wordDocExportController")
@RequestMapping(value={"/hussarDocument/word/docExport"})
@AuditLog(moduleName="\u6587\u6863\u5206\u7ec4")
@Api(tags={"\u6587\u6863\u5206\u7ec4\u6811\u64cd\u4f5c\u63a7\u5236\u5668"})
public class WordDocExportController {
    private final IWordDocExportService wordDocExportService;
    @Autowired
    private IDocumentInfoService documentInfoService;

    public WordDocExportController(IWordDocExportService wordDocExportService) {
        this.wordDocExportService = wordDocExportService;
    }

    @Inner
    @GetMapping(value={"/fileDownload"})
    @ApiOperation(value="\u6587\u4ef6\u4e0b\u8f7d", notes="\u6587\u4ef6\u4e0b\u8f7d")
    @AuditLog(moduleName="\u6587\u4ef6\u4e0b\u8f7d", eventDesc="\u6587\u4ef6\u4e0b\u8f7d", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.FILE)
    public void fileDownload(HttpServletResponse response, @ApiParam(value="\u6587\u4ef6id") @RequestParam Long detailsId) {
        this.wordDocExportService.exportDoc(response, detailsId);
    }

    @GetMapping(value={"/exportFile"})
    @ApiOperation(value="\u6587\u6863\u4e0b\u8f7d", notes="\u6587\u6863\u4e0b\u8f7d")
    @AuditLog(moduleName="\u6587\u6863\u4e0b\u8f7d", eventDesc="\u6587\u6863\u4e0b\u8f7d", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.FILE)
    public void exportDocument(HttpServletResponse response, @ApiParam(value="\u6587\u6863id") @RequestParam Long docId) {
        this.wordDocExportService.exportDocument(response, docId);
    }

    @PostMapping(value={"/uploadReportPdfFile"})
    public ApiResponse<Long> uploadReportPdfFile(@RequestParam(value="file") MultipartFile file, @RequestParam(value="docId") String docId, @RequestParam(value="exportName") String exportName) {
        return this.wordDocExportService.uploadReportPdfFile(file, docId, exportName);
    }

    @PostMapping(value={"/uploadPDF"})
    public ApiResponse<Long> uploadPDF(@RequestParam(value="file") MultipartFile file, @RequestParam(value="docId") String docId, @RequestParam(value="fileName") String fileName) {
        return this.wordDocExportService.uploadPDF(file, docId, fileName);
    }

    @RequestMapping(value={"/previewPDF"})
    public void previewPDF(HttpServletResponse response, @RequestParam(value="docId") Long docId) {
        this.documentInfoService.previewPDF(response, docId);
    }

    @GetMapping(value={"/previewPDFSnapshot"})
    public void previewSnapshot(HttpServletResponse response, @RequestParam(value="docId") Long docId) {
        this.documentInfoService.previewPDF(response, docId);
    }

    @GetMapping(value={"/exportPdf"})
    @ApiOperation(value="pdf\u4e0b\u8f7d", notes="pdf\u4e0b\u8f7d")
    @AuditLog(moduleName="pdf\u4e0b\u8f7d", eventDesc="pdf\u4e0b\u8f7d", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.FILE)
    public void exportPdf(HttpServletResponse response, @ApiParam(value="\u6587\u6863id") @RequestParam Long docId, @ApiParam(value="pdf id") @RequestParam Long fileId) {
        this.wordDocExportService.exportPdf(response, docId, fileId);
    }
}

