/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.word.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.document.common.CommonDocumentInterface;
import com.jxdinfo.document.common.DocumentType;
import com.jxdinfo.document.common.factory.DocumentFactory;
import com.jxdinfo.document.common.model.DocDataBindInfo;
import com.jxdinfo.document.common.model.GenerateReportParam;
import com.jxdinfo.document.common.model.WordDocTypeInfo;
import com.jxdinfo.document.common.service.IDocumentInfoService;
import com.jxdinfo.document.common.service.impl.DocumentDataBindServiceImpl;
import com.jxdinfo.document.common.service.impl.WordTypeInfoServiceImpl;
import com.jxdinfo.document.common.vo.DocumentDetailsVo;
import com.jxdinfo.document.common.vo.DocumentSplitVo;
import com.jxdinfo.document.editor.core.word.constant.WordConstant;
import com.jxdinfo.document.word.dao.WordEditorDetailsMapper;
import com.jxdinfo.document.word.dao.WordModelInfoMapper;
import com.jxdinfo.document.word.dto.WordModelInfoDto;
import com.jxdinfo.document.word.enums.OwnErrorEnum;
import com.jxdinfo.document.word.model.WordEditorDetails;
import com.jxdinfo.document.word.model.WordModelInfo;
import com.jxdinfo.document.word.service.IWordDocExportService;
import com.jxdinfo.document.word.service.WordPdfRelationshipService;
import com.jxdinfo.document.word.service.impl.WordDocImportServiceImpl;
import com.jxdinfo.document.word.service.impl.WordEditorDetailsServiceImpl;
import com.jxdinfo.document.word.service.impl.WordModelInfoServiceImpl;
import com.jxdinfo.document.word.utils.DocumentSplitOfUtil;
import com.jxdinfo.document.word.utils.JSExecutor;
import com.jxdinfo.document.word.utils.TypeUtils;
import com.jxdinfo.document.word.vo.WordEditorDetailsVo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.IdUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="com.jxdinfo.document.word.service.impl.WordCommonDocumentImpl")
public class WordCommonDocumentImpl
implements CommonDocumentInterface,
InitializingBean {
    @Resource
    private WordEditorDetailsServiceImpl wordEditorDetailsService;
    @Resource
    private WordModelInfoServiceImpl wordModelInfoService;
    @Resource
    private IWordDocExportService wordDocExportService;
    @Resource
    private WordPdfRelationshipService wordPdfRelationshipService;
    @Resource
    private IDocumentInfoService documentInfoService;
    @Resource
    private WordTypeInfoServiceImpl wordTypeInfoService;
    @Resource
    private DocumentDataBindServiceImpl documentDataBindService;
    @Resource
    private WordDocImportServiceImpl wordDocImportService;

    public DocumentDetailsVo queryDocumentDetail(Long docId) {
        WordEditorDetails wordEditorDetails;
        DocumentDetailsVo documentDetailsVo = new DocumentDetailsVo();
        HashMap<String, Object> extendResult = new HashMap<String, Object>();
        WordModelInfo wordModelInfo = (WordModelInfo)((WordModelInfoMapper)this.wordModelInfoService.getBaseMapper()).selectById(docId);
        documentDetailsVo.setType(0);
        documentDetailsVo.setDocumentName(wordModelInfo.getModelName());
        if (HussarUtils.isNotEmpty((Object)wordModelInfo)) {
            extendResult.put("docId", wordModelInfo.getId());
            extendResult.put("groupId", wordModelInfo.getGroupId());
            extendResult.put("modelName", wordModelInfo.getModelName());
            documentDetailsVo.setId(wordModelInfo.getId());
        }
        if (HussarUtils.isNotEmpty((Object)(wordEditorDetails = (WordEditorDetails)this.wordEditorDetailsService.getById((Serializable)((Object)wordModelInfo.getDetailsId()))))) {
            extendResult.put("detailOptions", wordEditorDetails.getDetailOptions());
            documentDetailsVo.setContent(wordEditorDetails.getDetailContent());
        }
        LambdaQueryWrapper wordModelInfoLambdaQueryWrapper = new LambdaQueryWrapper();
        wordModelInfoLambdaQueryWrapper.eq(WordModelInfo::getParentModelId, (Object)docId);
        List wordModelInfos = ((WordModelInfoMapper)this.wordModelInfoService.getBaseMapper()).selectList((Wrapper)wordModelInfoLambdaQueryWrapper);
        if (ToolUtil.isNotEmpty((Object)wordModelInfos)) {
            ArrayList<Long> businessIds = new ArrayList<Long>();
            for (WordModelInfo modelInfo : wordModelInfos) {
                businessIds.add(Long.valueOf(modelInfo.getDetailsId()));
            }
            List wordEditorDetailsList = ((WordEditorDetailsMapper)this.wordEditorDetailsService.getBaseMapper()).selectBatchIds(businessIds);
            extendResult.put("childDetails", wordEditorDetailsList);
        }
        documentDetailsVo.setExtendResult(extendResult);
        return documentDetailsVo;
    }

    public Object queryOffice(Long docId) {
        List<WordModelInfo> wordModelInfos;
        WordEditorDetails wordEditorDetails;
        WordEditorDetailsVo wordEditorDetailsVo = new WordEditorDetailsVo();
        HashMap<String, Object> extendResult = new HashMap<String, Object>();
        WordModelInfo wordModelInfo = (WordModelInfo)((WordModelInfoMapper)this.wordModelInfoService.getBaseMapper()).selectById(docId);
        if (HussarUtils.isNotEmpty((Object)wordModelInfo)) {
            extendResult.put("docId", wordModelInfo.getId());
            extendResult.put("groupId", wordModelInfo.getGroupId());
            extendResult.put("modelName", wordModelInfo.getModelName());
        }
        if (HussarUtils.isNotEmpty((Object)(wordEditorDetails = (WordEditorDetails)this.wordEditorDetailsService.getById((Serializable)((Object)wordModelInfo.getDetailsId()))))) {
            wordEditorDetailsVo.setWordEditorDetail(wordEditorDetails);
            wordEditorDetailsVo.setDetailsId(wordEditorDetails.getId());
        }
        if (ToolUtil.isNotEmpty(wordModelInfos = this.getChild(docId))) {
            ArrayList<Long> dtlIds = new ArrayList<Long>();
            this.traverseWordModelTreeForListId(wordModelInfos, dtlIds);
            List allEditorDetailsList = ((WordEditorDetailsMapper)this.wordEditorDetailsService.getBaseMapper()).selectBatchIds(dtlIds);
            ArrayList<Long> businessIds = new ArrayList<Long>();
            for (WordModelInfo modelInfo : wordModelInfos) {
                businessIds.add(Long.valueOf(modelInfo.getDetailsId()));
            }
            List wordEditorDetailsList = ((WordEditorDetailsMapper)this.wordEditorDetailsService.getBaseMapper()).selectBatchIds(businessIds);
            this.traverseWordModelTree(wordModelInfos, allEditorDetailsList, wordEditorDetailsList);
            extendResult.put("childDetails", wordEditorDetailsList);
        }
        wordEditorDetailsVo.setExtendResult(extendResult);
        ApiResponse dataBindByIdAPI = this.documentDataBindService.getDataBindById(docId);
        if (dataBindByIdAPI.isSuccess() && HussarUtils.isNotEmpty((Object)dataBindByIdAPI.getData())) {
            DocDataBindInfo data = (DocDataBindInfo)dataBindByIdAPI.getData();
            wordEditorDetailsVo.setDatabindDetails(data.getDataBindDetails());
            wordEditorDetailsVo.setWordDataSet(data.getWordDataSet());
            wordEditorDetailsVo.setInterFaceName(data.getInterFaceName());
        }
        return wordEditorDetailsVo;
    }

    public Long addBlankDocument(String documentName, String type) {
        String defaultName = "\u65e0\u6807\u9898\u6587\u6863";
        if (HussarUtils.isNotEmpty((Object)documentName)) {
            defaultName = documentName;
        }
        WordEditorDetails emptyWord = new WordEditorDetails();
        Long wordEditorDetailId = IdUtil.getSnowflakeNextId();
        emptyWord.setId(wordEditorDetailId);
        emptyWord.setDocId(null);
        emptyWord.setExtendedInfo("1");
        emptyWord.setDetailOptions("{\"settingInfo\":{\"waterInfo\":{\"hideSelf\":false,\"selectType\":\"1\",\"waterType\":\"2\",\"waterStyle\":false,\"imageWater\":{\"checked\":false,\"zoom\":\"auto\",\"erosion\":true,\"fileId\":\"\",\"rotate\":\"horizontal\"},\"textWater\":{\"checked\":false,\"content\":\"\",\"rotate\":\"horizontal\",\"fontFamily\":\"SimSun\",\"fontSize\":\"12pt\",\"transparency\":50,\"color\":\"#8F8F8F\"}},\"shading\":\"#ffffff\",\"pagingSeal\":{\"imgSrc\":\"\"},\"threads\":[],\"showThreads\":true,\"textBoxBorderMap\":{}},\"imgStyleMap\":{\"changeState\":false},\"userAgent\":\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36\",\"firstOpenAfterImport\":false,\"docRules\":{\"style\":[],\"visible\":[]},\"listMarkOption\":{\"marginLeftArr\":[],\"customListMark\":[{\"name\":\"none\",\"example\":\"\u65e0\u5217\u8868\"}]}}");
        emptyWord.setDetailContent("{\"type\":\"doc\",\"attrs\":{\"isBindData\":false},\"content\":[{\"type\":\"section\",\"attrs\":{\"HTMLAttributes\":null,\"id\":\"section-default\",\"pageOption\":{\"label\":\"A4\",\"width\":20.99,\"height\":29.77,\"direction\":\"vertical\",\"left\":3.18,\"right\":3.18,\"top\":2.54,\"bottom\":2.54,\"headerTop\":1.5,\"footerBottom\":1.75,\"isdefault\":true,\"gutterPlace\":\"left\",\"gutterWidth\":0},\"headerFooterState\":\"show\",\"pagesNum\":1,\"headerInfo\":{\"headerOption\":{\"first\":false,\"oddEven\":false},\"headerItem\":{\"common\":{\"numberOption\":{\"position\":\"right\",\"format\":\"number\",\"startNum\":1,\"numberType\":\"continuePreSection\"},\"html\":\"\"},\"odd\":{\"numberOption\":{\"position\":\"right\",\"format\":\"number\",\"startNum\":1,\"numberType\":\"continuePreSection\"},\"html\":\"\"},\"even\":{\"numberOption\":{\"position\":\"right\",\"format\":\"number\",\"startNum\":1,\"numberType\":\"continuePreSection\"},\"html\":\"\"},\"first\":{\"numberOption\":{\"position\":\"right\",\"format\":\"number\",\"startNum\":1,\"numberType\":\"continuePreSection\"},\"html\":\"\"}}},\"footerInfo\":{\"footerOption\":{\"first\":false,\"oddEven\":false},\"footerItem\":{\"common\":{\"numberOption\":{\"position\":\"right\",\"format\":\"number\",\"startNum\":1,\"numberType\":\"continuePreSection\"},\"html\":\"\"},\"odd\":{\"numberOption\":{\"position\":\"right\",\"format\":\"number\",\"startNum\":1,\"numberType\":\"continuePreSection\"},\"html\":\"\"},\"even\":{\"numberOption\":{\"position\":\"right\",\"format\":\"number\",\"startNum\":1,\"numberType\":\"continuePreSection\"},\"html\":\"\"},\"first\":{\"numberOption\":{\"position\":\"right\",\"format\":\"number\",\"startNum\":1,\"numberType\":\"continuePreSection\"},\"html\":\"\"}}},\"headerOption\":{\"first\":false,\"oddEven\":false},\"footerOption\":{\"first\":false,\"oddEven\":false},\"sectionOrder\":1},\"content\":[{\"type\":\"paragraph\",\"attrs\":{\"textAlign\":\"justify\",\"fontSize\":\"12pt\",\"lineHeight\":{\"label\":\"\u591a\u500d\u884c\u8ddd\",\"value\":1,\"unitLabel\":\"\u500d\",\"defaultCharValue\":12},\"position\":\"relative\",\"offsetTop\":0,\"actualLineHeight\":1.31,\"marginLeft\":{\"value\":0,\"unitLabel\":\"\u5b57\u7b26\",\"defaultCharValue\":12},\"marginRight\":{\"value\":0,\"unitLabel\":\"\u5b57\u7b26\",\"defaultCharValue\":12},\"marginTop\":{\"value\":0,\"unitLabel\":\"\u884c\",\"defaultCharValue\":12},\"actualMarginTop\":0,\"marginBottom\":{\"value\":0,\"unitLabel\":\"\u884c\",\"defaultCharValue\":12},\"actualMarginBottom\":0,\"marginIndent\":{\"value\":0,\"unitLabel\":\"\u884c\",\"defaultCharValue\":12},\"indent\":{\"label\":\"\u65e0\",\"value\":0,\"unitLabel\":\"\u5b57\u7b26\",\"defaultCharValue\":12},\"bindData\":{\"isBindData\":false,\"dataset\":\"\"},\"paragraphBackground\":null,\"marginTopToCalcY\":0,\"marginBottomToCalcY\":0,\"styleRuleIds\":null,\"visibleRuleIds\":null,\"ruleInfo\":{\"bold\":false,\"italic\":false,\"underline\":false,\"deleteline\":false,\"ruleColor\":null,\"ruleBackground\":null,\"ruleHidden\":false},\"id\":null,\"level\":0,\"y\":0,\"height\":0,\"renderInfo\":{\"rows\":[{\"startIndex\":0,\"height\":21}],\"textNum\":0,\"totalHeight\":21},\"pageBreakPos\":{\"pos\":[],\"textNum\":0},\"tocLevel\":0,\"childDetailsId\":null,\"childDocId\":null,\"childModelName\":null}}]}]}");
        ApiResponse<Integer> rows = this.wordEditorDetailsService.addWordEditorDetail(emptyWord);
        WordModelInfoDto wordModelInfoDto = new WordModelInfoDto();
        wordModelInfoDto.setModelName(defaultName);
        wordModelInfoDto.setGroupId(WordConstant.WORD_EMPTY_MODEL_GROUP_ID_DEFAULT);
        wordModelInfoDto.setDetailsId(String.valueOf(wordEditorDetailId));
        ApiResponse<Long> modelApiResponse = this.wordModelInfoService.addModelInfo(wordModelInfoDto);
        int typeCode = TypeUtils.getTypeCodeByName(type);
        if (typeCode < 0) {
            throw new HussarException("\u65e0\u6548\u7684\u6587\u6863\u7c7b\u578b");
        }
        WordDocTypeInfo wordDocTypeInfo = TypeUtils.createWordDocTypeInfo((Long)modelApiResponse.getData(), defaultName, typeCode, WordConstant.WORD_EMPTY_MODEL_GROUP_ID_DEFAULT);
        this.wordTypeInfoService.addOrUpdateWordDocTypeInfo(wordDocTypeInfo);
        return (Long)modelApiResponse.getData();
    }

    public Long copyDocument(Long docId) {
        WordEditorDetails copyWordDetail = new WordEditorDetails();
        if (HussarUtils.isEmpty((Object)docId)) {
            throw new HussarException(OwnErrorEnum.PARAMS_NULL_ERROR.getMsg());
        }
        WordModelInfo originalWordModelInfo = (WordModelInfo)((WordModelInfoMapper)this.wordModelInfoService.getBaseMapper()).selectById(docId);
        WordEditorDetails originalWordEditorDetails = (WordEditorDetails)this.wordEditorDetailsService.getById((Serializable)((Object)originalWordModelInfo.getDetailsId()));
        if (HussarUtils.isNotEmpty((Object)originalWordEditorDetails)) {
            long detailId = IdUtil.getSnowflakeNextId();
            copyWordDetail.setId(Long.valueOf(detailId));
            copyWordDetail.setDocId(null);
            copyWordDetail.setDetailContent(originalWordEditorDetails.getDetailContent());
            copyWordDetail.setDetailOptions(originalWordEditorDetails.getDetailOptions());
        }
        ApiResponse<Integer> row = this.wordEditorDetailsService.addWordEditorDetail(copyWordDetail);
        WordModelInfoDto copyWordModelInfo = new WordModelInfoDto();
        copyWordModelInfo.setModelName(originalWordModelInfo.getModelName());
        copyWordModelInfo.setGroupId(originalWordModelInfo.getGroupId());
        copyWordModelInfo.setModelCode(originalWordModelInfo.getModelCode());
        copyWordModelInfo.setModelVersion(originalWordModelInfo.getModelVersion());
        copyWordModelInfo.setModelStatus(originalWordModelInfo.getModelStatus());
        copyWordModelInfo.setEditStatus(originalWordModelInfo.getEditStatus());
        copyWordModelInfo.setValidTime(originalWordModelInfo.getValidTime());
        copyWordModelInfo.setDetailsId(String.valueOf(copyWordDetail.getId()));
        ApiResponse<Long> longApiResponse = this.wordModelInfoService.addModelInfo(copyWordModelInfo);
        LambdaQueryWrapper wordModelInfoLambdaQueryWrapper = new LambdaQueryWrapper();
        wordModelInfoLambdaQueryWrapper.eq(WordModelInfo::getParentModelId, (Object)docId);
        List childWordModelInfoList = ((WordModelInfoMapper)this.wordModelInfoService.getBaseMapper()).selectList((Wrapper)wordModelInfoLambdaQueryWrapper);
        if (HussarUtils.isNotEmpty((Object)childWordModelInfoList)) {
            Long copyParentModelInfoId = (Long)longApiResponse.getData();
            for (WordModelInfo childWordModelInfo : childWordModelInfoList) {
                WordEditorDetails childEditorDetails = (WordEditorDetails)this.wordEditorDetailsService.getById((Serializable)((Object)childWordModelInfo.getDetailsId()));
                Long copyChildEditorDetailsId = null;
                if (HussarUtils.isNotEmpty((Object)childEditorDetails)) {
                    copyChildEditorDetailsId = this.wordEditorDetailsService.copyEditorDetails(childEditorDetails);
                }
                Long copyChildModelInfoId = this.wordModelInfoService.copyWordModelInfo(childWordModelInfo, copyChildEditorDetailsId, copyParentModelInfoId);
                this.wordTypeInfoService.copyWordTypeInfo(childWordModelInfo.getId(), copyChildModelInfoId, DocumentType.WORD_MODEL.getTypeCode(), originalWordModelInfo.getGroupId(), copyParentModelInfoId);
                this.documentDataBindService.copyDataBind(childWordModelInfo.getId(), copyChildModelInfoId);
            }
        }
        List docTypeInfoList = this.wordTypeInfoService.queryList(docId);
        String modelName = "\u65e0\u6807\u9898\u6587\u6863";
        int typeCode = DocumentType.WORD_MODEL.getTypeCode();
        if (HussarUtils.isNotEmpty((Object)docTypeInfoList)) {
            modelName = ((WordDocTypeInfo)docTypeInfoList.get(0)).getReportName();
            typeCode = ((WordDocTypeInfo)docTypeInfoList.get(0)).getReportType();
        }
        WordDocTypeInfo wordDocTypeInfo = TypeUtils.createWordDocTypeInfo((Long)longApiResponse.getData(), modelName, typeCode, originalWordModelInfo.getGroupId(), originalWordModelInfo.getParentModelId());
        this.wordTypeInfoService.addOrUpdateWordDocTypeInfo(wordDocTypeInfo);
        ApiResponse dataBindByIdAPI = this.documentDataBindService.getDataBindById(docId);
        if (dataBindByIdAPI.isSuccess() && HussarUtils.isNotEmpty((Object)dataBindByIdAPI.getData())) {
            DocDataBindInfo dataBindInfo = (DocDataBindInfo)dataBindByIdAPI.getData();
            DocDataBindInfo copyInfo = new DocDataBindInfo();
            copyInfo.setDataBindId((Long)longApiResponse.getData());
            copyInfo.setDocId((Long)longApiResponse.getData());
            copyInfo.setDataBindDetails(dataBindInfo.getDataBindDetails());
            copyInfo.setWordDataSet(dataBindInfo.getWordDataSet());
            copyInfo.setInterFaceName(dataBindInfo.getInterFaceName());
            this.documentDataBindService.insertOrUpdate(copyInfo);
        }
        return (Long)longApiResponse.getData();
    }

    public void downloadDocument(HttpServletResponse response, Long docId) {
        this.wordDocExportService.exportDoc(response, docId);
    }

    public void previewPDF(HttpServletResponse response, Long docId) {
        Long fileId = this.wordPdfRelationshipService.getFileIdByDocId(docId);
        if (fileId == null) {
            throw new HussarException(OwnErrorEnum.PARAMS_NULL_ERROR.getMsg());
        }
        this.documentInfoService.getFileStreamByFileId(response, fileId);
    }

    public ApiResponse<InputStream> previewPDF(Long docId) {
        Long fileId = this.wordPdfRelationshipService.getFileIdByDocId(docId);
        if (fileId == null) {
            throw new HussarException(OwnErrorEnum.PARAMS_NULL_ERROR.getMsg());
        }
        return ApiResponse.success((Object)this.documentInfoService.getFileStreamByFileId(fileId));
    }

    public ApiResponse<Long> importDocument(MultipartFile file, Long groupId, String docName) {
        return this.wordDocImportService.importDoc(file, groupId, docName);
    }

    public void exportDocument(HttpServletResponse response, Long docId) {
        this.wordDocExportService.exportDocument(response, docId);
    }

    public DocDataBindInfo getBindConfig(GenerateReportParam generateReportParam) {
        if (HussarUtils.isEmpty((Object)generateReportParam) || HussarUtils.isEmpty((Object)generateReportParam.getBusinessId())) {
            return null;
        }
        Long businessId = generateReportParam.getBusinessId();
        ApiResponse dataBindByIdAPI = this.documentDataBindService.getDataBindById(businessId);
        if (!dataBindByIdAPI.isSuccess() || HussarUtils.isEmpty((Object)dataBindByIdAPI.getData())) {
            return null;
        }
        return (DocDataBindInfo)dataBindByIdAPI.getData();
    }

    public void afterPropertiesSet() throws Exception {
        DocumentFactory.add((String)DocumentType.WORD_MODEL.getTypeName(), (CommonDocumentInterface)this);
    }

    public Long generateReport(Long id, JSONObject report) {
        ApiResponse queryOfficeObj = this.documentInfoService.queryOffice(id.toString());
        if (!queryOfficeObj.isSuccess() || HussarUtils.isEmpty((Object)queryOfficeObj.getData())) {
            throw new BaseException("\u672a\u627e\u5230\u5bf9\u5e94\u6587\u4ef6");
        }
        JSONObject officeDataJson = JSON.parseObject((String)HussarUtils.toJson((Object)queryOfficeObj.getData()));
        JSONObject extendResult = officeDataJson.getJSONObject("extendResult");
        String modelName = (String)extendResult.get((Object)"modelName");
        Long groupId = HussarUtils.toLong((Object)extendResult.get((Object)"groupId"));
        String reportName = modelName + "_report";
        String content = (String)report.get((Object)"content");
        String options = (String)report.get((Object)"options");
        HashMap<String, String> reportData = new HashMap<String, String>();
        reportData.put("detailContent", content);
        reportData.put("detailOptions", options);
        ApiResponse<Long> detailIds = this.wordEditorDetailsService.addWordEditorDetail(null, null, reportData);
        Long detailId = (Long)detailIds.getData();
        WordModelInfoDto wordModelInfoDto = new WordModelInfoDto();
        wordModelInfoDto.setModelName(reportName);
        wordModelInfoDto.setGroupId(groupId);
        wordModelInfoDto.setDetailsId(String.valueOf(detailId));
        ApiResponse<Long> modelApiResponse = this.wordModelInfoService.addModelInfo(wordModelInfoDto);
        WordDocTypeInfo wordDocTypeInfo = TypeUtils.createWordDocTypeInfo((Long)modelApiResponse.getData(), reportName, 1, groupId);
        this.wordTypeInfoService.addOrUpdateWordDocTypeInfo(wordDocTypeInfo);
        if (detailIds.isSuccess() && modelApiResponse.isSuccess() && modelApiResponse.getData() != null) {
            return (Long)modelApiResponse.getData();
        }
        return null;
    }

    public JSONObject executeJsGenerateReportJson(Long id, String data) {
        ApiResponse queryOfficeObj = this.documentInfoService.queryOffice(id.toString());
        if (!queryOfficeObj.isSuccess() || HussarUtils.isEmpty((Object)queryOfficeObj.getData())) {
            throw new BaseException("\u672a\u627e\u5230\u5bf9\u5e94\u6587\u4ef6");
        }
        JSONObject officeDataJson = JSON.parseObject((String)HussarUtils.toJson((Object)queryOfficeObj.getData()));
        JSONObject wordEditorDetail = officeDataJson.getJSONObject("wordEditorDetail");
        String detailContent = (String)wordEditorDetail.get((Object)"detailContent");
        String detailOptions = (String)wordEditorDetail.get((Object)"detailOptions");
        JSONObject result = null;
        if (HussarUtils.isNotEmpty((Object)detailContent) && HussarUtils.isNotEmpty((Object)detailOptions)) {
            result = JSExecutor.executeDealReportJS(detailContent, detailOptions, data);
        }
        return result;
    }

    public DocumentSplitVo getDocumentById(Long docId) {
        WordModelInfo parentDocument = (WordModelInfo)this.wordModelInfoService.getById(docId);
        WordEditorDetails parentDocumentDetail = (WordEditorDetails)this.wordEditorDetailsService.getById((Serializable)((Object)parentDocument.getDetailsId()));
        DocumentSplitVo documentSplitVo = DocumentSplitOfUtil.of(parentDocument, parentDocumentDetail);
        List<WordModelInfo> child = this.getChild(parentDocument.getId());
        this.initRes(documentSplitVo, child);
        return documentSplitVo;
    }

    private List<WordModelInfo> getChild(Long parentId) {
        LambdaQueryWrapper qy = new LambdaQueryWrapper();
        qy.eq(WordModelInfo::getParentModelId, (Object)parentId);
        qy.ne(HussarDelflagEntity::getDelFlag, (Object)"1");
        List list = this.wordModelInfoService.list((Wrapper)qy);
        if (HussarUtils.isNotEmpty((Object)list)) {
            for (WordModelInfo wordModelInfo : list) {
                Long id = wordModelInfo.getId();
                List<WordModelInfo> child = this.getChild(id);
                wordModelInfo.setChildModelInfo(child);
            }
        }
        return list;
    }

    private void initRes(DocumentSplitVo documentSplitVo, List<WordModelInfo> child) {
        if (HussarUtils.isNotEmpty(child)) {
            ArrayList<DocumentSplitVo> documentSplitVos = new ArrayList<DocumentSplitVo>();
            for (int i = 0; i < child.size(); ++i) {
                WordModelInfo wordModelInfo = child.get(i);
                WordEditorDetails byId = (WordEditorDetails)this.wordEditorDetailsService.getById((Serializable)((Object)wordModelInfo.getDetailsId()));
                DocumentSplitVo childDocumentSplitVo = DocumentSplitOfUtil.of(wordModelInfo, byId);
                documentSplitVos.add(childDocumentSplitVo);
                if (!HussarUtils.isNotEmpty((Object)wordModelInfo.getChildModelInfo())) continue;
                List childModelInfo = wordModelInfo.getChildModelInfo();
                this.initRes(childDocumentSplitVo, childModelInfo);
            }
            documentSplitVo.setChildDocument(documentSplitVos);
        }
    }

    public void traverseWordModelTree(List<WordModelInfo> nodeList, List<WordEditorDetails> allWordEditorDetailsList, List<WordEditorDetails> editorDetailsList) {
        for (int i = 0; i < editorDetailsList.size(); ++i) {
            WordEditorDetails wordEditorDetails = editorDetailsList.get(i);
            String detailsId = wordEditorDetails.getDetailsId();
            List<WordModelInfo> childDitInfoList = this.getChildDitInfo(nodeList, detailsId);
            String modelName = this.getModelNameBydetailsId(nodeList, detailsId);
            wordEditorDetails.setModelName(modelName);
            String checkedTitleIds = this.getCheckedTitleIdsBydetailsId(nodeList, detailsId);
            wordEditorDetails.setCheckedTitleIds(checkedTitleIds);
            for (int j = 0; j < childDitInfoList.size(); ++j) {
                WordModelInfo childDitInfo = childDitInfoList.get(j);
                String childDtlId = childDitInfo.getDetailsId();
                List<WordEditorDetails> childDtls = allWordEditorDetailsList.stream().filter(dtl -> childDtlId.equals(String.valueOf(dtl.getId()))).collect(Collectors.toList());
                if (HussarUtils.isNotEmpty((Object)wordEditorDetails.getChildDetails())) {
                    List childDetails = wordEditorDetails.getChildDetails();
                    childDetails.addAll(childDtls);
                    wordEditorDetails.setChildDetails(childDetails);
                } else {
                    wordEditorDetails.setChildDetails(childDtls);
                }
                if (!HussarUtils.isNotEmpty(childDtls)) continue;
                this.traverseWordModelTree(nodeList, allWordEditorDetailsList, childDtls);
            }
        }
    }

    public void traverseWordModelTreeForListId(List<WordModelInfo> nodeList, List<Long> list) {
        if (nodeList == null || nodeList.isEmpty()) {
            return;
        }
        for (WordModelInfo node : nodeList) {
            if (HussarUtils.isNotEmpty((Object)node.getDetailsId())) {
                list.add(Long.valueOf(node.getDetailsId()));
            }
            if (node.getChildModelInfo() == null || node.getChildModelInfo().isEmpty()) continue;
            this.traverseWordModelTreeForListId(node.getChildModelInfo(), list);
        }
    }

    public List<WordModelInfo> getChildDitInfo(List<WordModelInfo> nodeList, String dtlId) {
        if (nodeList == null || nodeList.isEmpty()) {
            return null;
        }
        for (WordModelInfo node : nodeList) {
            List<WordModelInfo> childDitInfo;
            if (dtlId.equals(node.getDetailsId())) {
                return node.getChildModelInfo();
            }
            if (node.getChildModelInfo() == null || node.getChildModelInfo().isEmpty() || (childDitInfo = this.getChildDitInfo(node.getChildModelInfo(), dtlId)) == null) continue;
            return childDitInfo;
        }
        return null;
    }

    private String getModelNameBydetailsId(List<WordModelInfo> nodeList, String detailsId) {
        if (nodeList == null || nodeList.isEmpty()) {
            return "";
        }
        for (WordModelInfo node : nodeList) {
            String modelNameBydetailsId;
            if (detailsId.equals(node.getDetailsId())) {
                return node.getModelName();
            }
            if (node.getChildModelInfo() == null || node.getChildModelInfo().isEmpty() || !HussarUtils.isNotEmpty((Object)(modelNameBydetailsId = this.getModelNameBydetailsId(node.getChildModelInfo(), detailsId)))) continue;
            return modelNameBydetailsId;
        }
        return "";
    }

    private String getCheckedTitleIdsBydetailsId(List<WordModelInfo> nodeList, String detailsId) {
        if (nodeList == null || nodeList.isEmpty()) {
            return "";
        }
        for (WordModelInfo node : nodeList) {
            String checkedTitleIds;
            if (detailsId.equals(node.getDetailsId())) {
                return node.getCheckedTitleIds();
            }
            if (node.getChildModelInfo() == null || node.getChildModelInfo().isEmpty() || !HussarUtils.isNotEmpty((Object)(checkedTitleIds = this.getCheckedTitleIdsBydetailsId(node.getChildModelInfo(), detailsId)))) continue;
            return checkedTitleIds;
        }
        return "";
    }

    public Long addBlankDocument(String documentName, String type, String groupId) {
        String defaultName = "\u65e0\u6807\u9898\u6587\u6863";
        Long groupIdLong = Long.parseLong(groupId);
        if (HussarUtils.isNotEmpty((Object)documentName)) {
            defaultName = documentName;
        }
        WordEditorDetails emptyWord = new WordEditorDetails();
        Long wordEditorDetailId = IdUtil.getSnowflakeNextId();
        emptyWord.setId(wordEditorDetailId);
        emptyWord.setDocId(null);
        emptyWord.setExtendedInfo("1");
        emptyWord.setDetailOptions("{\"settingInfo\":{\"waterInfo\":{\"hideSelf\":false,\"selectType\":\"1\",\"waterType\":\"2\",\"waterStyle\":false,\"imageWater\":{\"checked\":false,\"zoom\":\"auto\",\"erosion\":true,\"fileId\":\"\",\"rotate\":\"horizontal\"},\"textWater\":{\"checked\":false,\"content\":\"\",\"rotate\":\"horizontal\",\"fontFamily\":\"SimSun\",\"fontSize\":\"12pt\",\"transparency\":50,\"color\":\"#8F8F8F\"}},\"shading\":\"#ffffff\",\"pagingSeal\":{\"imgSrc\":\"\"},\"threads\":[],\"showThreads\":true,\"textBoxBorderMap\":{}},\"imgStyleMap\":{\"changeState\":false},\"userAgent\":\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36\",\"firstOpenAfterImport\":false,\"docRules\":{\"style\":[],\"visible\":[]},\"listMarkOption\":{\"marginLeftArr\":[],\"customListMark\":[{\"name\":\"none\",\"example\":\"\u65e0\u5217\u8868\"}]}}");
        emptyWord.setDetailContent("{\"type\":\"doc\",\"attrs\":{\"isBindData\":false},\"content\":[{\"type\":\"section\",\"attrs\":{\"HTMLAttributes\":null,\"id\":\"section-default\",\"pageOption\":{\"label\":\"A4\",\"width\":20.99,\"height\":29.77,\"direction\":\"vertical\",\"left\":3.18,\"right\":3.18,\"top\":2.54,\"bottom\":2.54,\"headerTop\":1.5,\"footerBottom\":1.75,\"isdefault\":true,\"gutterPlace\":\"left\",\"gutterWidth\":0},\"headerFooterState\":\"show\",\"pagesNum\":1,\"headerInfo\":{\"headerOption\":{\"first\":false,\"oddEven\":false},\"headerItem\":{\"common\":{\"numberOption\":{\"position\":\"right\",\"format\":\"number\",\"startNum\":1,\"numberType\":\"continuePreSection\"},\"html\":\"\"},\"odd\":{\"numberOption\":{\"position\":\"right\",\"format\":\"number\",\"startNum\":1,\"numberType\":\"continuePreSection\"},\"html\":\"\"},\"even\":{\"numberOption\":{\"position\":\"right\",\"format\":\"number\",\"startNum\":1,\"numberType\":\"continuePreSection\"},\"html\":\"\"},\"first\":{\"numberOption\":{\"position\":\"right\",\"format\":\"number\",\"startNum\":1,\"numberType\":\"continuePreSection\"},\"html\":\"\"}}},\"footerInfo\":{\"footerOption\":{\"first\":false,\"oddEven\":false},\"footerItem\":{\"common\":{\"numberOption\":{\"position\":\"right\",\"format\":\"number\",\"startNum\":1,\"numberType\":\"continuePreSection\"},\"html\":\"\"},\"odd\":{\"numberOption\":{\"position\":\"right\",\"format\":\"number\",\"startNum\":1,\"numberType\":\"continuePreSection\"},\"html\":\"\"},\"even\":{\"numberOption\":{\"position\":\"right\",\"format\":\"number\",\"startNum\":1,\"numberType\":\"continuePreSection\"},\"html\":\"\"},\"first\":{\"numberOption\":{\"position\":\"right\",\"format\":\"number\",\"startNum\":1,\"numberType\":\"continuePreSection\"},\"html\":\"\"}}},\"headerOption\":{\"first\":false,\"oddEven\":false},\"footerOption\":{\"first\":false,\"oddEven\":false},\"sectionOrder\":1},\"content\":[{\"type\":\"paragraph\",\"attrs\":{\"textAlign\":\"justify\",\"fontSize\":\"12pt\",\"lineHeight\":{\"label\":\"\u591a\u500d\u884c\u8ddd\",\"value\":1,\"unitLabel\":\"\u500d\",\"defaultCharValue\":12},\"position\":\"relative\",\"offsetTop\":0,\"actualLineHeight\":1.31,\"marginLeft\":{\"value\":0,\"unitLabel\":\"\u5b57\u7b26\",\"defaultCharValue\":12},\"marginRight\":{\"value\":0,\"unitLabel\":\"\u5b57\u7b26\",\"defaultCharValue\":12},\"marginTop\":{\"value\":0,\"unitLabel\":\"\u884c\",\"defaultCharValue\":12},\"actualMarginTop\":0,\"marginBottom\":{\"value\":0,\"unitLabel\":\"\u884c\",\"defaultCharValue\":12},\"actualMarginBottom\":0,\"marginIndent\":{\"value\":0,\"unitLabel\":\"\u884c\",\"defaultCharValue\":12},\"indent\":{\"label\":\"\u65e0\",\"value\":0,\"unitLabel\":\"\u5b57\u7b26\",\"defaultCharValue\":12},\"bindData\":{\"isBindData\":false,\"dataset\":\"\"},\"paragraphBackground\":null,\"marginTopToCalcY\":0,\"marginBottomToCalcY\":0,\"styleRuleIds\":null,\"visibleRuleIds\":null,\"ruleInfo\":{\"bold\":false,\"italic\":false,\"underline\":false,\"deleteline\":false,\"ruleColor\":null,\"ruleBackground\":null,\"ruleHidden\":false},\"id\":null,\"level\":0,\"y\":0,\"height\":0,\"renderInfo\":{\"rows\":[{\"startIndex\":0,\"height\":21}],\"textNum\":0,\"totalHeight\":21},\"pageBreakPos\":{\"pos\":[],\"textNum\":0},\"tocLevel\":0,\"childDetailsId\":null,\"childDocId\":null,\"childModelName\":null}}]}]}");
        ApiResponse<Integer> rows = this.wordEditorDetailsService.addWordEditorDetail(emptyWord);
        WordModelInfoDto wordModelInfoDto = new WordModelInfoDto();
        wordModelInfoDto.setModelName(defaultName);
        wordModelInfoDto.setGroupId(Long.valueOf(Long.parseLong(groupId)));
        wordModelInfoDto.setDetailsId(String.valueOf(wordEditorDetailId));
        ApiResponse<Long> modelApiResponse = this.wordModelInfoService.addModelInfo(wordModelInfoDto);
        int typeCode = TypeUtils.getTypeCodeByName(type);
        if (typeCode < 0) {
            throw new HussarException("\u65e0\u6548\u7684\u6587\u6863\u7c7b\u578b");
        }
        this.wordTypeInfoService.addOrUpdateWordDocTypeInfo((Long)modelApiResponse.getData(), defaultName, typeCode, groupIdLong);
        return (Long)modelApiResponse.getData();
    }

    public boolean deleteDocument(Long docId) {
        if (docId == null) {
            throw new HussarException(OwnErrorEnum.PARAMS_NULL_ERROR.getMsg());
        }
        this.wordTypeInfoService.deleteByReportId(docId);
        ApiResponse<Boolean> result = this.wordModelInfoService.delete(Collections.singletonList(docId));
        return result.isSuccess();
    }

    public void downDocument(HttpServletResponse response, Long docId) {
        this.wordDocExportService.exportDocument(response, docId);
    }
}

