/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.word.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.document.word.dao.WordEditSavedVersionMapper;
import com.jxdinfo.document.word.dto.WordEditSavedVersionDto;
import com.jxdinfo.document.word.model.WordEditSavedVersion;
import com.jxdinfo.document.word.service.IWordEditSavedVersionService;
import com.jxdinfo.document.word.vo.WordEditSavedVersionListVo;
import com.jxdinfo.document.word.vo.WordEditSavedVersionVo;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserBoService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.HussarBaseEntity;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.document.word.service.impl.WordEditSavedVersionImpl")
public class WordEditSavedVersionImpl
implements IWordEditSavedVersionService {
    @Resource
    private WordEditSavedVersionMapper wordEditSavedVersionMapper;
    @Resource
    private IHussarBaseUserBoService iHussarBaseUserBoService;

    public ApiResponse<String> save(WordEditSavedVersionDto dto) {
        WordEditSavedVersion wordEditSavedVersion = new WordEditSavedVersion();
        wordEditSavedVersion.setHistoryName(dto.getVersionName());
        wordEditSavedVersion.setDetailContent(dto.getVersionContent());
        wordEditSavedVersion.setDetailOptions(dto.getVersionOptions());
        wordEditSavedVersion.setDocId(Long.valueOf(dto.getDocId()));
        wordEditSavedVersion.setWordDataSet(dto.getWordDataSet());
        wordEditSavedVersion.setDataBindDetails(dto.getDataBindDetails());
        wordEditSavedVersion.setInterFaceName(dto.getInterfaceName());
        this.wordEditSavedVersionMapper.insert(wordEditSavedVersion);
        return ApiResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    public boolean update(Long versionId, String versionName) {
        WordEditSavedVersion wordEditSavedVersion = (WordEditSavedVersion)this.wordEditSavedVersionMapper.selectById(versionId);
        if (HussarUtils.isNotEmpty((Object)versionName)) {
            wordEditSavedVersion.setHistoryName(versionName);
            this.wordEditSavedVersionMapper.updateById(wordEditSavedVersion);
            return true;
        }
        return false;
    }

    public ApiResponse<List<WordEditSavedVersionListVo>> queryHistoryList(Long docId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(WordEditSavedVersion::getDocId, (Object)docId)).eq(HussarDelflagEntity::getDelFlag, (Object)"0")).orderByDesc(HussarBaseEntity::getCreateTime);
        List wordEditSavedVersions = this.wordEditSavedVersionMapper.selectList((Wrapper)queryWrapper);
        List wordEditSavedVersionListVos = wordEditSavedVersions.stream().map(wordEditSavedVersion -> {
            SysUsers user;
            WordEditSavedVersionListVo vo = new WordEditSavedVersionListVo();
            vo.setVersionId(String.valueOf(wordEditSavedVersion.getId()));
            vo.setVersionName(wordEditSavedVersion.getHistoryName());
            vo.setCreateTime(wordEditSavedVersion.getCreateTime());
            if (HussarUtils.isNotEmpty((Object)wordEditSavedVersion.getCreator()) && HussarUtils.isNotEmpty((Object)(user = this.iHussarBaseUserBoService.getUser(wordEditSavedVersion.getCreator())))) {
                vo.setCreator(user.getUserName());
            }
            return vo;
        }).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(wordEditSavedVersionListVos)) {
            return ApiResponse.success(wordEditSavedVersionListVos);
        }
        return ApiResponse.success(new ArrayList(), (String)"\u6682\u65e0\u6570\u636e");
    }

    public ApiResponse<WordEditSavedVersionVo> getHistoryDetail(String id) {
        WordEditSavedVersionVo wordEditSavedVersionVo = new WordEditSavedVersionVo();
        WordEditSavedVersion wordEditSavedVersion = (WordEditSavedVersion)this.wordEditSavedVersionMapper.selectById((Serializable)((Object)id));
        if (HussarUtils.isNotEmpty((Object)wordEditSavedVersion)) {
            SysUsers user;
            wordEditSavedVersionVo.setVersionId(String.valueOf(wordEditSavedVersion.getId()));
            wordEditSavedVersionVo.setCreateTime(wordEditSavedVersion.getCreateTime());
            wordEditSavedVersionVo.setVersionName(wordEditSavedVersion.getHistoryName());
            wordEditSavedVersionVo.setVersionOptions(wordEditSavedVersion.getDetailOptions());
            wordEditSavedVersionVo.setVersionContent(wordEditSavedVersion.getDetailContent());
            wordEditSavedVersionVo.setWordDataSet(wordEditSavedVersion.getWordDataSet());
            wordEditSavedVersionVo.setDataBindDetails(wordEditSavedVersion.getDataBindDetails());
            wordEditSavedVersionVo.setInterfaceName(wordEditSavedVersion.getInterFaceName());
            wordEditSavedVersionVo.setDocId(String.valueOf(wordEditSavedVersion.getDocId()));
            if (HussarUtils.isNotEmpty((Object)wordEditSavedVersion.getCreator()) && HussarUtils.isNotEmpty((Object)(user = this.iHussarBaseUserBoService.getUser(wordEditSavedVersion.getCreator())))) {
                wordEditSavedVersionVo.setCreator(user.getUserName());
            }
            return ApiResponse.success((Object)wordEditSavedVersionVo);
        }
        return ApiResponse.fail((String)"\u67e5\u8be2\u5931\u8d25");
    }

    public ApiResponse<String> delete(String id) {
        WordEditSavedVersion wordEditSavedVersion = (WordEditSavedVersion)this.wordEditSavedVersionMapper.selectById((Serializable)((Object)id));
        if (HussarUtils.isNotEmpty((Object)wordEditSavedVersion)) {
            wordEditSavedVersion.setDelFlag("1");
            this.wordEditSavedVersionMapper.updateById(wordEditSavedVersion);
            return ApiResponse.success((String)"\u5220\u9664\u6210\u529f");
        }
        return ApiResponse.fail((String)"\u5220\u9664\u5931\u8d25");
    }
}

