/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.word.util;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.document.word.bean.PageRequestBody;
import com.jxdinfo.document.word.cnst.SystemErrorEnum;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.List;

public class PageUtils {
    private PageUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static Page checkAndGenPage(PageRequestBody page) {
        if (null == page || 0 >= page.getPageNum() || 0 >= page.getPageSize()) {
            throw new BaseException(SystemErrorEnum.PARAM_ERROR.getMsg());
        }
        return new Page((long)page.getPageNum(), (long)page.getPageSize());
    }

    public static Page pageValidate(PageRequestBody page) {
        if (page.getPageNum() < 0 || page.getPageSize() < 0) {
            throw new BaseException("\u5206\u9875\u53c2\u6570\u9519\u8bef");
        }
        return new Page((long)page.getPageNum(), (long)page.getPageSize());
    }

    public static <T> Page<T> listToPage(Page<T> page, List<T> list) {
        if (HussarUtils.isEmpty(list)) {
            return page;
        }
        page.setTotal((long)list.size());
        int size = (int)page.getSize();
        int current = (int)page.getCurrent();
        list = list.size() > current * size ? list.subList((current - 1) * size, current * size) : list.subList((current - 1) * size, list.size());
        return page.setRecords(list);
    }
}

