/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.word.util;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.base.Strings;
import com.jxdinfo.document.word.bean.PageRequestBody;
import com.jxdinfo.document.word.cnst.SystemErrorEnum;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.platform.core.utils.ObjectUtil;
import com.jxdinfo.hussar.platform.core.utils.ReflectUtil;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FuzzyQueryUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(FuzzyQueryUtil.class);

    private FuzzyQueryUtil() {
    }

    public static <T> T encodeValue(T object, Collection<String> fields) {
        try {
            return FuzzyQueryUtil.encodeValueRealize(object, fields);
        }
        catch (Exception e) {
            FuzzyQueryUtil.exceptionLog(e);
            throw new BaseException(SystemErrorEnum.UNKNOWN_ERROR.getMsg());
        }
    }

    public static String encodeValue(String value) {
        if (Strings.isNullOrEmpty((String)value)) {
            return value;
        }
        return FuzzyQueryUtil.encode(value);
    }

    public static <T> T encodeValue(T object, String ... fields) {
        try {
            return FuzzyQueryUtil.encodeValueRealize(object, Arrays.asList(fields));
        }
        catch (Exception e) {
            FuzzyQueryUtil.exceptionLog(e);
            throw new BaseException(SystemErrorEnum.UNKNOWN_ERROR.getMsg());
        }
    }

    public static Map<String, Object> encodeValue(Map<String, Object> params, Collection<String> fields) {
        try {
            return FuzzyQueryUtil.encodeValueRealize(params, fields);
        }
        catch (Exception e) {
            FuzzyQueryUtil.exceptionLog(e);
            throw new BaseException(SystemErrorEnum.UNKNOWN_ERROR.getMsg());
        }
    }

    public static Page pageValidate(Map<String, Object> params) {
        Object pageNum = params.get("pageNum");
        Object pageSize = params.get("pageSize");
        if (ObjectUtil.isEmpty((Object)pageNum) || ObjectUtil.isEmpty((Object)pageSize)) {
            throw new BaseException(SystemErrorEnum.PAGE_PARAM.getMsg());
        }
        Long pageNum1 = Long.valueOf(pageNum.toString());
        Long pageSize1 = Long.valueOf(pageSize.toString());
        if (pageNum1 < 0L || pageSize1 < 0L) {
            throw new BaseException(SystemErrorEnum.PAGE_PARAM.getMsg());
        }
        return new Page(pageNum1.longValue(), pageSize1.longValue());
    }

    public static Page pageValidate(PageRequestBody page) {
        if (page.getPageNum() < 0 || page.getPageSize() < 0) {
            throw new BaseException(SystemErrorEnum.PAGE_PARAM.getMsg());
        }
        return new Page((long)page.getPageNum(), (long)page.getPageSize());
    }

    public static Map<String, Object> encodeValue(Map<String, Object> params, String ... fields) {
        try {
            return FuzzyQueryUtil.encodeValueRealize(params, Arrays.asList(fields));
        }
        catch (Exception e) {
            FuzzyQueryUtil.exceptionLog(e);
            throw new BaseException(SystemErrorEnum.UNKNOWN_ERROR.getMsg());
        }
    }

    private static void exceptionLog(Exception e) {
        LOGGER.error("\u6a21\u7cca\u67e5\u8be2\u53c2\u6570\u5904\u7406\u5f02\u5e38:{}", (Object)e.getMessage(), (Object)e);
    }

    private static <T> T encodeValueRealize(T entity, Collection<String> fields) throws NoSuchFieldException, IllegalAccessException {
        for (String name : fields) {
            Field field = ReflectUtil.getField(entity.getClass(), (String)name);
            if (field == null) {
                throw new NoSuchFieldException(name);
            }
            field.setAccessible(true);
            String value = (String)field.get(entity);
            if (org.apache.logging.log4j.util.Strings.isEmpty((CharSequence)value)) continue;
            value = FuzzyQueryUtil.encode(value);
            field.set(entity, value);
        }
        return entity;
    }

    private static Map<String, Object> encodeValueRealize(Map<String, Object> params, Collection<String> fields) {
        for (String name : fields) {
            String value = null;
            if (params.get(name) instanceof String) {
                String string = value = params.get(name) != null ? params.get(name).toString() : null;
            }
            if (org.apache.logging.log4j.util.Strings.isEmpty(value)) continue;
            value = FuzzyQueryUtil.encode(value);
            params.put(name, value);
        }
        return params;
    }

    private static String encode(String value) {
        if ("".equals(value) || value == null) {
            return "";
        }
        value = value.contains("/") ? value.replace("/", "//") : value;
        value = value.contains("%") ? value.replace("%", "/%") : value;
        value = value.contains("_") ? value.replace("_", "/_") : value;
        return value;
    }
}

