/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.stamp.sealmanagement.sealprogramme.report_seal_programme.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jxdinfo.document.stamp.sealmanagement.seallibrary.report_seal_library.dao.ReportSealLibraryMapper;
import com.jxdinfo.document.stamp.sealmanagement.seallibrary.report_seal_library.model.ReportSealLibrary;
import com.jxdinfo.document.stamp.sealmanagement.sealprogramme.report_seal_programme.dao.ReportSealProgrammeCustomMapper;
import com.jxdinfo.document.stamp.sealmanagement.sealprogramme.report_seal_programme.dao.ReportSealProgrammeMapper;
import com.jxdinfo.document.stamp.sealmanagement.sealprogramme.report_seal_programme.dao.ReportSealProgrammeStampRecordMapper;
import com.jxdinfo.document.stamp.sealmanagement.sealprogramme.report_seal_programme.dto.ReportSealProgrammeInfo;
import com.jxdinfo.document.stamp.sealmanagement.sealprogramme.report_seal_programme.dto.ReportSealProgrammeStampRecordInfo;
import com.jxdinfo.document.stamp.sealmanagement.sealprogramme.report_seal_programme.model.ReportSealProgramme;
import com.jxdinfo.document.stamp.sealmanagement.sealprogramme.report_seal_programme.model.ReportSealProgrammeStampRecord;
import com.jxdinfo.document.stamp.sealmanagement.sealprogramme.report_seal_programme.service.ReportSealProgrammeCustomService;
import com.jxdinfo.document.stamp.sealmanagement.sealprogramme.report_seal_programme.service.ReportSealProgrammeExtendService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.security.integration.authentication.support.utils.HussarSecurityUtils;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="edreport.sealmanagement.sealprogramme.report_seal_programme.ReportSealProgrammeCustomServiceImpl")
public class ReportSealProgrammeCustomServiceImpl
implements ReportSealProgrammeCustomService {
    private static final Logger logger = LoggerFactory.getLogger(ReportSealProgrammeCustomServiceImpl.class);
    @Autowired
    private ReportSealProgrammeMapper reportSealProgrammeMapper;
    @Autowired
    private ReportSealProgrammeStampRecordMapper reportSealProgrammeStampRecordMapper;
    @Autowired
    private ReportSealLibraryMapper reportSealLibraryMapper;
    @Autowired
    private ReportSealProgrammeCustomMapper reportSealProgrammeCustomMapper;
    @Autowired(required=false)
    private ReportSealProgrammeExtendService reportSealProgrammeExtendService;

    public Boolean diffSealProgrammeName(String programmeName, String programmeId) {
        Boolean flag = true;
        QueryWrapper wapper = new QueryWrapper();
        wapper.eq((Object)"PROGRAMME_NAME", (Object)programmeName);
        List reportSealProgrammeList = this.reportSealProgrammeMapper.selectList((Wrapper)wapper);
        for (int i = 0; i < reportSealProgrammeList.size(); ++i) {
            if (((ReportSealProgramme)reportSealProgrammeList.get(i)).getId().toString().equals(programmeId)) continue;
            flag = false;
            break;
        }
        return flag;
    }

    @Override
    public ApiResponse<Map<String, Object>> saveSealProgramme(Map<String, Object> param) {
        try {
            int saveProgrammeRes;
            Long newProgrammeId = IdWorker.getId((Object)new Date());
            String programmeId = param.get("id").toString();
            String programmeName = param.get("programmeName").toString();
            Boolean diffProgrammeNameFlag = this.diffSealProgrammeName(programmeName, programmeId);
            if (!diffProgrammeNameFlag.booleanValue()) {
                return ApiResponse.fail((int)10001, (String)"\u65b9\u6848\u540d\u79f0\u5df2\u5b58\u5728");
            }
            ReportSealProgramme reportSealProgramme = new ReportSealProgramme();
            reportSealProgramme.setProgrammeName(param.get("programmeName").toString());
            reportSealProgramme.setProgrammeNo(param.get("programmeNo").toString());
            reportSealProgramme.setPageSize(HussarUtils.isNotEmpty((Object)param.get("pageSize")) ? param.get("pageSize").toString() : "A4");
            reportSealProgramme.setPageOrientation(HussarUtils.isNotEmpty((Object)param.get("pageOrientation")) ? param.get("pageOrientation").toString() : "portrait");
            reportSealProgramme.setPdfId(param.get("pdfId").toString());
            reportSealProgramme.setPdfName(param.get("pdfName").toString());
            reportSealProgramme.setPdfPath(param.get("pdfPath").toString());
            reportSealProgramme.setIsCrossSeal(param.get("isCrossSeal").toString());
            if (param.get("isCrossSeal").toString().equals("0")) {
                reportSealProgramme.setCrossSealPosY(null);
            } else {
                reportSealProgramme.setCrossSealPosY(Double.parseDouble(param.get("crossSealPosY").toString()));
            }
            reportSealProgramme.setUpdateTime(LocalDateTime.now());
            UserDetails user = HussarSecurityUtils.getLoginUserDetails();
            reportSealProgramme.setUpdateId(user.getUserId().toString());
            reportSealProgramme.setUpdateName(user.getUserName());
            if (programmeId.isEmpty()) {
                reportSealProgramme.setId(newProgrammeId);
                reportSealProgramme.setCreateTime(LocalDateTime.now());
                reportSealProgramme.setCreateId(user.getUserId().toString());
                reportSealProgramme.setCreateName(user.getUserName());
                saveProgrammeRes = this.reportSealProgrammeMapper.insert(reportSealProgramme);
            } else {
                reportSealProgramme.setId(Long.parseLong(programmeId));
                saveProgrammeRes = this.reportSealProgrammeMapper.updateById(reportSealProgramme);
                List<Long> savedStampRecordIdList = this.reportSealProgrammeStampRecordMapper.selectStampRecordIdByProgrammeId(Long.parseLong(programmeId));
                if (savedStampRecordIdList.size() > 0) {
                    this.reportSealProgrammeStampRecordMapper.deleteBatchIds(savedStampRecordIdList);
                }
            }
            List stampRecordList = (List)param.get("stampRecord");
            ArrayList<Integer> saveStampRecordResList = new ArrayList<Integer>();
            for (int i = 0; i < stampRecordList.size(); ++i) {
                Long newStampRecordId = IdWorker.getId((Object)new Date());
                HashMap stampRecord = (HashMap)stampRecordList.get(i);
                String stampRecordId = stampRecord.get("id").toString();
                ReportSealProgrammeStampRecord reportSealProgrammeStampRecord = new ReportSealProgrammeStampRecord();
                reportSealProgrammeStampRecord.setSealId(Long.parseLong(stampRecord.get("sealId").toString()));
                reportSealProgrammeStampRecord.setSealPosX(Double.parseDouble(stampRecord.get("sealPosX").toString()));
                reportSealProgrammeStampRecord.setSealPosY(Double.parseDouble(stampRecord.get("sealPosY").toString()));
                reportSealProgrammeStampRecord.setSealIsPerPage(stampRecord.get("sealIsPerPage").toString());
                reportSealProgrammeStampRecord.setSealPageNum(stampRecord.get("sealPageNum").toString());
                reportSealProgrammeStampRecord.setSealSkipPageNum(stampRecord.get("sealSkipPageNum").toString());
                if (programmeId.isEmpty()) {
                    reportSealProgrammeStampRecord.setSealProgrammeId(newProgrammeId);
                } else {
                    reportSealProgrammeStampRecord.setSealProgrammeId(Long.parseLong(programmeId));
                }
                if (stampRecordId.isEmpty()) {
                    reportSealProgrammeStampRecord.setId(newStampRecordId);
                } else {
                    reportSealProgrammeStampRecord.setId(Long.parseLong(stampRecord.get("id").toString()));
                }
                int saveStampRecordRes = this.reportSealProgrammeStampRecordMapper.insert(reportSealProgrammeStampRecord);
                if (saveStampRecordRes != 1) continue;
                saveStampRecordResList.add(saveStampRecordRes);
            }
            if (saveProgrammeRes == 1 && saveStampRecordResList.size() == stampRecordList.size()) {
                if (programmeId.isEmpty()) {
                    HashMap<String, Object> ans = new HashMap<String, Object>();
                    ans.put("programmeId", newProgrammeId);
                    if (this.reportSealProgrammeExtendService != null) {
                        this.reportSealProgrammeExtendService.saveSealProgrammeExtend(true, ans);
                    }
                    return ApiResponse.success(ans, (String)"\u4fdd\u5b58\u6210\u529f");
                }
                if (this.reportSealProgrammeExtendService != null) {
                    this.reportSealProgrammeExtendService.saveSealProgrammeExtend(true, new HashMap<String, Object>());
                }
                return ApiResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
            }
            logger.error("\uff01saveProgrammeRes == 1 && saveStampRecordResList.size() == stampRecordList.size()");
            if (this.reportSealProgrammeExtendService != null) {
                this.reportSealProgrammeExtendService.saveSealProgrammeExtend(false, new HashMap<String, Object>());
            }
            return ApiResponse.fail((String)"\u4fdd\u5b58\u5931\u8d25");
        }
        catch (Exception e) {
            throw new HussarException("\u4fdd\u5b58\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public ApiResponse<ReportSealProgrammeInfo> getSealProgrammeInfoById(Map<String, Object> param) {
        try {
            if (this.reportSealProgrammeExtendService != null) {
                this.reportSealProgrammeExtendService.beforeGetSealProgrammeInfo(param);
            }
            Long programmeId = Long.parseLong(param.get("programmeId").toString());
            ReportSealProgramme reportSealProgramme = (ReportSealProgramme)this.reportSealProgrammeMapper.selectById(programmeId);
            List<ReportSealProgrammeStampRecord> reportSealProgrammeStampRecordList = this.reportSealProgrammeStampRecordMapper.selectByProgrammeId(programmeId);
            ArrayList<ReportSealProgrammeStampRecordInfo> reportSealProgrammeStampRecordInfoList = new ArrayList<ReportSealProgrammeStampRecordInfo>();
            for (int i = 0; i < reportSealProgrammeStampRecordList.size(); ++i) {
                Long sealId = reportSealProgrammeStampRecordList.get(i).getSealId();
                ReportSealLibrary reportSealLibrary = (ReportSealLibrary)this.reportSealLibraryMapper.selectById(sealId);
                ReportSealProgrammeStampRecordInfo reportSealProgrammeStampRecordInfo = new ReportSealProgrammeStampRecordInfo(reportSealProgrammeStampRecordList.get(i), reportSealLibrary);
                reportSealProgrammeStampRecordInfoList.add(reportSealProgrammeStampRecordInfo);
            }
            if (HussarUtils.isEmpty((Object)reportSealProgramme)) {
                reportSealProgramme = new ReportSealProgramme();
            }
            ReportSealProgrammeInfo reportSealProgrammeInfo = new ReportSealProgrammeInfo(reportSealProgramme, reportSealProgrammeStampRecordInfoList);
            if (this.reportSealProgrammeExtendService != null) {
                reportSealProgrammeInfo = this.reportSealProgrammeExtendService.afterGetSealProgrammeInfo(reportSealProgrammeInfo);
            }
            return ApiResponse.success((Object)reportSealProgrammeInfo, (String)"\u83b7\u53d6\u6570\u636e\u6210\u529f");
        }
        catch (Exception e) {
            return ApiResponse.fail((String)"\u83b7\u53d6\u6570\u636e\u5931\u8d25");
        }
    }

    @Override
    public ApiResponse<List<ReportSealProgramme>> getSealProgrammeListByReportType(Map<String, Object> param) {
        try {
            String pageSize = "";
            String pageOrientation = "";
            if (this.reportSealProgrammeExtendService != null) {
                this.reportSealProgrammeExtendService.beforeGetSealProgrammeList(param);
            }
            if (param.get("pageSize") != null) {
                pageSize = param.get("pageSize").toString();
            }
            if (param.get("pageOrientation") != null) {
                pageOrientation = param.get("pageOrientation").toString();
            }
            Long reportType = null;
            List<ReportSealProgramme> reportSealProgrammeList = this.reportSealProgrammeCustomMapper.selectByReportType(reportType, pageSize, pageOrientation);
            if (this.reportSealProgrammeExtendService != null) {
                reportSealProgrammeList = this.reportSealProgrammeExtendService.afterGetSealProgrammeList(reportSealProgrammeList);
            }
            return ApiResponse.success(reportSealProgrammeList, (String)"\u83b7\u53d6\u6570\u636e\u6210\u529f");
        }
        catch (Exception e) {
            return ApiResponse.fail((String)"\u83b7\u53d6\u6570\u636e\u5931\u8d25");
        }
    }

    @Override
    public ApiResponse<Map<String, Object>> getSealProgrammeListAssembly(Map<String, Object> param) {
        Long programmeId;
        ReportSealProgramme reportSealProgramme;
        if (this.reportSealProgrammeExtendService != null) {
            this.reportSealProgrammeExtendService.beforeGetSealProgrammeListAssembly(param);
        }
        if (HussarUtils.isEmpty((Object)(reportSealProgramme = (ReportSealProgramme)this.reportSealProgrammeMapper.selectById(programmeId = Long.valueOf(Long.parseLong(param.get("programmeId").toString())))))) {
            return ApiResponse.success();
        }
        Map<String, Object> ans = new HashMap<String, Object>();
        HashMap<String, Object> crossSealInfo = new HashMap<String, Object>();
        ArrayList sealInfo = new ArrayList();
        ans.put("id", reportSealProgramme.getId());
        ans.put("title", reportSealProgramme.getProgrammeName());
        ans.put("pageOrientation", reportSealProgramme.getPageOrientation());
        ans.put("pageSize", reportSealProgramme.getPageSize());
        ans.put("crossSealInfo", crossSealInfo);
        ans.put("sealInfo", sealInfo);
        List<ReportSealProgrammeStampRecord> reportSealProgrammeStampRecordList = this.reportSealProgrammeStampRecordMapper.selectByProgrammeId(programmeId);
        boolean isCrossSeal = false;
        if ("1".equals(reportSealProgramme.getIsCrossSeal())) {
            isCrossSeal = true;
        }
        if (!isCrossSeal && HussarUtils.isEmpty(reportSealProgrammeStampRecordList)) {
            return ApiResponse.success(ans);
        }
        HashSet<Long> sealId = new HashSet<Long>();
        if (HussarUtils.isNotEmpty(reportSealProgrammeStampRecordList)) {
            for (ReportSealProgrammeStampRecord reportSealProgrammeStampRecord : reportSealProgrammeStampRecordList) {
                sealId.add(reportSealProgrammeStampRecord.getSealId());
            }
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (!sealId.isEmpty()) {
            queryWrapper.in(ReportSealLibrary::getId, sealId);
        }
        if (isCrossSeal) {
            ((LambdaQueryWrapper)queryWrapper.or()).eq(ReportSealLibrary::getSealType, (Object)"2");
        }
        List reportSealLibraryList = this.reportSealLibraryMapper.selectList((Wrapper)queryWrapper);
        for (ReportSealLibrary reportSealLibrary : reportSealLibraryList) {
            if ("2".equals(reportSealLibrary.getSealType()) && isCrossSeal) {
                crossSealInfo.put("crossSealPosY", reportSealLibrary.getPositionYUnitType() == 0 ? reportSealLibrary.getPositionY() : this.cmToPx(reportSealLibrary.getPositionY()));
                crossSealInfo.put("sealName", reportSealLibrary.getSealName());
                crossSealInfo.put("imgSrc", reportSealLibrary.getSealPath());
                crossSealInfo.put("sealType", reportSealLibrary.getSealType());
                crossSealInfo.put("height", reportSealLibrary.getSizeHeightUnitType() == 0 ? reportSealLibrary.getSizeHeight() : this.cmToPx(reportSealLibrary.getSizeHeight()));
                crossSealInfo.put("width", reportSealLibrary.getSizeWidthUnitType() == 0 ? reportSealLibrary.getSizeWidth() : this.cmToPx(reportSealLibrary.getSizeWidth()));
                crossSealInfo.put("isCrossSeal", reportSealProgramme.getIsCrossSeal());
            }
            for (ReportSealProgrammeStampRecord reportSealProgrammeStampRecord : reportSealProgrammeStampRecordList) {
                if (!reportSealProgrammeStampRecord.getSealId().equals(reportSealLibrary.getId())) continue;
                HashMap<String, Object> seal = new HashMap<String, Object>();
                seal.put("createId", reportSealLibrary.getCreateId());
                seal.put("createName", reportSealLibrary.getCreateName());
                seal.put("createTime", reportSealLibrary.getCreateTime());
                seal.put("id", reportSealLibrary.getId());
                seal.put("top", reportSealProgrammeStampRecord.getSealPosY());
                seal.put("left", reportSealProgrammeStampRecord.getSealPosX());
                seal.put("sealName", reportSealLibrary.getSealName());
                seal.put("imgSrc", reportSealLibrary.getSealPath());
                seal.put("sealType", reportSealLibrary.getSealType());
                seal.put("height", reportSealLibrary.getSizeHeightUnitType() == 0 ? reportSealLibrary.getSizeHeight() : this.cmToPx(reportSealLibrary.getSizeHeight()));
                seal.put("width", reportSealLibrary.getSizeWidthUnitType() == 0 ? reportSealLibrary.getSizeWidth() : this.cmToPx(reportSealLibrary.getSizeWidth()));
                seal.put("sealIsPerPage", reportSealProgrammeStampRecord.getSealIsPerPage());
                if (HussarUtils.isNotEmpty((Object)reportSealProgrammeStampRecord.getSealPageNum())) {
                    seal.put("onlyPages", Arrays.asList(reportSealProgrammeStampRecord.getSealPageNum().split(",")).stream().mapToInt(Integer::parseInt).toArray());
                } else {
                    seal.put("onlyPages", null);
                }
                if (HussarUtils.isNotEmpty((Object)reportSealProgrammeStampRecord.getSealSkipPageNum())) {
                    seal.put("excludePages", Arrays.asList(reportSealProgrammeStampRecord.getSealSkipPageNum().split(",")).stream().mapToInt(Integer::parseInt).toArray());
                } else {
                    seal.put("excludePages", null);
                }
                sealInfo.add(seal);
            }
            if (this.reportSealProgrammeExtendService == null) continue;
            ans = this.reportSealProgrammeExtendService.afterGetSealProgrammeListAssembly(ans);
        }
        return ApiResponse.success(ans);
    }

    private Double cmToPx(Double cm) {
        int dpi = 96;
        double cm_2_inch = 2.54;
        return cm * (double)dpi / cm_2_inch;
    }
}

