/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.dataset.service.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.jxdinfo.document.excel.tools.core.common.utils.JsonUtil;
import com.jxdinfo.document.excel.tools.dataset.service.IExcelDataSetService;
import com.jxdinfo.document.excel.tools.dataset.vo.ExcelDataSetVo;
import com.jxdinfo.hussar.application.report.model.SysReport;
import com.jxdinfo.hussar.application.report.service.ISysReportService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.document.excel.tools.dataset.service.impl.ExcelDataSetServiceImpl")
public class ExcelDataSetServiceImpl
implements IExcelDataSetService {
    @Autowired
    private ISysReportService sysReportService;

    public ApiResponse<List<Long>> getDataSetIdsByDocId(Long docId) {
        ArrayList<Long> dataSetIds = new ArrayList<Long>();
        SysReport sysReport = this.sysReportService.getSysReportById(docId);
        if (sysReport != null) {
            String dataset = sysReport.getDataset();
            if (ObjectUtils.isEmpty((Object)dataset)) {
                return ApiResponse.success(dataSetIds);
            }
            List excelDataSetVos = (List)JsonUtil.convertValue((Object)dataset, (TypeReference)new TypeReference<List<ExcelDataSetVo>>(){});
            for (ExcelDataSetVo excelDataSetVo : excelDataSetVos) {
                dataSetIds.add(Long.valueOf(excelDataSetVo.getId()));
            }
        }
        return ApiResponse.success(dataSetIds);
    }
}

