/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.report.custom.service.Impl;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.document.excel.tools.core.common.utils.ReportUtil;
import com.jxdinfo.document.excel.tools.report.custom.dao.CustomMapper;
import com.jxdinfo.document.excel.tools.report.custom.service.CustomService;
import com.jxdinfo.document.excel.tools.report.instance.instance.model.ReportToolFormInstance;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CustomServiceImpl
implements CustomService {
    @Autowired
    private CustomMapper customMapper;

    @Override
    public Object generateReportOtherMethod(ReportToolFormInstance reportToolFormInstance) {
        return null;
    }

    @Override
    public String getSignPathByUserId(String userId) {
        Map<String, Object> userInfo = this.customMapper.selectUserSignImgByUserId(Long.parseLong(userId));
        if (Objects.nonNull(userInfo)) {
            String picBase64 = String.valueOf(userInfo.get("userSignImg"));
            String s = ReportUtil.convertBase64ToImage((String)picBase64, (String)(userId + ".png"), (String)"");
            return s;
        }
        String picBase64 = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAWQAAAC6CAYAAACZWDfLAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAGYBSURBVHhe7d0JvHXndD/wnRExBSG0McQQIS2tmmlrCG1FVVEa2vLSTAQpMaSNoCrSJGaNII14pcEboWKqIUJaNCoiKpLQhCIxxSykMez//j55V2z7f8Z7z33vPuesdT/7c849w977Wc9av/Vb61l7n63qRqqUlJSUlHWXrTc/pqSkpKSssyQgp6SkpPREEpBTUlJSeiIJyCkpKSk9kQTklJSUlJ5IAnJKSkpKTyQBOSUlJaUnkoCckpKS0hNJQE5JSUnpiSQgp6SkpPREEpBTUlJSeiIJyCkpKSk9kQTklJSUlJ5IAnJKSkpKTyQBOSUlJaUnkoCckpKS0hNJQE5JSUnpiSQgp6SkpPREEpBTUlJSeiIJyCkpKSk9kQTklJSUlJ5IAnJKSkpKTyQBOSUlJaUnkoC8QFLXddlSllO21Nynja2dJCAvkGy11VZlI2vhNOmI/RVzM2ruh83dSuY0jpMye9mqmZD0sgUU05qOsxySc704koC8YLIS5/zZz35Wfec736m+/vWvV//3f/9XXeMa16h22GGHavvtt6+22Wab8hn79fo1r3nN8nrK/EoCeH8lAXkJ5Re/+EX1rW99q/r+979f/fSnP61+/OMfV5///Oerc845p7x2netcp9ppp52qa1/72tV2221XPn+1q12t2mWXXarf+I3fqG584xtv3lNKn4QrX3755dU3vvGNMmfXve51y1yaw5T5kATkORPTNQ274aA2wBsCgN///vdXn/70p8vzyy67rPrKV75SffWrX62uuOKKwoAxYSC87bbbFue+/vWvX93rXveqHvGIR1R3uMMdNu8ppS/CLn7yk59UF154YXXqqaeW5+brrne9a3WDG9xg86f+f5nWnlLWVhKQ51hM3c9//vPyGNJ2MKWIc889tzDfSy+9tNp6663L57/97W9XH/jAB6ovfOELxXGJ79hiXz4b+1G2uNWtblX9yZ/8SfVXf/VX1W1ve9t05J6JQPrFL36xetOb3lS97nWvq374wx9WBxxwQPWEJzyh2m233TZ/arQIvOY1traEfbTtImX2koA8p2LasNqLL764+t73vlcYcDiUR9sll1xSffjDH67OOuusAsIhABZYx+dsJJzOPnzmRje6UXWTm9yklCh+67d+q9pzzz2r3/md3yn15ZR+ifl9z3veUx155JHVl7/85QKc+++/f/XXf/3XJZiOE1nU//7v/5ZN1hSwELYha9p5552r293udmX+2YfPJDjPVhKQZyyAETthyNJ8jjFOsNSo6VpUC1C0BQNuM2GfUSf8xCc+URjw1772tcKQHDMchMNEmcJrAJij2QKMifPzXL34hje8YUlvvXata12rlCbuec97Vre5zW3K6+qRfQVjullEcJh0XALzG97whuqII44oNeM73vGO1eMf//jqD/7gD4od/uhHPyoBOjKisKcIztj1aaedVn384x8v4Ox1xw07saAL2J/85CeXMoiSVsrsJQF5hgJQLY596lOfKgZ/97vfvbrpTW9ajBo4MnAb8GT0QA/IAdcPfehD1Uc+8pECrvG5AEbO4P8Q+wOsWBHwty+vcUSO5PnVr371cuxb3OIWpRbss0oUaow/+MEPCqh73fF33HHHwoB///d/v4BvdFdwZIt7PuP/Pgo9q4HbnKOFLOMaJ4sE4ED2v//7v6tXv/rV1YknnljmTLlCvX/XXXct5aqPfvSj1fve974C3MYNhOmOzmxsQsbFlugvFgJ9jr0SQftpT3ta9bCHPayw5b7axDxLAvKMBAhecMEF1Tve8Y7qve99b3ESgHyXu9ylgCfgBJIY5ne/+93qm9/8ZnXLW96yLLwQNd23v/3t1f/8z/9c9TlAKUXkVJ5bYCOOxak4RAB3+38OxNmud73rlfekoWeffXb12c9+thzX9znXHnvsUUoQN7/5zaub3exmpdaIJU/iaH0BNO16//Ef/1GyBWPaa6+9SifIIgHuOPnSl75Uve1tb6tOOOGE6rzzzis1/uc973nV/e53vxJ4Tz/99GrTpk3VmWeeWQIXvdgEXo90xU4A+d3udrfChAU2rwFw3/vkJz9ZWPGBBx5YPepRjyodN9m9MXtJQJ6RBCBzDCwFE2W0ABngAVQbo8aksRavKwl4HRBj1nqBATJWyimANrAErpgLJ4kp40z+t4VwQPuwkMeZMG7nddFFFxW28+u//uvF4X7t136tsOI73elOpRwB7GPfkwDZpJ9ba6Hn4447rvqXf/mXUvM+6KCDCoPrZhVkmnPuy/jGiczrYx/7WHXMMcdU//Zv/1ZAFhBjssoWMrY3vvGN1cknn1yIgHmXBVkbEMCI4G3+2YZyBJvznsAsiL/+9a+vNm7cWOzxmc98ZvXwhz+8rCskQ569JCDPUNTpgCrnsMACABm/hZUHPOABBTA4OQcA4BhGLJB4LZhtAKxSBkaL1XgNSHMojtMGC4t6PsvhbOqB73rXuwpbCqbMATHie9/73tVv//Zvl9cEh2DV8yqCzate9aoCOso70vT99tuvuvWtbz2WwYXpz/P4tSqyNfVj6wlsY999963+9E//tDwHyO9+97urf//3fy+2sPvuu1d/+Id/WOwyAJke2Bd9CWSe04ksDzsGyP/6r/9aQPiFL3xh9cAHPrDYYsrsJQF5RkKNjBgjxZJf+9rXFmcAfADiz//8zwtITFoOAMJYjZ5SAAus1YSl5H/5l39ZPoMNq/l95jOfKezov/7rv8r/WJISCfaEpQsGUR9WF+Z0iyKYvzYvDE5gMsaDDz64euhDH1oAui0R9AhGaOs7GIdddcXrgjqg1ep2xhlnlPFjt4cffnh15zvfuQRcoOp19mA/XlOWAr6x7+4joSv2q4z2zne+s2R19ikDEdgnqdOnTC/bPE+xKWXVEoYMDKV2GKt0jyMwdGUBjIVDjBKfBcZWu4G6+qjyBseyARElDjVnrPDNb35zcZj//M//LIsy2A3w3bBhQwkC0sv73//+hRk5r0Wr+8kIZCVq5EADSMkAlGOUfujTBogtbFr8srgpMApMfddH2FVXvG5M7EQ2ZEzmXgnKnEe3jPFhwv63RSki9tF+JPGczX3wgx8s5EI5TV0esQi9DjuvlNVJAvKMBWByAkDsSjgggbUCYwt0GOooY/ZZpQZpuJXxYDZABWsBKurDGLFHC3YAHDP8sz/7s9Lq5AKOe9zjHmUx0Go4J+SciygAWZ+1LEHJCMj+7u/+bgEmc0FHQOUtb3lLWXDVaaCbhR5lHIJbABQd9x1o2ueI+QJkQdvYb3/725cLdwQkoDmthJ151L+OeSuDWOt45CMfWf3RH/1RyTr6rqN5lgTkNRJgoHyh3KC0YOVbR8MNb3Sj8v4gk9aN8bnPfa466aSTSqnC/xhftCh5BL7Yi5ow4NGlYRHnwQ9+cPWgBz2oMBggzCEBjW1LOtCWBjWgBJCxZPoSeDBBugK8p5xySqmx6hLA9PTimhc1UCk4PXYZY1+lrVuBW8AWmGViSgjs4LGPfWwpkw0by7j58R5dskFAT5/3ve99CyDTVd91NO+S90NeA1G2iJY24MgJgHJcqEG81hbpp7QTECtB6Av1mfgcR8BOdEhYlNlnn32qpzzlKaXfFCtyFZ33ML71TMNn5bBd/XT/D4m6sEfjBiAyE+Uc3S4udlALVULSIqfsg/HpJrDIGmA8D9LWrczLgptgBJzVhc2/MQ3Khobpry2Cv4xDAAP29uvioPvc5z6l0yfBeO0lAXkNhOEqEwDlna5/g0bJWxVDx2yv+OmVi0ph3BxLH6nWJUDspj/RvG/jXB6BjRRb2qgX9CEPeUhh3NGnrIdUICCx73mW7hjif8xXZ4FMAvBivi4VBibGLzOJvmufU/LxHXrEIs2JtjhBbV5bt4wHyxfABRplGuUKbW7d8bQDevsxJN6nPyTAIqEFQvaqbizz0pu8SAvBfZYE5DWQMHqMFmMFEpd89eLq/PPPr7759W9UP7n8J4WtAWLGr4f2Na95Tal16qsFLNJDZQ6gAUgsBgKT3/u93yvMW/dEH8FkGBMb9Po41uZ9G1YrmFm0VBO2kKm1UJ0dC7ZQJ/sAKjIR9VSlHfoJkNZeqMtFfd2iF9329TLwcWJ8auYCkfFix8ovv/mbv7n5E7+ULgAPEgCvpm5hmD7ZKaatBIIdW/9I2TKSNeQ1Eo4AFM4/77wCJGqd2227XXWd6163uqxxKFeWuYLKCrk+UekntgNEMGH3ILAwx/k4C2D3PweJfuauAK9JHHCW0j7mqOMPen3YZ4GrMoRHTM0iJ7CQRdCZurD/A5TUjkl8hwBh+wc2dOoSci2De++9d2nb8n5X1kN/KxFj3rRpU7Eh48WM//iP/7g8Tnv+UaZQ+hDolCv8H6UKV29GV8U86GbeJQF5jURNk7N86YtfKr2yX7v44ur7DSgrUZz96bMLE7EgI/UkUmqAoAtD37ArogAHtiI1tVCjfY2TRGmiK12H2RIA097/NMdybjaAEM/pDLgCHHVfC6JKEgBYn7GSjgUsC3LKNDKG6JTwfUwa+AJbulcD9bpsg071bwOaYee51rqahdCXjAB40g/2GnahbNUWYx82Ju8RmRoyYBEPMVC2MA9KbrIy37exOdug+nTK7CQvDJmhhANgZWqXwGPTm99SfeiDHywsGUhs2xg1Q7dJmW++6y0KiChfYMK6JJ70pCeVRTpA/pKXvKSwFiUKC3hAhXQdbZTz9U3oB3h6pBOb85dF6IQAvBbjXAIOAOgqSg8W5NTP1YDpxPuClototLbZBwHs9imQ+bxFUAt5dD2vYjx0BTxd/ME+rCk88YlPLKUseholXRvBhGUcxx9/fOlrJ96PzwB/+pOZuX8Fm+yCfspsJQF5RgJcMAuXOrtiTinC47e+8c3qis1MzcLczg1bU46wWILZbb3tNgVwMR6M7jGPeUz11Kc+tQCQjgu1ZSwRs3PrQ+1HfRbjDF3E/xw8QNiCpcudAa8gBXSxtGjxU3YQzDA1JR/1UTVzYGDhSgbhtfZFLvah/v7KV76y7DeuIrM/WYYuFHrT8TIsaMV59lnUi5Vp/umf/qn0U/vfuATqUcx/0NgELoxYpqajgt4FOP3b5s7CqExFyQzQK10o+bjYSFaynp08iyxLCcgrdb5B3wMkQEANDiO2sq/X1WuApvrFlT8OismpY2Jr7rdwy1vfqhg1VhwLeoDG1VDuQ2ARy30D3DkOQOk59p7Uu49CNwDXoqT+VYwfA8PoCHAEyoDW2GwCUGzesw/lCLVQrMx9OzA0AEB3wBhLxnLb80CHLvGVTag3x2dkIJg0QKa/cQyyj9K2OXbATl70oheVUpdFShkTewKmkwqQlYXIKAR7x9Cx43JzV3QCZMdCKAC/hVQ6dfGR7I1OMeUE5dlLMuTN0jb8UYKVcAZXMGEQQBfT04YFhIAS9oaZ6d38zqVXXq7rM8FyGf62229XgIjBSxmBOBa4YcOGkpbb/zOe8YwC9AAJE5I2TvpzPOshdCEFfvnLX14CE8cPoV+gbKNDTq+DRNsesAXE9K8zRQeE0g0AxnY5/rD6pf06rqvwADL2TXwWaEjpLeS5Feo8AnIIvcm+jj322JIJ0JX2PYA86a+42Acm7N7bbhjkKj+6dcdB9uXRfujO/LBZpQzlIMBtcU/ZBzFweb4LcNoyqQ+lDJelWdQbZyyj3sOCLaBIF7EGDFA5gbH6HxhLr6XEejel2FgLNrvLTXepLmq++6UmBbzxTW5c3fd+961u27AQoqvC5al6P31XSqh9CZA5hlIGJqmdCbBgjoCpr0aPDfvlEwGLs2JtLlawACc4AV4LcZid8oM7zyndYFyeu1WplBlIx30/ADJ2NmzMXi/dLOefX1LvkpU0Evd3BvR06/82IM8beLAJfdcyAYGfHgV2gUbpK8YyalwCocVSd4ZzabSsBMACY1fjmTP2FQHQfgU1cyALURpCHOxfMPX5KA+RedJnX2VpAHkaY2HU2CsDxBLi3hHqwtgFZoHBAiCr0RwekAIXfa4WWIColJvRa09SwvA5wAOQvA7IdRBwMOwZQ/Yd4C+d5IAYDaexks4J+2z0ygQYLiB0zhiX4OQxtvg/HjFhwI0NAwDZRVyEMGisATjtR/Mkk9AtINUGEvZvTpRIfI7OHSOkz3oMaY8RO0YCZALA0jqETbBrL1QOGxc7YssA3T7UkOleeUy/sVbKrtivgKaU5nksPNucA1sFyt6Lc01ZnSx8DwtDGSc+I0XDQjA8pQhgqF7nAgQpuMUPQIz9MW7gypClb1rU1NYwDYCr1oaNMdAf/+iy6mdX/LTUkl2x5zWpo/oqAME4OIPanUcg7/j6bJ0PhoItAqo+GjzdhY45phYzTDdAF4NzpZfH2NSHAXYw2DaghAwba7wej0pEgEKpAlPG7myCFxZu3xaolFDM2zxJjJFtypSsUXgEhII+MDbWceL7AN29PWRkgJlNxW1ZzVlb6BTosnXAzQbdJ0Wvs+DJRzBsGYnPsOeU2cjCA/IoEMNSpXE2BovJMlir2EDYlWDqZ8CR4TNeC0RA2H1h3UvCz6xjxVLtNgMjWDbgdRzfl3qrz/kfSGjtYtzYNNCSBiqPAA+gzJGUKTA9AaCPQr9dkBwm495fiShRYMdKRwKY4AAgHAtbp3PZiRIQ8JhHYUMCDiBV42UTgo0Fz5BRxMP3kYlNmzaVkoXPCopAvXuPCu/RlxvSu/0rf1AOso6hw4ItCqLsU7aotiwQrsXcLqMsRZd3GGvbaDktI3fPV6DrByJf8IIXVIceemgBYiUKgKqU4LaWWtH+9m//tjrkkEOqpz/96eVXGRhnLKYMMkhAzxkYLHAlzgEgu5T68+dfUD6D6ai1AmvlCgDjdWBiwUZq2Xa+Pkpbt2sl7WN4bg610emsEMQiwAJmF+AoJ1kgpHv3tgAi8yTGKGNyYZBuG33HxqPmjtW2FzmHASKdBHgKSjI35RtZjJp+uwYcYm1DeQ4xsYCoPY4vROubRzoFxvbr/JIlz0aWpmTBSeOmMzoBNNdrHwKyhx12WFm9VheWnlmYwyD233//8hlldiv1nCEWmThD2yEGCSNlyI4tDQQWHIyTAAyP6qbRTSAddXmw+1vYN4cB1BhJ32UtGJJ6sJKOzfO2OB7gAAqAir7oUCZiztWOMWSlE/cHNheyoAiMfZRuwHGuAjR7xXD9bzzKPoJNV9rfD2FvdIcYxNjZlJLFoHsm0ys2rNNHLZ/dslXfp1+lC8xaCU05A3lQuvB+WwadS8p4mVtAHjfh3pfOcmZtZxZEXvrSl1bPetazqmc/+9nVUUcdVepgwJKhMUIlCW1proKyaSmSHkYNt12vm8TgAC52rHYJMHyfwTNwjqa+qVyBcWAuQES6iPVxFvXoeG8tAK/vYtHTBTPaAqXQQAn4cn66lcIrM8l0AIc5sdErXQMU86rmqhQk9VYi6qu059hztmnM7gBozAgBomAhDSnoyiAboQf2I5OjM6SAX7Sztq54D5EI1mu/sSEQMjadMPZpDqy38LO2DDqXlPEyt4DcnXCOCPgYMaYZznz00UcXlosBS8PcfFuKxSgxYTf0xpL/7u/+rpQl3AkMEGJV6mvAOo7VPuYwgwug9ohBAF5Aq+Rgf0CCEWuh41TKHhYBGT+wsUCF1UhJBQiLU4OYzCJK6I547iITrYXm0fwdccQRZZPdyCSwMzVRc0l/vgOMAVYwQEzS/2zD55U32sfpqzhHwQOZMMYI0Ngxm5xU2BgyITDJ/ogShuwCOHfFcQUvgBz67GaDynhKaTI7ts3GY1G1Lb4/Stfj3l9GmfuShSjPsIBc/OCjxQgOrDOCM7sqCQgDubivgXKEX4P+i7/4i9IzbGFOV0CA8LQShtUGakwYqABmgCwN5FhY8Gc/d251tWtcvTBgi3lARXsdUAYigkUs3HCKZZBuwBOY6A6A0E1cpLBx48Yyx+ZVNoGpRducuaM/4KM1y//m1Nxrj8OS5wEEEAukwvl6LqjI1oxlWntgQzKxKN1g28oYGHNX6D2A0vPY2scU7JwLkAf4SkFKgeYiynLtTTC0xf8+w2/jGF2Zh/lZK+llH/KwiQrxvknlYIAWi9DSw0GlthYaGIiIrTsBA5XqAV0LdC6y8L+r6Ri6tA4DiGOOOvYw6X7HOQLjd73zXWXBiSMB/J0b8MXSnWMs0EipOZ/FE3VsrUVajJwjcGmzk0WTUXMNjM2zObLwSS8AFkDTF2bGsQU0wY6uAI0shK7Nr/o7/Ql4WJz3ZCXAug96HTZ+4CajU58FhtgxWwGG0wr7tmHc9ud49gdUBbGu8Cv+w36J8oTaNaZNgDBgdY42AM/X7NdzpIJfIh6DNms55iNYuP21AX+YPSyDrDsgDzLI+D/ei0fOacK1L5lYjMkFFFiTbgkOJxJzTIwJy9SqgwW7aENrGvDjlBybEdhv9/izEOfMoN//gfdXF19ySXWb3W5T3a1JNx1b/zFQsWINOHzWCriaNsN2ns7Zoh7gGCSD9DaPMmoMLkjA6lwU88AHPrCUcHQIAAE2ILUGNJhadAzon/WaNkJAYmHP/wBAyQIoyUowZq+vtwwbfwnmDSAbJ/B83OMeV8oEwGtaYefsBTHQaikQ2afSwyBA5mNIA3/Coi0CCm5sUTnQRp/KHjJTABsgjmi4wlSXks4QtwaIzWs2i5T2bWxKHvzaGoB98t/wzWWUdQfkUQ7pPQwo0hzpm6uMTjjhhNJTGSBsIr2PKXFcv7xsQQ7gMTzsSnRnUFsKxDiAejAHYMBqwTZlDIBM9DQDB/8LKpzAAow6oVq2VHzY+W6pcayHRLAxX4Ir0JB2y3ZkGgAFEABfKbjPcWSpM8AV9NqA7PPmQK+yBSivATePfRTjF7DVu9nHox/96BK4V7OWwD/s0wIhCYbML7q2RJfWOBwfQaAngUBWwvf8wg1gpUsgLyuJcoTyig3ACpi2eA58gT1/NX8udNHjD8QFHxkuYBcAnFcfMpgtLb2+dBoYAykgjAm7zBgIMxYTZ6Jd8QW83HjHIxCWXklhMSzOOSl4zZJ12heW86EPnlZ9uwGDnW6wU3XtxrC/8uWvVJ8555zqeg2Dd77AxpiwBk4jnfa6mt8ig+4oiXEPmg+sVtrOoS12KWsADeDsOUanfqzPFiALcMG2pMiCpM+wG7pfCeNcazFmoOjcneekNw8aJcaulICp0qtyGIYs0HX1LMjxO6VAeo3uHwHN63SI3QJWPui7ggU9Ix0ux3bVqtKgu+wJjjIdWYzPIiVA27wBc//bH3A3H9rq4nLtZZNeAbLJFzXVg6XvIqe6atzER4TnkEoRfiFBndUNVlzTb8JFVpcfS3lE13ERtmuI7eerFeDKeD/cAC3WxvmduzEwvNvd/vaFzTPMqHljBQKKWvcodrxoMgh4ybDXOC17oDN6pjdzTpf2ZVOfb9dIvY9Jq21aIIxF1nh/vaWrAwAnIxB81MHb7w3T1ygByEAVswW47ZJF7Mt+ASwWLbNTivA/HQNfAU/GwtcArUfn6HvAFYHSp+zqVYweqXAMWzzH+D0XaJTmzAPWDPTNkUARNzpKhryFxASaZMBkEUskxnp1SUhdGI3+Uk3/0iZAJrrqf1RHBFo2bFJNUTQFYBxumqg6rVGPlFgYbnaJgbnt5keaoKKPFAvY8do7VnVzvG9+8xvV9lfXYP/gxkDvWJ111iev+nUMxopVMNTVOuA8yTRjkxZjxuwEwMR9HQRp72FbbAugqS0L0MHezIu0W8BnUwACoPSBiXV14Jxkd4MC80psASDTWwAywKQzgOh/ehOo2KJs1PNYII2uCgBM14gQMgE86TgYNDtlv+7xQq9x/kBcULGu4/MyF/tSCgH6vmu8SnUW3Z3XMhGStswEkNWHsEA1PJv0IzZA4zFWZIGw1XEALE2PaKyvVC2Vw2A6JsuEWlm3qKNdzaP0x4RhN5gRZxsWSdcFyJrDSTcvuvCiwu6NpyxUbHe16vKGbVx+xeXV7ffYo3r0ox9Txnfqqe8oYzdezMAd3wSYkEUH42mFbdCrDfBiau4LLK1nBxwc42KTABjrAggcnGB5bM/7bujEvvro/M5nlgwRIMsOADK9AGQga+x80tWh1jG8Tz/0hPFiqnSsX599YrbhfwG6fB55EhD5Z9Tn2zo1FkHQ8Ty6kIT/W8zGwpEtv5bjWI7ZhyC5HrJqQKZMDDcAVaFfOonherSy7Xl7U8i3eQ6clSpiYcDCnMgr9ZFWicjKE9iwkoT6ICOYRLaokzWHapLlckzG/6kmnX7Xu99VXfzVi4th/+xnV1Q/uuyH1fYNQNzlznep9rz//aqvfuXL1dve/rayWInp6wSJlqyQ9hiWHZwBCefftGlTsTWOi60JYmqXdIPZqS+bAyRBJwC7AsoCuEdgAJyABkBmU32sJc9SomSh84Fgo2yO7wFhrFhLHJ3RBUDEnLFaIKlXP/wPqAJY+kY2+DB/FuSUioArRjwIVLFppSbgbxHPfMpUrAFh3fx/WcGYrBqQMWCLUlFmwAiVGWzxnPHrhpAyMQp1VBMDWEVbACyq2kw+MHZrQAszcVvKNkiRvoKTcxKk6IJOfvD9HxTDvqJhc2WhpjHmXRvwULtjxB/92JVOoFxhMVIXgc8BHxKGTzwuKygbN2DFgF0Gb8EUQEiRXUADJOidTr0nc6JHtuY7giJGh9kBJ59TF42WOba4yHqVTdCL9Ri6UMflU0pqwBFxEqyUy4AqXSBJ9IpJD7tCkM75NzBX9qBLAMtnMeEQ86fOjKTp0ggwdh7A3jxqRVxG227LTADZRDNukU0ExTrUnUQ7z4GMidJ+ZnOhhhqSiKhmJOX0HBtmEL7bBWDSBqM+TlycEyONO2FdfvllDSD//Mr7ITcZ6HbbbV/9onGIL33xwuqjH/9oAxZfLoCNUTB+LAPjUOYBQPTAsO27PeY+jn8txXiVK2QTcStNNiWNBswCFwe3GCzoA1/BnE6l5NFTi0kDFlmdEpryEKa46ItIAFlgAsieyxYAKTLFf/mlxXGtmPRGvzINgQoxUqpoAyzhj2wd0QLIyhwCHoYMXAXF+Bxwl73EFZYIGTDm+xax+XxKI42yViUNmNSXXnpp3YBI3Uxged4o+1e2JjLWDdDUDTMpW8Nc6gZs6iZSb97LlWJfq5Hu/tZL6ODwww+vGxZcb7ft1vU2W1f11bbZumw7bH+1+rrX3KHe8VrXrLffbqu6AYG6AYi6Md66Ad+6CWrl/8ZB6n322adu0vO6cZiit2UWttEE//oNb3hDfe9737tuUum6yaTq008/vW6AtthUw77qhmnVDXjXDbjUb3/72+u3vvWt9YYNG+oGKOqGGNQHH3xwfdppp9WHHHJI3TC5eq+99qpPOumkuiEUm4+0WBI+1YBlfcopp9RN8Cn21WQGdUOW6iYg1Q37rV/1qlfV3/3ud4sPveMd76gf+tCHlvfvdre71cccc0zdAG/ZT1fY+vHHH183GV6x3z333LN8/9vf/vbmT9R1A8b1Rz7ykfrhD394OXYTJOsmG6xf85rX1JdccsnmT6WQVVMCzCVWT614ey71UZ+LTZS1YSY2kVadqstIVsr6mnGUx5V+f5YiHcRyf/C971/JiptT28pNs5rnWzXPsWGs4vKfXlHYr15TW1tXRJ3Tz+34NRJ3nsNA7HdZJfSGBcvKsGW6jrn3XClCVkHoEnPG+vyggL5YjM39TehTOQ2jU4u2QKjdMvZF2s/nWdo+4blx8T+1YzpUjjjggAPK7WVlaUQWIqOgb/4s6x1X1w19yULMQfyPCcto/OADNu4YWLGbeXmUyaT8UmaSo5loE9atd7a3tZT2MddbgEJ0kwQ4bL31L8+PoW699ZXBaMcdr18ukT7yyCOrhi2UdO6f//mfi/Fa1QYgAEgt2h3OlEEWBSimFYCrRmlNQs2d49OPAE+XdC0tjqAFkL0v2Lns15WbBx54YEnHpc5qpvF5C9IbN24sjyF9sKVZCn3RH5BlQ+rr9KJ+q01N+5sxe91VjXTjf2sdtjYgt21QoDQ3ERwRLUTDnPADpMKN7unb+pAfgfBLO9ZLgH2XlC27pDZmKAzSwgWG4aqoEEa37bYu277SqPUjAws1NJ0VeqotYqqjW9xwsYvmeqwFy8MygLGFQl0DywjKHJ8e1DWBivUJi0+cOoDE++qjJADEe8DZugU9C3RYIXAKlo0tBlPGnBdNv8A12kyNm67YpHqvnuD2YprARocAXDCj5259PT5L7EtQo0efMU/0So8WC2Uk1kSAvjssqhezeyA/DRiPmxPvswvM3hqCOTWGeZME5BkIY4iNUTBA7IDBMd4o0VQNU/5ZY7Bet4gBfHWZWFhS5onNCjXQcAm1FWvgjRUyNgsziybjnI1EyUKZAWjoSrHQFD3bXhMMwwmDsYXQobKaFjkLydghXZsLAGS+LHj5iXzZiDYwl+xr0bJgHfM7jwKElWQEnTaTjVJZtxwR4/QesG73xbeFzulGCclz5Tbsmh7d9taFXo4Ti4UW7QG8uZhW2kHAGGSOWmxdx+DHiM0X8Dd/r3/960tfNZ+ZN0lAnoEwFn9bb7X1VSmfixNIA7+btyt/Aw44Y3V3vcvdq/vdd89SQ+s6hP1JxbVzAR41PPtVBgHI9rNI0na2YcIJAWcwYI6tYyLqnsGQlYzsDzD7DpCmMymzLMN9GHReWO8ADMCHPn1Ot8Bb3/rWUjJ62cteVn5x3P21tWoBnknOs49CZ8CJXQJI4xCIgjC0hT7iNYANjEPHXcGEdWjICOnP93RnxC+7IB1KIhs2bChtcwLgtGJenbtjmENBBdi6UlP7nFLfK17xivJrQH4L03zZnEMCcsqvAANQYODYg9c5PqDVZiWFixasYQIwtCMBH+DC2C32zWMqNo3QE/0BQSUaY9ZPLPMAAgIYkPGe14EsAPA8gAGT9pp+Y+zpJS95SfWP//iP1Ytf/OLCgAGJfQQ40a9j0jE2GRc7qd9jeljgPApbYY9YMr0apy1sMmw0xPP4Xy1Y8IqF5pB4335lber6shf7QjjYtXs3Wx9xoyFZ4DSsOJi3rMWtFbDg4447rgAu4LXmYr0FM9ZaCnwFTZ9lE8TxnP+8ybrcy2IhpSEVP7n8JwUERPDzLzi/+nnjAJgzqZvnv6h/UV13xx2ru9/zHtUjmrR5p4Z9AIOuMPgACrUwRg9svI4xu+yV4S+CGBMHBIbBgNUk6THq5soGmBFgVB+kF+ACPDmh93ShqJNySIBjPzIKzqo32T4AN1D3umNggPTo887DfuOR/gGM8pHeeHVPtdSYm3kRrNhNrtyegO7oxZjpTzlCDdl1AmFP5oG+6FVmZvFNrb6bxdmPwOXucfaPedOPtRC3v3Vxl/WPLpgPkrYNCBIxb4DYhg0DXsAfF5eZ+zbxcf4AWG86Vm69APEZRXj6KFs1ypjPwlgPxYIT43HPWPUtxrXt1ld2n2zDwRsn2PkmNy73t33Oc55T2If3Rgmj37hxY/klFIbnElO/AbiS9K+PgvECSY4GPDgYRwOeUtRYxDT2YGHh5JwYMAAXgMEpPfo83XNQAQwwRKeAzwJUF0bYDzB3HADt8/Zvv+bFc61Z0RUwj8J+pPY2jBNzZDsyCRdtWadgj8pj9IZJP/e5zy2XpwNiP/rr8vQ226QrwZJNqheze4HLgp3yBH1PCoTmQzajJGHOzT3gRWrYhTkXMM2tObRf7Nk5+C4xn+bSIqVatTnzfB4ZcgLyKiXUx3mxOamV+wVgtuTq2//yp+mBx41uvHMxGn2YkxgtY1cT4yCchQMB5GF1vb6JcQ9jlOrsygJaozz6P4CQI/ou5uV/uuOYAbzARCknnI5zcmZO7FH90mISMLGAZ4GqLY7js2qQLsUWGHwmAMJxibsL+u1F+2rvY9S4+iRKNtJ7tXEgJhBhxnRkzBiylkCBHuDRO7KgzKNF8ElPelLRYQQ65SNsm84wY7oCxjqEdAb5zrjyhPmMUpQgAYBlOFh5MGXn4Xycq3UW863ur9Tkbn1RQjL/Mh2L3zqWdCi17WLeJEsWMxCGysiwET9fg+15jQPf6pa3LEblf6zEzYWkUu6KJaqPc2rGiW3rnXUMhuemS3OXig0YJxYk2GjHkqYaH51hcICDcysXqEkCyKgP65YQ1LAxdwEElrontLZFLdki0r777lseAQanlZHE5lhKIDafp2cbQAYogMFzx/TcQixQAExkHsCYSO/pGeixQXqkV7oyFt0KGCd7Mj6fMR/0iOmyNWwTgLNv9Xcbm0QQgKVuIS2ayjrDwFgwdRylBrYsCGPtWDYiY/6dj7lnA0oP5hR7t2/zaN6Mh3+ZP/PqmOrV7hRnXQYYC9jzKgnIqxSOaWMgjEXtS+qFgQHeBzzwAdXNGoO+7MeXVd+69FvFMEV+0V4Ux/wwFY5vw2JswMF7XtPTiT14DdvTPjQvDCCAKx45fDzniK7eojd64dxusep3EKM321iN2XixIiDpPijSUnfGA86+p95pH64KAyZKDPaBKcfxiOPTo0WguKkOsPFdoC1N13JoPunee+bD8c2ZY82T0EXccAkYIwHYLBDTQYGlAutoXTNWbFX5SCCkD7qI4KmWa1/0CLCxUlkbnQHMttAppmtfjqHPWzucurNAaG0kshF6NZ8CrPqz8zP3CAiAdt8N5UDzy18AsRIJO2AzbIQNRAnQ+ZH23M+DJCDPUBgKBoAJiPQARdRmFNJjxs9Aw0gZGWDgMGqZ6nIAQirof4YPFLRtqbH5nlqfNHqeUrK2U7Sfc0bMCEvjlPqKsSHOyBEBAkDlkPRKL8DUFV9uKtS+pFfNGNMFGAKiG+L4HGYbEmUNOo8+WUAUbAsLEwzc7tX3lJ3MpQsr7N+cCrJY4Lw4Op3QG1sCVsZg0Yv+gCCWyzYBNx171GFi3HTLpi2IAlFkw1zRuwwPeCpnmKs2GANiwM5u2bZOFZvgqzTlXJAN88uW+UnMadxgTCCwSKh1zcKe+bLY6Hx8Nu4Q57MCZTdjND/zMkdtSUCekTB2IKm2K91Wm2MwUi8MVwcAB+fYgIgTMHRGjikGEEdnAUOWmgER3+MoGAzjZ8TzmJa12TGhJ46MmXJOwUuaCgzpM5wKONCJVJoOfMYtWwF17E+woi+fAUIYm24UTk0CjO1n48aNZTEKuPi+khIgkPYCGCm9QKC+qYYPtACMY5tfqb25bo+lr2KMgrksRDADplilxU56BtB0zSbZGFsFgvRJX15ju4KcsWOigNM+AKkAxRbpAhAjGtH5ErVmzJh926/sULkEoGPCWK6Sk2Aci6/sJPYTF37wB7bimMpVziHmoWtX8ywJyDMU6SBHllIDDFGeAFopm+jOcDgAw+Mc7iEANNS+PGdcnIPzcBZggaFhkmSeAbnrNJgmp5KqAkS3baSDttAHYJRGA1P74MDund2uVwJNNc64NaeUFiDTse943zwAY3V+YGMesCuMnJPTK51jhsDed+gdOJg7gRGoOGfniZX1HQjYkQU0gOz8lSmUGZR6AKzxC4bGS88AXOAxNu+zU2M1ZszUpecWzti41wU6upFpYMRKG66Y27RpU1l8CyIhA9FeZ04EPouI9oewOA57Dtt3rgIrVgyQLfb6rlKLy6+xYvMUuu/7HEwjCcgzFhEb47NJw7EGpQpGxuC9j4G5+9gTn/jEYpgMXPrHWDkAQAEW0mfgYx/SPOwa0ACveV64aItxAAMONmihkjNjZxiXVBoIAxSlG7okwczi12o4MAYIYAEBtmchySW16pDYLv0KguqfwFhQaAO8uQNeyhnmD1DZD+CR3QAyYO+c7auvYhzOm/2xIcFf5gaQ6c/7MhXlC+PwGWM2NvpTQooLPGQmgBiAAk/7ZauCpVZPly0LdgKfOfAZoC14AmH9yTIQ5SREA4ER/ALUBQ6lDZ0vFvuwdbahRmyBlo8IHs55kUC4LXml3iqF0YV0jcR7wELUx7YAqs9g0YxMmoYVSq8BDONjlFJ0DiEtU9dkvPMMwG0dTSt0BkADRDlwl5lyaAAAKOm6Ld4D1AADGHN8+wHAf/M3f1Na2mQdg/QLdNUqH/e4x1210AeElJle+cpXFvAQCFYzvrUWNgV8bcS50mFbf3SirKGmbs3CYuhhhx1WPf3pTy9ALNtztZ19AEOfV6t/0YteVD3taU+rXvjCF5a2Onpmv+aMPWOzRx99dLnDm9Y6jNiVp+3uIvOjLKTj4qlPfWrZp1KHfShpaPE86KCDSqnCfJi7rp8tkiRDXqWMMg7vAQjGqzbseTAPaTJnifoog7aKLeX2PaxZioa9YHc+AwyCIQc7nAdZjQNxfqvxaoiYMv1heJhSgCigVD9WF8aqODwHVqfEaLVYAU/7EtzULbE+QTFAJgRgtc9X3dIxHUv5AiMkHoGJ97DLNrvu7mM9xXkEC1a7VafHUGViwU6VYZR7jAkJwIp1qSAOMj36pUeLahiwjU7ZNSCPoCQroXe2C8jbi25svQ2mSinmymKhbhf2z86dKxYtcxQMERI6jjnqi17XSvLCkDUWdTX3UWB0WB4DU6oQ/RkZJ1fXZOCeS5OlhpzCAgqm4P3jjz++sECvH3roocXA510mAS7lAos6dAB0ZRSuJMPaAgQFKrVL9zlQe1TvxHyl10oYmDFAwdoAjoBoMSpAaZBEii+ziaAAkCxwEfMCOPRCC5D2ZSx9AuMQgIr5WotgcxbzBBjn6T1EgZ0aKwYrwPgc3asBY7D0ISiqQ9sPIuEzwFafMvBGFmR9yiJKUGy0SxzYsHmMe4UIBPYniJoT2YoynZqxINIOdOOkj7qfVhKQZyCDDCFek0a7qY3fEcNGgIQaKOZAsBKLF4BEKs7JpXqMk5FyFLU5n9EqpK7sKj/MZRnEYqjxyx4ENAzvGc94RnH+qDkDR8Cr9gh8gYF6PP35PqAR3NQgMT8g0nZ0bA1LxPTsC8BbkNIZAHiiVAFMAJu6NNAyVzIdczWo/r0eMg0o+axNnT42YzRm+tAFJLMDyEDba3Rr/GrDgFiApFtEQlCily4I0x07B/A6J+gWKNN7lFSUkFyEIoOJ7olllATkGUvbITzHAI466qhSF2PwjBYgMDyCHTBOtTcrzhiwehuWwck5hV8RATRSPosjhxxyyNIAsvG7y9cpp5xSQFQ67N4SQDCcVqDj6Fg04NZBASDoiMNbVAKcnB5gCGyAxyOwBRSOg/0CCa+ZN+1zmKRFLHOBTUufgT0gsgETwD+vQgcCFn0ATSUzmQHwRQYsZrJjQEyfFqTpEZMGnJgsXcdchP2bE5kFRm1/Fv5CpwCfzpATjFo3kpY3+2zvYxklAXnG0jZIRo4NKDdgcMDXIh/HtmEO/gc0QFrvssUTqbVFJAbqewAZoKtnqn0C5HYj/iKL2rlShLIFZuZSWhlEu/aLtVrZ127lpvLABPCqIWNdLvQAJOYGy46uDWABkJQzADrgAMDABSgDYd/DxgVIx3MOsps+seKQsL14bEv7NWMzbrrAftVujT8uIon+bCAMdOkAWRCMACcb1aFCH93j2C+7pls1YvsGxB5lIOxc2Q6rFijZOradcqUkIK+BSHsZNVZgoYnzYxuMFdvi1AQweI2xq20CYaANGCxaWZVmzNih9FntD3t+1rOeVUC86wyLKHTnHsaAFhvT/kQHWJmgBoyBiZKQjb7oBYv1G3p0CFiAtCsjlZDo0g2gZCUEW/OZqIf6HzADIOCBxUVGMy/SBWUEQfCXpbFNerDJDNTf6c2Ygayxsj9bm8VGJtDdt/1GWYft2i8w1rVhv95DLgC7ABkdE30LaH2QBOQZC4DFNICD9NmiCGGUjB2oYFfSNoskHMWKtB5NC1UA2XfVjBkxA7egJK3ETpQ0tBotizHTEUBWsgEKBx98cNGXDAEAaLWiZ4Ct9EAAhIVRv6bsO8BYcIyfZCIABaBj0tieDoS4xwPG5n2bMtG8SRcwEQTZmgCEpdKprhOBjF35LLC1MEcXAJMudE0gEMOE7ZoD9WX7VnqzOG3x036VOOhXaUe/t/p/nxc/+yAJyDMUKaDVY7VMKTZgYHSMVm2S0WPHgMBFIl4DLLouXAGFQQBkrNBP1WN0gJtwDGxFO5C0HZtZBtHzq5dVq5XxP/vZzy6LaXTr3gjKQZgYPYWjAyDsVroNNICDeqZgSejfCr602Yo+Ni1QApBBtXn7xCzNo6A66DN9FCSATQrogFJAYl9q7N6jGwEHEOsU8VuDAhjQZJeDbIze6YGOlSXYu3KaOQDKdGy/9CkoAnadE0o+wbDb0oafBOgE5JlJ9GkqL1gYwcqkfGqdGDP2xlAZucdwCCmye85yBo7hdfvSl+nn09X4OAFAljoCblf5zSNzW4lgthgyQFZjF7yAqJYpgQ9DBjqEQ0cQDHCmT69Jw5UfAA+dm4dYYAUW6sbDdKrly/0YMEvZjYAoe5mmJWtLiuARl5srz2CuNjZojABVUFELV9JRy5UhAFFj8pk2OEZAEvTsk33bvyDHzj3Hkn0XC8aw2T49Y8gWVgXBUeIYCcgJyDMRNTkpoJt6W4RivNqrAAfQxUwslnjOOIEEpqJuqQXOpbua9f1PAAxH0t6lFoeNeM8ildKGToNlAWQMOQBZKcGCEuAAki5KAAoBIPQegKzebsEICwbGGDPQwQDNgc/43iggJoKjerOyCDaodg3AZDr2peMASPdhkVXGRSdA06NNQFeuUGvH7hEEmYZsjH4EOfpx/t5vC7tTD2a79gV8tREqo9kfAbS+z37p2jqIfSIQAHocEKf8qiQgr1Kkba42CjDGvICxq8E4LSbnunxpI0aGNQBjQMuRXZ6qbokdBzAAFo6gVuz7HA3AWBAB3j4/CkRiSuedcRiHq8FcpuwmM8YMODwKWgCDBJDQk/cArnq8uiXAjLYsADFNucExLHhh4vrEzZvavX3RLZYMiDBNIATg2vtf6Tz43qTfEYDUhQElGxM09A5rYXO+bInOMFbdIoKITEtQG1WaYNfaAHUJKaGxxwD2CEbqzbILeqDn2Oeg0kTKZJKAvAphnNJYP5HDYTkR9hSX5AJd9TXpIueWvjFajuI1n7NIZdGDEYcTYtLSQ1f4qf1JCRm69FLbG+YNeKZx3FnKNMed9hyNnV4BCnaqNimgAQfvAV8g5Lk6sDox3WDKrnSkZ4ChE0PPNrDoMr9xYh8ACBMUCHTK6JIxFmBMpP0AHvMWTDFDnTI6ZoKFDwqa0+pj2OcFH5mZcpjFOYEbGKvjqhHTkUCEvcbtLhEFNuh1IDzqPNj1pk2bShnOXBiLLI1uo52QjXsNG5a9hG5CJh1r93PT6miRJAF5QukaCUDgsG5aI52VGmK/2BInBSacmiNjKRyAAzNa38V44w5W6phd58X+sDMXRajZOT42pobsGv9BrGaW4ngWaJyHzRiUWqImG+JzXd0Q/xuTR2mrsQs6ti5A2h+AUYeMy3gBQrA+QBu3yyS+j5lJvdWE6S/A0+cBpJY3i3/AZxLnNgbjFAjtw318AZw5xECBNDFvgMg5S+GxRs8BkoyHDagxC8zOcaUpe1enbMY5OD/z4pyUtWRl9KQ+LJCxCyApSLEXdfPoIwbOIYPmrC26fI455phyDPtEJJTXZB4A3v7MaVfG7TdltCQgr1A4IQBwFR6jBVTYA4cFXoySk+qUACZAhFPFggog1jEglRzWwoaZuJMWhsgBOZaShUXA1ba9mfYAWmNxbs7Z6557D+AILFgX4MFCbcYQ3wnz8ej7NiDEiY0ZiBovMDBWjJaO4rMEGNOT1BgYAmQ1S90R3rPvAGPPpcrAwV3JgI60W9CyCKrmjKG6c5gFJqA4TozFuARVjBAjxszNaZQgHNdxAK1FK2PU5aFeS0+hO2Ju99tvv3JusS4QEnoaJbEfYzc/9Axs6cjxzIdjysCcs/NkD4iAVjWBCmDKvAQJbH2QDDsXr7sM/dhjjy19xMYA2N21DeHokodBwn4EDrqN8YwT50KvxsJ+xulpESUBeYXCCXRCAExOwZAAELCR0gEDzuQqO47j8wzMZziLbgFMalRNEyAdeeSRhYFLTbEvJQsXhgCHroxysPY0e45tYZXAD+vyP+dxzoDAsTm+sSmZRBpsHN73SIBFW2KMoY9wsgALoCxt5nQB2OqVuiWw4rhKjGBg9OkzAMnme+4iZsFT3dZnsGqLfi972csKkCsdqM0DzzagDtINwS4d2+KdEpP/fV6KD9zp2rkKJhi5WrE67ete97pS43b+sW86Al5u7emz0vn2cUedR3uOzIcyjcVLcyEgWlxT06UH+wjwEqCcEyDWwuf4g9jrpOI8gDFQBsiIBZ0eccQRxXYHAbLvxPkDY4HVXCASdEJ/Hp23x9BDbEEIzLdA4jjmzmvLJAnIKxRGxSnVeIElNsCYgID+S2kzh9JPLK0EaAwVY7PYBDCkgQx1mABHoK9G7RJqDByIu0fsIEAeJFh2tCU5vvN2rl7D7DmOz2CInIKT+4znHiP9BSyOydEDaAnz8R3/c1Sb5163ARYlB8cD5L4f343PAXdjtXmNjgQfgAvEsSXftx9sz4IpgHBujuf81Tst/gF0pQoLokBq3AKTC3dciONufIKCcdOzhS+6tlhl7HRBh4KrQOZ4wNI5AES68V11bd9zuTYgi7FOIsYvABqnurDFYucEkI2TnhyDCA42wBVALNgpicWi40rFnBx33HEFkI3XGAUntixLa+/bZ9m28xaYzLfnatoyHhmWzzsnn6VHG/F67MtrngNhGYgatWO5GEoAbx9zkSUBeRWCqWAugIajAA6AAcCAlqvC3G5amsmpoq63YcOGcrWZz48TDBboc05O6bfMlC3a3zWFANW5cAjnwoA5A6eQxnNygBxMPVJKDuBc7ds+g8nYAKOVecAmwDh/AIeVBfASz7viPedlAVMJIO536zWb9yMYOSdArayhPhv9whbkAnTjfIG/wOd1+7AJiLpcsDqgoGSAoQaDHiTGB2zoVr1YYHJeUnwMXGshdgyMHV8WgZ3KeDx3XOenpurCBxmAcfgsXTk/5zpK2I99ATRjE1gwdGCGWRqLzxB6dy6RabiFKCAGVo7lPfMyK9FPD5DZj3EASDePZwvGbj6cI/s0r0o8atmCipKWeWfzvuuco3RER22xLxL7owtjMSYBxkK2bJMdsr9FlwTkGUmATAhQ5Fju3cuoOSq2hT1hcBxpEmGoUmgMkWBFmLXXOWsYMqfAot0fI4RDYIyYHQkQd67Ox34ECMBl8avNXgkQ4EgAEAPk8BzM1h3vIAF6zl05IX5yP8odYXb2C8BkFliec/E/cPae8xx3LMEG4L/61a8utdXIQADmIJByfMHSwpU6sIU7n3MOatMynO536RJrVWOmJ8zUXFhQBDhec56h21ECdMyJDMr+BANA5rwAnLmmO3oWMDF2C2nODzDRjbkzL7ME4bbI6tz21AUxgobA8w//8A8lCLA55RNrKOYUI1beoiNAat6MxbljuYKreY0ujGD5MafG6hiIi4Vsc4hg+LyxCwLuH47EGPM4/c6zJCDPUAI4GBywBBIuarAYwzDdy9gVeVhYV2IaBgGP/dkYOePl0MABCGPBQBeo2Bg2J7U/38E2OK+mfSCDwXuPUQNhbAuwSLUB9jiQJTHOUeI81R+xSk4GfJyrMURpwrmpFyo/RIrqnKZ1OKCP0elIoQstb9oJATtQa4uA4Fz8ZJCaMTDHvNT9lUKAMX2Q9jidN73Tr0AV2cK4c7UPuvD9YMFx4YbWRzpyDj4XNVOAZz7MDQD2KHUHyjKItQLhtoRON27cWJivLEDnivNx7jI2rNi5G1/YGdIRpRPA7DWAKnBFRtQVdgqA6UOJRhkpymmyBN9zfOsnMkSloEUF5QTkNRBgjIFJ+bBDBsvZn/CEJxTHn9ShwpkxJvVKzgxQgALDxWIAEAcGPNgJhw3gZciAg4Pok+XUXg+Q8Z1JQXhScc72B7z8qKhaK4fmcN5zTM4UrNhFLhiUmnEXPCcV4OHeIVFD9ht4Fj6Be3ufdOdc3vjGN5YyBb3SGWaOVQsMzqstMZ5pJeYO21NzlrnQAQDDLP0f2QJ9mCfzZv6wbZmJqxJ1NQA14NYuU621sCkBS+ubAIKVKyXJ7NieoOb81c8RDLalxOMz7M0YjIsNDgPirtCXcod5sciqfCProzPzCOzNq0cBaxFBOQF5xgKMMQjpnrqm/7FA0R0oM+xREuwam1SHY/QWD6XW+mL9z3CBBKYAYDkqdsVxlSCAPsfhCAwZW8HmVuvQk4KTz6nrPv/5zy9ODSS95lwAINCzcKNtjW5Wy3g4cJQs6E2N/pnPfGbRQew3ApsyhQUrQEkfUnFZizolFrcaibkzXum7ej5b0IkBWDBkABwlJLp0DvRh3tSFgY20POYMsJnHru4nnYuVSOxbdqOV0G0B6NH8BZtld5ivi5voDnvHktlh6HySc2zbO70ZMx8xX0iNu/wBZvNFLy72kQEB/S0ZoLaUJCDPSKiRw1kocrGIlJhDYg8YGzDGgNqMrS0YCXaA/UrdMD5szj4YLHD2GQaOYTNINxlS0wu2wHkxLds4mcRZBkn7e8P2AXSwKAua0lpsmfM4LyzKhS2YsTrsatNv56BUg4m78xvH9Xt6Shbqj3F+FjyxLmAcC6TYnEApOIwLlMMEcJh382Sc0mxBSDnJnNnMKRADNgKqYwNZ80UHdKE+ak7NZV8kWvvYYgQRAGocshrrIYKIwBf14WlE6cp+6UpAlfHp5tASym+8L5gJtOYOILN3HTQCufNYOGkMOmUG0hhPfeaZZ9YHHHBA3aTKdQO89W677Va/+MUvri+66KK6cdzNn/xVaQy8fLdhUPULXvCCugHuujHKumFrdWPkdeO4dQNadZO+1k9+8pPrN73pTXXDluuzzjqrbpz9V/ZrX6sV+1jNfny3CSB142B1wz7rhjEJ+HXDgusHPehB9cknn1xfeumlMzlX0oB/fe6559aHHnpovcsuu5TjPPe5z60bENz8ibpuwLI+44wz6sc+9rF1k2LXDRDWDburG3CuL7nkks2fGi3DzvdrX/ta3QBWfeCBB9Z77rln3TDcugk8Ze522GGHumGN5dEcNmBb9OGxSfHL+TSMvW6yic172/Iyah4aQlAfdthh9e677143AbXYdBPg6oc97GF1w5rrJsht/uT0wm7NG/+4z33uU3R2hzvcoW4yy7phylfZNb9oGHHRobnbe++96wacy5wuoiRDnoFghBbZMAlX1UnXsR1MTVreXdDweZ9x/wv1T+xNjRi7jlTad7AANUXM0qOaov1iWLZgJaZwJWw3BLuL1iUdG/aN9Ti+xUD1zGHMvi3OI7IEi5lxVZn0Vp0Wo3J/3EkY/KSCRSkLKA/JSmQTOixclq4UQteYnve0uGGr6tV+BkprmwW8ScY2THTQxG8eRk1YpkMipfYa3Ri3/mbMHAOkX+UK9eG2fXRltfO7UlHntrB30kknFfs2HjZocU+pQgbCVqYV9s72ZRJaMv1PL9ZYLO4qfRivjX5d8KPmzw6VLLR9qlmvhJX3XRKQZyBAR1uXK+rUKRmLcgIwtugRzqZGBqyUJACgGp001xRwZumtFNh3GDzDk9JKzaT26nOrTfEHiZVsTucCFM85AuMHXHG7S4EAOEcHwiAxBmOLxTx1VE7D2XSYaF3ixCGzABqArFPB+QNlYGjhZ5999inpP507F6UKi2vO37lwbOML0Fyp6LHW3WGhzngaxnnVmBxfmcpGn4KclBwY04vgIUBEyxjgjuDgOWDSeeLzyhtkFjqbVJAEdk1/gp5zEMQEM3bBHqcRurFPC90CGF+wD+UPdXxBOxadjdN8ITiCqU4lejjooIPKzbUiGGwpXWwp2eZ5Cn0pKxYg6j4KDIfRAmMOr58Vy8UYtfFYoFAPw6It0Kk1ckq1y6jBARMAwxG1+agtAkOODZRHsajViGNaVMGOsTXn43i6OqK9jnMAawFE0PFccLBxDGBsTJgMVmVlnAMah/q5AAMM2w40zpkmAR86U2vHtByfuEpOrZGoSwIAYzAmDN0NmoYxLMfE2IA8EDAuQDTos0RGI8sRSGUxAmjcfMeCoe4NF6pgw0CErulZjT3um2HRSnB2rs5Tj6/xOAeLoM41wG9LApA5VLtlu+zcsfUT647p1o3HzRU/4B8WVWUqwFj/Nj9BXgTtYMZEQJKxCQj0IFDFugmfYHdbUhdbShKQB8ikLATDsXqOQXjUZqVPEjMW6ZUlGLMb1AMqxg3MAAPD9llAJU3Diu0Po2OMHFC3BGa1WhY3TgA9x4+LDwCJdivn4JwsvAAd7JcjGSvgoCegy1k5mxTUZcg+SzBDYCSwAJVpxzHJHDg3egVodOecta9hcC5Y4PwCIWAVHDAxLJVDd+cZqAJj+5LteASe5nLYPAhGShHm01VlWB79ARj/6yEGJhYeAbBU3flKxenQ684bUwbuAiPG7FGwsV9gbn62tCASdMCGBRJjFbB1Vwg+7JiM8hdjMB6B3cId4mJsshNsmw8YHx0T+yLmTneH49MN8NaJ4qKq1Xbl9FkSkAfIOCBgNDoesBw9rdJVBssRMTCMFmt2lZP3OCHjZsAc1Yo6kNIupD9Y50Gwp7hSy3OgGIY/6JxGOcI0EqCC1QEQG6fjNLaos2LM6ooCDQDmWMYFpNWLjRNoAzvZAWYMkIFKOO8spD1uTJ2usSnOj7kJclbkAaAA4RyNI4KD90hXd0AbcOgfN3fGAiQFLONpl1tCsGd1YPqKuYwLONiI+rV9BbjQH9AXyOhcGi54+DwdK104D+wTIwTq9us4s5jraUSwcFGPdkvHZid0zD6Mk52TQedljqLrREA0D7pbdJsAVj5gPpTBohxD7EuAlznQmcyMXgR09qQtkH0tqiQgr0CApVoYMBb1RXAOJZWyQIZRSLUYIfDizNiu2hdGALQZGJBi5IyXA0rrGCAjxsaAN+fG+gYZ/Vo5qPMhWCEwxSyNDZABPM+BlPPEljE+QIat+q6N06nTBhgb57jzBVJ0IEOIDWvtfrf9HCA7vnTfd5WAHBvoYWPOi/4Am3Y75zNMAAFgV0sHpuYAqAAhDA1ABngYo/MAFnTRTt+NA4hh5yeeeGIJVEDWVW7ODQiZW0yeLaih2jewAoJAGdh5X9AWKB1nreY7JOY9jiOQ0a3AFK/RB5sUJNiDuemK/bAFfkAHMkj7MQ/KSbGeEONqC93xAXoTDOiEHcpq/MDvSq7knCdJQN4s4WDjxOc4uzqptFZKy6ikUcBBvVKNmHNjTliuXlcryNgZptatBTsuA8Y01Q6BuBROfyzjj4WOtZbQQWwhGInzlo4bQ5RYAJUxK2v4vM8Zm/0oV/gMkARG3m+zvPb+CeAV2ICAdFXZw8YhAaNUOaQ9V+ZCUFB3BaI+R1/B7pQDzIHaI3bVZmNdMQ5Zj6zGOCIoAAlzHMHIsbvnT+I156wXXUCmIwxYGespT3lKuajBzYsECIEOKAEcn8OmZR50ZjFP/VnW1a6tkkltdVrpjosO2SNAdkzi0TnLCLp15BBzIrC5OEqpzhzIBADqhg0bypgEnEHj4AfYMVbNDuzfsZQ3BKhFBmOy2KObUKYxcE5rEYmzS9kZCDCxAMKAgEcYn0t5XXoKkBlxF4jbolQR6aHPSWcxa+CypYxwnA68b3xYKLBwo3xMD/MJ0AIuWIwbK7lazucOOOCA0gVhkYyz0mE4eAjwxaRcROM70lNprftN00n7893zdGwCyOgRoAIEwUKgtMBno9NhEvu3L/PpHI3VpoQkyFoLiPp4W2RMPi878l2gAnCc/8tf/vICTLoDpPntuYxxKIsIKs5ZvdU5u+BCIInyynpIW8/mVqbjkY6BtHF2hR7oyQ83KNX4DFKBkGgDFZwiKHbnkR7dw0JXBXLif6RGCUoWsQySgNxI1zC6wlkxJQDM2V/xileUumUwPwCEfWm10gKlL9UvVihTYImYYziifXXByH6AOUaC5QE8KSFAHsRA1lucPxbP8YAlIJJyG790nzMCI6CE+Vm8ohdOaTv66KOvWrnndFJU+9K2Bvw4sffoDoukj1FzBCTo12dsgqOSktf0/Nqi/tvVfYjvxXvxKLACEwtq5l72Y3wAFHD7HHBSGjE+Y6ALQUlQ0bYoYAHYdtmpfQ7GKZ1X4nLeAoDgITvCxgcF41G6WI0M0o1jhW4RBY/sFCkRXEPow/9KDXSknAV4ZQLa5NSLMWpz1ZY4Jh9wfwx6YA+CKz0q82DUbGAZJEsWEwhWBIiVKKRg6pWAhMEAXXVhBofVABD1ZO8B4q7zxP/xyJCxAvtnkAwxemV1PGypcsUw4TDt43Mc7MVlynpJARXQAsBACJgAEhkBXVgA8v0oQWCAnFlqrtNAYFNjlaLG+AEYhiyzUEO1P4Gpey5EvVW5QmDATulcUHOeANV5qVuajwCWYSJ4qDljw0ofygyxiCRIqJ9igJiuY8losHpADZgdw5wBcPOm1OC8u8eM/41HILbYZTN2jFhZCCsU6Eed76yleywLkOYIGwbGdMJeBR3zi8FjsM5bqUkWZDO/wJjeZYrGAlAHZYiOyZci4Kk5WzwmghmbUiJbjy6T9ZAE5CHCWTAWNTSpFxZklZzjYTFYl1ogp1Xbipoao2V4g5hNSNvwgYc+VCvKjJrzawNSa8QQBxnxrGUQ0IW0X+eMauYAFBOiC+dIBwDUYhUmyBmBE9YMrAUYNWjgDCRlG2q1gJ3zcni6BqIWz7DDqDX67rAUlwBK+wKkgIF4VJ4ABPpcHdecjRonUfsF7AAZmAJzQVaqDjhlBQA5gBuAsA/Hw+TYgfHF/DvWqOOpmdNldHQAb3V6i4/OOca9XmK8SinsEiDGmoDxA1hjlgUJrvrrLXB77j2+EWDKL4bZMZuScQhIghtmjUVb/PR9c+j7o/xpkWRpAHmcM4YwNs4nzQaUcSEH4ACeFqsYGWPRNcEoGUy0dUlBORfHljZLv6R4HtsbI49aHHaMJXN23ReMGTMcxK7WQiY9Boao1MDxsFLnx2EsuGDGbRbDAQUXjA+oWqTyGazZ/+aDzoAwUPUINDm4gGQDAEBp1PlhyM7JfNE9Bwf4uin0HGO49knGjRPzw9LNO5aOqWK8vg+sMTcMX1lFMPGIxQJtwC9IT5PRsA+BHigTAU1mZH8CwnqDkIwmeqWNC9DSER8x9+bLgp2WR9mSNQKBV3AWVICqwNwtU4TIMuhQdqRcZVGTXWDee++9dwnMGLjjkEl9eJ5laQB51EQCWgtAWJoID4B1UXBMQKk2hnEBCY7H0TkfYGGYQEHKBcgBFRC3wm6RRkquxKFOyHD9b8Os7NtrGB5HB1COAZAB/zBD7sqWMFTMiMOpk2J0AJTjSEm1JAHe7jn43waYgRrnFLw4LcCUVXifUwM8z82FwARcjd9xbGQQYwxApkPP7QOQAWIMF0ufVI/ABvM17+ZC4BVI1J+Nz1wLHs7D5j3tWwCILoC4408iztXCp4tplAYEYqUvwY2OJj3ntRTniDgA5Mg6ovPEfGHQrqKzCVbKGHxDRwuiIkAP04c5NW4dFcCYj7Bj39MuKRgqVQUYk0l1O8+y1CULRsawGEZcRCAN5ZAAFFAwEotrfklC1AaWjIbDMhCsUVoXdUBsx3eBs+9Lx6T50lMb4GW8wJ+hM3jBABABLqCFiUj9MQggYWPAztdrtgAestaG6nh0RC/04/yxV2WFuHXlNGyO7nyHA9OP7MM+7QMQ0ZPASDdSWMcGAlijR+P1OY8AUhAEyvTEgQGB+qVtUKAYJpgf5isgOxfrA0ou5gQTBpo24CsI6SGWyagpt9vy2jIsWDpnKbrzFqzsR81cyWOt53NSce70K5MzB2xUUPI6sA77NifOW5mNj3juc4PG4bO+KzPEqoExYsL2LWRb9BXk2MeWKNf1TZb25kLATcrIIbBUCzSMLpgJ45P+YsEYECaIvWJGbScDGvHbY74jJQ+nYnyhXkDBwLyG/WGbGJKA4DjEd6SGFgVjwcTxgIPvY2DYGjBksMHavL+WTgwsjc+FMHSGwWFB7gnhXFZ6bOkw3Unbpa7GK8015vihT7oB4Ni0mnIAIqDkxAKbGwdZZBTYfFfA1PMriNLRpCIQyAC067EPAGmM5t2xZiX27Xzd5xfYqT27B7DWLuffF2HPAod7IlusE5jZpvOnK48CkVILXQHkKA91hR+wfeO1FoO08Dn+I+DJOB//+McXZsymQ9q+tgyydIBsuADR6rHorH4rRWYUUjIrvmpnorh0V00P+ACCdvoUAkgwHakX48SgsUaMapg4nuM+5znPKaUOIMvQGbNzw5wxD4YJkGyODVywdSAYbA07k/5bDAvDnaURcyLMXyufWp+ApaPkiCOOKMdcaWqNzWofBPKcUoChOwzJOB2T02LI3gcAApqAhUGps9IZXQJR3S+CG1DXy2yjK+c3qT7oXobz93//94XBAX2ArPThWGTYviY9BlAzLq1hSlrGrT1OwI8+6VnO32oFcdi4cWPpp5el8RM6p2tEQFkBYXFLTs+HifmWCcXNhWSKAJ/t8xc6UCKalBX3SUezlKUqWUhJOTe2p2FfqsRhsS+sKgARKHttv/32K86o5tmO2m1hQAyVsVmU4MgYJccDokDa5vv+B64AH+A4PvanS8GxgL80mZM6L6m3R99xThgJFmhR0KKhupvUXlpJsCvHmtZQBxm314xBbVY9HXhwQrqgE4wmAtQ0zmGfzldZwDwAXLrBfo0fQ5YJyDKCEUeWQNdRYpLVREsW1k7nyjy6FARQ3w9WO2hsg87X60AC646LWJRV2EYE2GHjnGT8gptAixkbP3Cz+GVdQtYR+4jHafS6VsK2sVqlHKDKBj06N/oVqMyTFjW23BZ2a67ND/uRFSAudMCuzRFbwqxlPexg0vGut17WSpYCkBmG9NdCml5iKTLG5aohhhRMKxbWpJAithQSOA5ixiEByBaDgKTaMdCXjjsGlhbMh3ECULUzIIeFOz6GoSapPOKzmCd2ZtEIyAAJjmATVICS83VcxxAMGD0jB2DTpteDjBtwCjCcSPAQCCw0WrSxOc/29yZxEOcLTO1P2xx9GQfHFJQwJWAMfM2DYwAqwZGeAKMgRY82gGn8NnoRjHzWgp7vmbfueY0COa+bT7Zi7OZH9hH7I6O+Pw5AnTM2L/03l0oqwFiWM4gZjtrXlhK+w94EKUTAHHrNxt6izKT+G4BqbHTI1mUcbJ3NC+7sCCvmWwKnu7fR8UqIxCLKUgAyA4m+UXUrhsQQXEXEkbE0zg3MpM3a2WLVHDiME/sALo7Bif2PDSl5MFTAYkUaO+CQUn9lCWBrYch5MFLGaj8WCZ0T9heMG3M3Do7AeRm/c3MsjMMjQOccjHslEoASAcYlrHQmUAENQKzdj57azjPMkWJ/ztnip33qKuCgGJcxCTwCEr1j3119Y8fYqXTYhrEC3Qg8AF3A8j1ZhGMGoHvf8W3mfBxg+p4NcGJ0gN4xHQ/w0Pug78d+R+3buWGa6rFa64A8QNJWxw76KvRGJ+ZKNwUb9L+A7ZGPmEP24X/zYV1GCckGkAGxsdOTeryswJwrUQjybDnlSlkKQOYMnAsoMCDOYCECAFo8AqKAk5Hoq+WEg1jxIIf2PzAEMADHMbA4KT0AY6gYBsPUDmdBA4A6D6AP/DF0r2mHk8ZHl4cFFTVqx+W09msD3pg3oAISzhUYK3fY50oXhmIs2D0WBzytpGPqnAgYGw8ZB27E+8AySgzAnR44Nod28YN6tM0xBuk8jsHZBRrjBpDOA2ulC1kMvdB9XBHovLE6+ovuCwANYIZJjCl0wD4EVt0d9KvEMEjG6cFYza8MTSePoBL9xqPWGvog9BV6o0/BmU4EWeMOcmCMGDF/cpGTLEhJCZlQ98eCAbAShfmW7UxKeJZJlmJRzxABA4e1iMZwpKRqsAxKe5SUmaOvJFpjVFifny7CBjDiDRs2lJV+oqXONfpAluFybgFAqxMQdUyAjpVhxgCB0QskmB6ntU/GyxG8xsgBL8DB7gURwUQg6ILOJOBJHBOTMQ6lCqwI4PktPL2hAHRSBzJOwGh/gEhWYIzmgdgvhigIYlh0MMk5tsW+MDLgi3XSM3YGOARBQOI4WBkw8AgMAeugcdCTDXjSgUVfmYzOGSUsfcLTdG2ECAjswoKW0pJx6yZo1437LGyOTgRoN8ziP2yTDs2bEpugiPTwBSyabQpkxijYKlHE+kifM4L1lqXpsuC8HBXoKRsAMs4ZqRPmBZyHyShQk+IDAqxSfZpBcl4r/RgFx8YQgRRQwBLUSzk31ud1LN3mPANQHS+MPl5zHp7H5licA/hwAGC9UsEIMXgr6s6XU6ltu2mQeqcgMIkAScxIymrxigMLhsZjvJwUQ1Q/VaZw7pPIqDkQxBxTicccCAAAAhiaV/MrM1IasQhFV1j1oEAgMGF3boKE0fsMNms+zZv/pxEBk93JfpSnBH8LyJMGtz4IG7M+Qie6JNSIQ2QfbMM8ml/6Vq6zFoMgICDYMH2njJalAWQMykKSKM8wtBlhqFjfpIAwSjADrWx+bcKxOBxmCygYMoMEatJ+C1TD+jW7MgiEuq+N+38SERSc90tf+tJSWsAwAbKaNHYIiCJlByRhNo4Tzz0CY4yYrqWvQN7rHFaZCCDap+d0MCgIruT8Q4xDvV6AxJiVfyyyYnnOQQDAyKXMgNFzjK17PJnU4YcfXkoMxoBp04F+YZlUBMhh0h6DIAvAbIBq0PH6LsYjUMny3NnOWgzW7HV2oRYuQ6NX4zO36u4rySiWWZYCkDkEsGFEgFPUxpIA8yhWPEraDkf8Lx1VJ45fyY06m75hvbOuYsLSxrHY7r6HyajPTfMe9oMRuqk6MMZmAYeAhf1gmnSI/QheNmPCOu0HM5UJAGObrg/lCexdaYauATDw86j8Qu+TjHEaiXHRu/ONdi31YIxfmSrSaYARXTbYr/tsAOw4J9+nC33ScQEPgMHs3dsYw47ANMk4nJPNuCf9Th+F/mQfSlr8ic4E2bifSeiQbgSt7jjneexbQpYCkEV2LEdNFMCI6AxnGuFMSgpYDgADRpw6jIsapeYbN24sJQqsOFJSNUgXGGDHamizEiAoRVcykRZif0BzGolyiyAiFQU8gAorlnIas8VFqbu+af8HoGH9xi0lj3KLdJ5uLLrJEDgpUPaaQOS73VR9rZzU+RifGrO5EXQAtOCMATsX54jxCho2Ywe2RA1cLTkuXhFIjOf5z3/+VUxwnKzV2NZTzLcsSEcQe4uMhz66c5synSxFlwWHwOo4lK1dopjUYTADC27KEoyRYEyAGvgCK+UQK8xSZobJ4b2PiVt00+IjhRuU7k56HlJyDqE1DlOJWx4KMlhtu77Z3md3//53bpi8BUdsUMBS41YrxXp0f1iwMU4pO71xOuzYRpfG5tH7Pi/4aCnEmNSfAZfv+5xgOGiMk4x7kIzTGT07ZwArEOp3BhzmQEDGVgVYXSAA1wKemjOWD2iMy3PrDYIfgGcH3sP2jWlSAOrqnqx03OstEchCn9Zi2tlFyspl4RnyOKedVDgqIHbvBd0Z0SYHADEFmxQZU+SwDBQ7i/tjADo1SOUSIAfYGPUgxtgW+1BCiHKA/QNgC2ZqeBgt1qYLQurdDjajBBg7NzVSF8sot2CHOioAKsBt6805CDzYpu92dUrPxgGkALCFu2HjWu2crPT7vgdQLe5iv9iycoR2RUFO5gO4BRZdEFq1ZFaCsA0wmy/rDn4RRueAOYwgOCtbS1leWZpFvdUKdsRxMVKr+P7XzgMA1VABFucEvLFQyPGxWFc4ATFA5YIGbNJz9WTOL5UHXu2p8NwxpNbAEnjGwhAGrk6LmUizte0BevuM744CBu8DF1dPGY++YECkb9pNYrD5ZRCsV9ZDlwKqkgY9W4jF9M2VwAq8vR9lDlmK/nGZhCwAk05JmYUkIE8o1BTs1Oq9OiR2ymGVC6TBgNgikVSOAGSfdcGHOi0g9R37AoCc2WexyhDvBQPFyn3HMT1akPQ+AHAcQKyNSvo8ae04Sh5asLB947A/bB8YY8lKC8skMg9B0zwpBQFfwCw7oVelDcw62gvZgTKIH3mVmZhD85XsOGW1koC8AsGgMEyOCYwxY447yCEtKKrT6u+1YWTxXamu7wBgnyOmA2h6HWtW7gCQQBvoKyWoy1rtx+LaNeNRYr82HRN6YvUaK73Yr8u3lSoEiEmBfRHFHGDDUaKQESnRAGK68+gzNsCstOPGOPrYBTVzFu6U4JyyEklAnkKoKpxuWocDssoNrthS8tAfi4G167Geh8S0AGNlDaUJfZ5AWBDo1oonOScMGwv0q9Bqp8BXL64LP4Bxd5/LJqFD82CugLKyjna5aOsj5sQagGDp7nLu46uEEfpbiX2kpJAE5C0k1GxThuDsmGr7dSAQUxHO7NGmxqzNDAvzfFCXxjhxPPVsF65YnMTy3VPAfWyVP3KV/FfFfAhgyjtqzK44dH8GpSNgrL5vvujNJcHaGpV9UlJWIwnIqxTqmxbIsGVbW7rT0N6n0kVsk0j3nJRIgIn+aFdaSbkxun333beASaTbKb8q9AiYtQPqMLH4qSdbiyCgFtQAs/UAYOye1ur5qcuUlcpS3aB+pTIKdFfifFEbbm8Wjtpb+z2fn+Y47c9qxdPaBowtWNm3qwb9MgcwjotbVjKOeZFxQXPY+16je50V6vdKR9HrreVQ1qGMAZQt1gJun1VSGtZznZIyShKQJ5B5c6wAGBc66FfW2qabQs1YL/SGDRtKzTgu/11k4BgHxmSS8QuMykXAFjDLMiz4WZzFlAGzOjOgtvjns0obAmBKyqSSgLyAIs1WpnBLUMzYBRDAwaXQwFhXwLCukEWTWY0xgF0Aw5aVKbymzqwHHUsGyoKgrhqZh8+oMftO7IMsg95TViYJyAsmatOYm5sc6TPWX4sJu1GQmxu5mk9anaAwnXT1BZRdiIMBqycrXwRT1n+uLu/CkvaVfPaRek8ZJZOtEqX0SoJpdQUzBsbup3HssceWixsAhwU8F3241HfZW9tmKa6UdMMogc4FNURpQ8CLmrLyRUrKpJKAPIcyjGW574IrA4Gxy61d9OEmQa4mc2m1skXK7MQ8YMl+cMBVe/rEBUCs2d3tXCIPnLsyLKCmpGTb2xyJqRoExl63mOSiD7fR9GOqVvn9agkwdn+N9q1CU2YrykTqyG6FKjtRJvJrKMpDQLmr92HzmJKSgLwAYnXflXeuAHR5tlpm3BDfj55ibbGw1JYEhtlIuFBc9KOOrHasjiwwpqRMKgnIcy4AABj7nUD3qLDarzyhm8LP6sQv+ybwrky6QSvcJfWZshaSgDyHYspsbgepTBH3WwASLvZwc3gLeNFnnJKSMh+SgDxnYrqUJCzauSeFq/DcLtKCnda2RzziEYUZt2/pmZKSMh+SgNwDMQWTpMA+p5XK/ZH91puOCvVjFyC4haZFPL9vNmhlPyUlpf+SgNxTGQTSelux4Y0bN5ar8Kzsu/hAL6wyhR/rTDBOSZlfSUDumcR0dMHYCr77Ubz5zW8uv4EHjP3m26Me9ajSYuUuY5PerD4lJaWfkoA8B6LH2KKdn11yX16LeXqLH/nIR5aLEfwGnpvZpKSkzLckIPdc3BfhjDPOqN773veWexn7bTc/jqpM4SZBftIpL4dOSVkMSUDuqZiWiy66qFz55co7N0dXxvDrHpixn3Taaaedsq0tJWWBJAG5h+KGNH6hwsKdtjYtbi7w8AvTFu+AsUuhu2IqJ+nWSElJ6ackIK+ztEHUcz986i5tmPGJJ55YWHK7rQ1Dzk6KlJTFlATkLSht8O2K93RSuEGNK+90Uli8c3Mav9emTHHHO94xf4EiJWWBJQG5J4IZn3POOYUVa21z0/Ndd921/Padq+/8llu3XjwK4FNSUuZPEpB7IJixe1L4hQ/dFMDZDc/9RL/LoXVSJDNOSVl8SUBeR6F6P5Kpi8IPkbpbm7Y2NwjyE/1+iNSPavoVivg8SVackrKYkoC8DkLlQNXi3fve976ygHf22WeXkoRbZ7r6zs3N825tKSnLJQnIU4pfh/AT8EoIwVynES1tfvfOL0F/4hOfqN7znveUXyrW1oYRW8DT3jaorS0lJWWxJQF5CvEjon5dWI8wwLz5zW8+FSirFWtjU5pwGbTn6sV+XcJVd37lw93aMOOUlJTlkwTkKUR999xzz61OPfXUAqJ+3FJbWnfBjUrbdV6g67aZF1xwQXXaaaeVEoUbBfkuNqw8ob/Yndt22GGHzd9KSUlZNklAnkIAsp9LOuqoo0rZYf/99y+/6qwLosuUqVV5wneUJJQnTj/99PLoNpo777xzudDDT/S7baYbyneBPCUlZbkkAXkKUbL4whe+UL32ta+tjjvuuOoWt7hF+fn3vfbaq/wcfAiVqjNjwRbr3BzozDPPrC6++OJSK77Xve5VPeQhDynbta51rc3fSklJWXZJQJ5S1IHdJP6EE04oV9SpJWPJSg7KGJhy1Irdh0KJAyP2C8R77LFHuV2mzYUebpmZjDglJSUkAXkKoSosGeCed9551cknn1xKGH7jznvAVZuaTgx1Y49ujXnb2962LNoBbUDsZ/nzZvIpKSldSUBegVAZwMWCAbNLnv3gqEU7YA2Ed9ttt7JYt/vuu1c3velNS0eGRby8d3FKSsowSUCeUqirXWbAjrXBqRdfeOGF5X93Y8OE73SnO5U7tSlNDLrAo7uvlJSU5ZYE5ClkGIAqY+iosHkOfLfbbrur2PCkwJsAnZKy3JKAnJKSktITyRslpKSkpPREEpBTUlJSeiIJyCkpKSk9kQTklJSUlJ5IAnJKSkpKTyQBOSUlJaUnkoCckpKS0hNJQE5JSUnpiSQgp6SkpPRCqur/AWmzaWmtj+4jAAAAAElFTkSuQmCC";
        String s = ReportUtil.convertBase64ToImage((String)picBase64, (String)"seal.png", (String)"");
        return s;
    }

    @Override
    public Map<String, Object> getFileInfoByFileId(Long fileId) {
        return this.customMapper.selectFileInfoByFileId(fileId);
    }

    @Override
    public JSONObject getDealDataSourceParams(Map<String, Object> param) {
        JSONObject dealDataSourceParams = new JSONObject(param);
        dealDataSourceParams.putIfAbsent((Object)"elnParam", (Object)"{\n          \"queryInfoList\": [\n              {\n                  \"key\": \"\u6570\u636e\u4e00\u4f53\u5316\u8054\u8c03\",\n                  \"taskId\": \"1e0a4507f9ae339f7a820ec891af2da4\",\n                  \"templateId\": \"3fb4c4fc-460f-4f40-a7df-39b5ae049657\"\n              }\n          ],\n          \"languageList\": [\"zh\",\"en\",\"ja\"]\n      }");
        return dealDataSourceParams;
    }
}

