/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.report.importer.service.impl;

import com.jxdinfo.document.excel.tools.core.common.utils.JsonUtil;
import com.jxdinfo.document.excel.tools.core.common.utils.ZipUtil;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.importer.ReportToolImportExcelUtil;
import com.jxdinfo.document.excel.tools.report.external.service.WordExcelCommonService;
import com.jxdinfo.document.excel.tools.report.importer.service.ImportExcelService;
import com.jxdinfo.document.excel.tools.report.instance.instance.service.ReportToolFormInstanceCustomService;
import com.jxdinfo.document.excel.tools.report.template.template.service.ReportToolFormTemplateCustomService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="document.excel.tools.report.importer.service.impl.ImportExcelServiceImpl")
public class ImportExcelServiceImpl
implements ImportExcelService {
    @Autowired
    private ReportToolImportExcelUtil excelUtil;
    @Autowired
    private ReportToolFormTemplateCustomService toolFormTemplateCustomService;
    @Autowired
    private ReportToolFormInstanceCustomService toolFormInstanceCustomService;
    @Autowired
    private WordExcelCommonService wordExcelCommonService;
    private static final Logger logger = LoggerFactory.getLogger(ImportExcelServiceImpl.class);

    @Override
    public ApiResponse<Long> importExcel(MultipartFile file, String docName, String groupId, String type) throws Exception {
        logger.info("importExcel \u5bfc\u5165excel \u5f00\u59cb");
        String json = null;
        if (HussarUtils.isNotEmpty((Object)file)) {
            ImportExcelServiceImpl.checkFileSize(file);
            ImportExcelServiceImpl.checkFileType(file);
            List luckySheets = this.excelUtil.importExcel(file);
            json = ZipUtil.zipReport((String)JsonUtil.asJSONString((Object)luckySheets));
        }
        logger.info("importExcel \u89e3\u6790\u5b8c\u6210");
        Long id = this.setDb(type, json, docName, groupId);
        logger.info("importExcel \u5bfc\u5165excel \u7ed3\u675f");
        return ApiResponse.success((Object)id);
    }

    private static void checkFileSize(MultipartFile file) {
        if (file.isEmpty() || file.getSize() == 0L) {
            throw new HussarException("\u4e0a\u4f20\u5931\u8d25\uff0c\u6587\u4ef6\u5927\u5c0f\u4e0d\u80fd\u4e3a 0 kb");
        }
    }

    private static void checkFileType(MultipartFile file) {
        if (!Objects.requireNonNull(file.getOriginalFilename()).endsWith(".xlsx")) {
            throw new HussarException("\u4e0a\u4f20\u5931\u8d25\uff0c\u6587\u4ef6\u683c\u5f0f\u9519\u8bef");
        }
    }

    private Long setDb(String type, String json, String docName, String groupId) {
        logger.info("setDb \u5bfc\u5165excel \u5f00\u59cb");
        Long id = 0L;
        if (type != null && type.equals("4")) {
            id = this.toolFormInstanceCustomService.addImportFormReport(docName, json);
            if (id != 0L) {
                logger.info("setDb \u5bfc\u5165excel \u5f80\u62a5\u544a\u8868\u585e\u5165\u6570\u636e\u7ed3\u675f");
                this.wordExcelCommonService.updateDocumentByReport(String.valueOf(id), docName, groupId);
                logger.info("setDb updateDocumentByReport \u5bfc\u5165excel \u5f80\u516c\u5171\u8868\u585e\u5165\u6570\u636e\u7ed3\u675f");
            }
        } else {
            id = this.toolFormTemplateCustomService.addImportFormTemplate(docName, json);
            if (id != 0L) {
                logger.info("setDb \u5bfc\u5165excel \u5f80\u6a21\u677f\u8868\u585e\u5165\u6570\u636e\u7ed3\u675f");
                this.wordExcelCommonService.updateDocumentByTemplate(String.valueOf(id), docName, groupId);
                logger.info("setDb updateDocumentByTemplate \u5bfc\u5165excel \u5f80\u516c\u5171\u8868\u585e\u5165\u6570\u636e\u7ed3\u675f");
            }
        }
        logger.info("setDb \u5bfc\u5165excel \u7ed3\u675f");
        return id;
    }
}

