/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.report.template.component.attachmentfilelink.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jxdinfo.document.excel.tools.report.template.component.attachmentfilelink.dao.ComponentFileLinkMapper;
import com.jxdinfo.document.excel.tools.report.template.component.attachmentfilelink.model.ComponentAttachmentFileLink;
import com.jxdinfo.document.excel.tools.report.template.component.attachmentfilelink.service.ComponentFileLinkCustomService;
import com.jxdinfo.document.excel.tools.report.template.component.attachmentfilelink.service.ComponentFileLinkService;
import com.jxdinfo.document.excel.tools.report.template.component.attachmentfilelink.vo.AddCompAttachmentFileParamVo;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="excel.tools.report.template.component.attachmentFileLink.ComponentFileLinkCustomServiceImpl")
public class ComponentFileLinkCustomServiceImpl
implements ComponentFileLinkCustomService {
    @Autowired
    private ComponentFileLinkMapper componentFileLinkMapper;
    @Resource
    private ComponentFileLinkService componentFileLinkService;

    @Override
    public ApiResponse<Map<String, Object>> addCompAttachmentFile(AddCompAttachmentFileParamVo param) {
        try {
            SecurityUser user = BaseSecurityUtil.getUser();
            if (user == null) {
                return ApiResponse.fail((String)"\u5f53\u524d\u767b\u5f55\u5931\u6548");
            }
            ComponentAttachmentFileLink reportTempAttachmentFileLink = new ComponentAttachmentFileLink();
            Long componentId = Long.valueOf(param.getComponentId());
            String fileId = param.getFileId();
            String fileName = param.getFileName();
            String filePath = param.getFilePath();
            String fileType = param.getFileType();
            if (param.getType() != null) {
                reportTempAttachmentFileLink.setType(param.getType());
            }
            String userName = user.getUserName();
            Long userId = user.getId();
            LocalDateTime now = LocalDateTime.now();
            Long id = IdWorker.getId((Object)new Date());
            reportTempAttachmentFileLink.setId(id);
            reportTempAttachmentFileLink.setComponentId(componentId);
            reportTempAttachmentFileLink.setFileId(fileId);
            reportTempAttachmentFileLink.setFileName(fileName);
            reportTempAttachmentFileLink.setFilePath(filePath);
            reportTempAttachmentFileLink.setFileType(fileType);
            reportTempAttachmentFileLink.setCreateId(userId);
            reportTempAttachmentFileLink.setCreateName(userName);
            reportTempAttachmentFileLink.setCreateTime(now);
            int i = this.componentFileLinkMapper.insert(reportTempAttachmentFileLink);
            if (i > 0) {
                return ApiResponse.success((String)"\u65b0\u589e\u6210\u529f");
            }
            return ApiResponse.fail((String)"\u65b0\u589e\u5931\u8d25");
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @Override
    public ApiResponse<Map<String, Object>> delCompAttachmentFile(Map<String, Object> param) {
        try {
            String idsStr = param.get("ids").toString();
            String[] ids = idsStr.split(",");
            int count = 0;
            int n = 0;
            for (int i = 0; i < ids.length; ++i) {
                if (ids[i] == null || ids[i].equals("")) continue;
                ++count;
                int m = this.componentFileLinkMapper.deleteById((Serializable)((Object)ids[i]));
                if (m <= 0) continue;
                ++n;
            }
            if (n == count) {
                return ApiResponse.success((String)"\u5220\u9664\u6210\u529f");
            }
            return ApiResponse.fail((String)"\u5220\u9664\u5931\u8d25");
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @Override
    public ApiResponse<List<ComponentAttachmentFileLink>> getCompAttachmentFileList(Map<String, Object> param) {
        try {
            String componentId = param.get("componentId").toString();
            List<ComponentAttachmentFileLink> reportCompAttachmentFileLinkList = this.getListByBusinessId(componentId);
            return ApiResponse.success(reportCompAttachmentFileLinkList);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @Override
    public List<ComponentAttachmentFileLink> getListByBusinessId(String businessId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(ComponentAttachmentFileLink::getComponentId, (Object)businessId);
        return this.componentFileLinkMapper.selectList((Wrapper)queryWrapper);
    }

    @Override
    public void copyByBusinessId(String businessId, List<ComponentAttachmentFileLink> componentAttachmentFileLinkList) {
        if (businessId == null || CollectionUtils.isEmpty(componentAttachmentFileLinkList)) {
            return;
        }
        for (ComponentAttachmentFileLink templateComponentAttachmentFileLink : componentAttachmentFileLinkList) {
            templateComponentAttachmentFileLink.setComponentId(Long.valueOf(businessId));
            templateComponentAttachmentFileLink.setId(IdWorker.getId((Object)new Date()));
        }
        this.componentFileLinkService.saveOrUpdateBatch(componentAttachmentFileLinkList);
    }
}

