/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.report.export.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jxdinfo.document.excel.tools.common.file.service.OssFileService;
import com.jxdinfo.document.excel.tools.common.vo.FileLinkParamVo;
import com.jxdinfo.document.excel.tools.core.common.utils.FilePathUtil;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.ExportExcelUtil;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.constant.ExcelConstant;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.vo.DownloadExcelParamVo;
import com.jxdinfo.document.excel.tools.report.export.service.ExportExcelService;
import com.jxdinfo.document.excel.tools.report.instance.attachmentfilelink.dao.InstanceFileLinkMapper;
import com.jxdinfo.document.excel.tools.report.instance.attachmentfilelink.model.ReportToolInstanceAttachmentFileLink;
import com.jxdinfo.document.excel.tools.report.instance.instance.model.ReportToolFormInstance;
import com.jxdinfo.document.excel.tools.report.instance.instance.service.ReportToolFormInstanceCustomService;
import com.jxdinfo.document.excel.tools.report.template.attachmentfilelink.dao.TemplateFileLinkMapper;
import com.jxdinfo.document.excel.tools.report.template.attachmentfilelink.model.ReportToolTemplateAttachmentFileLink;
import com.jxdinfo.document.excel.tools.report.template.component.attachmentfilelink.dao.ComponentFileLinkMapper;
import com.jxdinfo.document.excel.tools.report.template.component.attachmentfilelink.model.ComponentAttachmentFileLink;
import com.jxdinfo.document.excel.tools.report.template.component.component.model.ReportToolFormComponentTemplate;
import com.jxdinfo.document.excel.tools.report.template.component.component.service.ComponentTemplateCustomService;
import com.jxdinfo.document.excel.tools.report.template.template.model.ReportToolFormTemplate;
import com.jxdinfo.document.excel.tools.report.template.template.service.ReportToolFormTemplateCustomService;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="excel.tools.report.export.service.impl.ExportExcelServiceImpl")
public class ExportExcelServiceImpl
implements ExportExcelService {
    @Value(value="${export-excel-image-path}")
    private String exportExcelImagePath;
    @Resource
    private ExportExcelUtil exportExcelUtil;
    @Resource
    private ReportToolFormInstanceCustomService toolFromInstanceCustomService;
    @Resource
    private ReportToolFormTemplateCustomService toolFormTemplateCustomService;
    @Resource
    private ComponentTemplateCustomService componentTemplateCustomService;
    private static final Logger logger = LoggerFactory.getLogger(ExportExcelServiceImpl.class);
    @Autowired
    private InstanceFileLinkMapper instanceFileLinkMapper;
    @Autowired
    private TemplateFileLinkMapper templateFileLinkMapper;
    @Resource
    private ComponentFileLinkMapper componentFileLinkMapper;
    @Autowired
    private OssFileService ossFileService;

    private String getJson(String exportId, String type) {
        String jsonZipStr;
        if ("3".equals(type)) {
            ReportToolFormTemplate template = this.toolFormTemplateCustomService.getReportFormTemplateInfo(exportId);
            jsonZipStr = template.getTemplateJson();
        } else if ("4".equals(type)) {
            ReportToolFormInstance reportInfo = this.toolFromInstanceCustomService.getReportInfo(exportId);
            jsonZipStr = reportInfo.getReportData();
        } else {
            ReportToolFormComponentTemplate componentTemplate = this.componentTemplateCustomService.getReportFormCompTemplateInfo(exportId);
            jsonZipStr = componentTemplate.getTemplateJson();
        }
        return jsonZipStr;
    }

    private List<FileLinkParamVo> getFileLinkList(String exportId, String type) {
        ArrayList<FileLinkParamVo> fileLinkList;
        block5: {
            block6: {
                block4: {
                    fileLinkList = new ArrayList<FileLinkParamVo>();
                    if (!"3".equals(type)) break block4;
                    QueryWrapper queryWrapper = new QueryWrapper();
                    queryWrapper.lambda().eq(ReportToolTemplateAttachmentFileLink::getTemplateId, (Object)exportId);
                    List reportToolTemplateAttachmentFileLinkList = this.templateFileLinkMapper.selectList((Wrapper)queryWrapper);
                    if (!CollectionUtils.isNotEmpty((Collection)reportToolTemplateAttachmentFileLinkList)) break block5;
                    for (ReportToolTemplateAttachmentFileLink link : reportToolTemplateAttachmentFileLinkList) {
                        FileLinkParamVo fileLinkParamVo = new FileLinkParamVo();
                        fileLinkParamVo.setFileId(link.getFileId());
                        fileLinkParamVo.setFileName(link.getFileName());
                        fileLinkList.add(fileLinkParamVo);
                    }
                    break block5;
                }
                if (!"4".equals(type)) break block6;
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.lambda().eq(ReportToolInstanceAttachmentFileLink::getReportId, (Object)exportId);
                List reportToolInstanceAttachmentFileLinkList = this.instanceFileLinkMapper.selectList((Wrapper)queryWrapper);
                if (!CollectionUtils.isNotEmpty((Collection)reportToolInstanceAttachmentFileLinkList)) break block5;
                for (ReportToolInstanceAttachmentFileLink link : reportToolInstanceAttachmentFileLinkList) {
                    FileLinkParamVo fileLinkParamVo = new FileLinkParamVo();
                    fileLinkParamVo.setFileId(link.getFileId());
                    fileLinkParamVo.setFileName(link.getFileName());
                    fileLinkList.add(fileLinkParamVo);
                }
                break block5;
            }
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().eq(ComponentAttachmentFileLink::getComponentId, (Object)exportId);
            List componentAttachmentFileLinkList = this.componentFileLinkMapper.selectList((Wrapper)queryWrapper);
            if (CollectionUtils.isNotEmpty((Collection)componentAttachmentFileLinkList)) {
                for (ComponentAttachmentFileLink link : componentAttachmentFileLinkList) {
                    FileLinkParamVo fileLinkParamVo = new FileLinkParamVo();
                    fileLinkParamVo.setFileId(link.getFileId());
                    fileLinkParamVo.setFileName(link.getFileName());
                    fileLinkList.add(fileLinkParamVo);
                }
            }
        }
        return fileLinkList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportXlsx(HttpServletResponse response, DownloadExcelParamVo param) {
        try {
            String reportId = param.getExportId();
            String jsonZipStr = "";
            jsonZipStr = StringUtils.isNotBlank((CharSequence)reportId) ? this.getJson(reportId, param.getType()) : param.getJsonZipStr();
            if (StringUtils.isEmpty((CharSequence)jsonZipStr)) {
                throw new RuntimeException("jsonZipStr \u4e0d\u80fd\u4e3a\u7a7a");
            }
            String defaultFilePath = FilePathUtil.getFilePathSplicing((String)"exportExcel");
            File file = new File(defaultFilePath, "files.txt");
            if (ToolUtil.isNotEmpty((Object)jsonZipStr)) {
                try (FileOutputStream fos = new FileOutputStream(file);){
                    fos.write(jsonZipStr.getBytes());
                }
                catch (IOException e) {
                    logger.error("jsonZipStr \u6587\u4ef6\u5199\u5165\u5931\u8d25:{}", (Object)e.getMessage());
                }
            }
            String fastSimpleUUID = IdWorker.get32UUID();
            String zipPathFile = defaultFilePath + File.separator + fastSimpleUUID + ".zip";
            String zipUnPath = defaultFilePath + File.separator + "zip" + File.separator;
            String base64PdfStr = ExportExcelServiceImpl.getExcelData(defaultFilePath);
            byte[] pdfData = Base64.getDecoder().decode(base64PdfStr);
            FileUtils.writeByteArrayToFile((File)new File(zipPathFile), (byte[])pdfData);
            ExportExcelServiceImpl.unzip(zipPathFile, zipUnPath, fastSimpleUUID);
            this.exportExcelUtil.exportLuckySheetXlsx(zipUnPath + File.separator + fastSimpleUUID, param, response);
        }
        catch (Exception e) {
            logger.error("\u4e0b\u8f7d\u62a5\u544aexcel\u6587\u4ef6\u5f02\u5e38\uff1a", (Throwable)e);
        }
        finally {
            try {
                FileUtils.deleteDirectory((File)new File(FilePathUtil.getFilePathSplicing((String)"exportExcel")));
            }
            catch (IOException e) {
                logger.error("\u5220\u9664\u4e34\u65f6\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            }
        }
    }

    @Override
    public void exportComponentXlsx(HttpServletResponse response, Long componentId) {
        ReportToolFormComponentTemplate componentTemplate = this.componentTemplateCustomService.getReportFormCompTemplateInfo(String.valueOf(componentId));
        DownloadExcelParamVo param = new DownloadExcelParamVo();
        param.setExportId(String.valueOf(componentId));
        param.setExportActiveIndex("0");
        param.setReqURL(this.exportExcelImagePath);
        param.setFormulaTextStyleStr(ExcelConstant.formulaTextStyle.toJSONString());
        param.setExportName(componentTemplate.getName());
        param.setType("2");
        param.setMethod("get");
        this.exportXlsx(response, param);
    }

    @Override
    public void exportTemplateXlsx(HttpServletResponse response, Long templateId) {
        ReportToolFormTemplate reportTemplate = this.toolFormTemplateCustomService.getBase(templateId);
        DownloadExcelParamVo param = new DownloadExcelParamVo();
        param.setExportId(String.valueOf(templateId));
        param.setExportActiveIndex("0");
        param.setReqURL(this.exportExcelImagePath);
        param.setFormulaTextStyleStr(ExcelConstant.formulaTextStyle.toJSONString());
        param.setExportName(reportTemplate.getName());
        param.setType("3");
        param.setMethod("get");
        this.exportXlsx(response, param);
    }

    @Override
    public void exportReportXlsx(HttpServletResponse response, Long reportId) {
        ReportToolFormInstance reportInfo = this.toolFromInstanceCustomService.getReportInfo(String.valueOf(reportId));
        ReportToolFormTemplate reportTemplate = this.toolFormTemplateCustomService.getBase(reportInfo.getTemplateId());
        DownloadExcelParamVo param = new DownloadExcelParamVo();
        param.setJsonZipStr(reportInfo.getReportData());
        param.setExportId(String.valueOf(reportId));
        param.setExportActiveIndex("0");
        param.setReqURL(this.exportExcelImagePath);
        param.setFormulaTextStyleStr(ExcelConstant.formulaTextStyle.toJSONString());
        param.setExportName(reportTemplate.getName());
        param.setType("4");
        param.setMethod("get");
        this.exportXlsx(response, param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportZipFile(HttpServletResponse response, DownloadExcelParamVo param) {
        String zipFileName = param.getExportName() + ".zip";
        try {
            zipFileName = URLEncoder.encode(zipFileName, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", "attachment;filename=" + zipFileName);
        response.setHeader("Content-Encoding", "identity");
        response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", 0L);
        response.setHeader("Access-Control-Expose-Headers", "Content-Disposition, Content-Length");
        List<FileLinkParamVo> fileLinkList = this.getFileLinkList(param.getExportId(), param.getType());
        try (ZipOutputStream zos = new ZipOutputStream((OutputStream)response.getOutputStream());){
            XSSFWorkbook wb = this.getWb(param);
            ZipEntry excelEntry = new ZipEntry(param.getExportName() + ".xlsx");
            zos.putNextEntry(excelEntry);
            wb.write((OutputStream)zos);
            zos.closeEntry();
            wb.close();
            for (FileLinkParamVo link : fileLinkList) {
                InputStream is = this.ossFileService.getFileStream(link.getFileId());
                Throwable throwable = null;
                try {
                    int len;
                    ZipEntry entry = new ZipEntry("\u9644\u4ef6/" + link.getFileName());
                    zos.putNextEntry(entry);
                    byte[] buffer = new byte[4096];
                    while ((len = is.read(buffer)) != -1) {
                        zos.write(buffer, 0, len);
                        zos.flush();
                    }
                    zos.closeEntry();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    is.close();
                }
            }
            zos.finish();
        }
        catch (IOException ex) {
            logger.error("\u751f\u6210ZIP\u5931\u8d25", (Throwable)ex);
            response.setStatus(500);
            try {
                response.getWriter().write("Internal Server Error");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        catch (Exception ex) {
            logger.error("\u672a\u77e5\u5f02\u5e38\u53d1\u751f\u5728downReportZip\u4e2d", (Throwable)ex);
            response.setStatus(500);
            try {
                response.getWriter().write("Internal Server Error");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        finally {
            try {
                FileUtils.deleteDirectory((File)new File(FilePathUtil.getFilePathSplicing((String)"exportExcel")));
            }
            catch (IOException e) {
                logger.error("\u5220\u9664\u4e34\u65f6\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            }
        }
    }

    private XSSFWorkbook getWb(DownloadExcelParamVo param) throws IOException {
        String reportId = param.getExportId();
        String jsonZipStr = "";
        jsonZipStr = StringUtils.isNotBlank((CharSequence)reportId) ? this.getJson(reportId, param.getType()) : param.getJsonZipStr();
        if (StringUtils.isEmpty((CharSequence)jsonZipStr)) {
            throw new RuntimeException("jsonZipStr \u4e0d\u80fd\u4e3a\u7a7a");
        }
        String defaultFilePath = FilePathUtil.getFilePathSplicing((String)"exportExcel");
        File file = new File(defaultFilePath, "files.txt");
        if (ToolUtil.isNotEmpty((Object)jsonZipStr)) {
            try (FileOutputStream fos = new FileOutputStream(file);){
                fos.write(jsonZipStr.getBytes());
            }
            catch (IOException e) {
                logger.error("jsonZipStr \u6587\u4ef6\u5199\u5165\u5931\u8d25:{}", (Object)e.getMessage());
            }
        }
        String fastSimpleUUID = IdWorker.get32UUID();
        String zipPathFile = defaultFilePath + File.separator + fastSimpleUUID + ".zip";
        String zipUnPath = defaultFilePath + File.separator + "zip" + File.separator;
        String base64PdfStr = ExportExcelServiceImpl.getExcelData(defaultFilePath);
        byte[] pdfData = Base64.getDecoder().decode(base64PdfStr);
        FileUtils.writeByteArrayToFile((File)new File(zipPathFile), (byte[])pdfData);
        ExportExcelServiceImpl.unzip(zipPathFile, zipUnPath, fastSimpleUUID);
        return this.exportExcelUtil.exportLuckySheetXlsx(zipUnPath + File.separator + fastSimpleUUID, param);
    }

    public static String getExcelData(String defaultFilePath) {
        StringBuilder sb = new StringBuilder();
        try {
            File file = new File(defaultFilePath + File.separator + "files.txt");
            List lines = FileUtils.readLines((File)file, (String)"UTF-8");
            lines.forEach(sb::append);
        }
        catch (IOException e) {
            logger.error("\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25:{}", (Object)e.getMessage());
        }
        return sb.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void unzip(String zipPathFile, String zipUnPath, String fastSimpleUUID) {
        File destDir = new File(zipUnPath + File.separator + fastSimpleUUID);
        if (!destDir.exists()) {
            destDir.mkdirs();
        }
        try (ZipArchiveInputStream zis = new ZipArchiveInputStream((InputStream)new FileInputStream(zipPathFile));){
            ZipArchiveEntry entry;
            while ((entry = zis.getNextZipEntry()) != null) {
                OutputStream os;
                block27: {
                    File entryFile = new File(destDir, entry.getName());
                    if (entry.isDirectory()) {
                        if (entryFile.exists()) continue;
                        entryFile.mkdirs();
                        continue;
                    }
                    File parent = entryFile.getParentFile();
                    if (parent != null && !parent.exists()) {
                        parent.mkdirs();
                    }
                    os = Files.newOutputStream(entryFile.toPath(), new OpenOption[0]);
                    Throwable throwable = null;
                    try {
                        IOUtils.copy((InputStream)zis, (OutputStream)os);
                        if (os == null) continue;
                        if (throwable == null) break block27;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (os == null) throw throwable3;
                            if (throwable != null) {
                                try {
                                    os.close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                            os.close();
                            throw throwable3;
                        }
                    }
                    try {
                        os.close();
                        continue;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        continue;
                    }
                }
                os.close();
            }
            return;
        }
        catch (IOException e) {
            logger.error("\u89e3\u538bZIP\u6587\u4ef6\u5931\u8d25: {}", (Object)e.getMessage(), (Object)e);
        }
    }
}

