/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.common.datasource.controller;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.document.excel.tools.common.datasource.service.DataSourceCustomService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="excel.tools.report.dataSource.custom.DataSourceCustomController")
@AuditLog(moduleName="\u62a5\u544a\u6570\u636e\u6e90\u8868-\u81ea\u5b9a\u4e49\u63a7\u5236\u5668")
@RequestMapping(value={"/excel/report/common/dataSource/custom"})
public class DataSourceCustomController {
    @Autowired
    private DataSourceCustomService dataSourceCustomService;

    @PostMapping(value={"/getElnData"})
    public ApiResponse<JSONObject> getElnData(@RequestBody Map<String, Object> param) {
        JSONObject elnParam = null;
        try {
            if (!param.containsKey("elnParam")) {
                return ApiResponse.fail((String)"\u53c2\u6570\u9519\u8bef");
            }
            elnParam = JSONObject.parseObject((String)param.get("elnParam").toString());
        }
        catch (ClassCastException e) {
            elnParam = (JSONObject)JSONObject.toJSON((Object)param.get("elnParam"));
        }
        JSONObject res = this.dataSourceCustomService.getElnData(elnParam);
        if (res == null) {
            return ApiResponse.fail((String)"\u83b7\u53d6ELN\u6570\u636e\u5931\u8d25");
        }
        return ApiResponse.success((Object)res);
    }

    @AuditLog(moduleName="\u62a5\u544a\u6a21\u677f\u8868", eventDesc="\u83b7\u53d6\u6570\u636e\u6e90\u5217\u8868", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @PostMapping(value={"/getDataSourceList"})
    public ApiResponse<Map<String, Object>> getDataSourceList(@RequestBody Map<String, Object> param) {
        return this.dataSourceCustomService.getDataSourceList(param);
    }

    @AuditLog(moduleName="\u62a5\u544a\u6a21\u677f\u8868", eventDesc="\u4fdd\u5b58\u6570\u636e\u6e90", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    @PostMapping(value={"/saveDataSource"})
    public ApiResponse<Map<String, Object>> saveDataSource(@RequestBody Map<String, Object> param) {
        return this.dataSourceCustomService.saveDataSource(param);
    }

    @AuditLog(moduleName="\u62a5\u544a\u6a21\u677f\u8868", eventDesc="\u5220\u9664\u6570\u636e\u6e90", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.DELETE)
    @PostMapping(value={"/delDataSource"})
    public ApiResponse<Map<String, Object>> delDataSource(@RequestBody Map<String, Object> param) {
        return this.dataSourceCustomService.delDataSource(param);
    }

    @AuditLog(moduleName="\u62a5\u544a\u6a21\u677f\u8868", eventDesc="\u83b7\u53d6\u793a\u4f8b\u6570\u636e", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @PostMapping(value={"/getExampleData"})
    public ApiResponse<Map<String, Object>> getExampleData(@RequestBody Map<String, Object> param) {
        return this.dataSourceCustomService.getExampleData(param);
    }

    @AuditLog(moduleName="\u62a5\u544a\u6a21\u677f\u6570\u636e\u6e90\u8868", eventDesc="\u62a5\u544a\u6a21\u677f\u63a7\u5236\u9762\u677f-\u7ec4\u4ef6\u62d6\u62fd-\u5c06\u7ec4\u4ef6\u7684\u6570\u636e\u6e90\u589e\u52a0\u5230\u6a21\u677f\u4e2d", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    @PostMapping(value={"/templateComponentDrag"})
    public ApiResponse<Map<String, Object>> templateComponentDrag(@RequestBody Map<String, Object> param) {
        return this.dataSourceCustomService.templateComponentDrag(param);
    }
}

