/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.common.datasource.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.jxdinfo.document.excel.tools.common.datasource.dao.DataSourceMapper;
import com.jxdinfo.document.excel.tools.common.datasource.model.ReportToolTemplateDataSource;
import com.jxdinfo.document.excel.tools.common.datasource.service.DataSourceCustomService;
import com.jxdinfo.document.excel.tools.common.datasource.service.DataSourceService;
import com.jxdinfo.document.excel.tools.common.datasource.service.ExcelReportDataSourceService;
import com.jxdinfo.document.excel.tools.core.common.reportEnum.ReportStatusEnum;
import com.jxdinfo.document.excel.tools.core.common.utils.ELNUtil;
import com.jxdinfo.document.excel.tools.core.common.utils.ReportUtil;
import com.jxdinfo.document.excel.tools.core.common.utils.YMLUtils;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.repository.init.ResourceReader;
import org.springframework.stereotype.Service;

@Service(value="excel.tools.common.datasource.service.impl.reportToolTemplateDataSourceCustomService")
@HussarDs(value="master")
public class DataSourceCustomServiceImpl
implements DataSourceCustomService {
    @Autowired
    private DataSourceMapper dataSourceMapper;
    @Autowired
    private DataSourceService dataSourceService;
    @Resource
    private ISysDicRefService sysDicRefService;
    @Autowired
    private DataSource dataSource;
    @Autowired
    private ExcelReportDataSourceService excelReportDataSourceService;

    @Override
    public JSONObject getElnData(JSONObject elnParam) {
        return DataSourceCustomServiceImpl.executeElnInterface(elnParam);
    }

    @Override
    public List<ReportToolTemplateDataSource> getListByBusinessId(String businessId) {
        QueryWrapper ew = new QueryWrapper();
        ew.lambda().eq(ReportToolTemplateDataSource::getTemplateId, (Object)businessId);
        ew.lambda().orderByAsc(ReportToolTemplateDataSource::getCreateTime);
        return this.dataSourceMapper.selectList((Wrapper)ew);
    }

    @Override
    public void saveOrUpdateByBusinessId(String businessId, List<ReportToolTemplateDataSource> reportToolTemplateDataSourceList) {
        if (businessId == null || CollectionUtils.isEmpty(reportToolTemplateDataSourceList)) {
            return;
        }
        this.deleteByBusinessId(businessId);
        this.copyByBusinessId(businessId, reportToolTemplateDataSourceList);
    }

    @Override
    public void copyByBusinessId(String businessId, List<ReportToolTemplateDataSource> reportToolTemplateDataSourceList) {
        if (businessId == null || CollectionUtils.isEmpty(reportToolTemplateDataSourceList)) {
            return;
        }
        for (ReportToolTemplateDataSource reportTemplateDataSource : reportToolTemplateDataSourceList) {
            reportTemplateDataSource.setTemplateId(businessId);
            reportTemplateDataSource.setId(IdWorker.get32UUID());
        }
        this.dataSourceService.saveOrUpdateBatch(reportToolTemplateDataSourceList);
    }

    @Override
    public void deleteByBusinessId(String businessId) {
        List<ReportToolTemplateDataSource> reportToolTemplateDataSourceList = this.getListByBusinessId(businessId);
        if (CollectionUtils.isEmpty(reportToolTemplateDataSourceList)) {
            return;
        }
        this.dataSourceService.removeByIds(reportToolTemplateDataSourceList.stream().map(ReportToolTemplateDataSource::getId).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    @Override
    public String getSyncDataTemplateDataSourceId(List<ReportToolTemplateDataSource> reportToolTemplateDataSourceList) {
        if (CollectionUtils.isEmpty(reportToolTemplateDataSourceList)) {
            return "";
        }
        ReportToolTemplateDataSource syncDataTemplateDataSource = reportToolTemplateDataSourceList.stream().filter(dataSource -> dataSource.getContent() != null && dataSource.getContent().contains("ElnData")).findFirst().orElse(new ReportToolTemplateDataSource());
        return syncDataTemplateDataSource.getId();
    }

    @Override
    public ApiResponse<Map<String, Object>> getDataSourceList(Map<String, Object> param) {
        String templateId = String.valueOf(param.get(ReportStatusEnum.PARAM_TEMPLATE_ID.getValue()));
        List dictTypeList = (List)param.get(ReportStatusEnum.PARAM_DICT_TYPE.getValue());
        List<ReportToolTemplateDataSource> reportTemplateDataSourceList = this.getListByBusinessId(templateId);
        ArrayList baseDataList = new ArrayList();
        ArrayList extendDataList = new ArrayList();
        List signImgAnsList = new ArrayList();
        List qrCodeImgAnsList = new ArrayList();
        ArrayList compInsertPointList = new ArrayList();
        ArrayList recordFragmentList = new ArrayList();
        ArrayList dynamicRCCompList = new ArrayList();
        for (int i = 0; i < dictTypeList.size(); ++i) {
            String dictType = (String)dictTypeList.get(i);
            if (dictType.isEmpty()) continue;
            if (dictType.equals("sign_img_str")) {
                signImgAnsList = this.sysDicRefService.getDictByType(dictType);
                continue;
            }
            if (!dictType.equals("qr_code_img_str")) continue;
            qrCodeImgAnsList = this.sysDicRefService.getDictByType(dictType);
        }
        if (reportTemplateDataSourceList.isEmpty()) {
            HashMap ans = new HashMap();
            ans.put(ReportStatusEnum.PARAM_REPORT_DATA_SOURCE_BASE_DATA.getValue(), baseDataList);
            ans.put(ReportStatusEnum.PARAM_REPORT_DATA_SOURCE_EXTEND_DATA.getValue(), extendDataList);
            ans.put(ReportStatusEnum.PARAM_REPORT_DATA_SOURCE_SIGN_IMG_DATA.getValue(), signImgAnsList);
            ans.put(ReportStatusEnum.PARAM_REPORT_DATA_SOURCE_QR_CODE_IMG_DATA.getValue(), qrCodeImgAnsList);
            ans.put(ReportStatusEnum.PARAM_REPORT_INSERT_POINT_LIST.getValue(), compInsertPointList);
            ans.put(ReportStatusEnum.PARAM_REPORT_RECORD_FRAGMENT_LIST.getValue(), recordFragmentList);
            ans.put(ReportStatusEnum.PARAM_REPORT_DYNAMICRCCOMP_LIST.getValue(), dynamicRCCompList);
            return ApiResponse.success(ans, (String)"\u6570\u636e\u6e90\u4e3a\u7a7a");
        }
        for (ReportToolTemplateDataSource reportToolTemplateDataSource : reportTemplateDataSourceList) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(ReportStatusEnum.PARAM_SOURCE_ID.getValue(), reportToolTemplateDataSource.getId());
            map.put(ReportStatusEnum.PARAM_SOURCE_NAME.getValue(), reportToolTemplateDataSource.getName());
            map.put(ReportStatusEnum.PARAM_SOURCE_CONTENT.getValue(), reportToolTemplateDataSource.getContent());
            map.put(ReportStatusEnum.PARAM_SOURCE_INPARAMETER.getValue(), reportToolTemplateDataSource.getInParameter());
            String type = reportToolTemplateDataSource.getType();
            map.put(ReportStatusEnum.PARAM_SOURCE_TYPE.getValue(), type);
            map.put(ReportStatusEnum.PARAM_ACCESS_METHOD.getValue(), reportToolTemplateDataSource.getAccessMethod());
            String baseExtendType = reportToolTemplateDataSource.getBaseExtendType();
            map.put(ReportStatusEnum.PARAM_REPORT_DATA_SOURCE_BASE_EXTEND_TYPE.getValue(), baseExtendType);
            map.put(ReportStatusEnum.PARAM_SOURCE_DYNAMICRCCOMP_RANGE.getValue(), reportToolTemplateDataSource.getDynamicRcCompRange());
            if (StringUtils.isEmpty((CharSequence)reportToolTemplateDataSource.getExampleParameter())) {
                map.put(ReportStatusEnum.PARAM_SOURCE_EXAMPLE_PARAMETER.getValue(), "{}");
            } else {
                map.put(ReportStatusEnum.PARAM_SOURCE_EXAMPLE_PARAMETER.getValue(), reportToolTemplateDataSource.getExampleParameter());
            }
            if (StringUtils.isEmpty((CharSequence)reportToolTemplateDataSource.getInParameter())) {
                map.put(ReportStatusEnum.PARAM_SOURCE_INPARAMETER.getValue(), "{}");
            } else {
                map.put(ReportStatusEnum.PARAM_SOURCE_INPARAMETER.getValue(), reportToolTemplateDataSource.getInParameter());
            }
            if (StringUtils.isEmpty((CharSequence)reportToolTemplateDataSource.getExampleData())) {
                map.put(ReportStatusEnum.PARAM_SOURCE_EXAMPLE_EXAMPLE_DATA.getValue(), "{}");
            } else {
                map.put(ReportStatusEnum.PARAM_SOURCE_EXAMPLE_EXAMPLE_DATA.getValue(), reportToolTemplateDataSource.getExampleData());
            }
            if (baseExtendType.equals(ReportStatusEnum.PARAM_SOURCE_TYPE_BASE.getValue())) {
                baseDataList.add(map);
                continue;
            }
            if (baseExtendType.equals(ReportStatusEnum.PARAM_SOURCE_TYPE_EXTEND.getValue())) {
                extendDataList.add(map);
                continue;
            }
            if (baseExtendType.equals(ReportStatusEnum.PARAM_SOURCE_TYPE_COMP_INSERT_POINT.getValue())) {
                compInsertPointList.add(map);
                continue;
            }
            if (baseExtendType.equals(ReportStatusEnum.PARAM_SOURCE_TYPE_RECORD_FRAGMENT.getValue())) {
                recordFragmentList.add(map);
                continue;
            }
            if (!baseExtendType.equals(ReportStatusEnum.PARAM_SOURCE_TYPE_DYNAMICRCCOMP.getValue())) continue;
            dynamicRCCompList.add(map);
        }
        HashMap ans = new HashMap();
        ans.put(ReportStatusEnum.PARAM_REPORT_DATA_SOURCE_BASE_DATA.getValue(), baseDataList);
        ans.put(ReportStatusEnum.PARAM_REPORT_DATA_SOURCE_EXTEND_DATA.getValue(), extendDataList);
        ans.put(ReportStatusEnum.PARAM_REPORT_DATA_SOURCE_SIGN_IMG_DATA.getValue(), signImgAnsList);
        ans.put(ReportStatusEnum.PARAM_REPORT_DATA_SOURCE_QR_CODE_IMG_DATA.getValue(), qrCodeImgAnsList);
        ans.put(ReportStatusEnum.PARAM_REPORT_INSERT_POINT_LIST.getValue(), compInsertPointList);
        ans.put(ReportStatusEnum.PARAM_REPORT_RECORD_FRAGMENT_LIST.getValue(), recordFragmentList);
        ans.put(ReportStatusEnum.PARAM_REPORT_DYNAMICRCCOMP_LIST.getValue(), dynamicRCCompList);
        return ApiResponse.success((Object)ans);
    }

    @Override
    public ApiResponse<Map<String, Object>> saveDataSource(Map<String, Object> param) {
        String id = String.valueOf(param.get(ReportStatusEnum.PARAM_SOURCE_ID.getValue()));
        String templateId = String.valueOf(param.get(ReportStatusEnum.PARAM_TEMPLATE_ID.getValue()));
        String type = String.valueOf(param.get(ReportStatusEnum.PARAM_SOURCE_TYPE.getValue()));
        String accessMethod = String.valueOf(param.get(ReportStatusEnum.PARAM_ACCESS_METHOD.getValue()));
        String content = String.valueOf(param.get(ReportStatusEnum.PARAM_SOURCE_CONTENT.getValue()));
        String inParameter = String.valueOf(param.get(ReportStatusEnum.PARAM_SOURCE_INPARAMETER.getValue()));
        String exampleParameter = String.valueOf(param.get(ReportStatusEnum.PARAM_SOURCE_EXAMPLE_PARAMETER.getValue()));
        String exampleData = String.valueOf(param.get(ReportStatusEnum.PARAM_SOURCE_EXAMPLE_EXAMPLE_DATA.getValue()));
        Object baseExtendType = param.get(ReportStatusEnum.PARAM_REPORT_DATA_SOURCE_BASE_EXTEND_TYPE.getValue());
        String name = String.valueOf(param.get(ReportStatusEnum.PARAM_SOURCE_NAME.getValue()));
        String range = String.valueOf(param.get(ReportStatusEnum.PARAM_SOURCE_DYNAMICRCCOMP_RANGE.getValue()));
        ReportToolTemplateDataSource reportToolTemplateDataSource = new ReportToolTemplateDataSource();
        if (StringUtils.isNotEmpty((CharSequence)id)) {
            reportToolTemplateDataSource.setId(id);
        } else {
            reportToolTemplateDataSource.setId(String.valueOf(IdWorker.getId((Object)new Date())));
            reportToolTemplateDataSource.setCreateTime(LocalDateTime.now());
        }
        reportToolTemplateDataSource.setName(name);
        reportToolTemplateDataSource.setExampleData(exampleData);
        reportToolTemplateDataSource.setExampleParameter(exampleParameter);
        reportToolTemplateDataSource.setContent(content);
        reportToolTemplateDataSource.setInParameter(inParameter);
        reportToolTemplateDataSource.setAccessMethod(accessMethod);
        reportToolTemplateDataSource.setType(type);
        reportToolTemplateDataSource.setTemplateId(templateId);
        SecurityUser user = BaseSecurityUtil.getUser();
        if (user != null) {
            reportToolTemplateDataSource.setCreateId(user.getId().toString());
            reportToolTemplateDataSource.setCreateName(user.getUserName());
        } else {
            user = (SecurityUser)param.get("user");
            reportToolTemplateDataSource.setCreateId(user.getId().toString());
            reportToolTemplateDataSource.setCreateName(user.getUserName());
        }
        reportToolTemplateDataSource.setDynamicRcCompRange(range);
        if (ObjectUtils.isEmpty((Object)baseExtendType)) {
            reportToolTemplateDataSource.setBaseExtendType(ReportStatusEnum.PARAM_SOURCE_TYPE_EXTEND.getValue());
        } else {
            reportToolTemplateDataSource.setBaseExtendType(String.valueOf(baseExtendType));
        }
        if (this.dataSourceService.saveOrUpdate(reportToolTemplateDataSource)) {
            return ApiResponse.success();
        }
        return ApiResponse.fail((String)ReportStatusEnum.RETURN_CODE_MINUS_ONE.getDescription());
    }

    @Override
    public ApiResponse<Map<String, Object>> delDataSource(Map<String, Object> param) {
        String id = String.valueOf(param.get(ReportStatusEnum.PARAM_SOURCE_ID.getValue()));
        boolean b = this.dataSourceService.removeById((Serializable)((Object)id));
        if (b) {
            return ApiResponse.success();
        }
        return ApiResponse.fail((String)"\u5931\u8d25");
    }

    @Override
    public ApiResponse<Map<String, Object>> getExampleData(Map<String, Object> param) {
        String type = String.valueOf(param.get(ReportStatusEnum.PARAM_SOURCE_TYPE.getValue()));
        String exampleParameter = String.valueOf(param.get(ReportStatusEnum.PARAM_SOURCE_EXAMPLE_PARAMETER.getValue()));
        String content = String.valueOf(param.get(ReportStatusEnum.PARAM_SOURCE_CONTENT.getValue()));
        if (type.equals(ReportStatusEnum.PARAM_SOURCE_TYPE_SQL.getValue())) {
            String sql = ReportUtil.replaceSqlPlaceholders((String)content, (String)exampleParameter);
            if (sql.startsWith(ReportStatusEnum.SOURCE_REST_REQUEST_ERROR.getValue())) {
                String[] split = sql.split(",");
                String code = split[1];
                if (code.equals(ReportStatusEnum.RETURN_CODE_MINUS_TWO.getValue())) {
                    return ApiResponse.fail((String)ReportStatusEnum.RETURN_CODE_MINUS_TWO.getDescription());
                }
                if (code.equals(ReportStatusEnum.RETURN_CODE_MINUS_THREE.getValue())) {
                    return ApiResponse.fail((String)ReportStatusEnum.RETURN_CODE_MINUS_THREE.getDescription());
                }
                if (code.equals(ReportStatusEnum.RETURN_CODE_MINUS_FOUR.getValue())) {
                    return ApiResponse.fail((String)ReportStatusEnum.RETURN_CODE_MINUS_FOUR.getDescription());
                }
                if (code.equals(ReportStatusEnum.RETURN_CODE_MINUS_FIVE.getValue())) {
                    return ApiResponse.fail((String)ReportStatusEnum.RETURN_CODE_MINUS_FIVE.getDescription());
                }
            }
            ArrayList<String> sqlList = new ArrayList<String>();
            sqlList.add(sql);
            List maps = ReportUtil.doBatchSql(sqlList, (DataSource)this.dataSource);
            ArrayList<Map> ansList = new ArrayList<Map>();
            for (Map map : maps) {
                if (map.containsKey(ReportStatusEnum.RETURN_CODE_MINUS_SIX.getValue())) {
                    return ApiResponse.fail((int)ReportStatusEnum.RETURN_CODE_MINUS_SIX.getCode(), (String)String.valueOf(map.get(ReportStatusEnum.RETURN_CODE_MINUS_SIX.getValue())));
                }
                for (Map.Entry entry : map.entrySet()) {
                    String k = (String)entry.getKey();
                    Object vObj = entry.getValue();
                    if (vObj instanceof Map) {
                        Map dataMap = (Map)vObj;
                        ansList.add(dataMap);
                        continue;
                    }
                    if (!(vObj instanceof List)) continue;
                    List dataMapList = (List)vObj;
                    for (Map e : dataMapList) {
                        ansList.add(e);
                    }
                }
            }
            HashMap<String, ArrayList<Map>> ans = new HashMap<String, ArrayList<Map>>();
            ans.put("dataList", ansList);
            return ApiResponse.success(ans);
        }
        if (type.equals(ReportStatusEnum.PARAM_SOURCE_TYPE_REST.getValue())) {
            String accessMethod = String.valueOf(param.get(ReportStatusEnum.PARAM_ACCESS_METHOD.getValue()));
            if (accessMethod.equals(ReportStatusEnum.SOURCE_REST_REQUEST_GET.getValue())) {
                JSONObject jsonObject;
                JSONObject exampleParameterObj = (JSONObject)JSONObject.parse((String)exampleParameter);
                String json = ReportUtil.getJson((JSONObject)exampleParameterObj, (String)content);
                Object jsonObj = JSONObject.parse((String)json);
                if (jsonObj instanceof JSONObject && (jsonObject = (JSONObject)jsonObj).containsKey((Object)ReportStatusEnum.SOURCE_REST_REQUEST_ERROR.getValue())) {
                    return ApiResponse.fail((String)ReportStatusEnum.SOURCE_REST_REQUEST_ERROR.getDescription());
                }
                HashMap<String, String> ans = new HashMap<String, String>();
                ans.put("data", json);
                return ApiResponse.success(ans);
            }
            if (accessMethod.equals(ReportStatusEnum.SOURCE_REST_REQUEST_POST.getValue())) {
                JSONObject jsonObject;
                JSONObject exampleParameterObj = (JSONObject)JSONObject.parse((String)exampleParameter);
                String json = ReportUtil.postJson((JSONObject)exampleParameterObj, (String)content);
                Object jsonObj = JSONObject.parse((String)json);
                if (jsonObj instanceof JSONObject && (jsonObject = (JSONObject)jsonObj).containsKey((Object)ReportStatusEnum.SOURCE_REST_REQUEST_ERROR.getValue())) {
                    return ApiResponse.fail((String)ReportStatusEnum.SOURCE_REST_REQUEST_ERROR.getDescription());
                }
                HashMap<String, String> ans = new HashMap<String, String>();
                ans.put("data", json);
                return ApiResponse.success(ans);
            }
            return ApiResponse.fail((String)"\u672a\u4f20\u9012\u8bf7\u6c42\u7c7b\u578b");
        }
        return ApiResponse.fail((String)"\u672a\u4f20\u9012\u6570\u636e\u6e90\u7c7b\u578b");
    }

    @Override
    public ApiResponse<Map<String, Object>> templateComponentDrag(Map<String, Object> param) {
        try {
            String templateId = param.get("templateId").toString();
            String componentId = param.get("componentId").toString();
            Object isAsCompInsertPoint = param.get("isAsCompInsertPoint");
            if (isAsCompInsertPoint != null && ((Boolean)isAsCompInsertPoint).booleanValue()) {
                String singleCompName = param.get("singleCompName").toString();
                ReportToolTemplateDataSource reportToolTemplateDataSource = new ReportToolTemplateDataSource();
                reportToolTemplateDataSource.setId(IdWorker.getIdStr((Object)new Date()));
                reportToolTemplateDataSource.setTemplateId(templateId);
                reportToolTemplateDataSource.setType("singleComp");
                reportToolTemplateDataSource.setBaseExtendType("compInsertPoint");
                reportToolTemplateDataSource.setName(singleCompName);
                reportToolTemplateDataSource.setContent(componentId);
                reportToolTemplateDataSource.setCreateId(BaseSecurityUtil.getUser().getId().toString());
                reportToolTemplateDataSource.setCreateName(BaseSecurityUtil.getUser().getUserName());
                reportToolTemplateDataSource.setCreateTime(LocalDateTime.now());
                int insertRes = this.dataSourceMapper.insert(reportToolTemplateDataSource);
                if (insertRes > 0) {
                    return ApiResponse.success((String)"\u65b0\u589e\u7ec4\u4ef6\u6570\u636e\u6e90\u6210\u529f");
                }
                return ApiResponse.fail((String)"\u65b0\u589e\u7ec4\u4ef6\u6570\u636e\u6e90\u5931\u8d25");
            }
            List<ReportToolTemplateDataSource> compDataSourceList = this.excelReportDataSourceService.getListByTemplateIdAndTypes(componentId, null);
            if (compDataSourceList == null || compDataSourceList.size() == 0) {
                HashMap<String, Integer> map = new HashMap<String, Integer>();
                map.put("code", -1);
                return ApiResponse.success(map, (String)"\u7ec4\u4ef6\u6570\u636e\u6e90\u4e3a\u7a7a");
            }
            ArrayList<Integer> insertResList = new ArrayList<Integer>();
            for (ReportToolTemplateDataSource reportToolTemplateDataSource : compDataSourceList) {
                String dataSourceId = IdWorker.getIdStr((Object)new Date());
                reportToolTemplateDataSource.setId(dataSourceId);
                reportToolTemplateDataSource.setTemplateId(templateId);
                int insertRes = this.dataSourceMapper.insert(reportToolTemplateDataSource);
                if (insertRes <= 0) continue;
                insertResList.add(insertRes);
            }
            if (insertResList.size() == compDataSourceList.size()) {
                return ApiResponse.success((String)"\u65b0\u589e\u7ec4\u4ef6\u6570\u636e\u6e90\u6210\u529f");
            }
            return ApiResponse.fail((String)"\u65b0\u589e\u7ec4\u4ef6\u90e8\u5206\u6570\u636e\u6e90\u5931\u8d25");
        }
        catch (Exception e) {
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    private static JSONObject executeElnInterface(JSONObject elnParam) {
        Object useTestElnDataJson = YMLUtils.getValue((String)"application.yml", (String)"useTestElnDataJson");
        if (useTestElnDataJson != null && ((Boolean)useTestElnDataJson).booleanValue()) {
            try {
                InputStream inputStream = ResourceReader.class.getClassLoader().getResourceAsStream("test/testElnData.json");
                if (inputStream != null) {
                    String fileContent = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                    return ELNUtil.convertElnItemData((JSONObject)JSONObject.parseObject((String)fileContent));
                }
                return null;
            }
            catch (IOException ioException) {
                ioException.printStackTrace();
                return null;
            }
        }
        Map elnPath = (Map)YMLUtils.getValue((String)"application.yml", (String)"elnPath");
        String elnBackPath = String.valueOf(elnPath.get("backPath"));
        String elnUrl = elnBackPath + "/eln/api/getAnalysisDataForReport";
        String resStr = ReportUtil.postJson((JSONObject)elnParam, (String)elnUrl);
        JSONObject resJson = JSONObject.parseObject((String)resStr);
        if (!resJson.getBooleanValue("success")) {
            return null;
        }
        return ELNUtil.convertElnItemData((JSONObject)resJson.getJSONObject("data"));
    }
}

