/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.eln.back.util.excel;

import com.jxdinfo.document.eln.back.util.excel.ElnTableUtil;
import com.jxdinfo.document.eln.back.vo.eln.ElnCellVo;
import com.jxdinfo.document.eln.back.vo.eln.ElnColWidthVo;
import com.jxdinfo.document.eln.back.vo.eln.ElnOldNewRIdxVo;
import com.jxdinfo.document.eln.back.vo.eln.ElnOldRowConnVo;
import com.jxdinfo.document.eln.back.vo.eln.ElnSheetDataParsingVo;
import com.jxdinfo.document.eln.back.vo.eln.ElnTableRow;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class ElnRowColUtil {
    public static int getNrn(ElnSheetDataParsingVo processDataInfo, int oldRowIdx) {
        ElnOldNewRIdxVo oldNewRIdx = processDataInfo.getOldOrNewRIdx();
        Map<Integer, ElnOldRowConnVo> oldList = oldNewRIdx.getOld();
        if (oldRowIdx < oldList.size()) {
            return oldList.get(oldRowIdx).getNewRowIndex();
        }
        return oldList.get(oldRowIdx).getNewRowIndex() + 1;
    }

    public static List<ElnTableRow> getParsingElnData(List<ElnTableRow> contentRows, int totalCols, boolean mulTableToHCenter, Integer colIdx, Integer rowLen) {
        ArrayList<ElnTableRow> cellData = new ArrayList<ElnTableRow>();
        List<List<ElnTableRow>> tableList = ElnTableUtil.analyzeTable(contentRows);
        for (List<ElnTableRow> tableData : tableList) {
            List<ElnColWidthVo> colWidth = ElnRowColUtil.getRealColWidth(tableData, totalCols, mulTableToHCenter);
            List<ElnTableRow> rowData = ElnRowColUtil.calcCellWidth(tableData, colWidth, mulTableToHCenter, totalCols, colIdx, rowLen);
            cellData.addAll(rowData);
        }
        return cellData;
    }

    public static List<ElnColWidthVo> getRealColWidth(List<ElnTableRow> rowData, int totalCols, boolean mulTableToHCenter) {
        ArrayList<ElnColWidthVo> colWidth = new ArrayList<ElnColWidthVo>();
        int currentCols = 0;
        int colWidthNum = 0;
        for (int i = 0; i < rowData.size(); ++i) {
            List<ElnCellVo> percentages = rowData.get(i).getCells();
            int colIndex = 0;
            for (int j = 0; j < percentages.size(); ++j) {
                ElnCellVo cell;
                int col;
                if (j > 0) {
                    ++colIndex;
                }
                int n = col = (cell = percentages.get(j)).getCols() == 0 ? 1 : cell.getCols();
                if (i == 0) {
                    colWidthNum += col;
                }
                if (col == 1) {
                    while (colWidth.size() <= colIndex) {
                        colWidth.add(null);
                    }
                    if (colWidth.get(colIndex) != null && ((ElnColWidthVo)colWidth.get(colIndex)).isTrue()) continue;
                    double percentage = 0.0;
                    try {
                        String width = cell.getWidth();
                        if (StringUtils.isNotBlank((CharSequence)width)) {
                            width = width.replace("\\%", "").replace("%", "");
                        }
                        percentage = Double.parseDouble(width == null ? "0" : width);
                    }
                    catch (NumberFormatException e) {
                        System.err.println("\u89e3\u6790\u5bbd\u5ea6\u767e\u5206\u6bd4\u5931\u8d25: " + cell.getWidth());
                    }
                    int calculatedCols = mulTableToHCenter ? (int)Math.floor((double)totalCols * (percentage / 100.0)) : Math.round((float)((double)totalCols * (percentage / 100.0)));
                    colWidth.set(colIndex, new ElnColWidthVo(calculatedCols, true, colIndex));
                    currentCols += calculatedCols;
                    continue;
                }
                if (col <= 1) continue;
                for (int k = 0; k < col; ++k) {
                    if (k > 0) {
                        ++colIndex;
                    }
                    while (colWidth.size() <= colIndex) {
                        colWidth.add(null);
                    }
                    if (colWidth.get(colIndex) != null && ((ElnColWidthVo)colWidth.get(colIndex)).isTrue()) continue;
                    colWidth.set(colIndex, new ElnColWidthVo(0, false, colIndex));
                }
            }
        }
        if (colWidthNum != colWidth.size()) {
            System.out.println("\u4f20\u5165\u7684\u6570\u636e\u6e90\u5217\u4e0d\u6b63\u786e\uff01");
        }
        if (mulTableToHCenter) {
            return colWidth;
        }
        if (currentCols != totalCols) {
            ElnRowColUtil.correctionColumnWidth(totalCols, currentCols, colWidth);
        }
        return colWidth;
    }

    public static void correctionColumnWidth(int totalCols, int currentCols, List<ElnColWidthVo> colWidth) {
        List noWidthColumns = colWidth.stream().filter(col -> !col.isTrue()).collect(Collectors.toList());
        int noWidthCount = noWidthColumns.size();
        int surplusCount = totalCols - currentCols;
        if (noWidthCount == 0) {
            for (int i = 0; i < colWidth.size() && surplusCount != 0; surplusCount += surplusCount > 0 ? -1 : 1, ++i) {
                ElnColWidthVo col2 = colWidth.get(i);
                col2.setColNum(col2.getColNum() + (surplusCount > 0 ? 1 : -1));
            }
        } else {
            int baseWidth = surplusCount / noWidthCount;
            int remainingWidth = surplusCount % noWidthCount;
            for (int i = 0; i < noWidthColumns.size(); ++i) {
                ElnColWidthVo col3 = (ElnColWidthVo)noWidthColumns.get(i);
                int colNum = baseWidth + (i < remainingWidth ? 1 : 0);
                col3.setColNum(colNum);
            }
        }
    }

    public static List<ElnTableRow> calcCellWidth(List<ElnTableRow> rowsData, List<ElnColWidthVo> colWidth, boolean mulTableToHCenter, int totalCols, Integer colIdx, Integer rowLen) {
        int colOffset = 0;
        if (mulTableToHCenter) {
            int currentCols = 0;
            for (ElnColWidthVo item : colWidth) {
                currentCols += item.getColNum() <= 0 ? 1 : item.getColNum();
            }
            colOffset = ElnRowColUtil.getMulTableToHCenterColOffset(currentCols, totalCols, colIdx, rowLen);
        }
        for (ElnTableRow row : rowsData) {
            if (mulTableToHCenter) {
                row.setColOffset(colOffset);
            }
            List<ElnCellVo> cells = row.getCells();
            int colIndex = 0;
            for (int j = 0; j < cells.size(); ++j) {
                int col;
                ElnCellVo cell = cells.get(j);
                int n = col = cell.getCols() == 0 ? 1 : cell.getCols();
                if (j > 0) {
                    ++colIndex;
                }
                if (colWidth.size() <= colIndex || colWidth.get(colIndex).getColNum() <= 0) continue;
                if (col == 1) {
                    cell.setCols(colWidth.get(colIndex).getColNum());
                    continue;
                }
                int colNum = 0;
                for (int k = 0; k < col; ++k) {
                    if (k > 0) {
                        ++colIndex;
                    }
                    if (colWidth.size() <= colIndex) continue;
                    colNum += colWidth.get(colIndex).getColNum() <= 0 ? 1 : colWidth.get(colIndex).getColNum();
                }
                cell.setCols(colNum);
            }
        }
        return rowsData;
    }

    public static int getMulTableToHCenterColOffset(int currentCols, int totalCols, Integer colIdx, Integer rowLen) {
        int colOffset = 0;
        if (currentCols < totalCols) {
            colOffset = (totalCols - currentCols) / 2;
        } else if (currentCols > totalCols) {
            if (currentCols >= rowLen) {
                colOffset = -colIdx.intValue();
            } else {
                int colNum = (rowLen - currentCols) / 2;
                colOffset = colNum - colIdx;
            }
        }
        return colOffset;
    }
}

