/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.eln.back.util.excel;

import com.jxdinfo.document.eln.back.util.DeepCloneUtil;
import com.jxdinfo.document.eln.back.util.RandomStringUtil;
import com.jxdinfo.document.eln.back.util.StyleEqualsUtil;
import com.jxdinfo.document.eln.back.vo.univer.IStyleDataVo;
import java.util.HashMap;
import java.util.Map;

public class ElnAssistanceUtil {
    public static String subStrExp(String exp) {
        String phStart = "#{";
        String phEnd = "}";
        return exp.substring("#{".length(), exp.length() - "}".length());
    }

    @SafeVarargs
    public static <T> T getFirstNotNull(T ... values) {
        for (T value : values) {
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public static Map<String, Object> createTextDecorationStyle(Object decorationObj, String type) {
        HashMap<String, Object> decorationMap = new HashMap<String, Object>();
        decorationMap.put("s", 1);
        decorationMap.put("c", 1);
        HashMap<String, String> colorMap = new HashMap<String, String>();
        colorMap.put("rgb", "#000000");
        decorationMap.put("cl", colorMap);
        decorationMap.put("t", 0);
        return decorationMap;
    }

    public static String generateStyleKey(IStyleDataVo cStyle, Map<String, IStyleDataVo> oldStyles) {
        if (oldStyles == null) {
            return RandomStringUtil.generateAlphanumeric(8);
        }
        for (Map.Entry<String, IStyleDataVo> entry : oldStyles.entrySet()) {
            IStyleDataVo existingStyle = entry.getValue();
            if (!StyleEqualsUtil.isStyleEqual(existingStyle, cStyle)) continue;
            return entry.getKey();
        }
        String styleKey = RandomStringUtil.generateAlphanumeric(8);
        oldStyles.put(styleKey, DeepCloneUtil.deepClone(cStyle));
        return styleKey;
    }
}

