/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.eln.back.util.excel;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.core.type.TypeReference;
import com.jxdinfo.document.eln.back.util.JsonUtil;
import com.jxdinfo.document.eln.back.util.excel.ElnAssistanceUtil;
import com.jxdinfo.document.eln.back.util.excel.ElnExcelUtil;
import com.jxdinfo.document.eln.back.vo.eln.ElnOldRowConnVo;
import com.jxdinfo.document.eln.back.vo.univer.ICellDataVo;
import com.jxdinfo.document.eln.back.vo.univer.IWorksheetDataVo;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class ElnSheetUtil {
    private static final List<String> RICH_TEXT_TYPES = Arrays.asList("richTxtStepper", "editGrid", "sheet");

    public static Map<Integer, ElnOldRowConnVo> analysisRows(Map<Integer, Map<Integer, ICellDataVo>> cellData, IWorksheetDataVo worksheetData, Map<String, Object> dataSetMap) {
        HashMap<Integer, ElnOldRowConnVo> result = new HashMap<Integer, ElnOldRowConnVo>();
        if (cellData == null || cellData.isEmpty() || worksheetData == null || dataSetMap == null) {
            return result;
        }
        Map<Integer, Map<Integer, ICellDataVo>> sheetCellData = worksheetData.getCellData();
        if (sheetCellData == null || sheetCellData.isEmpty()) {
            return result;
        }
        block0: for (Map.Entry<Integer, Map<Integer, ICellDataVo>> rowEntry : cellData.entrySet()) {
            Integer rIdx = rowEntry.getKey();
            Map<Integer, ICellDataVo> rowCells = rowEntry.getValue();
            if (rowCells == null || rowCells.isEmpty()) continue;
            boolean foundMatchColumn = false;
            for (Map.Entry<Integer, ICellDataVo> cellEntry : rowCells.entrySet()) {
                String exp;
                Object cellModel;
                String matchType;
                Integer cIdx = cellEntry.getKey();
                ICellDataVo cell = cellEntry.getValue();
                String template = ElnSheetUtil.getValidTemplate(cell);
                if (template == null || (matchType = ElnSheetUtil.matchTargetComponentType(cellModel = ElnExcelUtil.getDataModelByExp(dataSetMap, exp = ElnAssistanceUtil.subStrExp(template)))) == null) continue;
                ElnOldRowConnVo rowConnVo = new ElnOldRowConnVo();
                rowConnVo.setCIdx(cIdx);
                rowConnVo.setType(matchType);
                result.put(rIdx, rowConnVo);
                foundMatchColumn = true;
                continue block0;
            }
        }
        return result;
    }

    public static String getValidTemplate(ICellDataVo cell) {
        Map<String, Object> customMap;
        if (cell == null) {
            return null;
        }
        Map<String, Object> custom = cell.getCustom();
        if (ObjectUtils.isEmpty(custom)) {
            return null;
        }
        try {
            customMap = JsonUtil.convertValue(custom, new TypeReference<Map<String, Object>>(){});
        }
        catch (Exception e) {
            return null;
        }
        Object templateObj = customMap.get("template");
        if (templateObj == null) {
            return null;
        }
        String template = templateObj.toString();
        if (StringUtils.isNotBlank((CharSequence)template) && template.contains("eln_")) {
            return template.trim();
        }
        return null;
    }

    public static String matchTargetComponentType(Object cellModel) {
        String jsonStr;
        JSONObject component;
        String type;
        if (cellModel instanceof List) {
            List modelList = (List)cellModel;
            if (!modelList.isEmpty()) {
                for (Object model : modelList) {
                    String jsonStr2 = JsonUtil.asJSONString(model);
                    JSONObject component2 = JSON.parseObject((String)jsonStr2);
                    String type2 = component2.getString("type");
                    if (!RICH_TEXT_TYPES.contains(type2)) continue;
                    return type2;
                }
            }
        } else if (cellModel instanceof JSONObject) {
            JSONObject firstComponent = (JSONObject)cellModel;
            String type3 = firstComponent.getString("type");
            if (RICH_TEXT_TYPES.contains(type3)) {
                return type3;
            }
        } else if (cellModel instanceof Map && RICH_TEXT_TYPES.contains(type = (component = JSON.parseObject((String)(jsonStr = JsonUtil.asJSONString(cellModel)))).getString("type"))) {
            return type;
        }
        return null;
    }
}

