/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.eln.back.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;

public class JsonUtil {
    private static final ObjectMapper mapper = new ObjectMapper();

    public static String asJSONString(Object entity) {
        try {
            return mapper.writeValueAsString(entity);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T dataToJson(String json, Class<T> clazz) {
        try {
            return (T)mapper.readValue(json, clazz);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Object convertValue(Object entity, Class<?> clazz) {
        try {
            return mapper.convertValue(entity, clazz);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T convertValue(Object entity, TypeReference<T> typeReference) {
        try {
            if (entity instanceof String) {
                return (T)mapper.readValue((String)entity, typeReference);
            }
            return (T)mapper.convertValue(entity, typeReference);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isValidJson(String jsonString) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            JsonNode rootNode = mapper.readTree(jsonString);
            return true;
        }
        catch (JsonProcessingException e) {
            return false;
        }
    }

    static {
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
    }
}

