/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.eln.back.util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.jxdinfo.document.eln.back.util.DeepCloneUtil;
import com.jxdinfo.document.eln.back.util.FileUtil;
import com.jxdinfo.document.eln.back.util.JsonUtil;
import com.jxdinfo.document.eln.back.util.excel.ElnAfterUtil;
import com.jxdinfo.document.eln.back.util.excel.ElnAssistanceUtil;
import com.jxdinfo.document.eln.back.util.excel.ElnConnHandler;
import com.jxdinfo.document.eln.back.util.excel.ElnExcelUtil;
import com.jxdinfo.document.eln.back.util.excel.ElnSheetUtil;
import com.jxdinfo.document.eln.back.util.excel.ElnTableUtil;
import com.jxdinfo.document.eln.back.vo.eln.ElnNewRowConnVo;
import com.jxdinfo.document.eln.back.vo.eln.ElnNewRowVo;
import com.jxdinfo.document.eln.back.vo.eln.ElnOldNewRIdxVo;
import com.jxdinfo.document.eln.back.vo.eln.ElnOldRowConnVo;
import com.jxdinfo.document.eln.back.vo.eln.ElnRCSpanVo;
import com.jxdinfo.document.eln.back.vo.eln.ElnSheetDataParsingVo;
import com.jxdinfo.document.eln.back.vo.param.ElnDataParsingParamVo;
import com.jxdinfo.document.eln.back.vo.param.ElnSheetParamVo;
import com.jxdinfo.document.eln.back.vo.result.ElnSheetResultVo;
import com.jxdinfo.document.eln.back.vo.result.HandleRichTextTableResult;
import com.jxdinfo.document.eln.back.vo.univer.ICellDataVo;
import com.jxdinfo.document.eln.back.vo.univer.IStyleDataVo;
import com.jxdinfo.document.eln.back.vo.univer.IWorkbookDataVo;
import com.jxdinfo.document.eln.back.vo.univer.IWorksheetDataVo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;

public class ElnDataParsingUtil {
    public static String ElnDataParsing(ElnDataParsingParamVo paramVo) {
        Map<String, Object> dataSetMap = JsonUtil.convertValue((Object)paramVo.getDataSetJson(), new TypeReference<Map<String, Object>>(){});
        Map<String, Object> designMap = JsonUtil.convertValue((Object)paramVo.getTemplateJson(), new TypeReference<Map<String, Object>>(){});
        IWorkbookDataVo oldWorkbookData = (IWorkbookDataVo)JsonUtil.convertValue(designMap.get("workBook"), IWorkbookDataVo.class);
        IWorkbookDataVo newWorkbookData = (IWorkbookDataVo)JsonUtil.convertValue(designMap.get("workBook"), IWorkbookDataVo.class);
        Map<String, IWorksheetDataVo> oldSheets = oldWorkbookData.getSheets();
        Map<String, IStyleDataVo> styles = newWorkbookData.getStyles();
        for (String sheetKey : oldSheets.keySet()) {
            IWorksheetDataVo oldSheet = oldSheets.get(sheetKey);
            IWorksheetDataVo newSheet = newWorkbookData.getSheets().get(sheetKey);
            ElnSheetParamVo sheetParamVo = new ElnSheetParamVo(dataSetMap, oldSheet, newSheet, styles);
            ElnSheetResultVo elnSheetResultVo = ElnDataParsingUtil.ElnSheetParsing(sheetParamVo, paramVo.isHandleExtendRow(), true);
            newWorkbookData.getSheets().put(sheetKey, elnSheetResultVo.getNewSheet());
        }
        designMap.put("workBook", newWorkbookData);
        return JsonUtil.asJSONString(designMap);
    }

    public static ElnSheetResultVo ElnSheetParsing(ElnSheetParamVo paramVo, boolean isHandleJsonAfterNewRow, boolean isAddTableBorder) {
        IWorksheetDataVo oldSheet = paramVo.getOldSheet();
        IWorksheetDataVo newSheet = paramVo.getNewSheet();
        Map<String, Object> dataSetMap = paramVo.getDataSetMap();
        Map<String, IStyleDataVo> oldStyles = paramVo.getOldStyles();
        ElnSheetDataParsingVo eLnSheetDataParsingVo = ElnDataParsingUtil.initParsingVo();
        ElnSheetResultVo resultVo = new ElnSheetResultVo(newSheet, eLnSheetDataParsingVo);
        Map<Integer, Map<Integer, ICellDataVo>> oldCellData = oldSheet.getCellData();
        if (ObjectUtils.isEmpty(oldCellData)) {
            return resultVo;
        }
        newSheet.setCellData(new HashMap<Integer, Map<Integer, ICellDataVo>>());
        Map<Integer, ElnOldRowConnVo> oldRowTypeMap = ElnSheetUtil.analysisRows(oldCellData, oldSheet, dataSetMap);
        int nRIdx = 0;
        int rCount = 0;
        List sortedOldRowIndices = oldCellData.keySet().stream().sorted().collect(Collectors.toList());
        for (Integer ri : sortedOldRowIndices) {
            ElnOldRowConnVo rowTypeVo = oldRowTypeMap.get(ri);
            Map<Integer, ICellDataVo> oldRowCells = oldCellData.get(ri);
            if (rowTypeVo == null) continue;
            if (rCount < ri) {
                for (int i = rCount; i < ri; ++i) {
                    if (oldSheet.getCellData().get(i) != null) {
                        ElnDataParsingUtil.copyOldRowToNewSheet(oldSheet.getCellData().get(i), newSheet, nRIdx, eLnSheetDataParsingVo, oldRowTypeMap);
                    }
                    ++nRIdx;
                }
                rCount = ri;
            }
            Integer targetCIdx = rowTypeVo.getCIdx();
            ICellDataVo templateCell = oldRowCells.get(targetCIdx);
            String template = ElnSheetUtil.getValidTemplate(templateCell);
            Object cellModel = ElnExcelUtil.getDataModelByExp(dataSetMap, ElnAssistanceUtil.subStrExp(template));
            List<Object> cellModelList = ElnDataParsingUtil.convertToList(cellModel);
            switch (rowTypeVo.getType()) {
                case "richTxtStepper": 
                case "editGrid": 
                case "sheet": {
                    HandleRichTextTableResult handleResult = ElnTableUtil.handleRichTextTable(cellModelList, oldSheet, ri, targetCIdx, nRIdx, rCount, newSheet, eLnSheetDataParsingVo, oldStyles, isAddTableBorder);
                    nRIdx = handleResult.getNRIdx();
                    rCount = handleResult.getRCount();
                    break;
                }
            }
        }
        if (rCount < oldSheet.getRowCount()) {
            for (int i = rCount; i < oldSheet.getRowCount(); ++i) {
                if (oldSheet.getCellData().get(i) != null) {
                    ElnDataParsingUtil.copyOldRowToNewSheet(oldCellData.get(i), newSheet, nRIdx, eLnSheetDataParsingVo, oldRowTypeMap);
                }
                ++nRIdx;
            }
        }
        ElnConnHandler.handleProcessDataInfo(eLnSheetDataParsingVo, oldSheet.getRowCount(), newSheet);
        ElnAfterUtil.afterSheetData(newSheet, eLnSheetDataParsingVo, oldStyles);
        return resultVo;
    }

    private static ElnSheetDataParsingVo initParsingVo() {
        ElnSheetDataParsingVo parsingVo = new ElnSheetDataParsingVo();
        parsingVo.setNewRows(new ArrayList<ElnNewRowVo>());
        ElnOldNewRIdxVo oldNewRIdx = new ElnOldNewRIdxVo();
        oldNewRIdx.setOld(new HashMap<Integer, ElnOldRowConnVo>());
        oldNewRIdx.setNewIdx(new HashMap<Integer, ElnNewRowConnVo>());
        parsingVo.setOldOrNewRIdx(oldNewRIdx);
        parsingVo.setRcSpan(new ArrayList<ElnRCSpanVo>());
        return parsingVo;
    }

    private static void copyOldRowToNewSheet(Map<Integer, ICellDataVo> oldRowCells, IWorksheetDataVo newSheet, int newRIdx, ElnSheetDataParsingVo parsingVo, Map<Integer, ElnOldRowConnVo> oldRowTypeMap) {
        Map<Integer, ICellDataVo> newRowCells = ElnDataParsingUtil.deepCopyCellMap(oldRowCells);
        newSheet.getCellData().put(newRIdx, newRowCells);
        if (oldRowTypeMap != null) {
            parsingVo.getOldOrNewRIdx().getOld().putAll(oldRowTypeMap);
        }
    }

    private static Map<Integer, ICellDataVo> deepCopyCellMap(Map<Integer, ICellDataVo> oldRowCells) {
        if (ObjectUtils.isEmpty(oldRowCells)) {
            return new HashMap<Integer, ICellDataVo>();
        }
        HashMap<Integer, ICellDataVo> newRowCells = new HashMap<Integer, ICellDataVo>();
        for (Map.Entry<Integer, ICellDataVo> cellEntry : oldRowCells.entrySet()) {
            ICellDataVo oldCell = cellEntry.getValue();
            ICellDataVo newCell = DeepCloneUtil.deepClone(oldCell);
            newRowCells.put(cellEntry.getKey(), newCell);
        }
        return newRowCells;
    }

    private static List<Object> convertToList(Object cellModel) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (cellModel == null) {
            return result;
        }
        if (cellModel instanceof Collection) {
            result = new ArrayList((Collection)cellModel);
        } else {
            result.add(cellModel);
        }
        return result;
    }

    public static void main(String[] args) {
        ElnDataParsingParamVo paramVo = new ElnDataParsingParamVo();
        String dataSetJson = FileUtil.getFileResourceString("test/testEditGridData.json");
        String templateJson = FileUtil.getFileResourceString("test/reportTemplateData.json");
        paramVo.setDataSetJson(dataSetJson);
        paramVo.setTemplateJson(templateJson);
        paramVo.setHandleExtendRow(true);
        String result = ElnDataParsingUtil.ElnDataParsing(paramVo);
        System.out.println(result);
        System.out.println("\u7ed3\u675f");
    }
}

