/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.eln.back.util.excel;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.core.type.TypeReference;
import com.jxdinfo.document.eln.back.util.DeepCloneUtil;
import com.jxdinfo.document.eln.back.util.JsonUtil;
import com.jxdinfo.document.eln.back.util.excel.ElnCellUtil;
import com.jxdinfo.document.eln.back.util.excel.ElnRowColUtil;
import com.jxdinfo.document.eln.back.util.excel.ElnStyleUtil;
import com.jxdinfo.document.eln.back.vo.eln.ElnCellTextVo;
import com.jxdinfo.document.eln.back.vo.eln.ElnCellVo;
import com.jxdinfo.document.eln.back.vo.eln.ElnNewRowVo;
import com.jxdinfo.document.eln.back.vo.eln.ElnRCSpanVo;
import com.jxdinfo.document.eln.back.vo.eln.ElnSheetDataParsingVo;
import com.jxdinfo.document.eln.back.vo.eln.ElnStyleVo;
import com.jxdinfo.document.eln.back.vo.eln.ElnTableRow;
import com.jxdinfo.document.eln.back.vo.result.ElnStyleResultVo;
import com.jxdinfo.document.eln.back.vo.result.HandleRichTextTableResult;
import com.jxdinfo.document.eln.back.vo.univer.ICellDataVo;
import com.jxdinfo.document.eln.back.vo.univer.IMergeDataVo;
import com.jxdinfo.document.eln.back.vo.univer.IStyleDataVo;
import com.jxdinfo.document.eln.back.vo.univer.IWorksheetDataVo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

public class ElnTableUtil {
    public static List<List<ElnTableRow>> analyzeTable(List<ElnTableRow> contentRows) {
        ArrayList<List<ElnTableRow>> tableList = new ArrayList<List<ElnTableRow>>();
        ArrayList<ElnTableRow> currentTable = new ArrayList<ElnTableRow>();
        if (contentRows == null || contentRows.isEmpty()) {
            return tableList;
        }
        for (ElnTableRow rowObj : contentRows) {
            String type;
            ElnTableRow row;
            if (rowObj instanceof ElnTableRow) {
                row = rowObj;
            } else if (rowObj instanceof Map) {
                try {
                    row = (ElnTableRow)JSON.parseObject((String)JsonUtil.asJSONString(rowObj), ElnTableRow.class);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("\u884c\u6570\u636e\u8f6c\u6362ElnTableRow\u5931\u8d25\uff0c\u6570\u636e\uff1a" + rowObj, e);
                }
            } else {
                throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u884c\u6570\u636e\u7c7b\u578b\uff1a" + rowObj.getClass().getName() + "\uff0c\u8bf7\u4f20\u5165ElnTableRow\u6216Map\u7c7b\u578b");
            }
            String string = type = row.getType() == null ? "" : row.getType();
            if (type.isEmpty() || "splitLine".equals(type)) {
                if (!currentTable.isEmpty()) {
                    tableList.add(new ArrayList(currentTable));
                    currentTable.clear();
                }
                ArrayList<ElnTableRow> splitRowList = new ArrayList<ElnTableRow>();
                splitRowList.add(row);
                tableList.add(splitRowList);
                continue;
            }
            currentTable.add(row);
        }
        if (!currentTable.isEmpty()) {
            tableList.add(new ArrayList(currentTable));
        }
        return tableList;
    }

    public static HandleRichTextTableResult handleRichTextTable(List<Object> model, IWorksheetDataVo sheet, int rIdx, int cIdx, int nRIdx, int rCount, IWorksheetDataVo newSheet, ElnSheetDataParsingVo eLnSheetDataParsingVo, Map<String, IStyleDataVo> styles, boolean isAddTableBorder) {
        List<ElnRCSpanVo> rcSpan = eLnSheetDataParsingVo.getRcSpan();
        List<ElnNewRowVo> newRows = eLnSheetDataParsingVo.getNewRows();
        int totalCols = 1;
        int rowSpan = 1;
        List<IMergeDataVo> mergeData = sheet.getMergeData();
        int mergeIdx = -1;
        if (ObjectUtils.isNotEmpty(mergeData)) {
            for (int i = 0; i < mergeData.size(); ++i) {
                IMergeDataVo mergeItem2 = mergeData.get(i);
                if (mergeItem2.getStartRow() > rIdx || mergeItem2.getEndRow() < rIdx || mergeItem2.getStartColumn() > cIdx || mergeItem2.getEndColumn() < cIdx) continue;
                mergeIdx = i;
                break;
            }
            if (mergeIdx != -1) {
                IMergeDataVo removedMerge = mergeData.remove(mergeIdx);
                totalCols = removedMerge.getEndColumn() - removedMerge.getStartColumn() + 1;
                rowSpan = removedMerge.getEndRow() - removedMerge.getStartRow() + 1;
                newSheet.getMergeData().removeIf(mergeItem -> mergeItem.getStartRow() == removedMerge.getStartRow() && mergeItem.getEndRow() == removedMerge.getEndRow() && mergeItem.getStartColumn() == removedMerge.getStartColumn() && mergeItem.getEndColumn() == removedMerge.getEndColumn());
            }
        }
        rCount += rowSpan;
        ICellDataVo oCell = sheet.getCellData().get(rIdx).get(cIdx);
        String oCellS = oCell.getS();
        IStyleDataVo initStyle = null;
        if (oCellS != null) {
            initStyle = (IStyleDataVo)DeepCloneUtil.deepClone((Serializable)styles.get(oCellS));
            if (Objects.isNull(initStyle)) {
                initStyle = new IStyleDataVo();
            } else if (JsonUtil.isValidJson(oCellS)) {
                initStyle = JsonUtil.convertValue((Object)oCellS, new TypeReference<IStyleDataVo>(){});
            }
        }
        if (initStyle != null && initStyle.getTb() == 0) {
            initStyle.setTb(3);
        }
        int addedRowCount = 0;
        for (int k = 0; k < model.size(); ++k) {
            Object modelItemObject = model.get(k);
            Map modelItem = (Map)modelItemObject;
            List<ElnTableRow> value = (List<ElnTableRow>)modelItem.get("value");
            if (CollectionUtils.isEmpty((Collection)value)) continue;
            value = ElnRowColUtil.getParsingElnData(value, totalCols, isAddTableBorder, cIdx, rowSpan);
            Object tabelStyleObject = modelItem.get("style");
            Map tableStyle = (Map)JsonUtil.convertValue(tabelStyleObject, Map.class);
            for (int i = 0; i < value.size(); ++i) {
                ElnTableRow rowData = value.get(i);
                Map<String, Object> rowStyle = rowData.getStyle() != null ? rowData.getStyle() : new HashMap<String, Object>();
                rowStyle = ElnStyleUtil.mergeStyle(tableStyle, rowStyle);
                HashMap<Integer, ICellDataVo> newRowCells = new HashMap<Integer, ICellDataVo>();
                List<ElnCellVo> cells = rowData.getCells();
                int ci = cIdx + rowData.getColOffset();
                for (int j = 0; j < cells.size(); ++j) {
                    ElnCellVo cell = cells.get(j);
                    HashMap<String, Object> cellStyle = cell.getStyle() != null ? cell.getStyle() : new HashMap<String, Object>();
                    Map<String, Object> combinedStyle = new HashMap<String, Object>();
                    combinedStyle = ElnStyleUtil.mergeStyle(combinedStyle, rowStyle);
                    combinedStyle = ElnStyleUtil.mergeStyle(combinedStyle, cellStyle);
                    combinedStyle = ElnStyleUtil.mergeStyle(cellStyle, combinedStyle);
                    ElnStyleResultVo cellSObj = null;
                    if ("cell".equals(cell.getType())) {
                        ICellDataVo newCell = new ICellDataVo();
                        String cellType = ElnCellUtil.getCellType(cellStyle);
                        if (StringUtils.isNotEmpty((CharSequence)cellType)) {
                            newCell.setT(Integer.parseInt(cellType));
                        }
                        ElnStyleVo eLnStyleVo = JsonUtil.convertValue(cellStyle, new TypeReference<ElnStyleVo>(){});
                        cellSObj = ElnCellUtil.getCellStyle(eLnStyleVo, initStyle, styles, isAddTableBorder, cellType);
                        newCell.setS(cellSObj.getS());
                        if (cell.getAttachment() != null) {
                            ArrayList<ElnCellTextVo> textArr = new ArrayList<ElnCellTextVo>();
                            ElnCellTextVo textItem = new ElnCellTextVo();
                            textItem.setText(cell.getText());
                            textItem.setType("attachment");
                            textItem.setAttachment(cell.getAttachment());
                            textArr.add(textItem);
                            newCell.setP(ElnCellUtil.getCellStyleParagraph(textArr, cellSObj, styles));
                        } else if (cell.getText() != null) {
                            newCell.setV(cell.getText());
                        } else if (cell.getInlineStr() != null) {
                            List<ElnCellTextVo> textArr = JsonUtil.convertValue(cell.getInlineStr(), new TypeReference<List<ElnCellTextVo>>(){});
                            newCell.setV(ElnCellUtil.getCellStyleParagraphV(textArr));
                        }
                        newRowCells.put(ci, newCell);
                    } else if ("empty".equals(cell.getType())) {
                        ElnStyleVo eLnStyleVo = JsonUtil.convertValue(cellStyle, new TypeReference<ElnStyleVo>(){});
                        cellSObj = ElnCellUtil.getCellStyle(eLnStyleVo, initStyle, styles, isAddTableBorder, null);
                    }
                    int rowOffset = addedRowCount + i * rowSpan;
                    int colOffset = 0;
                    int rs = rowSpan * (cell.getRows() > 0 ? cell.getRows() : 1);
                    int cs = cell.getCols() > 0 ? cell.getCols() : 1;
                    int finalCi = ci;
                    boolean exists = rcSpan.stream().anyMatch(t -> t.getRIdx() == rIdx && t.getRowOffset() == rowOffset && t.getCIdx() == finalCi && t.getColOffset() == colOffset);
                    if (!(cell.getRows() <= 0 || rs <= 1 && cs <= 1 || exists)) {
                        ElnRCSpanVo rcSpanItem = new ElnRCSpanVo();
                        rcSpanItem.setRIdx(rIdx);
                        rcSpanItem.setRowOffset(rowOffset);
                        rcSpanItem.setCIdx(ci);
                        rcSpanItem.setColOffset(colOffset);
                        rcSpanItem.setRowSpan(rs);
                        rcSpanItem.setColSpan(cs);
                        rcSpanItem.setExtend(true);
                        rcSpanItem.setUseAfterCellMc(true);
                        if (cellSObj != null && cellSObj.getStyle() != null && cellSObj.getStyle().getBd() != null) {
                            rcSpanItem.setBorder(cellSObj.getStyle().getBd());
                        }
                        rcSpan.add(rcSpanItem);
                    }
                    ci += cell.getCols() > 0 ? cell.getCols() : 1;
                }
                newSheet.getCellData().put(nRIdx, newRowCells);
                nRIdx += rowSpan;
            }
            addedRowCount += value.size() * rowSpan;
            ++nRIdx;
            ++addedRowCount;
        }
        ElnNewRowVo newRow = new ElnNewRowVo();
        newRow.setSr(rIdx + rowSpan);
        newRow.setCnt(addedRowCount - rowSpan);
        newRow.setBc(addedRowCount - rowSpan);
        newRow.setBs(1);
        newRow.setIgnoreParentStyle(false);
        newRows.add(newRow);
        HandleRichTextTableResult result = new HandleRichTextTableResult();
        result.setNRIdx(nRIdx);
        result.setRCount(rCount);
        return result;
    }
}

