/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.eln.back.util.excel;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.document.eln.back.util.DeepCloneUtil;
import com.jxdinfo.document.eln.back.util.JsonUtil;
import com.jxdinfo.document.eln.back.util.RandomStringUtil;
import com.jxdinfo.document.eln.back.util.StyleEqualsUtil;
import com.jxdinfo.document.eln.back.util.excel.ElnAssistanceUtil;
import com.jxdinfo.document.eln.back.vo.eln.ElnStyleVo;
import com.jxdinfo.document.eln.back.vo.univer.BorderDataVo;
import com.jxdinfo.document.eln.back.vo.univer.BorderStyleDataVo;
import com.jxdinfo.document.eln.back.vo.univer.IStyleDataVo;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ElnStyleUtil {
    public static Map<String, Object> mergeStyle(Map<String, Object> lowStyleMap, Map<String, Object> highStyleMap) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (highStyleMap != null) {
            result.putAll(highStyleMap);
        }
        if (lowStyleMap != null) {
            for (Map.Entry<String, Object> entry : lowStyleMap.entrySet()) {
                String key = entry.getKey();
                Object lowValue = entry.getValue();
                if (result.containsKey(key) && result.get(key) != null || lowValue == null) continue;
                result.put(key, lowValue);
            }
        }
        return result;
    }

    public static void processVerticalAlign(ElnStyleVo cellStyle, IStyleDataVo style, IStyleDataVo cStyle) {
        if (cellStyle.getVerticalAlign() != null) {
            Integer vt = null;
            switch (cellStyle.getVerticalAlign()) {
                case "top": {
                    vt = 1;
                    break;
                }
                case "bottom": {
                    vt = 3;
                    break;
                }
                case "middle": 
                case "center": {
                    vt = 2;
                }
            }
            if (vt != null) {
                style.setVt(vt);
                cStyle.setVt(vt);
            }
        }
    }

    public static void processHorizontalAlign(ElnStyleVo cellStyle, IStyleDataVo style, IStyleDataVo cStyle, Map<String, Object> pParagraphStyle) {
        if (cellStyle.getTextAlign() != null) {
            Integer ht = null;
            switch (cellStyle.getTextAlign()) {
                case "left": {
                    ht = 1;
                    break;
                }
                case "right": {
                    ht = 3;
                    break;
                }
                case "center": {
                    ht = 2;
                }
            }
            if (ht != null) {
                style.setHt(ht);
                cStyle.setHt(ht);
                pParagraphStyle.put("horizontalAlign", ht);
            }
        }
    }

    public static void processBold(ElnStyleVo cellStyle, IStyleDataVo style, IStyleDataVo cStyle, Map<String, Object> pTextStyle) {
        Integer bl = ElnAssistanceUtil.getFirstNotNull(cellStyle.getBl(), cellStyle.getBold());
        if (bl != null && bl == 1) {
            style.setBl(1);
            cStyle.setBl(1);
            pTextStyle.put("bl", 1);
        } else {
            style.setBl(0);
            cStyle.setBl(0);
            pTextStyle.put("bl", 0);
        }
    }

    public static void processItalic(ElnStyleVo cellStyle, IStyleDataVo style, IStyleDataVo cStyle, Map<String, Object> pTextStyle) {
        Integer it = ElnAssistanceUtil.getFirstNotNull(cellStyle.getIt(), cellStyle.getItalic());
        if (it != null && it == 1) {
            style.setIt(1);
            cStyle.setIt(1);
            pTextStyle.put("it", 1);
        } else {
            style.setIt(0);
            cStyle.setIt(0);
            pTextStyle.put("it", 0);
        }
    }

    public static void processBackgroundColor(ElnStyleVo cellStyle, IStyleDataVo style, IStyleDataVo cStyle) {
        String bgValue = ElnAssistanceUtil.getFirstNotNull(cellStyle.getBg(), cellStyle.getBackgroundColor());
        if (StringUtils.isNotBlank((CharSequence)bgValue)) {
            HashMap<String, String> bgMap = new HashMap<String, String>();
            bgMap.put("rgb", cellStyle.getBg());
            style.setBg(bgMap);
            cStyle.setBg(bgMap);
        }
    }

    public static void processFontColor(ElnStyleVo cellStyle, IStyleDataVo style, IStyleDataVo cStyle, Map<String, Object> pTextStyle) {
        String fontColor = ElnAssistanceUtil.getFirstNotNull(cellStyle.getFc(), cellStyle.getFontColor());
        if (StringUtils.isNotBlank((CharSequence)fontColor)) {
            HashMap<String, String> colorMap = new HashMap<String, String>();
            colorMap.put("rgb", fontColor);
            style.setCl(colorMap);
            cStyle.setCl(colorMap);
            pTextStyle.put("cl", colorMap);
        }
    }

    public static void processFontSize(ElnStyleVo cellStyle, IStyleDataVo style, IStyleDataVo cStyle, Map<String, Object> pTextStyle) {
        String fontSizeStr = ElnAssistanceUtil.getFirstNotNull(cellStyle.getFs(), cellStyle.getFontSize());
        if (StringUtils.isNotBlank((CharSequence)fontSizeStr)) {
            try {
                int fontSize = Integer.parseInt(fontSizeStr);
                if (fontSize > 0) {
                    style.setFs(fontSize);
                    cStyle.setFs(fontSize);
                    pTextStyle.put("fs", fontSize);
                }
            }
            catch (NumberFormatException e) {
                int defaultSize = 11;
                style.setFs(defaultSize);
                cStyle.setFs(defaultSize);
                pTextStyle.put("fs", defaultSize);
            }
        }
    }

    public static void processFontFamily(ElnStyleVo cellStyle, IStyleDataVo style, IStyleDataVo cStyle, Map<String, Object> pTextStyle) {
        String fontFamily = ElnAssistanceUtil.getFirstNotNull(cellStyle.getFf(), cellStyle.getFontFamily());
        if (StringUtils.isNotBlank((CharSequence)fontFamily)) {
            style.setFf(fontFamily);
            cStyle.setFf(fontFamily);
            pTextStyle.put("ff", fontFamily);
        }
    }

    public static void processNumberFormat(String cellType, ElnStyleVo cellStyle, IStyleDataVo style, IStyleDataVo cStyle) {
        if ("2".equals(cellType) && cellStyle.getN() != null) {
            HashMap<String, String> numberFormat = new HashMap<String, String>();
            numberFormat.put("pattern", cellStyle.getN());
            style.setN(numberFormat);
            cStyle.setN(numberFormat);
        }
    }

    public static void processBorder(ElnStyleVo cellStyle, boolean isAddTableBorder, IStyleDataVo style, IStyleDataVo cStyle) {
        boolean hasBorder;
        boolean bl = hasBorder = isAddTableBorder || StringUtils.isNotBlank((CharSequence)cellStyle.getBorderTopColor()) || StringUtils.isNotBlank((CharSequence)cellStyle.getBorderBottomColor()) || StringUtils.isNotBlank((CharSequence)cellStyle.getBorderLeftColor()) || StringUtils.isNotBlank((CharSequence)cellStyle.getBorderRightColor());
        if (hasBorder) {
            BorderStyleDataVo borderStyleDataVo = new BorderStyleDataVo();
            BorderDataVo topBorder = new BorderDataVo();
            topBorder.setS(1);
            HashMap<String, String> topColor = new HashMap<String, String>();
            topColor.put("rgb", StringUtils.isNotBlank((CharSequence)cellStyle.getBorderTopColor()) ? cellStyle.getBorderTopColor() : "#000000");
            topBorder.setCl(topColor);
            borderStyleDataVo.setT(topBorder);
            BorderDataVo bottomBorder = new BorderDataVo();
            bottomBorder.setS(1);
            HashMap<String, String> bottomColor = new HashMap<String, String>();
            bottomColor.put("rgb", StringUtils.isNotBlank((CharSequence)cellStyle.getBorderBottomColor()) ? cellStyle.getBorderBottomColor() : "#000000");
            bottomBorder.setCl(bottomColor);
            borderStyleDataVo.setB(bottomBorder);
            BorderDataVo leftBorder = new BorderDataVo();
            leftBorder.setS(1);
            HashMap<String, String> leftColor = new HashMap<String, String>();
            leftColor.put("rgb", StringUtils.isNotBlank((CharSequence)cellStyle.getBorderLeftColor()) ? cellStyle.getBorderLeftColor() : "#000000");
            leftBorder.setCl(leftColor);
            borderStyleDataVo.setL(leftBorder);
            BorderDataVo rightBorder = new BorderDataVo();
            rightBorder.setS(1);
            HashMap<String, String> rightColor = new HashMap<String, String>();
            rightColor.put("rgb", StringUtils.isNotBlank((CharSequence)cellStyle.getBorderRightColor()) ? cellStyle.getBorderRightColor() : "#000000");
            rightBorder.setCl(rightColor);
            borderStyleDataVo.setR(rightBorder);
            style.setBd(borderStyleDataVo);
            cStyle.setBd(borderStyleDataVo);
        }
    }

    public static void processUnderline(ElnStyleVo cellStyle, IStyleDataVo style, IStyleDataVo cStyle, Map<String, Object> pTextStyle) {
        Map underlineObj = ElnAssistanceUtil.getFirstNotNull(cellStyle.getUl(), cellStyle.getUnderline(), cellStyle.getUl(), cellStyle.getUn());
        if (underlineObj != null) {
            Map<String, Object> ulMap = ElnAssistanceUtil.createTextDecorationStyle(underlineObj, "underline");
            style.setUl(ulMap);
            cStyle.setUl(ulMap);
            pTextStyle.put("ul", ulMap);
        }
    }

    public static void processStrikethrough(ElnStyleVo cellStyle, IStyleDataVo style, IStyleDataVo cStyle, Map<String, Object> pTextStyle) {
        Map strikeObj = ElnAssistanceUtil.getFirstNotNull(cellStyle.getSt(), cellStyle.getStrikethrough());
        if (strikeObj != null) {
            Map<String, Object> stMap = ElnAssistanceUtil.createTextDecorationStyle(strikeObj, "strikethrough");
            style.setSt(stMap);
            cStyle.setSt(stMap);
            pTextStyle.put("st", stMap);
        }
    }

    public static void processOverline(ElnStyleVo cellStyle, IStyleDataVo style, IStyleDataVo cStyle, Map<String, Object> pTextStyle) {
        if (cellStyle.getOl() != null) {
            Map<String, Object> olMap = ElnAssistanceUtil.createTextDecorationStyle(cellStyle.getOl(), "overline");
            style.setOl(olMap);
            cStyle.setOl(olMap);
            pTextStyle.put("ol", olMap);
        }
    }

    public static void processVerticalAlignText(ElnStyleVo cellStyle, IStyleDataVo style, Map<String, Object> pTextStyle) {
        Integer va = null;
        if (cellStyle.getSub() != null && cellStyle.getSub().booleanValue()) {
            va = 2;
        } else if (cellStyle.getSup() != null && cellStyle.getSup().booleanValue()) {
            va = 3;
        }
        if (cellStyle.getVa() != null) {
            try {
                va = Integer.parseInt(cellStyle.getVa().toString());
            }
            catch (NumberFormatException e) {
                va = 1;
            }
        }
        if (va != null) {
            style.setVa(va);
            pTextStyle.put("va", va);
        }
    }

    public static void processTextRotation(ElnStyleVo cellStyle, IStyleDataVo style, IStyleDataVo cStyle) {
        Map rotationObj = ElnAssistanceUtil.getFirstNotNull(cellStyle.getTr(), cellStyle.getTextRotation());
        if (rotationObj != null) {
            JSONObject trObj = JSONObject.parseObject((String)JsonUtil.asJSONString(rotationObj));
            HashMap<String, Short> trMap = new HashMap<String, Short>();
            trMap.put("a", trObj.getShortValue("angle"));
            trMap.put("v", trObj.getShortValue("isVertical"));
            style.setTr(trMap);
            cStyle.setTr(trMap);
        }
    }

    public static void processPadding(ElnStyleVo cellStyle, IStyleDataVo style, IStyleDataVo cStyle) {
        Map paddingObj = ElnAssistanceUtil.getFirstNotNull(cellStyle.getPd(), cellStyle.getPadding());
        if (paddingObj != null) {
            JSONObject pdObj = JSONObject.parseObject((String)JsonUtil.asJSONString(paddingObj));
            HashMap<String, Short> paddingMap = new HashMap<String, Short>();
            paddingMap.put("t", pdObj.getShortValue("top"));
            paddingMap.put("b", pdObj.getShortValue("bottom"));
            paddingMap.put("l", pdObj.getShortValue("left"));
            paddingMap.put("r", pdObj.getShortValue("right"));
            style.setPd(paddingMap);
            cStyle.setPd(paddingMap);
        }
    }

    public static void processTextBreak(ElnStyleVo cellStyle, IStyleDataVo style, IStyleDataVo cStyle) {
        Integer breakObj = ElnAssistanceUtil.getFirstNotNull(cellStyle.getTb(), cellStyle.getTextBreak(), cellStyle.getTextBeak());
        if (breakObj != null) {
            int tb = 1;
            int breakValue = breakObj;
            if (breakValue == 0) {
                tb = 2;
            } else if (breakValue == 2) {
                tb = 3;
            }
            style.setTb(tb);
            cStyle.setTb(tb);
        }
    }

    public static String getCellS(Map<String, IStyleDataVo> styles, IStyleDataVo cellStyle) {
        int targetHashCode = StyleEqualsUtil.calculateStyleHashCode(cellStyle);
        for (Map.Entry<String, IStyleDataVo> entry : styles.entrySet()) {
            IStyleDataVo existingStyle = entry.getValue();
            if (StyleEqualsUtil.calculateStyleHashCode(existingStyle) != targetHashCode || !StyleEqualsUtil.isStyleEqual(existingStyle, cellStyle)) continue;
            return entry.getKey();
        }
        String newStyleKey = RandomStringUtil.generateAlphanumeric(8);
        IStyleDataVo styleCopy = DeepCloneUtil.deepClone(cellStyle);
        styles.put(newStyleKey, styleCopy);
        return newStyleKey;
    }
}

