/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.eln.back.util.excel;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ElnExcelUtil {
    public static Object getDataModelByExp(Map<String, Object> dataSet, Object exp, int tailCut) {
        return ElnExcelUtil.getDataModelByExp(dataSet, exp, tailCut, false);
    }

    public static Object getDataModelByExp(Map<String, Object> dataSet, Object exp) {
        return ElnExcelUtil.getDataModelByExp(dataSet, exp, 0);
    }

    public static Object getDataModelByExp(Map<String, Object> dataSet, Object exp, int tailCut, boolean internalCall) {
        String[] expArr;
        Object data = dataSet;
        if (exp == null) {
            return "";
        }
        if (exp instanceof String[]) {
            expArr = (String[])exp;
        } else if (exp instanceof String) {
            expArr = ((String)exp).split("\\.");
        } else {
            return "";
        }
        if (expArr.length > 0) {
            int loopLength = expArr.length - tailCut;
            for (int i = 0; i < loopLength; ++i) {
                Object jsonData;
                if (data == null) {
                    return "";
                }
                if ((data = ElnExcelUtil.getValueByKey(data, expArr[i])) == null) {
                    return "";
                }
                if (!internalCall && data instanceof String && !(jsonData = ElnExcelUtil.dataToJson(data)).equals(data)) {
                    data = jsonData;
                }
                if (data instanceof List && ((List)data).size() == 1) {
                    data = ((List)data).get(0);
                }
                if (data != null) continue;
                return "";
            }
        }
        return data != null ? data : "";
    }

    public static Object getValueByKey(Object obj, String key) {
        if (obj == null || key == null) {
            return null;
        }
        try {
            Iterator jsonData;
            if (obj instanceof String && !(jsonData = ElnExcelUtil.dataToJson(obj)).equals(obj)) {
                return ElnExcelUtil.getValueByKey(jsonData, key);
            }
            if (obj instanceof Map) {
                if (((Map)obj).containsKey(key)) {
                    return ((Map)obj).get(key);
                }
                jsonData = ((Map)obj).entrySet().iterator();
                if (jsonData.hasNext()) {
                    Map.Entry entry = jsonData.next();
                    return ElnExcelUtil.getValueByKey(entry.getValue(), key);
                }
            }
            if (obj instanceof List) {
                try {
                    List list = (List)obj;
                    Iterator entry = list.iterator();
                    if (entry.hasNext()) {
                        Object o = entry.next();
                        return ElnExcelUtil.getValueByKey(o, key);
                    }
                }
                catch (NumberFormatException list) {
                    // empty catch block
                }
            }
            try {
                Field field = obj.getClass().getDeclaredField(key);
                field.setAccessible(true);
                return field.get(obj);
            }
            catch (NoSuchFieldException e) {
                try {
                    String getterName = "get" + key.substring(0, 1).toUpperCase() + key.substring(1);
                    Method method = obj.getClass().getMethod(getterName, new Class[0]);
                    return method.invoke(obj, new Object[0]);
                }
                catch (Exception ex) {
                    return null;
                }
            }
            catch (IllegalAccessException e) {
                return null;
            }
        }
        catch (Exception e) {
            System.err.println("\u83b7\u53d6\u952e\u503c\u5931\u8d25 - key: " + key + ", \u9519\u8bef: " + e.getMessage());
            return null;
        }
    }

    public static Object dataToJson(Object d) {
        if (d == null) {
            return null;
        }
        if (!(d instanceof String)) {
            return d;
        }
        String jsonString = (String)d;
        if (jsonString.trim().isEmpty()) {
            return d;
        }
        ObjectMapper mapper = ElnExcelUtil.createObjectMapper();
        try {
            return mapper.readValue(jsonString, Object.class);
        }
        catch (JsonProcessingException e1) {
            try {
                String cleanedJson = ElnExcelUtil.cleanJsonString(jsonString);
                return mapper.readValue(cleanedJson, Object.class);
            }
            catch (JsonProcessingException e2) {
                try {
                    return ElnExcelUtil.handleDeeplyEscapedJson(jsonString, mapper);
                }
                catch (Exception e3) {
                    System.err.println("JSON\u89e3\u6790\u5931\u8d25\uff0c\u4fdd\u6301\u539f\u59cb\u5b57\u7b26\u4e32\u3002\u8f93\u5165: " + (jsonString.length() > 100 ? jsonString.substring(0, 100) + "..." : jsonString));
                    System.err.println("\u89e3\u6790\u9519\u8bef: " + e3.getMessage());
                    return d;
                }
            }
        }
    }

    public static String cleanJsonString(String jsonString) {
        if (jsonString == null) {
            return null;
        }
        String cleaned = jsonString.trim();
        if (cleaned.startsWith("\"") && cleaned.endsWith("\"")) {
            cleaned = cleaned.substring(1, cleaned.length() - 1);
        }
        cleaned = cleaned.replace("\\\"", "\"").replace("\\\\", "\\").replace("\\n", "\n").replace("\\r", "\r").replace("\\t", "\t").replace("\\/", "/");
        return cleaned;
    }

    public static Object handleDeeplyEscapedJson(String jsonString, ObjectMapper mapper) throws Exception {
        String current = jsonString;
        for (int i = 0; i < 3; ++i) {
            try {
                return mapper.readValue(current, Object.class);
            }
            catch (JsonProcessingException e) {
                String cleaned = ElnExcelUtil.cleanJsonString(current);
                if (cleaned.equals(current)) {
                    throw e;
                }
                current = cleaned;
                continue;
            }
        }
        return current;
    }

    public static ObjectMapper createObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
        mapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        mapper.configure(JsonParser.Feature.ALLOW_TRAILING_COMMA, true);
        return mapper;
    }
}

