/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.eln.back.util.excel;

import com.fasterxml.jackson.core.type.TypeReference;
import com.jxdinfo.document.eln.back.util.DeepCloneUtil;
import com.jxdinfo.document.eln.back.util.JsonUtil;
import com.jxdinfo.document.eln.back.util.excel.ElnAssistanceUtil;
import com.jxdinfo.document.eln.back.util.excel.ElnStyleUtil;
import com.jxdinfo.document.eln.back.vo.eln.ElnCellTextVo;
import com.jxdinfo.document.eln.back.vo.eln.ElnStyleVo;
import com.jxdinfo.document.eln.back.vo.result.ElnStyleResultVo;
import com.jxdinfo.document.eln.back.vo.univer.ICellDataPVo;
import com.jxdinfo.document.eln.back.vo.univer.IStyleDataVo;
import com.jxdinfo.document.eln.back.vo.univer.ParagraphTextRunVo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ElnCellUtil {
    public static String getCellType(Map<String, Object> styleMap) {
        String type;
        switch (type = styleMap.get("t") == null ? "" : styleMap.get("t").toString()) {
            case "string": 
            case "1": {
                return "1";
            }
            case "number": 
            case "2": {
                return "2";
            }
            case "boolean": 
            case "3": {
                return "3";
            }
            case "text": 
            case "4": {
                return "4";
            }
        }
        return type;
    }

    public static ElnStyleResultVo getCellStyle(ElnStyleVo cellStyle, IStyleDataVo initStyle, Map<String, IStyleDataVo> oldStyles, boolean isAddTableBorder, String cellType) {
        ElnStyleResultVo result = new ElnStyleResultVo();
        if (cellStyle == null) {
            return result;
        }
        IStyleDataVo style = DeepCloneUtil.deepClone(initStyle);
        IStyleDataVo cStyle = new IStyleDataVo();
        HashMap<String, Object> pTextStyle = new HashMap<String, Object>();
        HashMap<String, Object> pParagraphStyle = new HashMap<String, Object>();
        ElnStyleUtil.processVerticalAlign(cellStyle, style, cStyle);
        ElnStyleUtil.processHorizontalAlign(cellStyle, style, cStyle, pParagraphStyle);
        ElnStyleUtil.processBold(cellStyle, style, cStyle, pTextStyle);
        ElnStyleUtil.processItalic(cellStyle, style, cStyle, pTextStyle);
        ElnStyleUtil.processBackgroundColor(cellStyle, style, cStyle);
        ElnStyleUtil.processFontColor(cellStyle, style, cStyle, pTextStyle);
        ElnStyleUtil.processFontSize(cellStyle, style, cStyle, pTextStyle);
        ElnStyleUtil.processFontFamily(cellStyle, style, cStyle, pTextStyle);
        ElnStyleUtil.processNumberFormat(cellType, cellStyle, style, cStyle);
        ElnStyleUtil.processBorder(cellStyle, isAddTableBorder, style, cStyle);
        ElnStyleUtil.processUnderline(cellStyle, style, cStyle, pTextStyle);
        ElnStyleUtil.processStrikethrough(cellStyle, style, cStyle, pTextStyle);
        ElnStyleUtil.processOverline(cellStyle, style, cStyle, pTextStyle);
        ElnStyleUtil.processVerticalAlignText(cellStyle, style, pTextStyle);
        ElnStyleUtil.processTextRotation(cellStyle, style, cStyle);
        ElnStyleUtil.processPadding(cellStyle, style, cStyle);
        ElnStyleUtil.processTextBreak(cellStyle, style, cStyle);
        String styleKey = ElnAssistanceUtil.generateStyleKey(cStyle, oldStyles);
        result.setS(styleKey);
        result.setStyle(style);
        result.setCStyle(cStyle);
        result.setPTextStyle(pTextStyle);
        result.setPParagraphStyle(pParagraphStyle);
        return result;
    }

    public static String getCellStyleParagraphV(List<ElnCellTextVo> inlineStr) {
        StringBuilder dataStream = new StringBuilder();
        if (inlineStr != null) {
            for (ElnCellTextVo item : inlineStr) {
                if (item.getImage() != null || item.getText() == null) continue;
                dataStream.append(item.getText());
            }
        }
        return dataStream.append("\r\n").toString();
    }

    public static ICellDataPVo getCellStyleParagraph(List<ElnCellTextVo> inlineStr, ElnStyleResultVo cellSObj, Map<String, IStyleDataVo> oldStyles) {
        ElnCellTextVo item;
        ICellDataPVo result = new ICellDataPVo();
        HashMap<String, Object> body = new HashMap<String, Object>();
        if (inlineStr != null && inlineStr.size() == 1 && "attachment".equals((item = inlineStr.get(0)).getType())) {
            String text = item.getText() == null ? "" : item.getText();
            String attachment = item.getAttachment() == null ? "" : item.getAttachment();
            body.put("dataStream", text + "\r\n");
            ArrayList<ParagraphTextRunVo> textRuns = new ArrayList<ParagraphTextRunVo>();
            ParagraphTextRunVo textRun = new ParagraphTextRunVo();
            textRun.setSt(0);
            textRun.setEd(text != null ? text.length() : 0);
            textRun.setTs(cellSObj.getPTextStyle());
            textRuns.add(textRun);
            body.put("textRuns", textRuns);
            ArrayList customRanges = new ArrayList();
            HashMap<String, Object> customRange = new HashMap<String, Object>();
            HashMap<String, String> properties = new HashMap<String, String>();
            customRange.put("startIndex", 0);
            customRange.put("endIndex", text != null ? text.length() - 1 : 0);
            customRange.put("rangeType", 0);
            customRange.put("properties", properties.put("url", ElnCellUtil.getElnFileUrl(attachment)));
            customRanges.add(customRange);
            body.put("customRanges", customRanges);
            result.setBody(body);
            return result;
        }
        StringBuilder dataStream = new StringBuilder();
        int textCount = 0;
        if (inlineStr != null) {
            ArrayList<ParagraphTextRunVo> textRuns = new ArrayList<ParagraphTextRunVo>();
            for (ElnCellTextVo item2 : inlineStr) {
                if (item2.getImage() != null || item2.getText() == null) continue;
                String text = item2.getText();
                dataStream.append(text);
                ElnStyleVo cellStyle = JsonUtil.convertValue(item2.getStyle(), new TypeReference<ElnStyleVo>(){});
                Map<String, Object> itemTextStyle = ElnCellUtil.getCellStyle(cellStyle, new IStyleDataVo(), oldStyles, false, null).getPTextStyle();
                ParagraphTextRunVo textRun = new ParagraphTextRunVo();
                textRun.setSt(textCount);
                textRun.setEd(textCount + text.length());
                textRun.setTs(itemTextStyle);
                textRuns.add(textRun);
                body.put("textRuns", textRuns);
                textCount += text.length();
            }
        }
        body.put("dataStream", dataStream.append("\r\n").toString());
        result.setBody(body);
        return result;
    }

    private static String getElnFileUrl(String attachment) {
        String url = "";
        if (attachment.startsWith("data:image") || attachment.startsWith("http")) {
            url = attachment;
        }
        return url;
    }
}

