/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.eln.back.util.excel;

import com.fasterxml.jackson.core.type.TypeReference;
import com.jxdinfo.document.eln.back.util.DeepCloneUtil;
import com.jxdinfo.document.eln.back.util.JsonUtil;
import com.jxdinfo.document.eln.back.util.excel.ElnRowColUtil;
import com.jxdinfo.document.eln.back.util.excel.ElnStyleUtil;
import com.jxdinfo.document.eln.back.vo.eln.ElnNewRowVo;
import com.jxdinfo.document.eln.back.vo.eln.ElnOldNewRIdxVo;
import com.jxdinfo.document.eln.back.vo.eln.ElnRCSpanVo;
import com.jxdinfo.document.eln.back.vo.eln.ElnSheetDataParsingVo;
import com.jxdinfo.document.eln.back.vo.univer.BorderStyleDataVo;
import com.jxdinfo.document.eln.back.vo.univer.ICellDataVo;
import com.jxdinfo.document.eln.back.vo.univer.IMergeDataVo;
import com.jxdinfo.document.eln.back.vo.univer.IStyleDataVo;
import com.jxdinfo.document.eln.back.vo.univer.IWorksheetDataVo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;

public class ElnAfterUtil {
    public static void afterSheetData(IWorksheetDataVo newSheet, ElnSheetDataParsingVo sheetDataParsingVo, Map<String, IStyleDataVo> styles) {
        ElnAfterUtil.processStyleMerge(newSheet, sheetDataParsingVo);
        ElnAfterUtil.addMergeInfo(newSheet, sheetDataParsingVo, styles);
        ElnAfterUtil.processStyleRowData(newSheet, sheetDataParsingVo);
        ElnAfterUtil.processStyleCellDataCustom(newSheet);
    }

    public static void processStyleMerge(IWorksheetDataVo newSheet, ElnSheetDataParsingVo sheetDataParsingVo) {
        List<IMergeDataVo> oldMergeData = newSheet.getMergeData();
        if (ObjectUtils.isEmpty(oldMergeData)) {
            return;
        }
        List<ElnNewRowVo> newRows = sheetDataParsingVo.getNewRows();
        ArrayList<IMergeDataVo> newMergeData = new ArrayList<IMergeDataVo>();
        for (IMergeDataVo item : oldMergeData) {
            IMergeDataVo mergeItem = DeepCloneUtil.deepClone(item);
            newMergeData.add(mergeItem);
            mergeItem.setStartRow(ElnRowColUtil.getNrn(sheetDataParsingVo, mergeItem.getStartRow()));
            mergeItem.setEndRow(ElnRowColUtil.getNrn(sheetDataParsingVo, mergeItem.getEndRow()));
            int sr = item.getStartRow();
            int er = item.getEndRow();
            for (ElnNewRowVo nri : newRows) {
                if (nri.isIgnoreParentStyle()) continue;
                int baseSr = nri.getSr() - nri.getBs();
                int baseEr = nri.getSr();
                if (sr >= baseSr && baseEr - 1 >= er) {
                    for (int j = 0; j < nri.getBc(); ++j) {
                        IMergeDataVo mc = new IMergeDataVo();
                        mc.setStartColumn(mergeItem.getStartColumn());
                        mc.setEndColumn(mergeItem.getEndColumn());
                        mc.setStartRow(nri.getNsr() + nri.getBs() * j + mergeItem.getStartRow() - baseSr);
                        mc.setEndRow(nri.getNsr() + nri.getBs() * j + mergeItem.getEndRow() - baseSr);
                        newMergeData.add(mc);
                    }
                    continue;
                }
                if (baseEr - 1 >= er || baseEr - 1 <= sr || baseSr > sr) continue;
                mergeItem.setEndRow(mergeItem.getEndRow() + nri.getCnt());
            }
        }
        newSheet.setMergeData(newMergeData);
    }

    public static void addMergeInfo(IWorksheetDataVo newSheet, ElnSheetDataParsingVo processDataInfo, Map<String, IStyleDataVo> styles) {
        List<ElnRCSpanVo> rcSpanList = processDataInfo.getRcSpan();
        if (ObjectUtils.isEmpty(rcSpanList)) {
            return;
        }
        if (ObjectUtils.isEmpty(newSheet.getMergeData())) {
            newSheet.setMergeData(new ArrayList<IMergeDataVo>());
        }
        for (ElnRCSpanVo s : rcSpanList) {
            if (s.getRowSpan() <= 1 && s.getColSpan() <= 1) continue;
            List<IMergeDataVo> mergeData = newSheet.getMergeData();
            int nsr = ElnRowColUtil.getNrn(processDataInfo, s.getRIdx()) + s.getRowOffset();
            int nCIdx = s.getCIdx() + s.getColOffset();
            int mergeIdx = -1;
            for (int i = 0; i < mergeData.size(); ++i) {
                IMergeDataVo t2 = mergeData.get(i);
                if (t2.getStartRow() > nsr || t2.getEndRow() < nsr || t2.getStartColumn() > nCIdx || t2.getEndColumn() < nCIdx) continue;
                mergeIdx = i;
                break;
            }
            int colSpan = 1;
            int rowSpan = 1;
            if (mergeIdx > -1) {
                IMergeDataVo nextCellMc;
                int i;
                int useAfterCellMcR;
                IMergeDataVo existMerge = mergeData.get(mergeIdx);
                colSpan = existMerge.getEndColumn() - existMerge.getStartColumn() + 1;
                rowSpan = existMerge.getEndRow() - existMerge.getStartRow() + 1;
                if (s.getRowSpan() == 1 || s.getExtend()) {
                    if (s.getRowSpan() > 1 && s.getUseAfterCellMc()) {
                        int newCellRowSpan = rowSpan;
                        useAfterCellMcR = nsr;
                        for (i = 1; i < s.getRowSpan(); ++i) {
                            int finalNewCellRowSpan = newCellRowSpan;
                            nextCellMc = mergeData.stream().filter(t -> t.getStartRow() <= useAfterCellMcR + finalNewCellRowSpan && t.getEndRow() >= useAfterCellMcR + finalNewCellRowSpan && t.getStartColumn() <= nCIdx && t.getEndColumn() >= nCIdx).findFirst().orElse(null);
                            int nextCellMcRs = nextCellMc != null ? nextCellMc.getEndRow() - nextCellMc.getStartRow() + 1 : 1;
                            newCellRowSpan += nextCellMcRs;
                        }
                        s.setRowSpan(newCellRowSpan);
                    } else {
                        s.setRowSpan(s.getRowSpan() * rowSpan);
                    }
                }
                if (s.getColSpan() == 1 || s.getExtend()) {
                    if (s.getColSpan() > 1 && s.getUseAfterCellMc()) {
                        int newCellColSpan = colSpan;
                        useAfterCellMcR = nsr;
                        for (i = 1; i < s.getColSpan(); ++i) {
                            int finalNewCellColSpan = newCellColSpan;
                            nextCellMc = mergeData.stream().filter(t -> t.getStartRow() <= useAfterCellMcR && t.getEndRow() >= useAfterCellMcR && t.getStartColumn() <= nCIdx + finalNewCellColSpan && t.getEndColumn() >= nCIdx + finalNewCellColSpan).findFirst().orElse(null);
                            int nextCellMcCs = nextCellMc != null ? nextCellMc.getEndColumn() - nextCellMc.getStartColumn() + 1 : 1;
                            newCellColSpan += nextCellMcCs;
                        }
                        s.setColSpan(newCellColSpan);
                    } else {
                        s.setColSpan(s.getColSpan() * colSpan);
                    }
                }
            }
            IMergeDataVo mergeItem = new IMergeDataVo();
            mergeItem.setStartRow(nsr);
            mergeItem.setStartColumn(nCIdx);
            mergeItem.setEndRow(nsr + s.getRowSpan() - 1);
            mergeItem.setEndColumn(nCIdx + s.getColSpan() - 1);
            List<IMergeDataVo> filteredMergeData = mergeData.stream().filter(t -> t.getStartRow() > mergeItem.getStartRow() || t.getEndRow() < mergeItem.getEndRow() || t.getStartColumn() > mergeItem.getStartColumn() || t.getEndColumn() < mergeItem.getEndColumn()).collect(Collectors.toList());
            filteredMergeData.add(mergeItem);
            newSheet.setMergeData(filteredMergeData);
            ElnAfterUtil.handleBorderAddMerge(s, mergeItem, newSheet, styles);
        }
    }

    private static void handleBorderAddMerge(ElnRCSpanVo rsSpanItem, IMergeDataVo mergeItem, IWorksheetDataVo newSheet, Map<String, IStyleDataVo> styles) {
        BorderStyleDataVo border = rsSpanItem.getBorder();
        if (border == null) {
            return;
        }
        Map<Integer, Map<Integer, ICellDataVo>> cellData = newSheet.getCellData();
        for (int i = mergeItem.getStartRow(); i <= mergeItem.getEndRow(); ++i) {
            cellData.computeIfAbsent(i, k -> new HashMap());
            Map<Integer, ICellDataVo> rowCells = cellData.get(i);
            for (int j = mergeItem.getStartColumn(); j <= mergeItem.getEndColumn(); ++j) {
                rowCells.computeIfAbsent(j, k -> new ICellDataVo());
                ICellDataVo cell = rowCells.get(j);
                String cellStyleObj = cell.getS();
                IStyleDataVo cellStyle = new IStyleDataVo();
                if (cellStyleObj != null) {
                    cellStyle = styles.get(cellStyleObj);
                    if (cellStyle == null) {
                        cellStyle = new IStyleDataVo();
                    } else if (JsonUtil.isValidJson(cellStyleObj)) {
                        cellStyle = JsonUtil.convertValue((Object)cellStyleObj, new TypeReference<IStyleDataVo>(){});
                    }
                }
                BorderStyleDataVo copyBorder = DeepCloneUtil.deepClone(border);
                if (cellStyle != null) {
                    cellStyle.setBd(copyBorder);
                }
                String styleKey = ElnStyleUtil.getCellS(styles, cellStyle);
                cell.setS(styleKey);
            }
        }
    }

    public static void processStyleRowData(IWorksheetDataVo newSheet, ElnSheetDataParsingVo processDataInfo) {
        Map<String, Map<String, Double>> oldRowData = newSheet.getRowData();
        if (ObjectUtils.isEmpty(oldRowData)) {
            return;
        }
        List<ElnNewRowVo> newRows = processDataInfo.getNewRows();
        if (ObjectUtils.isEmpty(newRows)) {
            return;
        }
        HashMap<String, Map<String, Double>> nRowData = new HashMap<String, Map<String, Double>>();
        ElnOldNewRIdxVo oldNewRIdx = processDataInfo.getOldOrNewRIdx();
        for (Map.Entry<String, Map<String, Double>> entry : oldRowData.entrySet()) {
            int oldIdx = Integer.parseInt(entry.getKey());
            if (oldIdx >= oldNewRIdx.getOld().size()) continue;
            int newIdx = ElnRowColUtil.getNrn(processDataInfo, oldIdx);
            HashMap<String, Double> copyRowData = new HashMap<String, Double>(entry.getValue());
            nRowData.put(String.valueOf(newIdx), copyRowData);
        }
        for (ElnNewRowVo nri : newRows) {
            if (nri.isIgnoreParentStyle()) continue;
            int baseSr = nri.getSr() - nri.getBs();
            int baseEr = nri.getSr();
            for (int k = baseSr; k < baseEr; ++k) {
                Map<String, Double> baseRowData = oldRowData.get(String.valueOf(k));
                if (baseRowData == null) continue;
                for (int j = 0; j < nri.getBc(); ++j) {
                    int newIdx = nri.getNsr() + nri.getBs() * j + k - baseSr;
                    HashMap<String, Double> copyRowData = new HashMap<String, Double>(baseRowData);
                    nRowData.put(String.valueOf(newIdx), copyRowData);
                }
            }
        }
        newSheet.setRowData(nRowData);
    }

    public static void processStyleCellDataCustom(IWorksheetDataVo newSheet) {
        Map<Integer, Map<Integer, ICellDataVo>> cellData = newSheet.getCellData();
        if (ObjectUtils.isEmpty(cellData)) {
            return;
        }
        for (Map.Entry<Integer, Map<Integer, ICellDataVo>> rowEntry : cellData.entrySet()) {
            int ri = rowEntry.getKey();
            Map<Integer, ICellDataVo> rowCells = rowEntry.getValue();
            for (Map.Entry<Integer, ICellDataVo> cellEntry : rowCells.entrySet()) {
                int ci = cellEntry.getKey();
                ICellDataVo cell = cellEntry.getValue();
                if (cell == null || cell.getCustom() == null) continue;
                cell.getCustom().put("position", new int[]{ri, ci});
            }
        }
    }
}

